/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.PrintWriter;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.util.Daemon;

class PendingReplicationBlocks {
    private Map<Block, PendingBlockInfo> pendingReplications;
    private ArrayList<Block> timedOutItems;
    Daemon timerThread = null;
    private volatile boolean fsRunning = true;
    private long timeout = 300000L;
    private long defaultRecheckInterval = 300000L;

    PendingReplicationBlocks(long timeoutPeriod) {
        if (timeoutPeriod > 0L) {
            this.timeout = timeoutPeriod;
        }
        this.init();
    }

    PendingReplicationBlocks() {
        this.init();
    }

    void init() {
        this.pendingReplications = new HashMap<Block, PendingBlockInfo>();
        this.timedOutItems = new ArrayList();
        this.timerThread = new Daemon(new PendingReplicationMonitor());
        this.timerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increment(Block block, int numReplicas) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found == null) {
                this.pendingReplications.put(block, new PendingBlockInfo(numReplicas));
            } else {
                found.incrementReplicas(numReplicas);
                found.setTimeStamp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrement(Block block) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found != null) {
                FSNamesystem.LOG.debug((Object)("Removing pending replication for block" + block));
                found.decrementReplicas();
                if (found.getNumReplicas() <= 0) {
                    this.pendingReplications.remove(block);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Block block) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            this.pendingReplications.remove(block);
        }
    }

    int size() {
        return this.pendingReplications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumReplicas(Block block) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReplications.get(block);
            if (found != null) {
                return found.getNumReplicas();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Block[] getTimedOutBlocks() {
        ArrayList<Block> arrayList = this.timedOutItems;
        synchronized (arrayList) {
            if (this.timedOutItems.size() <= 0) {
                return null;
            }
            Block[] blockList = this.timedOutItems.toArray(new Block[this.timedOutItems.size()]);
            this.timedOutItems.clear();
            return blockList;
        }
    }

    void stop() {
        this.fsRunning = false;
        this.timerThread.interrupt();
        try {
            this.timerThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(PrintWriter out) {
        Map<Block, PendingBlockInfo> map = this.pendingReplications;
        synchronized (map) {
            out.println("Metasave: Blocks being replicated: " + this.pendingReplications.size());
            for (Map.Entry<Block, PendingBlockInfo> entry : this.pendingReplications.entrySet()) {
                PendingBlockInfo pendingBlock = entry.getValue();
                Block block = entry.getKey();
                out.println(block + " StartTime: " + new Time(pendingBlock.timeStamp) + " NumReplicaInProgress: " + pendingBlock.numReplicasInProgress);
            }
        }
    }

    class PendingReplicationMonitor
    implements Runnable {
        PendingReplicationMonitor() {
        }

        @Override
        public void run() {
            while (PendingReplicationBlocks.this.fsRunning) {
                long period = Math.min(PendingReplicationBlocks.this.defaultRecheckInterval, PendingReplicationBlocks.this.timeout);
                try {
                    this.pendingReplicationCheck();
                    Thread.sleep(period);
                }
                catch (InterruptedException ie) {
                    FSNamesystem.LOG.debug((Object)("PendingReplicationMonitor thread received exception. " + ie));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pendingReplicationCheck() {
            Map map = PendingReplicationBlocks.this.pendingReplications;
            synchronized (map) {
                Iterator iter = PendingReplicationBlocks.this.pendingReplications.entrySet().iterator();
                long now = FSNamesystem.now();
                FSNamesystem.LOG.debug((Object)"PendingReplicationMonitor checking Q");
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    PendingBlockInfo pendingBlock = (PendingBlockInfo)entry.getValue();
                    if (now <= pendingBlock.getTimeStamp() + PendingReplicationBlocks.this.timeout) continue;
                    Block block = (Block)entry.getKey();
                    ArrayList arrayList = PendingReplicationBlocks.this.timedOutItems;
                    synchronized (arrayList) {
                        PendingReplicationBlocks.this.timedOutItems.add(block);
                    }
                    FSNamesystem.LOG.warn((Object)("PendingReplicationMonitor timed out block " + block));
                    iter.remove();
                }
            }
        }
    }

    static class PendingBlockInfo {
        private long timeStamp = FSNamesystem.now();
        private int numReplicasInProgress;

        PendingBlockInfo(int numReplicas) {
            this.numReplicasInProgress = numReplicas;
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        void setTimeStamp() {
            this.timeStamp = FSNamesystem.now();
        }

        void incrementReplicas(int increment) {
            this.numReplicasInProgress += increment;
        }

        void decrementReplicas() {
            --this.numReplicasInProgress;
            assert (this.numReplicasInProgress >= 0);
        }

        int getNumReplicas() {
            return this.numReplicasInProgress;
        }
    }
}

