/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.FSConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredDatanodeException;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.common.GenerationStamp;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import org.apache.hadoop.hdfs.server.namenode.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.CorruptReplicasMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.DecommissionManager;
import org.apache.hadoop.hdfs.server.namenode.FSClusterStats;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import org.apache.hadoop.hdfs.server.namenode.Host2NodesMap;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NotReplicatedYetException;
import org.apache.hadoop.hdfs.server.namenode.PendingReplicationBlocks;
import org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import org.apache.hadoop.hdfs.server.namenode.UnderReplicatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.UpgradeManagerNamenode;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.protocol.BalancerBandwidthCommand;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DisallowedDatanodeException;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.util.QueueProcessingStatistics;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.mortbay.util.ajax.JSON;

public class FSNamesystem
implements FSConstants,
FSNamesystemMBean,
FSClusterStats,
NameNodeMXBean,
MetricsSource {
    public static final Log LOG = LogFactory.getLog(FSNamesystem.class);
    public static final String AUDIT_FORMAT = "ugi=%s\tip=%s\tcmd=%s\tsrc=%s\tdst=%s\tperm=%s";
    private static final ThreadLocal<Formatter> auditFormatter = new ThreadLocal<Formatter>(){

        @Override
        protected Formatter initialValue() {
            return new Formatter(new StringBuilder(FSNamesystem.AUDIT_FORMAT.length() * 4));
        }
    };
    public static final Log auditLog = LogFactory.getLog((String)(FSNamesystem.class.getName() + ".audit"));
    public static final int DEFAULT_INITIAL_MAP_CAPACITY = 16;
    public static final float DEFAULT_MAP_LOAD_FACTOR = 0.75f;
    static int BLOCK_DELETION_INCREMENT = 1000;
    private float blocksInvalidateWorkPct;
    private int blocksReplWorkMultiplier;
    private boolean isPermissionEnabled;
    private boolean persistBlocks;
    private UserGroupInformation fsOwner;
    private String fsOwnerShortUserName;
    private String supergroup;
    private PermissionStatus defaultPermission;
    private long capacityTotal = 0L;
    private long capacityUsed = 0L;
    private long capacityRemaining = 0L;
    private int totalLoad = 0;
    boolean isAccessTokenEnabled;
    BlockTokenSecretManager accessTokenHandler;
    private long accessKeyUpdateInterval;
    private long accessTokenLifetime;
    private static final long DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private DelegationTokenSecretManager dtSecretManager;
    volatile long pendingReplicationBlocksCount = 0L;
    volatile long corruptReplicaBlocksCount = 0L;
    volatile long underReplicatedBlocksCount = 0L;
    volatile long scheduledReplicationBlocksCount = 0L;
    volatile long excessBlocksCount = 0L;
    volatile long pendingDeletionBlocksCount = 0L;
    public FSDirectory dir;
    final BlocksMap blocksMap = new BlocksMap(16, 0.75f);
    public CorruptReplicasMap corruptReplicas = new CorruptReplicasMap();
    NavigableMap<String, DatanodeDescriptor> datanodeMap = new TreeMap<String, DatanodeDescriptor>();
    private Map<String, Collection<Block>> recentInvalidateSets = new TreeMap<String, Collection<Block>>();
    Map<String, Collection<Block>> excessReplicateMap = new TreeMap<String, Collection<Block>>();
    Random r = new Random();
    ArrayList<DatanodeDescriptor> heartbeats = new ArrayList();
    private UnderReplicatedBlocks neededReplications = new UnderReplicatedBlocks();
    PendingReplicationBlocks pendingReplications;
    public LeaseManager leaseManager = new LeaseManager(this);
    Daemon hbthread = null;
    public Daemon lmthread = null;
    Daemon smmthread = null;
    public Daemon replthread = null;
    private ReplicationMonitor replmon = null;
    private volatile boolean fsRunning = true;
    long systemStart = 0L;
    private int maxReplication;
    private int maxReplicationStreams;
    private int minReplication;
    private int defaultReplication;
    private volatile boolean stallReplicationWork = false;
    private long heartbeatRecheckInterval;
    private long heartbeatExpireInterval;
    private long replicationRecheckInterval;
    private long defaultBlockSize = 0L;
    private boolean allowBrokenAppend = false;
    private boolean durableSync = true;
    int maxCorruptFilesReturned;
    private int replIndex = 0;
    private long missingBlocksInCurIter = 0L;
    private long missingBlocksInPrevIter = 0L;
    public static FSNamesystem fsNamesystemObject;
    private InetSocketAddress nameNodeAddress = null;
    private SafeModeInfo safeMode;
    private Host2NodesMap host2DataNodeMap = new Host2NodesMap();
    NetworkTopology clusterMap;
    private DNSToSwitchMapping dnsToSwitchMapping;
    BlockPlacementPolicy replicator;
    private HostsFileReader hostsReader;
    private Daemon dnthread = null;
    private long maxFsObjects = 0L;
    private final GenerationStamp generationStamp = new GenerationStamp();
    int blockInvalidateLimit = 100;
    private long accessTimePrecision = 0L;
    private String nameNodeHostName;
    private long staleInterval;
    private boolean avoidStaleDataNodesForRead;
    private boolean avoidStaleDataNodesForWrite;
    private float ratioUseStaleDataNodesForWrite;
    private volatile int numStaleNodes = 0;
    static Random randBlockId;
    UpgradeManagerNamenode upgradeManager = new UpgradeManagerNamenode();
    private ObjectName mbeanName;
    private ObjectName mxBean = null;

    private static final void logAuditEvent(UserGroupInformation ugi, InetAddress addr, String cmd, String src, String dst, HdfsFileStatus stat) {
        Formatter fmt = auditFormatter.get();
        ((StringBuilder)fmt.out()).setLength(0);
        auditLog.info((Object)fmt.format(AUDIT_FORMAT, ugi, addr, cmd, src, dst, stat == null ? null : stat.getOwner() + ':' + stat.getGroup() + ':' + stat.getPermission()).toString());
    }

    FSNamesystem(NameNode nn, Configuration conf) throws IOException {
        try {
            this.initialize(nn, conf);
        }
        catch (IOException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            this.shutdown();
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error((Object)(this.getClass().getSimpleName() + " initialization failed."), (Throwable)e);
            this.close();
            this.shutdown();
            throw e;
        }
    }

    void activateSecretManager() throws IOException {
        if (this.dtSecretManager != null) {
            this.dtSecretManager.startThreads();
        }
    }

    private void initialize(NameNode nn, Configuration conf) throws IOException {
        this.systemStart = FSNamesystem.now();
        this.setConfigurationParameters(conf);
        this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
        this.nameNodeAddress = nn.getNameNodeAddress();
        this.registerMBean(conf);
        this.dir = new FSDirectory(this, conf);
        HdfsConstants.StartupOption startOpt = NameNode.getStartupOption(conf);
        this.dir.loadFSImage(FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf), startOpt);
        long timeTakenToLoadFSImage = FSNamesystem.now() - this.systemStart;
        LOG.info((Object)("Finished loading FSImage in " + timeTakenToLoadFSImage + " msecs"));
        NameNode.getNameNodeMetrics().setFsImageLoadTime(timeTakenToLoadFSImage);
        this.safeMode = new SafeModeInfo(conf);
        this.setBlockTotal();
        this.pendingReplications = new PendingReplicationBlocks((long)conf.getInt("dfs.replication.pending.timeout.sec", -1) * 1000L);
        if (this.isAccessTokenEnabled) {
            this.accessTokenHandler = new BlockTokenSecretManager(true, this.accessKeyUpdateInterval, this.accessTokenLifetime);
        }
        this.hbthread = new Daemon(new HeartbeatMonitor());
        this.lmthread = new Daemon(new LeaseManager.Monitor(this.leaseManager));
        this.replmon = new ReplicationMonitor();
        this.replthread = new Daemon(this.replmon);
        this.hbthread.start();
        this.lmthread.start();
        this.replthread.start();
        this.hostsReader = new HostsFileReader(conf.get("dfs.hosts", ""), conf.get("dfs.hosts.exclude", ""));
        DecommissionManager decommissionManager = new DecommissionManager(this);
        decommissionManager.getClass();
        this.dnthread = new Daemon(decommissionManager.new DecommissionManager.Monitor(conf.getInt("dfs.namenode.decommission.interval", 30), conf.getInt("dfs.namenode.decommission.nodes.per.interval", 5)));
        this.dnthread.start();
        this.dnsToSwitchMapping = ReflectionUtils.newInstance(conf.getClass("topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), conf);
        if (this.dnsToSwitchMapping instanceof CachedDNSToSwitchMapping) {
            this.dnsToSwitchMapping.resolve(new ArrayList<String>(this.hostsReader.getHosts()));
        }
        InetSocketAddress socAddr = NameNode.getAddress(conf);
        this.nameNodeHostName = socAddr.getHostName();
        this.registerWith(DefaultMetricsSystem.INSTANCE);
    }

    public static Collection<File> getNamespaceDirs(Configuration conf) {
        Collection<String> dirNames = conf.getStringCollection("dfs.name.dir");
        if (dirNames.isEmpty()) {
            dirNames.add("/tmp/hadoop/dfs/name");
        }
        ArrayList<File> dirs = new ArrayList<File>(dirNames.size());
        for (String name : dirNames) {
            dirs.add(new File(name));
        }
        return dirs;
    }

    public static Collection<File> getNamespaceEditsDirs(Configuration conf) {
        Collection<String> editsDirNames = conf.getStringCollection("dfs.name.edits.dir");
        if (editsDirNames.isEmpty()) {
            editsDirNames.add("/tmp/hadoop/dfs/name");
        }
        ArrayList<File> dirs = new ArrayList<File>(editsDirNames.size());
        for (String name : editsDirNames) {
            dirs.add(new File(name));
        }
        return dirs;
    }

    FSNamesystem(FSImage fsImage, Configuration conf) throws IOException {
        this.setConfigurationParameters(conf);
        this.dir = new FSDirectory(fsImage, this, conf);
        this.dtSecretManager = this.createDelegationTokenSecretManager(conf);
    }

    private void setConfigurationParameters(Configuration conf) throws IOException {
        fsNamesystemObject = this;
        this.fsOwner = UserGroupInformation.getCurrentUser();
        this.fsOwnerShortUserName = this.fsOwner.getShortUserName();
        LOG.info((Object)("fsOwner=" + this.fsOwner));
        this.supergroup = conf.get("dfs.permissions.supergroup", "supergroup");
        this.isPermissionEnabled = conf.getBoolean("dfs.permissions", true);
        LOG.info((Object)("supergroup=" + this.supergroup));
        LOG.info((Object)("isPermissionEnabled=" + this.isPermissionEnabled));
        this.persistBlocks = conf.getBoolean("dfs.persist.blocks", false);
        short filePermission = (short)conf.getInt("dfs.upgrade.permission", 511);
        this.defaultPermission = PermissionStatus.createImmutable(this.fsOwnerShortUserName, this.supergroup, new FsPermission(filePermission));
        this.blocksInvalidateWorkPct = DFSUtil.getInvalidateWorkPctPerIteration(conf);
        this.blocksReplWorkMultiplier = DFSUtil.getReplWorkMultiplier(conf);
        this.clusterMap = NetworkTopology.getInstance(conf);
        this.maxCorruptFilesReturned = conf.getInt("dfs.corruptfilesreturned.max", 500);
        this.replicator = BlockPlacementPolicy.getInstance(conf, this, this.clusterMap);
        this.defaultReplication = conf.getInt("dfs.replication", 3);
        this.maxReplication = conf.getInt("dfs.replication.max", 512);
        this.minReplication = conf.getInt("dfs.replication.min", 1);
        if (this.minReplication <= 0) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.min = " + this.minReplication + " must be greater than 0");
        }
        if (this.maxReplication >= Short.MAX_VALUE) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.max = " + this.maxReplication + " must be less than " + Short.MAX_VALUE);
        }
        if (this.maxReplication < this.minReplication) {
            throw new IOException("Unexpected configuration parameters: dfs.replication.min = " + this.minReplication + " must be less than dfs.replication.max = " + this.maxReplication);
        }
        this.maxReplicationStreams = conf.getInt("dfs.max-repl-streams", 2);
        long heartbeatInterval = conf.getLong("dfs.heartbeat.interval", 3L) * 1000L;
        this.heartbeatRecheckInterval = conf.getInt("heartbeat.recheck.interval", 300000);
        this.heartbeatExpireInterval = 2L * this.heartbeatRecheckInterval + 10L * heartbeatInterval;
        this.replicationRecheckInterval = (long)conf.getInt("dfs.replication.interval", 3) * 1000L;
        this.defaultBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.maxFsObjects = conf.getLong("dfs.max.objects", 0L);
        this.blockInvalidateLimit = Math.max(this.blockInvalidateLimit, 20 * (int)(heartbeatInterval / 1000L));
        this.blockInvalidateLimit = conf.getInt("dfs.block.invalidate.limit", this.blockInvalidateLimit);
        LOG.info((Object)("dfs.block.invalidate.limit=" + this.blockInvalidateLimit));
        this.accessTimePrecision = conf.getLong("dfs.access.time.precision", 0L);
        this.allowBrokenAppend = conf.getBoolean("dfs.support.broken.append", false);
        if (conf.getBoolean("dfs.support.append", false)) {
            LOG.warn((Object)"The dfs.support.append option is in your configuration, however append is not supported. This configuration option is no longer required to enable sync");
        }
        this.durableSync = conf.getBoolean("dfs.durable.sync", true);
        if (!this.durableSync) {
            LOG.warn((Object)"Durable sync disabled. Beware data loss when running programs like HBase that require durable sync!");
        }
        this.isAccessTokenEnabled = conf.getBoolean("dfs.block.access.token.enable", false);
        if (this.isAccessTokenEnabled) {
            this.accessKeyUpdateInterval = conf.getLong("dfs.block.access.key.update.interval", 600L) * 60L * 1000L;
            this.accessTokenLifetime = conf.getLong("dfs.block.access.token.lifetime", 600L) * 60L * 1000L;
        }
        LOG.info((Object)("isAccessTokenEnabled=" + this.isAccessTokenEnabled + " accessKeyUpdateInterval=" + this.accessKeyUpdateInterval / 60000L + " min(s), accessTokenLifetime=" + this.accessTokenLifetime / 60000L + " min(s)"));
        this.avoidStaleDataNodesForRead = conf.getBoolean("dfs.namenode.avoid.read.stale.datanode", false);
        this.avoidStaleDataNodesForWrite = conf.getBoolean("dfs.namenode.avoid.write.stale.datanode", false);
        this.staleInterval = FSNamesystem.getStaleIntervalFromConf(conf, this.heartbeatExpireInterval);
        this.ratioUseStaleDataNodesForWrite = FSNamesystem.getRatioUseStaleNodesForWriteFromConf(conf);
        if (this.avoidStaleDataNodesForWrite && this.staleInterval < this.heartbeatRecheckInterval) {
            this.heartbeatRecheckInterval = this.staleInterval;
            LOG.info((Object)("Setting heartbeat recheck interval to " + this.staleInterval + " since " + "dfs.namenode.stale.datanode.interval" + " is less than " + "dfs.namenode.heartbeat.recheck-interval"));
        }
    }

    private static float getRatioUseStaleNodesForWriteFromConf(Configuration conf) {
        float ratioUseStaleDataNodesForWrite = conf.getFloat("dfs.namenode.write.stale.datanode.ratio", 0.5f);
        if (ratioUseStaleDataNodesForWrite > 0.0f && ratioUseStaleDataNodesForWrite <= 1.0f) {
            return ratioUseStaleDataNodesForWrite;
        }
        throw new IllegalArgumentException("dfs.namenode.write.stale.datanode.ratio = '" + ratioUseStaleDataNodesForWrite + "' is invalid. It should be a positive non-zero float value," + " not greater than 1.0f");
    }

    private static long getStaleIntervalFromConf(Configuration conf, long heartbeatExpireInterval) {
        long staleInterval = conf.getLong("dfs.namenode.stale.datanode.interval", 30000L);
        if (staleInterval <= 0L) {
            throw new IllegalArgumentException("dfs.namenode.stale.datanode.interval = '" + staleInterval + "' is invalid. It should be a positive non-zero value");
        }
        long heartbeatIntervalSeconds = conf.getLong("dfs.heartbeat.interval", 3L);
        long minStaleInterval = (long)conf.getInt("dfs.namenode.stale.datanode.minimum.interval", 3) * heartbeatIntervalSeconds * 1000L;
        if (staleInterval < minStaleInterval) {
            LOG.warn((Object)("The given interval for marking stale datanode = " + staleInterval + ", which is less than " + 3 + " heartbeat intervals. This may cause too frequent changes of " + "stale states of DataNodes since a heartbeat msg may be missing " + "due to temporary short-term failures. Reset stale interval to " + minStaleInterval));
            staleInterval = minStaleInterval;
        }
        if (staleInterval > heartbeatExpireInterval) {
            LOG.warn((Object)("The given interval for marking stale datanode = " + staleInterval + ", which is larger than heartbeat expire interval " + heartbeatExpireInterval));
        }
        return staleInterval;
    }

    protected PermissionStatus getUpgradePermission() {
        return this.defaultPermission;
    }

    public static FSNamesystem getFSNamesystem() {
        return fsNamesystemObject;
    }

    synchronized NamespaceInfo getNamespaceInfo() {
        return new NamespaceInfo(this.dir.fsImage.getNamespaceID(), this.dir.fsImage.getCTime(), this.getDistributedUpgradeVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        block23: {
            block21: {
                this.fsRunning = false;
                if (this.pendingReplications != null) {
                    this.pendingReplications.stop();
                }
                if (this.hbthread != null) {
                    this.hbthread.interrupt();
                }
                if (this.replthread != null) {
                    this.replthread.interrupt();
                }
                if (this.dnthread != null) {
                    this.dnthread.interrupt();
                }
                if (this.smmthread != null) {
                    this.smmthread.interrupt();
                }
                if (this.dtSecretManager == null) break block21;
                this.dtSecretManager.stopThreads();
            }
            try {
                if (this.lmthread != null) {
                    this.lmthread.interrupt();
                    this.lmthread.join(3000L);
                }
                this.dir.close();
                this.blocksMap.close();
            }
            catch (InterruptedException ie) {
            }
            catch (IOException ie) {
                LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                IOUtils.cleanup(LOG, this.dir);
            }
            break block23;
            catch (Exception e) {
                try {
                    LOG.warn((Object)"Exception shutting down FSNamesystem", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (this.lmthread != null) {
                            this.lmthread.interrupt();
                            this.lmthread.join(3000L);
                        }
                        this.dir.close();
                        this.blocksMap.close();
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (IOException ie) {
                        LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                        IOUtils.cleanup(LOG, this.dir);
                    }
                    throw throwable;
                }
                try {
                    if (this.lmthread != null) {
                        this.lmthread.interrupt();
                        this.lmthread.join(3000L);
                    }
                    this.dir.close();
                    this.blocksMap.close();
                }
                catch (InterruptedException ie) {
                }
                catch (IOException ie) {
                    LOG.error((Object)"Error closing FSDirectory", (Throwable)ie);
                    IOUtils.cleanup(LOG, this.dir);
                }
            }
        }
    }

    boolean isRunning() {
        return this.fsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(String filename) throws IOException {
        this.checkSuperuserPrivilege();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            File file = new File(System.getProperty("hadoop.log.dir"), filename);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
            long totalInodes = this.dir.totalInodes();
            long totalBlocks = this.getBlocksTotal();
            ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
            ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
            this.DFSNodesStatus(live, dead);
            String str = totalInodes + " files and directories, " + totalBlocks + " blocks = " + (totalInodes + totalBlocks) + " total";
            out.println(str);
            out.println("Live Datanodes: " + live.size());
            out.println("Dead Datanodes: " + dead.size());
            UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
            synchronized (underReplicatedBlocks) {
                out.println("Metasave: Blocks waiting for replication: " + this.neededReplications.size());
                for (Block block : this.neededReplications) {
                    ArrayList<DatanodeDescriptor> containingNodes = new ArrayList<DatanodeDescriptor>();
                    NumberReplicas numReplicas = new NumberReplicas();
                    this.chooseSourceDatanode(block, containingNodes, numReplicas);
                    int usableReplicas = numReplicas.liveReplicas() + numReplicas.decommissionedReplicas();
                    if (block instanceof BlocksMap.BlockInfo) {
                        String fileName = FSDirectory.getFullPathName(((BlocksMap.BlockInfo)block).getINode());
                        out.print(fileName + ": ");
                    }
                    out.print(block + (usableReplicas > 0 ? "" : " MISSING") + " (replicas:" + " l: " + numReplicas.liveReplicas() + " d: " + numReplicas.decommissionedReplicas() + " c: " + numReplicas.corruptReplicas() + " e: " + numReplicas.excessReplicas() + ") ");
                    Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
                    Iterator<DatanodeDescriptor> jt = this.blocksMap.nodeIterator(block);
                    while (jt.hasNext()) {
                        DatanodeDescriptor node = jt.next();
                        String state = "";
                        if (corruptNodes != null && corruptNodes.contains(node)) {
                            state = "(corrupt)";
                        } else if (node.isDecommissioned() || node.isDecommissionInProgress()) {
                            state = "(decommissioned)";
                        }
                        out.print(" " + node + state + " : ");
                    }
                    out.println("");
                }
            }
            this.pendingReplications.metaSave(out);
            this.dumpRecentInvalidateSets(out);
            this.datanodeDump(out);
            out.flush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkSuperuserPrivilege();
        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
        synchronized (navigableMap) {
            for (DatanodeDescriptor nodeInfo : this.datanodeMap.values()) {
                nodeInfo.setBalancerBandwidth(bandwidth);
            }
        }
    }

    long getDefaultBlockSize() {
        return this.defaultBlockSize;
    }

    long getAccessTimePrecision() {
        return this.accessTimePrecision;
    }

    private boolean isAccessTimeSupported() {
        return this.accessTimePrecision > 0L;
    }

    private int getReplication(Block block) {
        INodeFile fileINode = this.blocksMap.getINode(block);
        if (fileINode == null) {
            return 0;
        }
        assert (!fileINode.isDirectory()) : "Block cannot belong to a directory";
        return fileINode.getReplication();
    }

    synchronized void updateNeededReplications(Block block, int curReplicasDelta, int expectedReplicasDelta) {
        NumberReplicas repl = this.countNodes(block);
        int curExpectedReplicas = this.getReplication(block);
        this.neededReplications.update(block, repl.liveReplicas(), repl.decommissionedReplicas(), curExpectedReplicas, curReplicasDelta, expectedReplicasDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlocksWithLocations getBlocks(DatanodeID datanode, long size) throws IOException {
        this.checkSuperuserPrivilege();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            long totalSize;
            DatanodeDescriptor node = this.getDatanode(datanode);
            if (node == null) {
                NameNode.stateChangeLog.warn((Object)("BLOCK* NameSystem.getBlocks: Asking for blocks from an unrecorded node " + datanode.getName()));
                throw new IllegalArgumentException("Unexpected exception.  Got getBlocks message for datanode " + datanode.getName() + ", but there is no info for it");
            }
            int numBlocks = node.numBlocks();
            if (numBlocks == 0) {
                return new BlocksWithLocations(new BlocksWithLocations.BlockWithLocations[0]);
            }
            Iterator<Block> iter = node.getBlockIterator();
            int startBlock = this.r.nextInt(numBlocks);
            for (int i = 0; i < startBlock; ++i) {
                iter.next();
            }
            ArrayList<BlocksWithLocations.BlockWithLocations> results = new ArrayList<BlocksWithLocations.BlockWithLocations>();
            for (totalSize = 0L; totalSize < size && iter.hasNext(); totalSize += this.addBlock(iter.next(), results)) {
            }
            if (totalSize < size) {
                iter = node.getBlockIterator();
                for (int i = 0; i < startBlock && totalSize < size; totalSize += this.addBlock(iter.next(), results), ++i) {
                }
            }
            return new BlocksWithLocations(results.toArray(new BlocksWithLocations.BlockWithLocations[results.size()]));
        }
    }

    ExportedBlockKeys getBlockKeys() {
        return this.isAccessTokenEnabled ? this.accessTokenHandler.exportKeys() : ExportedBlockKeys.DUMMY_KEYS;
    }

    private long addBlock(Block block, List<BlocksWithLocations.BlockWithLocations> results) {
        ArrayList<String> machineSet = new ArrayList<String>(this.blocksMap.numNodes(block));
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            String storageID = it.next().getStorageID();
            Collection<Block> blocks = this.recentInvalidateSets.get(storageID);
            if (blocks != null && blocks.contains(block)) continue;
            machineSet.add(storageID);
        }
        if (machineSet.size() == 0) {
            return 0L;
        }
        results.add(new BlocksWithLocations.BlockWithLocations(block, machineSet.toArray(new String[machineSet.size()])));
        return block.getNumBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermission(String src, FsPermission permission) throws IOException {
        FSPermissionChecker pc = new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup);
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set permission for " + src, this.safeMode);
            }
            this.checkOwner(pc, src);
            this.dir.setPermission(src, permission);
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(src);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setPermission", src, null, stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(String src, String username, String group) throws IOException {
        FSPermissionChecker pc = new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup);
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set owner for " + src, this.safeMode);
            }
            this.checkOwner(pc, src);
            if (!pc.isSuperUser()) {
                if (username != null && !pc.getUser().equals(username)) {
                    throw new AccessControlException("Non-super user cannot change owner");
                }
                if (group != null && !pc.containsGroup(group)) {
                    throw new AccessControlException("User does not belong to " + group);
                }
            }
            this.dir.setOwner(src, username, group);
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(src);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setOwner", src, null, stat);
        }
    }

    LocatedBlocks getBlockLocations(String clientMachine, String src, long offset, long length) throws IOException {
        LocatedBlocks blocks = this.getBlockLocations(src, offset, length, true, true, true);
        if (blocks != null) {
            Node client = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
            if (client == null) {
                ArrayList<String> hosts = new ArrayList<String>(1);
                hosts.add(clientMachine);
                String rName = this.dnsToSwitchMapping.resolve(hosts).get(0);
                if (rName != null) {
                    client = new NodeBase(clientMachine, rName);
                }
            }
            DFSUtil.StaleComparator comparator = null;
            if (this.avoidStaleDataNodesForRead) {
                comparator = new DFSUtil.StaleComparator(this.staleInterval);
            }
            for (LocatedBlock b : blocks.getLocatedBlocks()) {
                this.clusterMap.pseudoSortByDistance(client, b.getLocations());
                if (!this.avoidStaleDataNodesForRead) continue;
                Arrays.sort(b.getLocations(), comparator);
            }
        }
        return blocks;
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        return this.getBlockLocations(src, offset, length, false, true, true);
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length, boolean doAccessTime, boolean needBlockToken, boolean checkSafeMode) throws IOException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            this.checkPathAccess(pc, src, FsAction.READ);
        }
        if (offset < 0L) {
            throw new IOException("Negative offset is not supported. File: " + src);
        }
        if (length < 0L) {
            throw new IOException("Negative length is not supported. File: " + src);
        }
        LocatedBlocks ret = this.getBlockLocationsInternal(src, offset, length, Integer.MAX_VALUE, doAccessTime, needBlockToken);
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "open", src, null, null);
        }
        if (checkSafeMode && this.isInSafeMode()) {
            for (LocatedBlock b : ret.getLocatedBlocks()) {
                if (b.getLocations() != null && b.getLocations().length != 0) continue;
                throw new SafeModeException("Zero blocklocations for " + src, this.safeMode);
            }
        }
        return ret;
    }

    private synchronized LocatedBlocks getBlockLocationsInternal(String src, long offset, long length, int nrBlocksToReturn, boolean doAccessTime, boolean needBlockToken) throws IOException {
        BlocksMap.BlockInfo[] blocks;
        INodeFile inode = this.dir.getFileINode(src);
        if (inode == null) {
            return null;
        }
        if (doAccessTime && this.isAccessTimeSupported()) {
            this.dir.setTimes(src, inode, -1L, FSNamesystem.now(), false);
        }
        if ((blocks = inode.getBlocks()) == null) {
            return null;
        }
        if (blocks.length == 0) {
            return inode.createLocatedBlocks(new ArrayList<LocatedBlock>(blocks.length));
        }
        ArrayList<LocatedBlock> results = new ArrayList<LocatedBlock>(blocks.length);
        int curBlk = 0;
        long curPos = 0L;
        long blkSize = 0L;
        int nrBlocks = blocks[0].getNumBytes() == 0L ? 0 : blocks.length;
        for (curBlk = 0; curBlk < nrBlocks; ++curBlk) {
            blkSize = blocks[curBlk].getNumBytes();
            assert (blkSize > 0L) : "Block of size 0";
            if (curPos + blkSize > offset) break;
            curPos += blkSize;
        }
        if (nrBlocks > 0 && curBlk == nrBlocks) {
            return null;
        }
        long endOff = offset + length;
        do {
            int numCorruptReplicas;
            int numNodes = this.blocksMap.numNodes(blocks[curBlk]);
            int numCorruptNodes = this.countNodes(blocks[curBlk]).corruptReplicas();
            if (numCorruptNodes != (numCorruptReplicas = this.corruptReplicas.numCorruptReplicas(blocks[curBlk]))) {
                LOG.warn((Object)("Inconsistent number of corrupt replicas for " + blocks[curBlk] + "blockMap has " + numCorruptNodes + " but corrupt replicas map has " + numCorruptReplicas));
            }
            DatanodeInfo[] machineSet = null;
            boolean blockCorrupt = false;
            if (inode.isUnderConstruction() && curBlk == blocks.length - 1 && this.blocksMap.numNodes(blocks[curBlk]) == 0) {
                INodeFileUnderConstruction cons = (INodeFileUnderConstruction)inode;
                machineSet = cons.getTargets();
                blockCorrupt = false;
            } else {
                blockCorrupt = numCorruptNodes == numNodes;
                int numMachineSet = blockCorrupt ? numNodes : numNodes - numCorruptNodes;
                machineSet = new DatanodeDescriptor[numMachineSet];
                if (numMachineSet > 0) {
                    numNodes = 0;
                    Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(blocks[curBlk]);
                    while (it.hasNext()) {
                        DatanodeDescriptor dn = it.next();
                        boolean replicaCorrupt = this.corruptReplicas.isReplicaCorrupt(blocks[curBlk], dn);
                        if (!blockCorrupt && (blockCorrupt || replicaCorrupt)) continue;
                        machineSet[numNodes++] = dn;
                    }
                }
            }
            LocatedBlock b = new LocatedBlock(blocks[curBlk], machineSet, curPos, blockCorrupt);
            if (this.isAccessTokenEnabled && needBlockToken) {
                b.setBlockToken(this.accessTokenHandler.generateToken(b.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.READ)));
            }
            results.add(b);
        } while ((curPos += blocks[++curBlk].getNumBytes()) < endOff && curBlk < blocks.length && results.size() < nrBlocksToReturn);
        return inode.createLocatedBlocks(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void concat(String target, String[] srcs) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("concat " + Arrays.toString(srcs) + " to " + target));
        }
        if (target.isEmpty()) {
            throw new IllegalArgumentException("Target file name is empty");
        }
        if (srcs == null || srcs.length == 0) {
            throw new IllegalArgumentException("No sources given");
        }
        String trgParent = target.substring(0, target.lastIndexOf(47));
        for (String s : srcs) {
            String srcParent = s.substring(0, s.lastIndexOf(47));
            if (srcParent.equals(trgParent)) continue;
            throw new IllegalArgumentException("Sources and target are not in the same directory");
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        HdfsFileStatus resultingStat = null;
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot concat " + target, this.safeMode);
            }
            this.concatInternal(pc, target, srcs);
            if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
                resultingStat = this.dir.getFileInfo(target);
            }
        }
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getLoginUser(), Server.getRemoteIp(), "concat", Arrays.toString(srcs), target, resultingStat);
        }
    }

    private void concatInternal(FSPermissionChecker pc, String target, String[] srcs) throws IOException {
        BlocksMap.BlockInfo last;
        if (this.isPermissionEnabled) {
            this.checkPathAccess(pc, target, FsAction.WRITE);
            for (String aSrc : srcs) {
                this.checkPathAccess(pc, aSrc, FsAction.READ);
                this.checkParentAccess(pc, aSrc, FsAction.WRITE);
            }
        }
        HashSet<INodeFile> si = new HashSet<INodeFile>();
        INodeFile trgInode = this.dir.getFileINode(target);
        if (trgInode.isUnderConstruction()) {
            throw new IllegalArgumentException("concat: target file " + target + " is under construction");
        }
        if (trgInode.blocks.length == 0) {
            throw new IllegalArgumentException("concat: target file " + target + " is empty");
        }
        long blockSize = trgInode.getPreferredBlockSize();
        if (blockSize != (last = trgInode.blocks[trgInode.blocks.length - 1]).getNumBytes()) {
            throw new IllegalArgumentException("The last block in " + target + " is not full; last block size = " + last.getNumBytes() + " but file block size = " + blockSize);
        }
        si.add(trgInode);
        short repl = trgInode.getReplication();
        boolean endSrc = false;
        for (int i = 0; i < srcs.length; ++i) {
            String src = srcs[i];
            if (i == srcs.length - 1) {
                endSrc = true;
            }
            INodeFile srcInode = this.dir.getFileINode(src);
            if (src.isEmpty() || srcInode.isUnderConstruction() || srcInode.blocks.length == 0) {
                throw new IllegalArgumentException("concat: source file " + src + " is invalid or empty or underConstruction");
            }
            if (repl != srcInode.getReplication()) {
                throw new IllegalArgumentException("concat: the source file " + src + " and the target file " + target + " should have the same replication: source replication is " + srcInode.getReplication() + " but target replication is " + repl);
            }
            BlocksMap.BlockInfo[] srcBlocks = srcInode.getBlocks();
            int idx = srcBlocks.length - 1;
            if (endSrc) {
                idx = srcBlocks.length - 2;
            }
            if (idx >= 0 && srcBlocks[idx].getNumBytes() != blockSize) {
                throw new IllegalArgumentException("concat: the soruce file " + src + " and the target file " + target + " should have the same blocks sizes: target block size is " + blockSize + " but the size of source block " + idx + " is " + srcBlocks[idx].getNumBytes());
            }
            si.add(srcInode);
        }
        if (si.size() < srcs.length + 1) {
            throw new IllegalArgumentException("concat: at least two of the source files are the same");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* NameSystem.concat: " + Arrays.toString(srcs) + " to " + target));
        }
        this.dir.concat(target, srcs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimes(String src, long mtime, long atime) throws IOException {
        if (!this.isAccessTimeSupported() && atime != -1L) {
            throw new IOException("Access time for hdfs is not configured.  Please set dfs.access.time.precision configuration parameter");
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            INodeFile inode;
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set accesstimes  for " + src, this.safeMode);
            }
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            if ((inode = this.dir.getFileINode(src)) != null) {
                this.dir.setTimes(src, inode, mtime, atime, true);
                if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
                    HdfsFileStatus stat = this.dir.getFileInfo(src);
                    FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setTimes", src, null, stat);
                }
            } else {
                throw new FileNotFoundException("File " + src + " does not exist");
            }
        }
    }

    public boolean setReplication(String src, short replication) throws IOException {
        boolean status = this.setReplicationInternal(src, replication);
        this.getEditLog().logSync();
        if (status && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "setReplication", src, null, null);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setReplicationInternal(String src, short replication) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            int idx;
            int[] oldReplication;
            Block[] fileBlocks;
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set replication for " + src, this.safeMode);
            }
            this.verifyReplication(src, replication, null);
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            if ((fileBlocks = this.dir.setReplication(src, replication, oldReplication = new int[1])) == null) {
                return false;
            }
            int oldRepl = oldReplication[0];
            if (oldRepl == replication) {
                return true;
            }
            for (idx = 0; idx < fileBlocks.length; ++idx) {
                this.updateNeededReplications(fileBlocks[idx], 0, replication - oldRepl);
            }
            if (oldRepl > replication) {
                LOG.info((Object)("Reducing replication for " + src + ". New replication is " + replication));
                for (idx = 0; idx < fileBlocks.length; ++idx) {
                    this.processOverReplicatedBlock(fileBlocks[idx], replication, null, null);
                }
            } else {
                LOG.info((Object)("Increasing replication for " + src + ". New replication is " + replication));
            }
        }
        return true;
    }

    long getPreferredBlockSize(String filename) throws IOException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            this.checkTraverse(pc, filename);
        }
        return this.dir.getPreferredBlockSize(filename);
    }

    private void verifyReplication(String src, short replication, String clientName) throws IOException {
        String text = "file " + src + (clientName != null ? " on client " + clientName : "") + ".\n" + "Requested replication " + replication;
        if (replication > this.maxReplication) {
            throw new IOException(text + " exceeds maximum " + this.maxReplication);
        }
        if (replication < this.minReplication) {
            throw new IOException(text + " is less than the required minimum " + this.minReplication);
        }
    }

    private void verifyParentDir(String src) throws FileAlreadyExistsException, FileNotFoundException {
        Path parent = new Path(src).getParent();
        if (parent != null) {
            INode[] pathINodes = this.dir.getExistingPathINodes(parent.toString());
            if (pathINodes[pathINodes.length - 1] == null) {
                throw new FileNotFoundException("Parent directory doesn't exist: " + parent.toString());
            }
            if (!pathINodes[pathINodes.length - 1].isDirectory()) {
                throw new FileAlreadyExistsException("Parent path is not a directory: " + parent.toString());
            }
        }
    }

    void startFile(String src, PermissionStatus permissions, String holder, String clientMachine, boolean overwrite, boolean createParent, short replication, long blockSize) throws IOException {
        this.startFileInternal(src, permissions, holder, clientMachine, overwrite, false, createParent, replication, blockSize);
        this.getEditLog().logSync();
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(src);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "create", src, null, stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFileInternal(String src, PermissionStatus permissions, String holder, String clientMachine, boolean overwrite, boolean append, boolean createParent, short replication, long blockSize) throws IOException {
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* startFile: src=" + src + ", holder=" + holder + ", clientMachine=" + clientMachine + ", createParent=" + createParent + ", replication=" + replication + ", overwrite=" + overwrite + ", append=" + append));
        }
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot create " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(src)) {
                throw new IOException("Invalid name: " + src);
            }
            boolean pathExists = this.dir.exists(src);
            if (pathExists && this.dir.isDir(src)) {
                throw new IOException("Cannot create " + src + "; already exists as a directory");
            }
            if (this.isPermissionEnabled) {
                if (append || overwrite && pathExists) {
                    this.checkPathAccess(pc, src, FsAction.WRITE);
                } else {
                    this.checkAncestorAccess(pc, src, FsAction.WRITE);
                }
            }
            if (!createParent) {
                this.verifyParentDir(src);
            }
            try {
                INodeFile myFile = this.dir.getFileINode(src);
                this.recoverLeaseInternal(myFile, src, holder, clientMachine, false);
                try {
                    this.verifyReplication(src, replication, clientMachine);
                }
                catch (IOException e) {
                    throw new IOException("failed to create " + e.getMessage());
                }
                if (append) {
                    if (myFile == null) {
                        throw new FileNotFoundException("failed to append to non-existent " + src + " on client " + clientMachine);
                    }
                    if (((INode)myFile).isDirectory()) {
                        throw new IOException("failed to append to directory " + src + " on client " + clientMachine);
                    }
                } else if (!this.dir.isValidToCreate(src)) {
                    if (overwrite) {
                        this.delete(src, true);
                    } else {
                        throw new IOException("failed to create file " + src + " on client " + clientMachine + " either because the filename is invalid or the file exists");
                    }
                }
                DatanodeDescriptor clientNode = this.host2DataNodeMap.getDatanodeByHost(clientMachine);
                if (append) {
                    INodeFile node = myFile;
                    INodeFileUnderConstruction cons = new INodeFileUnderConstruction(node.getLocalNameBytes(), node.getReplication(), node.getModificationTime(), node.getPreferredBlockSize(), node.getBlocks(), node.getPermissionStatus(), holder, clientMachine, clientNode);
                    this.dir.replaceNode(src, node, cons);
                    this.leaseManager.addLease(cons.clientName, src);
                } else {
                    this.checkFsObjectLimit();
                    long genstamp = this.nextGenerationStamp();
                    INodeFileUnderConstruction newNode = this.dir.addFile(src, permissions, replication, blockSize, holder, clientMachine, clientNode, genstamp);
                    if (newNode == null) {
                        throw new IOException("DIR* startFile: Unable to add to namespace");
                    }
                    this.leaseManager.addLease(newNode.clientName, src);
                    if (NameNode.stateChangeLog.isDebugEnabled()) {
                        NameNode.stateChangeLog.debug((Object)("DIR* startFile: add " + src + " to namespace for " + holder));
                    }
                }
            }
            catch (IOException ie) {
                NameNode.stateChangeLog.warn((Object)("DIR* startFile: " + ie.getMessage()));
                throw ie;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isFileClosed(String src) throws AccessControlException, IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            INodeFile inode;
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, src);
            }
            if ((inode = this.dir.getFileINode(src)) == null) {
                throw new FileNotFoundException("File not found " + src);
            }
            return !inode.isUnderConstruction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean recoverLease(String src, String holder, String clientMachine) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot recover the lease of " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(src)) {
                throw new IOException("Invalid name: " + src);
            }
            INodeFile inode = this.dir.getFileINode(src);
            if (inode == null) {
                throw new FileNotFoundException("File not found " + src);
            }
            if (!inode.isUnderConstruction()) {
                return true;
            }
            if (this.isPermissionEnabled) {
                this.checkPathAccess(pc, src, FsAction.WRITE);
            }
            this.recoverLeaseInternal(inode, src, holder, clientMachine, true);
        }
        return false;
    }

    private void recoverLeaseInternal(INode fileInode, String src, String holder, String clientMachine, boolean force) throws IOException {
        if (fileInode != null && fileInode.isUnderConstruction()) {
            LeaseManager.Lease leaseFile;
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)fileInode;
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            if (!force && lease != null && (leaseFile = this.leaseManager.getLeaseByPath(src)) != null && leaseFile.equals(lease)) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because current leaseholder is trying to recreate file");
            }
            lease = this.leaseManager.getLease(pendingFile.clientName);
            if (lease == null) {
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + " because pendingCreates is non-null but no leases found");
            }
            if (force) {
                LOG.info((Object)("recoverLease: recover lease " + lease + ", src=" + src + " from client " + pendingFile.clientName));
                this.internalReleaseLeaseOne(lease, src);
            } else {
                if (lease.expiredSoftLimit()) {
                    LOG.info((Object)("startFile: recover lease " + lease + ", src=" + src + " from client " + pendingFile.clientName));
                    this.internalReleaseLease(lease, src);
                }
                throw new AlreadyBeingCreatedException("failed to create file " + src + " for " + holder + " on client " + clientMachine + ", because this file is already being created by " + pendingFile.getClientName() + " on " + pendingFile.getClientMachine());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocatedBlock appendFile(String src, String holder, String clientMachine) throws IOException {
        if (!this.allowBrokenAppend) {
            throw new IOException("Append is not supported. Please see the dfs.support.append configuration parameter");
        }
        this.startFileInternal(src, null, holder, clientMachine, false, true, false, (short)this.maxReplication, 0L);
        this.getEditLog().logSync();
        LocatedBlock lb = null;
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            INodeFileUnderConstruction file = this.checkLease(src, holder);
            BlocksMap.BlockInfo[] blocks = file.getBlocks();
            if (blocks != null && blocks.length > 0) {
                BlocksMap.BlockInfo last = blocks[blocks.length - 1];
                BlocksMap.BlockInfo storedBlock = this.blocksMap.getStoredBlock(last);
                if (file.getPreferredBlockSize() > storedBlock.getNumBytes()) {
                    long fileLength = file.computeContentSummary().getLength();
                    DatanodeInfo[] targets = new DatanodeDescriptor[this.blocksMap.numNodes(last)];
                    Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(last);
                    int i = 0;
                    while (it != null && it.hasNext()) {
                        targets[i] = it.next();
                        ++i;
                    }
                    for (i = 0; i < targets.length; ++i) {
                        targets[i].removeBlock(storedBlock);
                    }
                    file.setLastBlock(storedBlock, (DatanodeDescriptor[])targets);
                    lb = new LocatedBlock(last, targets, fileLength - storedBlock.getNumBytes());
                    if (this.isAccessTokenEnabled) {
                        lb.setBlockToken(this.accessTokenHandler.generateToken(lb.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
                    }
                    this.updateNeededReplications(last, 0, 0);
                    for (DatanodeInfo dd : targets) {
                        String datanodeId = dd.getStorageID();
                        Collection<Block> v = this.recentInvalidateSets.get(datanodeId);
                        if (v == null || !v.remove(last)) continue;
                        if (v.isEmpty()) {
                            this.recentInvalidateSets.remove(datanodeId);
                        }
                        --this.pendingDeletionBlocksCount;
                    }
                }
            }
        }
        if (lb != null && NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* appendFile: " + src + " for " + holder + " at " + clientMachine + " block " + lb.getBlock() + " block size " + lb.getBlock().getNumBytes()));
        }
        if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "append", src, null, null);
        }
        return lb;
    }

    public LocatedBlock getAdditionalBlock(String src, String clientName) throws IOException {
        return this.getAdditionalBlock(src, clientName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocatedBlock getAdditionalBlock(String src, String clientName, HashMap<Node, Node> excludedNodes) throws IOException {
        short replication;
        long blockSize;
        long fileLength;
        Object pendingFile;
        DatanodeDescriptor clientNode = null;
        Block newBlock = null;
        NameNode.stateChangeLog.debug((Object)("BLOCK* getAdditionalBlock: " + src + " for " + clientName));
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add block to " + src, this.safeMode);
            }
            this.checkFsObjectLimit();
            pendingFile = this.checkLease(src, clientName);
            if (!this.checkFileProgress((INodeFile)pendingFile, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            fileLength = ((INode)pendingFile).computeContentSummary().getLength();
            blockSize = ((INodeFile)pendingFile).getPreferredBlockSize();
            clientNode = ((INodeFileUnderConstruction)pendingFile).getClientNode();
            replication = ((INodeFile)pendingFile).getReplication();
        }
        DatanodeInfo[] targets = this.replicator.chooseTarget(src, (int)replication, clientNode, excludedNodes, blockSize);
        if (targets.length < this.minReplication) {
            throw new IOException("File " + src + " could only be replicated to " + targets.length + " nodes, instead of " + this.minReplication);
        }
        pendingFile = this;
        synchronized (pendingFile) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot add block to " + src, this.safeMode);
            }
            INode[] pathINodes = this.dir.getExistingPathINodes(src);
            int inodesLen = pathINodes.length;
            this.checkLease(src, clientName, pathINodes[inodesLen - 1]);
            INodeFileUnderConstruction pendingFile2 = (INodeFileUnderConstruction)pathINodes[inodesLen - 1];
            if (!this.checkFileProgress(pendingFile2, false)) {
                throw new NotReplicatedYetException("Not replicated yet:" + src);
            }
            newBlock = this.allocateBlock(src, pathINodes);
            pendingFile2.setTargets((DatanodeDescriptor[])targets);
            for (DatanodeDescriptor datanodeDescriptor : targets) {
                datanodeDescriptor.incBlocksScheduled();
            }
            this.dir.persistBlocks(src, pendingFile2);
        }
        if (this.persistBlocks) {
            this.getEditLog().logSync();
        }
        LocatedBlock b = new LocatedBlock(newBlock, targets, fileLength);
        if (this.isAccessTokenEnabled) {
            b.setBlockToken(this.accessTokenHandler.generateToken(b.getBlock(), EnumSet.of(BlockTokenSecretManager.AccessMode.WRITE)));
        }
        return b;
    }

    public synchronized boolean abandonBlock(Block b, String src, String holder) throws IOException {
        NameNode.stateChangeLog.debug((Object)("BLOCK* abandonBlock: " + b + "of " + src));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot abandon " + b + " for " + src, this.safeMode);
        }
        INodeFileUnderConstruction file = this.checkLease(src, holder);
        this.dir.removeBlock(src, file, b);
        NameNode.stateChangeLog.debug((Object)("BLOCK* abandonBlock: " + b + " is removed from pendingCreates"));
        this.dir.persistBlocks(src, file);
        if (this.persistBlocks) {
            this.getEditLog().logSync();
        }
        return true;
    }

    private INodeFileUnderConstruction checkLease(String src, String holder) throws IOException {
        INodeFile file = this.dir.getFileINode(src);
        this.checkLease(src, holder, file);
        return (INodeFileUnderConstruction)file;
    }

    private void checkLease(String src, String holder, INode file) throws IOException {
        if (file == null || file.isDirectory()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + " File does not exist. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files"));
        }
        if (!file.isUnderConstruction()) {
            LeaseManager.Lease lease = this.leaseManager.getLease(holder);
            throw new LeaseExpiredException("No lease on " + src + " File is not open for writing. " + (lease != null ? lease.toString() : "Holder " + holder + " does not have any open files"));
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)file;
        if (holder != null && !pendingFile.getClientName().equals(holder)) {
            throw new LeaseExpiredException("Lease mismatch on " + src + " owned by " + pendingFile.getClientName() + " but is accessed by " + holder);
        }
    }

    public CompleteFileStatus completeFile(String src, String holder) throws IOException {
        CompleteFileStatus status = this.completeFileInternal(src, holder);
        this.getEditLog().logSync();
        return status;
    }

    private synchronized CompleteFileStatus completeFileInternal(String src, String holder) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* completeFile: " + src + " for " + holder));
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot complete " + src, this.safeMode);
        }
        INodeFileUnderConstruction pendingFile = this.checkLease(src, holder);
        Block[] fileBlocks = this.dir.getFileBlocks(src);
        if (fileBlocks == null) {
            NameNode.stateChangeLog.warn((Object)("DIR* completeFile: failed to complete " + src + " because dir.getFileBlocks() is null," + " pending from " + pendingFile.getClientMachine()));
            return CompleteFileStatus.OPERATION_FAILED;
        }
        if (!this.checkFileProgress(pendingFile, true)) {
            return CompleteFileStatus.STILL_WAITING;
        }
        this.finalizeINodeFileUnderConstruction(src, pendingFile);
        NameNode.stateChangeLog.info((Object)("DIR* completeFile: " + src + " is closed by " + holder));
        return CompleteFileStatus.COMPLETE_SUCCESS;
    }

    private void checkReplicationFactor(INodeFile file) {
        short numExpectedReplicas = file.getReplication();
        BlocksMap.BlockInfo[] pendingBlocks = file.getBlocks();
        int nrBlocks = pendingBlocks.length;
        for (int i = 0; i < nrBlocks; ++i) {
            NumberReplicas number = this.countNodes(pendingBlocks[i]);
            if (number.liveReplicas() >= numExpectedReplicas) continue;
            this.neededReplications.add(pendingBlocks[i], number.liveReplicas(), number.decommissionedReplicas, numExpectedReplicas);
        }
    }

    private Block allocateBlock(String src, INode[] inodes) throws IOException {
        Block b = new Block(randBlockId.nextLong(), 0L, 0L);
        while (this.isValidBlock(b)) {
            b.setBlockId(randBlockId.nextLong());
        }
        b.setGenerationStamp(this.getGenerationStamp());
        b = this.dir.addBlock(src, inodes, b);
        NameNode.stateChangeLog.info((Object)("BLOCK* allocateBlock: " + src + ". " + b));
        return b;
    }

    synchronized boolean checkFileProgress(INodeFile v, boolean checkall) {
        if (checkall) {
            for (BlocksMap.BlockInfo block : v.getBlocks()) {
                if (this.blocksMap.numNodes(block) >= this.minReplication) continue;
                return false;
            }
        } else {
            Block b = v.getPenultimateBlock();
            if (b != null && this.blocksMap.numNodes(b) < this.minReplication) {
                return false;
            }
        }
        return true;
    }

    void removeFromInvalidates(String storageID) {
        Collection<Block> blocks = this.recentInvalidateSets.remove(storageID);
        if (blocks != null) {
            this.pendingDeletionBlocksCount -= (long)blocks.size();
        }
    }

    void addToInvalidates(Block b, DatanodeInfo dn, boolean log) {
        this.addToInvalidatesNoLog(b, dn);
        if (log) {
            NameNode.stateChangeLog.info((Object)("BLOCK* addToInvalidates: " + b.getBlockName() + " to " + dn.getName()));
        }
    }

    void addToInvalidates(Block b, DatanodeInfo dn) {
        this.addToInvalidates(b, dn, true);
    }

    void addToInvalidatesNoLog(Block b, DatanodeInfo n) {
        Collection<Block> invalidateSet = this.recentInvalidateSets.get(n.getStorageID());
        if (invalidateSet == null) {
            invalidateSet = new HashSet<Block>();
            this.recentInvalidateSets.put(n.getStorageID(), invalidateSet);
        }
        if (invalidateSet.add(b)) {
            ++this.pendingDeletionBlocksCount;
        }
    }

    private void addToInvalidates(Block b) {
        StringBuilder datanodes = new StringBuilder();
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(b);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            this.addToInvalidates(b, node, false);
            datanodes.append(node.getName()).append(" ");
        }
        if (datanodes.length() != 0) {
            NameNode.stateChangeLog.info((Object)("BLOCK* addToInvalidates: " + b.getBlockName() + " to " + datanodes.toString()));
        }
    }

    private synchronized void dumpRecentInvalidateSets(PrintWriter out) {
        int size = this.recentInvalidateSets.values().size();
        out.println("Metasave: Blocks " + this.pendingDeletionBlocksCount + " waiting deletion from " + size + " datanodes");
        if (size == 0) {
            return;
        }
        for (Map.Entry<String, Collection<Block>> entry : this.recentInvalidateSets.entrySet()) {
            Collection<Block> blocks = entry.getValue();
            if (blocks.size() <= 0) continue;
            out.println(((DatanodeDescriptor)this.datanodeMap.get(entry.getKey())).getName() + blocks);
        }
    }

    public synchronized void markBlockAsCorrupt(Block blk, DatanodeInfo dn) throws IOException {
        DatanodeDescriptor node = this.getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot mark block" + blk.getBlockName() + " as corrupt because datanode " + dn.getName() + " does not exist. ");
        }
        BlocksMap.BlockInfo storedBlockInfo = this.blocksMap.getStoredBlock(blk);
        if (storedBlockInfo == null) {
            NameNode.stateChangeLog.info((Object)("BLOCK markBlockAsCorrupt: " + blk + " could not be marked " + "as corrupt as it does not exists in " + "blocksMap"));
        } else {
            INodeFile inode = storedBlockInfo.getINode();
            if (inode == null) {
                NameNode.stateChangeLog.info((Object)("BLOCK markBlockAsCorrupt: " + blk + " could not be marked " + "as corrupt as it does not belong to " + "any file"));
                this.addToInvalidates(storedBlockInfo, node);
                return;
            }
            this.corruptReplicas.addToCorruptReplicasMap(storedBlockInfo, node);
            if (this.countNodes(storedBlockInfo).liveReplicas() > inode.getReplication()) {
                this.invalidateBlock(storedBlockInfo, node);
            } else {
                this.updateNeededReplications(storedBlockInfo, -1, 0);
            }
        }
    }

    private synchronized void invalidateBlock(Block blk, DatanodeInfo dn) throws IOException {
        NameNode.stateChangeLog.info((Object)("DIR* invalidateBlock: " + blk + " on " + dn.getName()));
        DatanodeDescriptor node = this.getDatanode(dn);
        if (node == null) {
            throw new IOException("Cannot invalidate " + blk + " because datanode " + dn.getName() + " does not exist");
        }
        int count = this.countNodes(blk).liveReplicas();
        if (count > 1) {
            this.addToInvalidates(blk, dn);
            this.removeStoredBlock(blk, node);
            NameNode.stateChangeLog.debug((Object)("BLOCK* invalidateBlocks: " + blk + " on " + dn.getName() + " listed for deletion"));
        } else {
            NameNode.stateChangeLog.info((Object)("BLOCK* invalidateBlocks: " + blk + " on " + dn.getName() + " is the only copy and was not deleted"));
        }
    }

    public boolean renameTo(String src, String dst) throws IOException {
        boolean status = this.renameToInternal(src, dst);
        this.getEditLog().logSync();
        if (status && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(dst);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "rename", src, dst, stat);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean renameToInternal(String src, String dst) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* renameTo: " + src + " to " + dst));
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot rename " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(dst)) {
                throw new IOException("Invalid name: " + dst);
            }
            if (this.isPermissionEnabled) {
                String actualdst = this.dir.isDir(dst) ? dst + "/" + new Path(src).getName() : dst;
                this.checkParentAccess(pc, src, FsAction.WRITE);
                this.checkAncestorAccess(pc, actualdst, FsAction.WRITE);
            }
            HdfsFileStatus dinfo = this.dir.getFileInfo(dst);
            if (this.dir.renameTo(src, dst)) {
                this.changeLease(src, dst, dinfo);
                return true;
            }
        }
        return false;
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        boolean status;
        if (!recursive && !this.dir.isDirEmpty(src)) {
            throw new IOException(src + " is non empty");
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* delete: " + src));
        }
        if ((status = this.deleteInternal(src, true)) && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "delete", src, null, null);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteInternal(String src, boolean enforcePermission) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        ArrayList<Block> collectedBlocks = new ArrayList<Block>();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot delete " + src, this.safeMode);
            }
            if (enforcePermission && this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, FsAction.WRITE, null, FsAction.ALL);
            }
            if (!this.dir.delete(src, collectedBlocks)) {
                return false;
            }
        }
        this.getEditLog().logSync();
        this.removeBlocks(collectedBlocks);
        collectedBlocks.clear();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("DIR* delete: " + src + " is removed"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBlocks(List<Block> blocks) {
        int start = 0;
        int end = 0;
        while (start < blocks.size()) {
            end = BLOCK_DELETION_INCREMENT + start;
            end = end > blocks.size() ? blocks.size() : end;
            FSNamesystem fSNamesystem = this;
            synchronized (fSNamesystem) {
                for (int i = start; i < end; ++i) {
                    Block b = blocks.get(i);
                    this.blocksMap.removeINode(b);
                    this.corruptReplicas.removeFromCorruptReplicasMap(b);
                    if (this.pendingReplications != null) {
                        this.pendingReplications.remove(b);
                    }
                    this.addToInvalidates(b);
                }
            }
            start = end;
        }
    }

    void removePathAndBlocks(String src, List<Block> blocks) {
        this.leaseManager.removeLeaseWithPrefixPath(src);
        if (blocks == null) {
            return;
        }
        this.removeBlocks(blocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdfsFileStatus getFileInfo(String src) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, src);
            }
            return this.dir.getFileInfo(src);
        }
    }

    public boolean mkdirs(String src, PermissionStatus permissions) throws IOException {
        boolean status = this.mkdirsInternal(src, permissions);
        this.getEditLog().logSync();
        if (status && auditLog.isInfoEnabled() && this.isExternalInvocation()) {
            HdfsFileStatus stat = this.dir.getFileInfo(src);
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "mkdirs", src, null, stat);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mkdirsInternal(String src, PermissionStatus permissions) throws IOException {
        NameNode.stateChangeLog.debug((Object)("DIR* mkdirs: " + src));
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isPermissionEnabled) {
                this.checkTraverse(pc, src);
            }
            if (this.dir.isDir(src)) {
                return true;
            }
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot create directory " + src, this.safeMode);
            }
            if (!DFSUtil.isValidName(src)) {
                throw new IOException("Invalid directory name: " + src);
            }
            if (this.isPermissionEnabled) {
                this.checkAncestorAccess(pc, src, FsAction.WRITE);
            }
            this.checkFsObjectLimit();
            if (!this.dir.mkdirs(src, permissions, false, FSNamesystem.now())) {
                throw new IOException("Invalid directory name: " + src);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ContentSummary getContentSummary(String src) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isPermissionEnabled) {
                this.checkPermission(pc, src, false, null, null, null, FsAction.READ_EXECUTE);
            }
            return this.dir.getContentSummary(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setQuota(String path, long nsQuota, long dsQuota) throws IOException {
        this.checkSuperuserPrivilege();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot set quota on " + path, this.safeMode);
            }
            this.dir.setQuota(path, nsQuota, dsQuota);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fsync(String src, String clientName) throws IOException {
        NameNode.stateChangeLog.info((Object)("BLOCK* fsync: " + src + " for " + clientName));
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Cannot fsync " + src, this.safeMode);
            }
            INodeFileUnderConstruction pendingFile = this.checkLease(src, clientName);
            this.dir.persistBlocks(src, pendingFile);
        }
        this.getEditLog().logSync();
    }

    void internalReleaseLease(LeaseManager.Lease lease, String src) throws IOException {
        if (lease.hasPath()) {
            String[] leasePaths = new String[lease.getPaths().size()];
            lease.getPaths().toArray(leasePaths);
            for (String p : leasePaths) {
                this.internalReleaseLeaseOne(lease, p);
            }
        } else {
            this.internalReleaseLeaseOne(lease, src);
        }
    }

    void internalReleaseLeaseOne(LeaseManager.Lease lease, String src) throws IOException {
        assert (Thread.holdsLock(this));
        LOG.info((Object)("Recovering lease=" + lease + ", src=" + src));
        INodeFile iFile = this.dir.getFileINode(src);
        if (iFile == null) {
            String message = "DIR* internalReleaseCreate: attempt to release a create lock on " + src + " file does not exist";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        if (!iFile.isUnderConstruction()) {
            String message = "DIR* internalReleaseCreate: attempt to release a create lock on " + src + " but file is already closed";
            NameNode.stateChangeLog.warn((Object)message);
            throw new IOException(message);
        }
        INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)iFile;
        if (pendingFile.getTargets() == null || pendingFile.getTargets().length == 0) {
            if (pendingFile.getBlocks().length == 0) {
                this.finalizeINodeFileUnderConstruction(src, pendingFile);
                NameNode.stateChangeLog.warn((Object)("BLOCK* internalReleaseLease: No blocks found, lease removed for " + src));
                return;
            }
            BlocksMap.BlockInfo[] blocks = pendingFile.getBlocks();
            BlocksMap.BlockInfo last = blocks[blocks.length - 1];
            DatanodeDescriptor[] targets = new DatanodeDescriptor[this.blocksMap.numNodes(last)];
            Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(last);
            int i = 0;
            while (it != null && it.hasNext()) {
                targets[i] = it.next();
                ++i;
            }
            pendingFile.setTargets(targets);
        }
        pendingFile.assignPrimaryDatanode();
        LeaseManager.Lease reassignedLease = this.reassignLease(lease, src, "NN_Recovery", pendingFile);
        this.leaseManager.renewLease(reassignedLease);
    }

    private LeaseManager.Lease reassignLease(LeaseManager.Lease lease, String src, String newHolder, INodeFileUnderConstruction pendingFile) {
        if (newHolder == null) {
            return lease;
        }
        pendingFile.setClientName(newHolder);
        return this.leaseManager.reassignLease(lease, src, newHolder);
    }

    private void finalizeINodeFileUnderConstruction(String src, INodeFileUnderConstruction pendingFile) throws IOException {
        NameNode.stateChangeLog.info((Object)("Removing lease on  " + src + " from client " + pendingFile.clientName));
        this.leaseManager.removeLease(pendingFile.clientName, src);
        INodeFile newFile = pendingFile.convertToInodeFile();
        this.dir.replaceNode(src, pendingFile, newFile);
        this.dir.closeFile(src, newFile);
        this.checkReplicationFactor(newFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitBlockSynchronization(Block lastblock, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets) throws IOException {
        LOG.info((Object)("commitBlockSynchronization(lastblock=" + lastblock + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ", closeFile=" + closeFile + ", deleteBlock=" + deleteblock + ")"));
        String src = null;
        try {
            FSNamesystem fSNamesystem = this;
            synchronized (fSNamesystem) {
                INodeFileUnderConstruction pendingFile;
                block20: {
                    if (this.isInSafeMode()) {
                        throw new SafeModeException("Cannot commitBlockSynchronization " + lastblock, this.safeMode);
                    }
                    BlocksMap.BlockInfo oldblockinfo = this.blocksMap.getStoredBlock(lastblock);
                    if (oldblockinfo == null) {
                        throw new IOException("Block (=" + lastblock + ") not found");
                    }
                    INodeFile iFile = oldblockinfo.getINode();
                    if (!iFile.isUnderConstruction()) {
                        throw new IOException("Unexpected block (=" + lastblock + ") since the file (=" + iFile.getLocalName() + ") is not under construction");
                    }
                    pendingFile = (INodeFileUnderConstruction)iFile;
                    this.blocksMap.removeBlock(oldblockinfo);
                    if (deleteblock) {
                        pendingFile.removeBlock(lastblock);
                    } else {
                        lastblock.set(lastblock.getBlockId(), newlength, newgenerationstamp);
                        BlocksMap.BlockInfo newblockinfo = this.blocksMap.addINode(lastblock, pendingFile);
                        DatanodeDescriptor[] descriptors = null;
                        ArrayList<DatanodeDescriptor> descriptorsList = new ArrayList<DatanodeDescriptor>(newtargets.length);
                        for (int i = 0; i < newtargets.length; ++i) {
                            DatanodeDescriptor node = (DatanodeDescriptor)this.datanodeMap.get(newtargets[i].getStorageID());
                            if (node != null) {
                                if (closeFile) {
                                    node.addBlock(newblockinfo);
                                }
                                descriptorsList.add(node);
                                continue;
                            }
                            LOG.error((Object)("commitBlockSynchronization included a target DN " + newtargets[i] + " which is not known to NN. Ignoring"));
                        }
                        if (!descriptorsList.isEmpty()) {
                            descriptors = descriptorsList.toArray(new DatanodeDescriptor[0]);
                        }
                        pendingFile.setLastBlock(newblockinfo, descriptors);
                    }
                    src = this.leaseManager.findPath(pendingFile);
                    if (closeFile) break block20;
                    if (this.durableSync) {
                        this.dir.persistBlocks(src, pendingFile);
                    }
                    LOG.info((Object)("commitBlockSynchronization(" + lastblock + ") successful"));
                    return;
                }
                this.finalizeINodeFileUnderConstruction(src, pendingFile);
            }
        }
        finally {
            if (closeFile || this.durableSync) {
                this.getEditLog().logSync();
            }
        }
        if (closeFile) {
            LOG.info((Object)("commitBlockSynchronization(newblock=" + lastblock + ", file=" + src + ", newgenerationstamp=" + newgenerationstamp + ", newlength=" + newlength + ", newtargets=" + Arrays.asList(newtargets) + ") successful"));
        }
    }

    synchronized void renewLease(String holder) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot renew lease for " + holder, this.safeMode);
        }
        this.leaseManager.renewLease(holder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryListing getListing(String src, byte[] startAfter) throws IOException {
        FSPermissionChecker pc = this.getPermissionChecker();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isPermissionEnabled) {
                if (this.dir.isDir(src)) {
                    this.checkPathAccess(pc, src, FsAction.READ_EXECUTE);
                } else {
                    this.checkTraverse(pc, src);
                }
            }
            if (auditLog.isInfoEnabled() && this.isExternalInvocation()) {
                FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), Server.getRemoteIp(), "listStatus", src, null, null);
            }
            return this.dir.getListing(src, startAfter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        String dnAddress = Server.getRemoteAddress();
        if (dnAddress == null) {
            dnAddress = nodeReg.getHost();
        }
        if (!this.verifyNodeRegistration(nodeReg, dnAddress)) {
            throw new DisallowedDatanodeException(nodeReg);
        }
        String hostName = nodeReg.getHost();
        DatanodeID dnReg = new DatanodeID(dnAddress + ":" + nodeReg.getPort(), nodeReg.getStorageID(), nodeReg.getInfoPort(), nodeReg.getIpcPort());
        nodeReg.updateRegInfo(dnReg);
        nodeReg.exportedKeys = this.getBlockKeys();
        NameNode.stateChangeLog.info((Object)("BLOCK* registerDatanode: node registration from " + nodeReg.getName() + " storage " + nodeReg.getStorageID()));
        DatanodeDescriptor nodeS = (DatanodeDescriptor)this.datanodeMap.get(nodeReg.getStorageID());
        DatanodeDescriptor nodeN = this.host2DataNodeMap.getDatanodeByName(nodeReg.getName());
        if (nodeN != null && nodeN != nodeS) {
            NameNode.LOG.info((Object)("BLOCK* registerDatanode: node from name: " + nodeN.getName()));
            this.removeDatanode(nodeN);
            this.wipeDatanode(nodeN);
            nodeN = null;
        }
        if (nodeS != null) {
            if (nodeN == nodeS) {
                NameNode.stateChangeLog.debug((Object)"BLOCK* registerDatanode: node restarted");
            } else {
                NameNode.stateChangeLog.info((Object)("BLOCK* registerDatanode: node " + nodeS.getName() + " is replaced by " + nodeReg.getName() + " with the same storageID " + nodeReg.getStorageID()));
            }
            this.clusterMap.remove(nodeS);
            nodeS.updateRegInfo(nodeReg);
            nodeS.setHostName(hostName);
            this.resolveNetworkLocation(nodeS);
            this.clusterMap.add(nodeS);
            ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
            synchronized (arrayList) {
                if (!this.heartbeats.contains(nodeS)) {
                    this.heartbeats.add(nodeS);
                    nodeS.updateHeartbeat(0L, 0L, 0L, 0);
                    nodeS.isAlive = true;
                }
            }
            return;
        }
        if (nodeReg.getStorageID().equals("")) {
            nodeReg.storageID = this.newStorageID();
            NameNode.stateChangeLog.debug((Object)("BLOCK* registerDatanode: new storageID " + nodeReg.getStorageID() + " assigned"));
        }
        DatanodeDescriptor nodeDescr = new DatanodeDescriptor(nodeReg, "/default-rack", hostName);
        this.resolveNetworkLocation(nodeDescr);
        this.unprotectedAddDatanode(nodeDescr);
        this.clusterMap.add(nodeDescr);
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            this.heartbeats.add(nodeDescr);
            nodeDescr.isAlive = true;
        }
        if (this.safeMode != null) {
            this.safeMode.checkMode();
        }
    }

    private void resolveNetworkLocation(DatanodeDescriptor node) {
        String networkLocation;
        ArrayList<String> names = new ArrayList<String>(1);
        if (this.dnsToSwitchMapping instanceof CachedDNSToSwitchMapping) {
            names.add(node.getHost());
        } else {
            String hostName = node.getHostName();
            int colon = hostName.indexOf(":");
            hostName = colon == -1 ? hostName : hostName.substring(0, colon);
            names.add(hostName);
        }
        List<String> rName = this.dnsToSwitchMapping.resolve(names);
        if (rName == null) {
            LOG.error((Object)("The resolve call returned null! Using /default-rack for host " + names));
            networkLocation = "/default-rack";
        } else {
            networkLocation = rName.get(0);
        }
        node.setNetworkLocation(networkLocation);
    }

    public String getRegistrationID() {
        return Storage.getRegistrationID(this.dir.fsImage);
    }

    private String newStorageID() {
        String newID = null;
        while (newID == null) {
            newID = "DS" + Integer.toString(this.r.nextInt());
            if (this.datanodeMap.get(newID) == null) continue;
            newID = null;
        }
        return newID;
    }

    private boolean isDatanodeDead(DatanodeDescriptor node) {
        return node.getLastUpdate() < FSNamesystem.now() - this.heartbeatExpireInterval;
    }

    private void setDatanodeDead(DatanodeDescriptor node) {
        node.setLastUpdate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeCommand[] handleHeartbeat(DatanodeRegistration nodeReg, long capacity, long dfsUsed, long remaining, int xceiverCount, int xmitsInProgress) throws IOException {
        DatanodeCommand cmd = null;
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
            synchronized (navigableMap) {
                DatanodeDescriptor nodeinfo = null;
                try {
                    nodeinfo = this.getDatanode(nodeReg);
                }
                catch (UnregisteredDatanodeException e) {
                    return new DatanodeCommand[]{DatanodeCommand.REGISTER};
                }
                if (nodeinfo != null && this.shouldNodeShutdown(nodeinfo)) {
                    this.setDatanodeDead(nodeinfo);
                    throw new DisallowedDatanodeException(nodeinfo);
                }
                if (nodeinfo == null || !nodeinfo.isAlive) {
                    return new DatanodeCommand[]{DatanodeCommand.REGISTER};
                }
                this.updateStats(nodeinfo, false);
                nodeinfo.updateHeartbeat(capacity, dfsUsed, remaining, xceiverCount);
                this.updateStats(nodeinfo, true);
                cmd = nodeinfo.getLeaseRecoveryCommand(Integer.MAX_VALUE);
                if (cmd != null) {
                    return new DatanodeCommand[]{cmd};
                }
                ArrayList<DatanodeCommand> cmds = new ArrayList<DatanodeCommand>();
                cmd = nodeinfo.getReplicationCommand(this.maxReplicationStreams - xmitsInProgress);
                if (cmd != null) {
                    cmds.add(cmd);
                }
                if ((cmd = nodeinfo.getInvalidateBlocks(this.blockInvalidateLimit)) != null) {
                    cmds.add(cmd);
                }
                if (this.isAccessTokenEnabled && nodeinfo.needKeyUpdate) {
                    cmds.add(new KeyUpdateCommand(this.accessTokenHandler.exportKeys()));
                    nodeinfo.needKeyUpdate = false;
                }
                if (nodeinfo.getBalancerBandwidth() > 0L) {
                    cmds.add(new BalancerBandwidthCommand(nodeinfo.getBalancerBandwidth()));
                    nodeinfo.setBalancerBandwidth(0L);
                }
                if (!cmds.isEmpty()) {
                    return cmds.toArray(new DatanodeCommand[cmds.size()]);
                }
            }
        }
        cmd = this.getDistributedUpgradeCommand();
        if (cmd != null) {
            return new DatanodeCommand[]{cmd};
        }
        return null;
    }

    private void updateStats(DatanodeDescriptor node, boolean isAdded) {
        assert (Thread.holdsLock(this.heartbeats));
        if (isAdded) {
            this.capacityTotal += node.getCapacity();
            this.capacityUsed += node.getDfsUsed();
            this.capacityRemaining += node.getRemaining();
            this.totalLoad += node.getXceiverCount();
        } else {
            this.capacityTotal -= node.getCapacity();
            this.capacityUsed -= node.getDfsUsed();
            this.capacityRemaining -= node.getRemaining();
            this.totalLoad -= node.getXceiverCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAccessKey() throws IOException {
        this.accessTokenHandler.updateKeys();
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            for (DatanodeDescriptor nodeInfo : this.heartbeats) {
                nodeInfo.needKeyUpdate = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int computeDatanodeWork() throws IOException {
        int replicationWorkFound = 0;
        int invalidationWorkFound = 0;
        int blocksToProcess = 0;
        int nodesToProcess = 0;
        if (this.isInSafeMode()) {
            this.replmon.replicateQueueStats.checkRestart();
            this.replmon.invalidateQueueStats.checkRestart();
            return 0;
        }
        Object object = this.heartbeats;
        synchronized (object) {
            blocksToProcess = this.heartbeats.size() * this.blocksReplWorkMultiplier;
            nodesToProcess = (int)Math.ceil((double)this.heartbeats.size() * (double)this.blocksInvalidateWorkPct);
        }
        this.replmon.replicateQueueStats.startCycle(blocksToProcess);
        replicationWorkFound = this.computeReplicationWork(blocksToProcess);
        this.replmon.replicateQueueStats.endCycle(replicationWorkFound);
        object = this;
        synchronized (object) {
            this.pendingReplicationBlocksCount = this.pendingReplications.size();
            this.underReplicatedBlocksCount = this.neededReplications.size();
            this.scheduledReplicationBlocksCount = replicationWorkFound;
            this.corruptReplicaBlocksCount = this.corruptReplicas.size();
        }
        this.replmon.invalidateQueueStats.startCycle(nodesToProcess);
        invalidationWorkFound = this.computeInvalidateWork(nodesToProcess);
        this.replmon.invalidateQueueStats.endCycle(invalidationWorkFound);
        return replicationWorkFound + invalidationWorkFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int computeInvalidateWork(int nodesToProcess) {
        int keyIndex;
        int i;
        ArrayList<String> keyArray;
        int numOfNodes = 0;
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            numOfNodes = this.recentInvalidateSets.size();
            keyArray = new ArrayList<String>(this.recentInvalidateSets.keySet());
        }
        nodesToProcess = Math.min(numOfNodes, nodesToProcess);
        int remainingNodes = numOfNodes - nodesToProcess;
        if (nodesToProcess < remainingNodes) {
            for (i = 0; i < nodesToProcess; ++i) {
                keyIndex = this.r.nextInt(numOfNodes - i) + i;
                Collections.swap(keyArray, keyIndex, i);
            }
        } else {
            for (i = 0; i < remainingNodes; ++i) {
                keyIndex = this.r.nextInt(numOfNodes - i);
                Collections.swap(keyArray, keyIndex, numOfNodes - i - 1);
            }
        }
        int blockCnt = 0;
        for (int nodeCnt = 0; nodeCnt < nodesToProcess; ++nodeCnt) {
            blockCnt += this.invalidateWorkForOneNode(keyArray.get(nodeCnt));
        }
        return blockCnt;
    }

    private int computeReplicationWork(int blocksToProcess) throws IOException {
        if (this.stallReplicationWork) {
            return 0;
        }
        List<List<Block>> blocksToReplicate = this.chooseUnderReplicatedBlocks(blocksToProcess);
        int scheduledReplicationCount = 0;
        for (int i = 0; i < blocksToReplicate.size(); ++i) {
            for (Block block : blocksToReplicate.get(i)) {
                if (!this.computeReplicationWorkForBlock(block, i)) continue;
                ++scheduledReplicationCount;
            }
        }
        return scheduledReplicationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized List<List<Block>> chooseUnderReplicatedBlocks(int blocksToProcess) {
        ArrayList<List<Block>> blocksToReplicate = new ArrayList<List<Block>>(3);
        for (int i = 0; i < 3; ++i) {
            blocksToReplicate.add(new ArrayList());
        }
        UnderReplicatedBlocks underReplicatedBlocks = this.neededReplications;
        synchronized (underReplicatedBlocks) {
            if (this.neededReplications.size() == 0) {
                this.missingBlocksInCurIter = 0L;
                this.missingBlocksInPrevIter = 0L;
                return blocksToReplicate;
            }
            UnderReplicatedBlocks.BlockIterator neededReplicationsIterator = this.neededReplications.iterator();
            for (int i = 0; i < this.replIndex && neededReplicationsIterator.hasNext(); ++i) {
                neededReplicationsIterator.next();
            }
            blocksToProcess = Math.min(blocksToProcess, this.neededReplications.size());
            int blkCnt = 0;
            while (blkCnt < blocksToProcess) {
                if (!neededReplicationsIterator.hasNext()) {
                    this.replIndex = 0;
                    this.missingBlocksInPrevIter = this.missingBlocksInCurIter;
                    this.missingBlocksInCurIter = 0L;
                    if (blkCnt >= (blocksToProcess = Math.min(blocksToProcess, this.neededReplications.size()))) break;
                    neededReplicationsIterator = this.neededReplications.iterator();
                    assert (neededReplicationsIterator.hasNext()) : "neededReplications should not be empty";
                }
                Block block = neededReplicationsIterator.next();
                int priority = neededReplicationsIterator.getPriority();
                if (priority < 0 || priority >= blocksToReplicate.size()) {
                    LOG.warn((Object)("Unexpected replication priority: " + priority + " " + block));
                } else {
                    ((List)blocksToReplicate.get(priority)).add(block);
                }
                ++blkCnt;
                ++this.replIndex;
            }
        }
        return blocksToReplicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean computeReplicationWorkForBlock(Block block, int priority) {
        int numEffectiveReplicas;
        DatanodeDescriptor srcNode;
        Object numReplicas;
        ArrayList<DatanodeDescriptor> containingNodes;
        short requiredReplication;
        Object object;
        INodeFile fileINode = null;
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            object = this.neededReplications;
            synchronized (object) {
                fileINode = this.blocksMap.getINode(block);
                if (fileINode == null || fileINode.isUnderConstruction()) {
                    this.neededReplications.remove(block, priority);
                    --this.replIndex;
                    return false;
                }
                requiredReplication = fileINode.getReplication();
                containingNodes = new ArrayList<DatanodeDescriptor>();
                numReplicas = new NumberReplicas();
                srcNode = this.chooseSourceDatanode(block, containingNodes, (NumberReplicas)numReplicas);
                if (((NumberReplicas)numReplicas).liveReplicas() + ((NumberReplicas)numReplicas).decommissionedReplicas() <= 0) {
                    ++this.missingBlocksInCurIter;
                }
                if (srcNode == null) {
                    return false;
                }
                numEffectiveReplicas = ((NumberReplicas)numReplicas).liveReplicas() + this.pendingReplications.getNumReplicas(block);
                if (numEffectiveReplicas >= requiredReplication) {
                    this.neededReplications.remove(block, priority);
                    --this.replIndex;
                    NameNode.stateChangeLog.info((Object)("BLOCK* Removing " + block + " from neededReplications as it has enough replicas"));
                    return false;
                }
            }
        }
        DatanodeDescriptor[] targets = this.replicator.chooseTarget(fileINode, requiredReplication - numEffectiveReplicas, srcNode, containingNodes, block.getNumBytes());
        if (targets.length == 0) {
            return false;
        }
        object = this;
        synchronized (object) {
            numReplicas = this.neededReplications;
            synchronized (numReplicas) {
                fileINode = this.blocksMap.getINode(block);
                if (fileINode == null || fileINode.isUnderConstruction()) {
                    this.neededReplications.remove(block, priority);
                    --this.replIndex;
                    return false;
                }
                requiredReplication = fileINode.getReplication();
                NumberReplicas numReplicas2 = this.countNodes(block);
                numEffectiveReplicas = numReplicas2.liveReplicas() + this.pendingReplications.getNumReplicas(block);
                if (numEffectiveReplicas >= requiredReplication) {
                    this.neededReplications.remove(block, priority);
                    --this.replIndex;
                    NameNode.stateChangeLog.info((Object)("BLOCK* Removing " + block + " from neededReplications as it has enough replicas"));
                    return false;
                }
                srcNode.addBlockToBeReplicated(block, targets);
                for (DatanodeDescriptor dn : targets) {
                    dn.incBlocksScheduled();
                }
                this.pendingReplications.increment(block, targets.length);
                NameNode.stateChangeLog.debug((Object)("BLOCK* " + block + " is moved from neededReplications to pendingReplications"));
                if (numEffectiveReplicas + targets.length >= requiredReplication) {
                    this.neededReplications.remove(block, priority);
                    --this.replIndex;
                }
            }
        }
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            StringBuilder targetList = new StringBuilder("datanode(s)");
            for (int k = 0; k < targets.length; ++k) {
                targetList.append(' ');
                targetList.append(targets[k].getName());
            }
            NameNode.stateChangeLog.info((Object)("BLOCK* ask " + srcNode.getName() + " to replicate " + block + " to " + targetList));
            NameNode.stateChangeLog.debug((Object)("BLOCK* neededReplications = " + this.neededReplications.size() + " pendingReplications = " + this.pendingReplications.size()));
        }
        return true;
    }

    public DatanodeInfo chooseDatanode(String srcPath, String address, long blocksize) {
        HashMap<Node, Node> excludedNodes;
        DatanodeDescriptor[] datanodes;
        DatanodeDescriptor clientNode = this.host2DataNodeMap.getDatanodeByHost(address);
        if (clientNode != null && (datanodes = this.replicator.chooseTarget(srcPath, 1, clientNode, excludedNodes = null, blocksize)).length > 0) {
            return datanodes[0];
        }
        return null;
    }

    private DatanodeDescriptor chooseSourceDatanode(Block block, List<DatanodeDescriptor> containingNodes, NumberReplicas numReplicas) {
        containingNodes.clear();
        DatanodeDescriptor srcNode = null;
        int live = 0;
        int decommissioned = 0;
        int corrupt = 0;
        int excess = 0;
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(block);
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            Collection<Block> excessBlocks = this.excessReplicateMap.get(node.getStorageID());
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
            } else if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++decommissioned;
            } else if (excessBlocks != null && excessBlocks.contains(block)) {
                ++excess;
            } else {
                ++live;
            }
            containingNodes.add(node);
            if (nodesCorrupt != null && nodesCorrupt.contains(node) || node.getNumberOfBlocksToBeReplicated() >= this.maxReplicationStreams || excessBlocks != null && excessBlocks.contains(block) || node.isDecommissioned()) continue;
            if (node.isDecommissionInProgress() || srcNode == null) {
                srcNode = node;
                continue;
            }
            if (srcNode.isDecommissionInProgress() || !this.r.nextBoolean()) continue;
            srcNode = node;
        }
        if (numReplicas != null) {
            numReplicas.initialize(live, decommissioned, corrupt, excess);
        }
        return srcNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invalidateWorkForOneNode(String nodeId) {
        ArrayList<Block> blocksToInvalidate = new ArrayList<Block>(this.blockInvalidateLimit);
        DatanodeDescriptor dn = null;
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                return 0;
            }
            assert (nodeId != null);
            dn = (DatanodeDescriptor)this.datanodeMap.get(nodeId);
            if (dn == null) {
                this.recentInvalidateSets.remove(nodeId);
                return 0;
            }
            Collection<Block> invalidateSet = this.recentInvalidateSets.get(nodeId);
            if (invalidateSet == null) {
                return 0;
            }
            Iterator<Block> it = invalidateSet.iterator();
            for (int blkCount = 0; blkCount < this.blockInvalidateLimit && it.hasNext(); ++blkCount) {
                blocksToInvalidate.add(it.next());
                it.remove();
            }
            if (!it.hasNext()) {
                this.recentInvalidateSets.remove(nodeId);
            }
            dn.addBlocksToBeInvalidated(blocksToInvalidate);
            this.pendingDeletionBlocksCount -= (long)blocksToInvalidate.size();
        }
        if (NameNode.stateChangeLog.isInfoEnabled()) {
            StringBuilder blockList = new StringBuilder();
            for (Block blk : blocksToInvalidate) {
                blockList.append(' ');
                blockList.append(blk);
            }
            NameNode.stateChangeLog.info((Object)("BLOCK* ask " + dn.getName() + " to delete " + blockList));
        }
        return blocksToInvalidate.size();
    }

    public void setNodeReplicationLimit(int limit) {
        this.maxReplicationStreams = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processPendingReplications() {
        Block[] timedOutItems = this.pendingReplications.getTimedOutBlocks();
        if (timedOutItems != null) {
            FSNamesystem fSNamesystem = this;
            synchronized (fSNamesystem) {
                for (int i = 0; i < timedOutItems.length; ++i) {
                    NumberReplicas num = this.countNodes(timedOutItems[i]);
                    this.neededReplications.add(timedOutItems[i], num.liveReplicas(), num.decommissionedReplicas(), this.getReplication(timedOutItems[i]));
                }
            }
        }
    }

    public synchronized void removeDatanode(DatanodeID nodeID) throws IOException {
        DatanodeDescriptor nodeInfo = this.getDatanode(nodeID);
        if (nodeInfo != null) {
            this.removeDatanode(nodeInfo);
        } else {
            NameNode.stateChangeLog.warn((Object)("BLOCK* removeDatanode: " + nodeID.getName() + " does not exist"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDatanode(DatanodeDescriptor nodeInfo) {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (nodeInfo.isAlive) {
                this.updateStats(nodeInfo, false);
                this.heartbeats.remove(nodeInfo);
                nodeInfo.isAlive = false;
            }
        }
        Iterator<Block> it = nodeInfo.getBlockIterator();
        while (it.hasNext()) {
            this.removeStoredBlock(it.next(), nodeInfo);
        }
        this.unprotectedRemoveDatanode(nodeInfo);
        this.clusterMap.remove(nodeInfo);
        if (this.safeMode != null) {
            this.safeMode.checkMode();
        }
    }

    void unprotectedRemoveDatanode(DatanodeDescriptor nodeDescr) {
        nodeDescr.resetBlocks();
        this.removeFromInvalidates(nodeDescr.getStorageID());
        NameNode.stateChangeLog.debug((Object)("BLOCK* unprotectedRemoveDatanode: " + nodeDescr.getName() + " is out of service now"));
    }

    void unprotectedAddDatanode(DatanodeDescriptor nodeDescr) {
        this.host2DataNodeMap.remove(this.datanodeMap.put(nodeDescr.getStorageID(), nodeDescr));
        this.host2DataNodeMap.add(nodeDescr);
        NameNode.stateChangeLog.debug((Object)("BLOCK* unprotectedAddDatanode: node " + nodeDescr.getName() + " is added to datanodeMap"));
    }

    void wipeDatanode(DatanodeID nodeID) throws IOException {
        String key = nodeID.getStorageID();
        this.host2DataNodeMap.remove((DatanodeDescriptor)this.datanodeMap.remove(key));
        NameNode.stateChangeLog.debug((Object)("BLOCK* wipeDatanode: " + nodeID.getName() + " storage " + key + " is removed from datanodeMap"));
    }

    FSImage getFSImage() {
        return this.dir.fsImage;
    }

    FSEditLog getEditLog() {
        return this.getFSImage().getEditLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void heartbeatCheck() {
        if (this.isInSafeMode()) {
            return;
        }
        boolean allAlive = false;
        while (!allAlive) {
            boolean foundDead = false;
            DatanodeDescriptor dead = null;
            int numOfStaleNodes = 0;
            Object object = this.heartbeats;
            synchronized (object) {
                for (DatanodeDescriptor nodeInfo : this.heartbeats) {
                    if (dead == null && this.isDatanodeDead(nodeInfo)) {
                        foundDead = true;
                        dead = nodeInfo;
                    }
                    if (!nodeInfo.isStale(this.staleInterval)) continue;
                    ++numOfStaleNodes;
                }
                this.setNumStaleNodes(numOfStaleNodes);
            }
            if (foundDead) {
                object = this;
                synchronized (object) {
                    ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
                    synchronized (arrayList) {
                        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
                        synchronized (navigableMap) {
                            DatanodeDescriptor nodeInfo = null;
                            try {
                                nodeInfo = this.getDatanode(dead);
                            }
                            catch (IOException e) {
                                nodeInfo = null;
                            }
                            if (nodeInfo != null && this.isDatanodeDead(nodeInfo)) {
                                NameNode.stateChangeLog.info((Object)("BLOCK* heartbeatCheck: lost heartbeat from " + nodeInfo.getName()));
                                this.removeDatanode(nodeInfo);
                            }
                        }
                    }
                }
            }
            allAlive = !foundDead;
        }
    }

    private Block rejectAddStoredBlock(Block block, DatanodeDescriptor node, String msg) {
        NameNode.stateChangeLog.info((Object)("BLOCK* addStoredBlock: addStoredBlock request received for " + block + " on " + node.getName() + " size " + block.getNumBytes() + " but was rejected: " + msg));
        this.addToInvalidates(block, node);
        return block;
    }

    public synchronized void processBlocksBeingWrittenReport(DatanodeID nodeID, BlockListAsLongs blocksBeingWritten) throws IOException {
        DatanodeDescriptor dataNode = this.getDatanode(nodeID);
        if (dataNode == null) {
            throw new IOException("ProcessReport from unregistered node: " + nodeID.getName());
        }
        if (this.shouldNodeShutdown(dataNode)) {
            this.setDatanodeDead(dataNode);
            throw new DisallowedDatanodeException(dataNode);
        }
        Block block = new Block();
        for (int i = 0; i < blocksBeingWritten.getNumberOfBlocks(); ++i) {
            boolean isLastBlock;
            block.set(blocksBeingWritten.getBlockId(i), blocksBeingWritten.getBlockLen(i), blocksBeingWritten.getBlockGenStamp(i));
            BlocksMap.BlockInfo storedBlock = this.blocksMap.getStoredBlockWithoutMatchingGS(block);
            if (storedBlock == null) {
                this.rejectAddStoredBlock(new Block(block), dataNode, "Block not in blockMap with any generation stamp");
                continue;
            }
            INodeFile inode = storedBlock.getINode();
            if (inode == null) {
                this.rejectAddStoredBlock(new Block(block), dataNode, "Block does not correspond to any file");
                continue;
            }
            boolean underConstruction = inode.isUnderConstruction();
            boolean bl = isLastBlock = inode.getLastBlock() != null && inode.getLastBlock().getBlockId() == block.getBlockId();
            if (!underConstruction) {
                this.rejectAddStoredBlock(new Block(block), dataNode, "Reported as block being written but is a block of closed file");
                continue;
            }
            if (!isLastBlock) {
                this.rejectAddStoredBlock(new Block(block), dataNode, "Reported as block being written but not the last block of an under-construction file");
                continue;
            }
            INodeFileUnderConstruction pendingFile = (INodeFileUnderConstruction)inode;
            pendingFile.addTarget(dataNode);
            this.incrementSafeBlockCount(pendingFile.getTargets().length);
        }
    }

    public synchronized void processReport(DatanodeID nodeID, BlockListAsLongs newReport) throws IOException {
        DatanodeDescriptor node;
        long startTime = FSNamesystem.now();
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* processReport: from " + nodeID.getName() + " " + newReport.getNumberOfBlocks() + " blocks"));
        }
        if ((node = this.getDatanode(nodeID)) == null || !node.isAlive) {
            throw new IOException("ProcessReport from dead or unregisterted node: " + nodeID.getName());
        }
        if (this.shouldNodeShutdown(node)) {
            this.setDatanodeDead(node);
            throw new DisallowedDatanodeException(node);
        }
        if (this.isInStartupSafeMode() && !node.firstBlockReport()) {
            NameNode.stateChangeLog.info((Object)("BLOCK* processReport: discarded non-initial block report from " + nodeID.getName() + " because namenode still in startup phase"));
            return;
        }
        LinkedList<Block> toAdd = new LinkedList<Block>();
        LinkedList<Block> toRemove = new LinkedList<Block>();
        LinkedList<Block> toInvalidate = new LinkedList<Block>();
        node.reportDiff(this.blocksMap, newReport, toAdd, toRemove, toInvalidate);
        for (Block b : toRemove) {
            this.removeStoredBlock(b, node);
        }
        for (Block b : toAdd) {
            this.addStoredBlock(b, node, null);
        }
        for (Block b : toInvalidate) {
            NameNode.stateChangeLog.info((Object)("BLOCK* processReport: " + b + " on " + node.getName() + " size " + b.getNumBytes() + " does not belong to any file"));
            this.addToInvalidates(b, node);
        }
        long endTime = FSNamesystem.now();
        NameNode.getNameNodeMetrics().addBlockReport(endTime - startTime);
        NameNode.stateChangeLog.info((Object)("*BLOCK* processReport: from " + nodeID.getName() + ", blocks: " + newReport.getNumberOfBlocks() + ", processing time: " + (endTime - startTime) + " msecs"));
        node.processedBlockReport();
    }

    synchronized Block addStoredBlock(Block block, DatanodeDescriptor node, DatanodeDescriptor delNodeHint) {
        INodeFile fileINode;
        BlocksMap.BlockInfo storedBlock = this.blocksMap.getStoredBlock(block);
        if (storedBlock == null) {
            boolean isLastBlock;
            storedBlock = this.blocksMap.getStoredBlockWithoutMatchingGS(block);
            if (storedBlock == null) {
                return this.rejectAddStoredBlock(block, node, "Block not in blockMap with any generation stamp");
            }
            INodeFile inode = storedBlock.getINode();
            if (inode == null) {
                return this.rejectAddStoredBlock(block, node, "Block does not correspond to any file");
            }
            boolean reportedOldGS = block.getGenerationStamp() < storedBlock.getGenerationStamp();
            boolean reportedNewGS = block.getGenerationStamp() > storedBlock.getGenerationStamp();
            boolean underConstruction = inode.isUnderConstruction();
            boolean bl = isLastBlock = inode.getLastBlock() != null && inode.getLastBlock().getBlockId() == block.getBlockId();
            if (!(!reportedOldGS || underConstruction && isLastBlock)) {
                return this.rejectAddStoredBlock(block, node, "Reported block has old generation stamp but is not the last block of an under-construction file. (current generation is " + storedBlock.getGenerationStamp() + ")");
            }
            if (underConstruction && isLastBlock && (reportedOldGS || reportedNewGS)) {
                NameNode.stateChangeLog.info((Object)("BLOCK* addStoredBlock: Targets updated: " + block + " on " + node.getName() + " is added as a target for " + storedBlock + " with size " + block.getNumBytes()));
                ((INodeFileUnderConstruction)inode).addTarget(node);
                return block;
            }
        }
        if ((fileINode = storedBlock.getINode()) == null) {
            return this.rejectAddStoredBlock(block, node, "Block does not correspond to any file");
        }
        assert (storedBlock != null) : "Block must be stored by now";
        boolean added = node.addBlock(storedBlock);
        boolean blockUnderConstruction = false;
        if (fileINode.isUnderConstruction()) {
            Block last = fileINode.getLastBlock();
            if (last == null) {
                LOG.error((Object)("Null blocks for reported =" + block + " stored=" + storedBlock + " inode=" + fileINode));
                return block;
            }
            blockUnderConstruction = last.equals(storedBlock);
        }
        if (block != storedBlock) {
            if (block.getNumBytes() >= 0L) {
                long diff;
                long cursize = storedBlock.getNumBytes();
                INodeFile file = storedBlock.getINode();
                if (cursize == 0L) {
                    storedBlock.setNumBytes(block.getNumBytes());
                } else if (cursize != block.getNumBytes()) {
                    LOG.warn((Object)("Inconsistent size for " + block + " reported from " + node.getName() + " current size is " + cursize + " reported size is " + block.getNumBytes()));
                    try {
                        if (cursize > block.getNumBytes() && !blockUnderConstruction) {
                            LOG.warn((Object)("Mark new replica " + block + " from " + node.getName() + "as corrupt because its length is shorter than existing ones"));
                            this.markBlockAsCorrupt(block, node);
                        } else {
                            if (!blockUnderConstruction) {
                                int numNodes = this.blocksMap.numNodes(block);
                                int count = 0;
                                DatanodeDescriptor[] nodes = new DatanodeDescriptor[numNodes];
                                Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
                                while (it != null && it.hasNext()) {
                                    DatanodeDescriptor dd = it.next();
                                    if (dd.equals(node)) continue;
                                    nodes[count++] = dd;
                                }
                                for (int j = 0; j < count; ++j) {
                                    LOG.warn((Object)("Mark existing replica " + block + " from " + node.getName() + " as corrupt because its length is shorter than the new one"));
                                    this.markBlockAsCorrupt(block, nodes[j]);
                                }
                            }
                            storedBlock.setNumBytes(block.getNumBytes());
                        }
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Error in deleting bad " + block + e));
                    }
                }
                long l = diff = file == null ? 0L : file.getPreferredBlockSize() - storedBlock.getNumBytes();
                if (diff > 0L && file.isUnderConstruction() && cursize < storedBlock.getNumBytes()) {
                    try {
                        String path = this.leaseManager.findPath((INodeFileUnderConstruction)file);
                        this.dir.updateSpaceConsumed(path, 0L, -diff * (long)file.getReplication());
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Unexpected exception while updating disk space : " + e.getMessage()));
                    }
                }
            }
            block = storedBlock;
        }
        assert (storedBlock == block) : "Block must be stored by now";
        int curReplicaDelta = 0;
        if (added) {
            curReplicaDelta = 1;
            if (!this.isInSafeMode()) {
                NameNode.stateChangeLog.info((Object)("BLOCK* addStoredBlock: blockMap updated: " + node.getName() + " is added to " + block + " size " + block.getNumBytes()));
            }
        } else {
            NameNode.stateChangeLog.warn((Object)("BLOCK* addStoredBlock: Redundant addStoredBlock request received for " + block + " on " + node.getName() + " size " + block.getNumBytes()));
        }
        NumberReplicas num = this.countNodes(storedBlock);
        int numLiveReplicas = num.liveReplicas();
        int numCurrentReplica = numLiveReplicas + this.pendingReplications.getNumReplicas(block);
        this.incrementSafeBlockCount(numCurrentReplica);
        if (blockUnderConstruction) {
            INodeFileUnderConstruction cons = (INodeFileUnderConstruction)fileINode;
            cons.addTarget(node);
            return block;
        }
        if (this.isInSafeMode()) {
            return block;
        }
        short fileReplication = fileINode.getReplication();
        if (numCurrentReplica >= fileReplication) {
            this.neededReplications.remove(block, numCurrentReplica, num.decommissionedReplicas, fileReplication);
        } else {
            this.updateNeededReplications(block, curReplicaDelta, 0);
        }
        if (numCurrentReplica > fileReplication) {
            this.processOverReplicatedBlock(block, fileReplication, node, delNodeHint);
        }
        int corruptReplicasCount = this.corruptReplicas.numCorruptReplicas(block);
        int numCorruptNodes = num.corruptReplicas();
        if (numCorruptNodes != corruptReplicasCount) {
            LOG.warn((Object)("Inconsistent number of corrupt replicas for " + block + "blockMap has " + numCorruptNodes + " but corrupt replicas map has " + corruptReplicasCount));
        }
        if (corruptReplicasCount > 0 && numLiveReplicas >= fileReplication) {
            this.invalidateCorruptReplicas(block);
        }
        return block;
    }

    void invalidateCorruptReplicas(Block blk) {
        Collection<DatanodeDescriptor> nodes = this.corruptReplicas.getNodes(blk);
        boolean gotException = false;
        if (nodes == null) {
            return;
        }
        nodes = new ArrayList<DatanodeDescriptor>(nodes);
        NameNode.stateChangeLog.debug((Object)("NameNode.invalidateCorruptReplicas: invalidating corrupt replicas on " + nodes.size() + "nodes"));
        for (DatanodeDescriptor node : nodes) {
            try {
                this.invalidateBlock(blk, node);
            }
            catch (IOException e) {
                NameNode.stateChangeLog.info((Object)("NameNode.invalidateCorruptReplicas error in deleting bad " + blk + " on " + node + e));
                gotException = true;
            }
        }
        if (!gotException) {
            this.corruptReplicas.removeFromCorruptReplicasMap(blk);
        }
    }

    private synchronized void processMisReplicatedBlocks() {
        long nrInvalid = 0L;
        long nrOverReplicated = 0L;
        long nrUnderReplicated = 0L;
        this.neededReplications.clear();
        for (BlocksMap.BlockInfo block : this.blocksMap.getBlocks()) {
            INodeFile fileINode = block.getINode();
            if (fileINode == null) {
                ++nrInvalid;
                this.addToInvalidates(block);
                continue;
            }
            short expectedReplication = fileINode.getReplication();
            NumberReplicas num = this.countNodes(block);
            int numCurrentReplica = num.liveReplicas();
            if (this.neededReplications.add(block, numCurrentReplica, num.decommissionedReplicas(), expectedReplication)) {
                ++nrUnderReplicated;
            }
            if (numCurrentReplica <= expectedReplication) continue;
            ++nrOverReplicated;
            this.processOverReplicatedBlock(block, expectedReplication, null, null);
        }
        LOG.info((Object)("Total number of blocks = " + this.blocksMap.size()));
        LOG.info((Object)("Number of invalid blocks = " + nrInvalid));
        LOG.info((Object)("Number of under-replicated blocks = " + nrUnderReplicated));
        LOG.info((Object)("Number of  over-replicated blocks = " + nrOverReplicated));
    }

    private void processOverReplicatedBlock(Block block, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        if (addedNode == delNodeHint) {
            delNodeHint = null;
        }
        ArrayList<DatanodeDescriptor> nonExcess = new ArrayList<DatanodeDescriptor>();
        Collection<DatanodeDescriptor> corruptNodes = this.corruptReplicas.getNodes(block);
        Iterator<DatanodeDescriptor> it = this.blocksMap.nodeIterator(block);
        while (it.hasNext()) {
            DatanodeDescriptor cur = it.next();
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks != null && excessBlocks.contains(block) || cur.isDecommissionInProgress() || cur.isDecommissioned() || corruptNodes != null && corruptNodes.contains(cur)) continue;
            nonExcess.add(cur);
        }
        this.chooseExcessReplicates(nonExcess, block, replication, addedNode, delNodeHint);
    }

    void chooseExcessReplicates(Collection<DatanodeDescriptor> nonExcess, Block b, short replication, DatanodeDescriptor addedNode, DatanodeDescriptor delNodeHint) {
        INodeFile inode = this.blocksMap.getINode(b);
        HashMap<String, List<DatanodeDescriptor>> rackMap = new HashMap<String, List<DatanodeDescriptor>>();
        ArrayList<DatanodeDescriptor> moreThanOne = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> exactlyOne = new ArrayList<DatanodeDescriptor>();
        this.replicator.splitNodesWithRack(nonExcess, rackMap, moreThanOne, exactlyOne);
        boolean firstOne = true;
        while (nonExcess.size() - replication > 0) {
            DatanodeDescriptor cur = null;
            cur = firstOne && delNodeHint != null && nonExcess.contains(delNodeHint) && (moreThanOne.contains(delNodeHint) || addedNode != null && !moreThanOne.contains(addedNode)) ? delNodeHint : this.replicator.chooseReplicaToDelete(inode, b, replication, moreThanOne, exactlyOne);
            firstOne = false;
            this.replicator.adjustSetsWithChosenReplica(rackMap, moreThanOne, exactlyOne, cur);
            nonExcess.remove(cur);
            Collection<Block> excessBlocks = this.excessReplicateMap.get(cur.getStorageID());
            if (excessBlocks == null) {
                excessBlocks = new TreeSet<Block>();
                this.excessReplicateMap.put(cur.getStorageID(), excessBlocks);
            }
            if (excessBlocks.add(b)) {
                ++this.excessBlocksCount;
                NameNode.stateChangeLog.debug((Object)("BLOCK* chooseExcessReplicates: (" + cur.getName() + ", " + b + ") is added to excessReplicateMap"));
            }
            this.addToInvalidatesNoLog(b, cur);
            NameNode.stateChangeLog.info((Object)("BLOCK* chooseExcessReplicates: (" + cur.getName() + ", " + b + ") is added to recentInvalidateSets"));
        }
    }

    synchronized void removeStoredBlock(Block block, DatanodeDescriptor node) {
        Collection<Block> excessBlocks;
        NameNode.stateChangeLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " from " + node.getName()));
        if (!this.blocksMap.removeNode(block, node)) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " has already been removed from node " + node));
            return;
        }
        INodeFile fileINode = this.blocksMap.getINode(block);
        if (fileINode != null) {
            this.decrementSafeBlockCount(block);
            this.updateNeededReplications(block, -1, 0);
        }
        if ((excessBlocks = this.excessReplicateMap.get(node.getStorageID())) != null && excessBlocks.remove(block)) {
            --this.excessBlocksCount;
            NameNode.stateChangeLog.debug((Object)("BLOCK* removeStoredBlock: " + block + " is removed from excessBlocks"));
            if (excessBlocks.size() == 0) {
                this.excessReplicateMap.remove(node.getStorageID());
            }
        }
        this.corruptReplicas.removeFromCorruptReplicasMap(block, node);
    }

    public synchronized void blockReceived(DatanodeID nodeID, Block block, String delHint) throws IOException {
        DatanodeDescriptor node = this.getDatanode(nodeID);
        if (node == null || !node.isAlive) {
            NameNode.stateChangeLog.warn((Object)("BLOCK* blockReceived: " + block + " is received from dead or unregistered node " + nodeID.getName()));
            throw new IOException("Got blockReceived message from unregistered or dead node " + block);
        }
        if (NameNode.stateChangeLog.isDebugEnabled()) {
            NameNode.stateChangeLog.debug((Object)("BLOCK* blockReceived: " + block + " is received from " + nodeID.getName()));
        }
        if (this.shouldNodeShutdown(node)) {
            this.setDatanodeDead(node);
            throw new DisallowedDatanodeException(node);
        }
        DatanodeDescriptor delHintNode = null;
        if (delHint != null && delHint.length() != 0 && (delHintNode = (DatanodeDescriptor)this.datanodeMap.get(delHint)) == null) {
            NameNode.stateChangeLog.warn((Object)("BLOCK* blockReceived: " + block + " is expected to be removed from an unrecorded node " + delHint));
        }
        this.pendingReplications.decrement(block);
        this.addStoredBlock(block, node, delHintNode);
        node.decBlocksScheduled();
    }

    public long getMissingBlocksCount() {
        return Math.max(this.missingBlocksInPrevIter, this.missingBlocksInCurIter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getStats() throws IOException {
        this.checkSuperuserPrivilege();
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return new long[]{this.capacityTotal, this.capacityUsed, this.capacityRemaining, this.underReplicatedBlocksCount, this.corruptReplicaBlocksCount, this.getMissingBlocksCount()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacityTotal() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.capacityTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacityUsed() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.capacityUsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCapacityUsedPercent() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (this.capacityTotal <= 0L) {
                return 100.0f;
            }
            return (float)this.capacityUsed * 100.0f / (float)this.capacityTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityUsedNonDFS() {
        long nonDFSUsed = 0L;
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            nonDFSUsed = this.capacityTotal - this.capacityRemaining - this.capacityUsed;
        }
        return nonDFSUsed < 0L ? 0L : nonDFSUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCapacityRemaining() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.capacityRemaining;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getCapacityRemainingPercent() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            if (this.capacityTotal <= 0L) {
                return 0.0f;
            }
            return (float)this.capacityRemaining * 100.0f / (float)this.capacityTotal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalLoad() {
        ArrayList<DatanodeDescriptor> arrayList = this.heartbeats;
        synchronized (arrayList) {
            return this.totalLoad;
        }
    }

    int getNumberOfDatanodes(FSConstants.DatanodeReportType type) {
        return this.getDatanodeListForReport(type).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ArrayList<DatanodeDescriptor> getDatanodeListForReport(FSConstants.DatanodeReportType type) {
        boolean listLiveNodes = type == FSConstants.DatanodeReportType.ALL || type == FSConstants.DatanodeReportType.LIVE;
        boolean listDeadNodes = type == FSConstants.DatanodeReportType.ALL || type == FSConstants.DatanodeReportType.DEAD;
        HashMap<String, String> mustList = new HashMap<String, String>();
        if (listDeadNodes) {
            Iterator<String> it = this.hostsReader.getHosts().iterator();
            while (it.hasNext()) {
                mustList.put(it.next(), "");
            }
            it = this.hostsReader.getExcludedHosts().iterator();
            while (it.hasNext()) {
                mustList.put(it.next(), "");
            }
        }
        ArrayList<DatanodeDescriptor> nodes = null;
        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
        synchronized (navigableMap) {
            nodes = new ArrayList<DatanodeDescriptor>(this.datanodeMap.size() + mustList.size());
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                boolean isDead = this.isDatanodeDead(dn);
                if (isDead && listDeadNodes || !isDead && listLiveNodes) {
                    nodes.add(dn);
                }
                mustList.remove(dn.getName());
                mustList.remove(dn.getHost());
                mustList.remove(dn.getHostName());
            }
        }
        if (listDeadNodes) {
            Iterator it = mustList.keySet().iterator();
            while (it.hasNext()) {
                DatanodeDescriptor dn = new DatanodeDescriptor(new DatanodeID((String)it.next()));
                dn.setLastUpdate(0L);
                nodes.add(dn);
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeInfo[] datanodeReport(FSConstants.DatanodeReportType type) throws AccessControlException {
        this.checkSuperuserPrivilege();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(type);
            DatanodeInfo[] arr = new DatanodeInfo[results.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = new DatanodeInfo(results.get(i));
            }
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveNamespace() throws AccessControlException, IOException {
        this.checkSuperuserPrivilege();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (!this.isInSafeMode()) {
                throw new IOException("Safe mode should be turned ON in order to create namespace image");
            }
            this.getFSImage().saveNamespace(true);
            LOG.info((Object)"New namespace image has been created");
        }
    }

    public synchronized void DFSNodesStatus(ArrayList<DatanodeDescriptor> live, ArrayList<DatanodeDescriptor> dead) {
        ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(FSConstants.DatanodeReportType.ALL);
        for (DatanodeDescriptor node : results) {
            if (this.isDatanodeDead(node)) {
                dead.add(node);
                continue;
            }
            live.add(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void datanodeDump(PrintWriter out) {
        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
        synchronized (navigableMap) {
            out.println("Metasave: Number of datanodes: " + this.datanodeMap.size());
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                out.println(node.dumpDatanode());
            }
        }
    }

    private void startDecommission(DatanodeDescriptor node) throws IOException {
        if (!node.isDecommissionInProgress() && !node.isDecommissioned()) {
            LOG.info((Object)("Start Decommissioning node " + node.getName()));
            node.startDecommission();
            node.decommissioningStatus.setStartTime(FSNamesystem.now());
            this.checkDecommissionStateInternal(node);
        }
    }

    public void stopDecommission(DatanodeDescriptor node) throws IOException {
        LOG.info((Object)("Stop Decommissioning node " + node.getName()));
        node.stopDecommission();
    }

    public DatanodeInfo getDataNodeInfo(String name) {
        return (DatanodeInfo)this.datanodeMap.get(name);
    }

    @Deprecated
    public InetSocketAddress getDFSNameNodeAddress() {
        return this.nameNodeAddress;
    }

    public Date getStartTime() {
        return new Date(this.systemStart);
    }

    short getMaxReplication() {
        return (short)this.maxReplication;
    }

    short getMinReplication() {
        return (short)this.minReplication;
    }

    short getDefaultReplication() {
        return (short)this.defaultReplication;
    }

    public void stallReplicationWork() {
        this.stallReplicationWork = true;
    }

    public void restartReplicationWork() {
        this.stallReplicationWork = false;
    }

    private NumberReplicas countNodes(Block b, Iterator<DatanodeDescriptor> nodeIter) {
        int count = 0;
        int live = 0;
        int corrupt = 0;
        int excess = 0;
        Collection<DatanodeDescriptor> nodesCorrupt = this.corruptReplicas.getNodes(b);
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            if (nodesCorrupt != null && nodesCorrupt.contains(node)) {
                ++corrupt;
                continue;
            }
            if (node.isDecommissionInProgress() || node.isDecommissioned()) {
                ++count;
                continue;
            }
            Collection<Block> blocksExcess = this.excessReplicateMap.get(node.getStorageID());
            if (blocksExcess != null && blocksExcess.contains(b)) {
                ++excess;
                continue;
            }
            ++live;
        }
        return new NumberReplicas(live, count, corrupt, excess);
    }

    NumberReplicas countNodes(Block b) {
        return this.countNodes(b, this.blocksMap.nodeIterator(b));
    }

    private void logBlockReplicationInfo(Block block, DatanodeDescriptor srcNode, NumberReplicas num) {
        int curReplicas = num.liveReplicas();
        int curExpectedReplicas = this.getReplication(block);
        INodeFile fileINode = this.blocksMap.getINode(block);
        Iterator<DatanodeDescriptor> nodeIter = this.blocksMap.nodeIterator(block);
        StringBuffer nodeList = new StringBuffer();
        while (nodeIter.hasNext()) {
            DatanodeDescriptor node = nodeIter.next();
            nodeList.append(node.name);
            nodeList.append(" ");
        }
        LOG.info((Object)("Block: " + block + ", Expected Replicas: " + curExpectedReplicas + ", live replicas: " + curReplicas + ", corrupt replicas: " + num.corruptReplicas() + ", decommissioned replicas: " + num.decommissionedReplicas() + ", excess replicas: " + num.excessReplicas() + ", Is Open File: " + fileINode.isUnderConstruction() + ", Datanodes having this block: " + nodeList + ", Current Datanode: " + srcNode.name + ", Is current datanode decommissioning: " + srcNode.isDecommissionInProgress()));
    }

    private boolean isReplicationInProgress(DatanodeDescriptor srcNode) {
        boolean status = false;
        int underReplicatedBlocks = 0;
        int decommissionOnlyReplicas = 0;
        int underReplicatedInOpenFiles = 0;
        Iterator<Block> i = srcNode.getBlockIterator();
        while (i.hasNext()) {
            Block block = i.next();
            INodeFile fileINode = this.blocksMap.getINode(block);
            if (fileINode == null) continue;
            NumberReplicas num = this.countNodes(block);
            int curReplicas = num.liveReplicas();
            int curExpectedReplicas = this.getReplication(block);
            if (curExpectedReplicas <= curReplicas) continue;
            if (!status) {
                status = true;
                this.logBlockReplicationInfo(block, srcNode, num);
            }
            ++underReplicatedBlocks;
            if (curReplicas == 0 && num.decommissionedReplicas() > 0) {
                ++decommissionOnlyReplicas;
            }
            if (fileINode.isUnderConstruction()) {
                ++underReplicatedInOpenFiles;
            }
            if (this.neededReplications.contains(block) || this.pendingReplications.getNumReplicas(block) != 0) continue;
            this.neededReplications.add(block, curReplicas, num.decommissionedReplicas(), curExpectedReplicas);
        }
        srcNode.decommissioningStatus.set(underReplicatedBlocks, decommissionOnlyReplicas, underReplicatedInOpenFiles);
        return status;
    }

    boolean checkDecommissionStateInternal(DatanodeDescriptor node) {
        if (node.isDecommissionInProgress() && !this.isReplicationInProgress(node)) {
            node.setDecommissioned();
            LOG.info((Object)("Decommission complete for node " + node.getName()));
        }
        return node.isDecommissioned();
    }

    private boolean inHostsList(DatanodeID node, String ipAddr) {
        Set<String> hostsList = this.hostsReader.getHosts();
        return hostsList.isEmpty() || ipAddr != null && hostsList.contains(ipAddr) || hostsList.contains(node.getHost()) || hostsList.contains(node.getName()) || node instanceof DatanodeInfo && hostsList.contains(((DatanodeInfo)node).getHostName());
    }

    private boolean inExcludedHostsList(DatanodeID node, String ipAddr) {
        Set<String> excludeList = this.hostsReader.getExcludedHosts();
        return ipAddr != null && excludeList.contains(ipAddr) || excludeList.contains(node.getHost()) || excludeList.contains(node.getName()) || node instanceof DatanodeInfo && excludeList.contains(((DatanodeInfo)node).getHostName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNodes(Configuration conf) throws IOException {
        this.checkSuperuserPrivilege();
        if (conf == null) {
            conf = new Configuration();
        }
        this.hostsReader.updateFileNames(conf.get("dfs.hosts", ""), conf.get("dfs.hosts.exclude", ""));
        this.hostsReader.refresh();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            for (DatanodeDescriptor node : this.datanodeMap.values()) {
                if (!this.inHostsList(node, null)) {
                    node.setDecommissioned();
                    continue;
                }
                if (this.inExcludedHostsList(node, null)) {
                    if (node.isDecommissionInProgress() || node.isDecommissioned()) continue;
                    this.startDecommission(node);
                    continue;
                }
                if (!node.isDecommissionInProgress() && !node.isDecommissioned()) continue;
                this.stopDecommission(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeUpgrade() throws IOException {
        this.checkSuperuserPrivilege();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            this.getFSImage().finalizeUpgrade();
        }
    }

    private synchronized boolean verifyNodeRegistration(DatanodeRegistration nodeReg, String ipAddr) throws IOException {
        if (!this.inHostsList(nodeReg, ipAddr)) {
            return false;
        }
        if (this.inExcludedHostsList(nodeReg, ipAddr)) {
            DatanodeDescriptor node = this.getDatanode(nodeReg);
            if (node == null) {
                throw new IOException("verifyNodeRegistration: unknown datanode " + nodeReg.getName());
            }
            if (!this.checkDecommissionStateInternal(node)) {
                this.startDecommission(node);
            }
        }
        return true;
    }

    private boolean shouldNodeShutdown(DatanodeDescriptor node) {
        return node.isDecommissioned();
    }

    public DatanodeDescriptor getDatanode(DatanodeID nodeID) throws IOException {
        UnregisteredDatanodeException e = null;
        DatanodeDescriptor node = (DatanodeDescriptor)this.datanodeMap.get(nodeID.getStorageID());
        if (node == null) {
            return null;
        }
        if (!node.getName().equals(nodeID.getName())) {
            e = new UnregisteredDatanodeException(nodeID, node);
            NameNode.stateChangeLog.fatal((Object)("BLOCK* getDatanode: " + e.getLocalizedMessage()));
            throw e;
        }
        return node;
    }

    @Deprecated
    private DatanodeDescriptor getDatanodeByIndex(int index) {
        int i = 0;
        for (DatanodeDescriptor node : this.datanodeMap.values()) {
            if (i == index) {
                return node;
            }
            ++i;
        }
        return null;
    }

    @Deprecated
    public String randomDataNode() {
        int size = this.datanodeMap.size();
        int index = 0;
        if (size != 0) {
            index = this.r.nextInt(size);
            for (int i = 0; i < size; ++i) {
                DatanodeDescriptor d = this.getDatanodeByIndex(index);
                if (!(d == null || d.isDecommissioned() || this.isDatanodeDead(d) || d.isDecommissionInProgress())) {
                    return d.getHost() + ":" + d.getInfoPort();
                }
                index = (index + 1) % size;
            }
        }
        return null;
    }

    public DatanodeDescriptor getRandomDatanode() {
        return (DatanodeDescriptor)this.clusterMap.chooseRandom("");
    }

    static long now() {
        return System.currentTimeMillis();
    }

    boolean setSafeMode(FSConstants.SafeModeAction action) throws IOException {
        if (action != FSConstants.SafeModeAction.SAFEMODE_GET) {
            this.checkSuperuserPrivilege();
            switch (action) {
                case SAFEMODE_LEAVE: {
                    this.leaveSafeMode(false);
                    break;
                }
                case SAFEMODE_ENTER: {
                    this.enterSafeMode();
                }
            }
        }
        return this.isInSafeMode();
    }

    boolean isInSafeMode() {
        if (this.safeMode == null) {
            return false;
        }
        return this.safeMode.isOn();
    }

    synchronized boolean isInStartupSafeMode() {
        if (this.safeMode == null) {
            return false;
        }
        return this.safeMode.isOn() && !this.safeMode.isManual();
    }

    void incrementSafeBlockCount(int replication) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.incrementSafeBlockCount((short)replication);
    }

    void decrementSafeBlockCount(Block b) {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.decrementSafeBlockCount((short)this.countNodes(b).liveReplicas());
    }

    void setBlockTotal() {
        if (this.safeMode == null) {
            return;
        }
        this.safeMode.setBlockTotal((int)this.getSafeBlockCount());
    }

    @Override
    public long getBlocksTotal() {
        return this.blocksMap.size();
    }

    private long getSafeBlockCount() {
        long numExcludedBlocks = 0L;
        for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
            for (String path : lease.getPaths()) {
                INodeFile node = this.dir.getFileINode(path);
                if (node == null) {
                    LOG.error((Object)("Found a lease for nonexisting file: " + path));
                    continue;
                }
                if (!node.isUnderConstruction()) {
                    LOG.error((Object)("Found a lease for file that is not under construction:" + path));
                    continue;
                }
                INodeFileUnderConstruction cons = (INodeFileUnderConstruction)node;
                BlocksMap.BlockInfo[] blocks = cons.getBlocks();
                if (blocks == null || blocks.length == 0 || blocks[blocks.length - 1].getNumBytes() != 0L) continue;
                ++numExcludedBlocks;
            }
        }
        LOG.info((Object)("Number of blocks excluded by safe block count: " + numExcludedBlocks + " total blocks: " + this.getBlocksTotal() + " and thus the safe blocks: " + (this.getBlocksTotal() - numExcludedBlocks)));
        return this.getBlocksTotal() - numExcludedBlocks;
    }

    synchronized void enterSafeMode() throws IOException {
        if (!this.isInSafeMode()) {
            this.safeMode = new SafeModeInfo();
            return;
        }
        this.safeMode.setManual();
        this.getEditLog().logSync();
        NameNode.stateChangeLog.info((Object)("STATE* Safe mode is ON. " + this.safeMode.getTurnOffTip()));
    }

    synchronized void leaveSafeMode(boolean checkForUpgrades) throws SafeModeException {
        if (!this.isInSafeMode()) {
            NameNode.stateChangeLog.info((Object)"STATE* Safe mode is already OFF.");
            return;
        }
        if (this.getDistributedUpgradeState()) {
            throw new SafeModeException("Distributed upgrade is in progress", this.safeMode);
        }
        this.safeMode.leave(checkForUpgrades);
    }

    public String getSafeModeTip() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return this.safeMode.getTurnOffTip();
    }

    long getEditLogSize() throws IOException {
        return this.getEditLog().getEditLogSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized CheckpointSignature rollEditLog() throws IOException {
        this.checkSuperuserPrivilege();
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            if (this.isInSafeMode()) {
                throw new SafeModeException("Log not rolled", this.safeMode);
            }
            LOG.info((Object)("Roll Edit Log from " + Server.getRemoteAddress()));
            return this.getFSImage().rollEditLog();
        }
    }

    synchronized void rollFSImage() throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Checkpoint not created", this.safeMode);
        }
        LOG.info((Object)("Roll FSImage from " + Server.getRemoteAddress()));
        this.getFSImage().rollFSImage();
    }

    private boolean isValidBlock(Block b) {
        return this.blocksMap.getINode(b) != null;
    }

    UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        return this.upgradeManager.distributedUpgradeProgress(action);
    }

    UpgradeCommand processDistributedUpgradeCommand(UpgradeCommand comm) throws IOException {
        return this.upgradeManager.processUpgradeCommand(comm);
    }

    int getDistributedUpgradeVersion() {
        return this.upgradeManager.getUpgradeVersion();
    }

    UpgradeCommand getDistributedUpgradeCommand() throws IOException {
        return this.upgradeManager.getBroadcastCommand();
    }

    boolean getDistributedUpgradeState() {
        return this.upgradeManager.getUpgradeState();
    }

    short getDistributedUpgradeStatus() {
        return this.upgradeManager.getUpgradeStatus();
    }

    boolean startDistributedUpgradeIfNeeded() throws IOException {
        return this.upgradeManager.startUpgrade();
    }

    PermissionStatus createFsOwnerPermissions(FsPermission permission) {
        return new PermissionStatus(this.fsOwner.getShortUserName(), this.supergroup, permission);
    }

    private FSPermissionChecker getPermissionChecker() throws AccessControlException {
        return this.isPermissionEnabled ? new FSPermissionChecker(this.fsOwnerShortUserName, this.supergroup) : null;
    }

    private void checkOwner(FSPermissionChecker pc, String path) throws AccessControlException {
        this.checkPermission(pc, path, true, null, null, null, null);
    }

    private void checkPathAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException {
        this.checkPermission(pc, path, false, null, null, access, null);
    }

    private void checkParentAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException {
        this.checkPermission(pc, path, false, null, access, null, null);
    }

    private void checkAncestorAccess(FSPermissionChecker pc, String path, FsAction access) throws AccessControlException {
        this.checkPermission(pc, path, false, access, null, null, null);
    }

    private void checkTraverse(FSPermissionChecker pc, String path) throws AccessControlException {
        this.checkPermission(pc, path, false, null, null, null, null);
    }

    private void checkSuperuserPrivilege() throws AccessControlException {
        if (this.isPermissionEnabled) {
            FSPermissionChecker pc = this.getPermissionChecker();
            pc.checkSuperuserPrivilege();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermission(FSPermissionChecker pc, String path, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException {
        if (!pc.isSuperUser()) {
            this.dir.waitForReady();
            FSNamesystem fSNamesystem = this;
            synchronized (fSNamesystem) {
                pc.checkPermission(path, this.dir.rootDir, doCheckOwner, ancestorAccess, parentAccess, access, subAccess);
            }
        }
    }

    void checkFsObjectLimit() throws IOException {
        if (this.maxFsObjects != 0L && this.maxFsObjects <= this.dir.totalInodes() + this.getBlocksTotal()) {
            throw new IOException("Exceeded the configured number of objects " + this.maxFsObjects + " in the filesystem.");
        }
    }

    long getMaxObjects() {
        return this.maxFsObjects;
    }

    @Override
    public long getFilesTotal() {
        return this.dir.totalInodes();
    }

    @Override
    public long getPendingReplicationBlocks() {
        return this.pendingReplicationBlocksCount;
    }

    @Override
    public long getUnderReplicatedBlocks() {
        return this.underReplicatedBlocksCount;
    }

    public long getCorruptReplicaBlocks() {
        return this.corruptReplicaBlocksCount;
    }

    @Override
    public long getScheduledReplicationBlocks() {
        return this.scheduledReplicationBlocksCount;
    }

    public long getPendingDeletionBlocks() {
        return this.pendingDeletionBlocksCount;
    }

    public long getExcessBlocks() {
        return this.excessBlocksCount;
    }

    public synchronized int getBlockCapacity() {
        return this.blocksMap.getCapacity();
    }

    @Override
    public String getFSState() {
        return this.isInSafeMode() ? "safeMode" : "Operational";
    }

    void registerMBean(Configuration conf) {
        try {
            StandardMBean bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.mbeanName = MBeans.register("NameNode", "FSNamesystemState", bean);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        this.mxBean = MBeans.register("NameNode", "NameNodeInfo", this);
        LOG.info((Object)"Registered FSNamesystemStateMBean and NameNodeMXBean");
    }

    public void shutdown() {
        if (this.mbeanName != null) {
            MBeans.unregister(this.mbeanName);
        }
        if (this.mxBean != null) {
            MBeans.unregister(this.mxBean);
        }
        if (this.dir != null) {
            this.dir.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numLiveDataNodes() {
        int numLive = 0;
        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
        synchronized (navigableMap) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (this.isDatanodeDead(dn)) continue;
                ++numLive;
            }
        }
        return numLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numDeadDataNodes() {
        int numDead = 0;
        NavigableMap<String, DatanodeDescriptor> navigableMap = this.datanodeMap;
        synchronized (navigableMap) {
            for (DatanodeDescriptor dn : this.datanodeMap.values()) {
                if (!this.isDatanodeDead(dn)) continue;
                ++numDead;
            }
        }
        return numDead;
    }

    public void setGenerationStamp(long stamp) {
        this.generationStamp.setStamp(stamp);
    }

    public long getGenerationStamp() {
        return this.generationStamp.getStamp();
    }

    private long nextGenerationStamp() {
        long gs = this.generationStamp.nextStamp();
        this.getEditLog().logGenerationStamp(gs);
        return gs;
    }

    synchronized long nextGenerationStampForBlock(Block block, boolean fromNN) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot get nextGenStamp for " + block, this.safeMode);
        }
        BlocksMap.BlockInfo storedBlock = this.blocksMap.getStoredBlock(block);
        if (storedBlock == null) {
            BlocksMap.BlockInfo match = this.blocksMap.getStoredBlock(block.getWithWildcardGS());
            String msg = match == null ? block + " is missing" : block + " has out of date GS " + block.getGenerationStamp() + " found " + match.getGenerationStamp() + ", may already be committed";
            LOG.info((Object)msg);
            throw new IOException(msg);
        }
        INodeFile fileINode = storedBlock.getINode();
        if (!fileINode.isUnderConstruction()) {
            String msg = block + " is already commited, !fileINode.isUnderConstruction().";
            LOG.info((Object)msg);
            throw new IOException(msg);
        }
        if (!fromNN && "NN_Recovery".equals(this.leaseManager.getLeaseByPath(FSDirectory.getFullPathName(fileINode)).getHolder())) {
            String msg = block + "is being recovered by NameNode, ignoring the request from a client";
            LOG.info((Object)msg);
            throw new IOException(msg);
        }
        if (!((INodeFileUnderConstruction)fileINode).setLastRecoveryTime(FSNamesystem.now())) {
            String msg = block + " is already being recovered, ignoring this request.";
            LOG.info((Object)msg);
            throw new IOException(msg);
        }
        return this.nextGenerationStamp();
    }

    void changeLease(String src, String dst, HdfsFileStatus dinfo) throws IOException {
        String replaceBy;
        String overwrite;
        boolean destinationExisted = true;
        if (dinfo == null) {
            destinationExisted = false;
        }
        if (destinationExisted && dinfo.isDir()) {
            Path spath = new Path(src);
            Path parent = spath.getParent();
            overwrite = this.isRoot(parent) ? parent.toString() : parent.toString() + "/";
            replaceBy = dst + "/";
        } else {
            overwrite = src;
            replaceBy = dst;
        }
        this.leaseManager.changeLease(src, dst, overwrite, replaceBy);
    }

    private boolean isRoot(Path path) {
        return path.getParent() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveFilesUnderConstruction(DataOutputStream out) throws IOException {
        LeaseManager leaseManager = this.leaseManager;
        synchronized (leaseManager) {
            out.writeInt(this.leaseManager.countPath());
            for (LeaseManager.Lease lease : this.leaseManager.getSortedLeases()) {
                for (String path : lease.getPaths()) {
                    INodeFile node = this.dir.getFileINode(path);
                    if (node == null) {
                        throw new IOException("saveLeases found path " + path + " but no matching entry in namespace.");
                    }
                    if (!node.isUnderConstruction()) {
                        throw new IOException("saveLeases found path " + path + " but is not under construction.");
                    }
                    INodeFileUnderConstruction cons = (INodeFileUnderConstruction)node;
                    FSImage.writeINodeUnderConstruction(out, cons, path);
                }
            }
        }
    }

    public synchronized ArrayList<DatanodeDescriptor> getDecommissioningNodes() {
        ArrayList<DatanodeDescriptor> decommissioningNodes = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> results = this.getDatanodeListForReport(FSConstants.DatanodeReportType.LIVE);
        for (DatanodeDescriptor node : results) {
            if (!node.isDecommissionInProgress()) continue;
            decommissioningNodes.add(node);
        }
        return decommissioningNodes;
    }

    private DelegationTokenSecretManager createDelegationTokenSecretManager(Configuration conf) {
        return new DelegationTokenSecretManager(conf.getLong("dfs.namenode.delegation.key.update-interval", 86400000L), conf.getLong("dfs.namenode.delegation.token.max-lifetime", 604800000L), conf.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L), DELEGATION_TOKEN_REMOVER_SCAN_INTERVAL, this);
    }

    public DelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.dtSecretManager;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot issue delegation token", this.safeMode);
        }
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be issued only with kerberos or web authentication");
        }
        if (this.dtSecretManager == null || !this.dtSecretManager.isRunning()) {
            LOG.warn((Object)"trying to get DT with no secret manager running");
            return null;
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String user = ugi.getUserName();
        Text owner = new Text(user);
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        DelegationTokenIdentifier dtId = new DelegationTokenIdentifier(owner, renewer, realUser);
        Token<DelegationTokenIdentifier> token = new Token<DelegationTokenIdentifier>(dtId, this.dtSecretManager);
        long expiryTime = this.dtSecretManager.getTokenExpiryTime(dtId);
        this.logGetDelegationToken(dtId, expiryTime);
        return token;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot renew delegation token", this.safeMode);
        }
        if (!this.isAllowedDelegationTokenOp()) {
            throw new IOException("Delegation Token can be renewed only with kerberos or web authentication");
        }
        String renewer = UserGroupInformation.getCurrentUser().getShortUserName();
        long expiryTime = this.dtSecretManager.renewToken(token, renewer);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        id.readFields(in);
        this.logRenewDelegationToken(id, expiryTime);
        return expiryTime;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        if (this.isInSafeMode()) {
            throw new SafeModeException("Cannot cancel delegation token", this.safeMode);
        }
        String canceller = UserGroupInformation.getCurrentUser().getUserName();
        DelegationTokenIdentifier id = this.dtSecretManager.cancelToken(token, canceller);
        this.logCancelDelegationToken(id);
    }

    void saveSecretManagerState(DataOutputStream out) throws IOException {
        this.dtSecretManager.saveSecretManagerState(out);
    }

    void loadSecretManagerState(DataInputStream in) throws IOException {
        this.dtSecretManager.loadSecretManagerState(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logGetDelegationToken(DelegationTokenIdentifier id, long expiryTime) throws IOException {
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            this.getEditLog().logGetDelegationToken(id, expiryTime);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRenewDelegationToken(DelegationTokenIdentifier id, long expiryTime) throws IOException {
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            this.getEditLog().logRenewDelegationToken(id, expiryTime);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCancelDelegationToken(DelegationTokenIdentifier id) throws IOException {
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            this.getEditLog().logCancelDelegationToken(id);
        }
        this.getEditLog().logSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUpdateMasterKey(DelegationKey key) throws IOException {
        FSNamesystem fSNamesystem = this;
        synchronized (fSNamesystem) {
            this.getEditLog().logUpdateMasterKey(key);
        }
        this.getEditLog().logSync();
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    @Override
    public String getHostName() {
        return this.nameNodeHostName;
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public long getUsed() {
        return this.getCapacityUsed();
    }

    @Override
    public long getFree() {
        return this.getCapacityRemaining();
    }

    @Override
    public long getTotal() {
        return this.getCapacityTotal();
    }

    @Override
    public String getSafemode() {
        if (!this.isInSafeMode()) {
            return "";
        }
        return "Safe mode is ON." + this.getSafeModeTip();
    }

    @Override
    public boolean isUpgradeFinalized() {
        return this.getFSImage().isUpgradeFinalized();
    }

    @Override
    public long getNonDfsUsedSpace() {
        return this.getCapacityUsedNonDFS();
    }

    @Override
    public float getPercentUsed() {
        return this.getCapacityUsedPercent();
    }

    @Override
    public float getPercentRemaining() {
        return this.getCapacityRemainingPercent();
    }

    @Override
    public long getTotalBlocks() {
        return this.getBlocksTotal();
    }

    @Override
    public long getTotalFiles() {
        return this.getFilesTotal();
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> aliveNodeList = this.getDatanodeListForReport(FSConstants.DatanodeReportType.LIVE);
        for (DatanodeDescriptor node : aliveNodeList) {
            HashMap<String, Long> innerinfo = new HashMap<String, Long>();
            innerinfo.put("lastContact", this.getLastContact(node));
            innerinfo.put("usedSpace", this.getDfsUsed(node));
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDeadNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> deadNodeList = this.getDatanodeListForReport(FSConstants.DatanodeReportType.DEAD);
        this.removeDecomNodeFromDeadList(deadNodeList);
        for (DatanodeDescriptor node : deadNodeList) {
            HashMap<String, Long> innerinfo = new HashMap<String, Long>();
            innerinfo.put("lastContact", this.getLastContact(node));
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getDecomNodes() {
        HashMap info = new HashMap();
        ArrayList<DatanodeDescriptor> decomNodeList = this.getDecommissioningNodes();
        for (DatanodeDescriptor node : decomNodeList) {
            HashMap<String, Integer> innerinfo = new HashMap<String, Integer>();
            innerinfo.put("underReplicatedBlocks", node.decommissioningStatus.getUnderReplicatedBlocks());
            innerinfo.put("decommissionOnlyReplicas", node.decommissioningStatus.getDecommissionOnlyReplicas());
            innerinfo.put("underReplicateInOpenFiles", node.decommissioningStatus.getUnderReplicatedInOpenFiles());
            info.put(node.getHostName(), innerinfo);
        }
        return JSON.toString(info);
    }

    @Override
    public String getNameDirStatuses() {
        HashMap statusMap = new HashMap();
        HashMap<File, Storage.StorageDirType> activeDirs = new HashMap<File, Storage.StorageDirType>();
        Iterator<Storage.StorageDirectory> it = this.getFSImage().dirIterator();
        while (it.hasNext()) {
            Storage.StorageDirectory st = it.next();
            activeDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("active", activeDirs);
        List<Storage.StorageDirectory> removedStorageDirs = this.getFSImage().getRemovedStorageDirs();
        HashMap<File, Storage.StorageDirType> failedDirs = new HashMap<File, Storage.StorageDirType>();
        for (Storage.StorageDirectory st : removedStorageDirs) {
            failedDirs.put(st.getRoot(), st.getStorageDirType());
        }
        statusMap.put("failed", failedDirs);
        return JSON.toString(statusMap);
    }

    private long getLastContact(DatanodeDescriptor alivenode) {
        return (System.currentTimeMillis() - alivenode.getLastUpdate()) / 1000L;
    }

    private long getDfsUsed(DatanodeDescriptor alivenode) {
        return alivenode.getDfsUsed();
    }

    private static int roundBytesToGBytes(long bytes) {
        return Math.round((float)bytes / 1.0737418E9f);
    }

    @Override
    public void getMetrics(MetricsBuilder builder, boolean all) {
        builder.addRecord("FSNamesystem").setContext("dfs").addGauge("FilesTotal", "", this.getFilesTotal()).addGauge("BlocksTotal", "", this.getBlocksTotal()).addGauge("CapacityTotalGB", "", FSNamesystem.roundBytesToGBytes(this.getCapacityTotal())).addGauge("CapacityUsedGB", "", FSNamesystem.roundBytesToGBytes(this.getCapacityUsed())).addGauge("CapacityRemainingGB", "", FSNamesystem.roundBytesToGBytes(this.getCapacityRemaining())).addGauge("CapacityTotal", "", this.getCapacityTotal()).addGauge("CapacityUsed", "", this.getCapacityUsed()).addGauge("CapacityRemaining", "", this.getCapacityRemaining()).addGauge("CapacityUsedNonDFS", "", this.getNonDfsUsedSpace()).addGauge("TotalLoad", "", this.getTotalLoad()).addGauge("CorruptBlocks", "", this.getCorruptReplicaBlocks()).addGauge("ExcessBlocks", "", this.getExcessBlocks()).addGauge("PendingDeletionBlocks", "", this.getPendingDeletionBlocks()).addGauge("PendingReplicationBlocks", "", this.getPendingReplicationBlocks()).addGauge("UnderReplicatedBlocks", "", this.getUnderReplicatedBlocks()).addGauge("ScheduledReplicationBlocks", "", this.getScheduledReplicationBlocks()).addGauge("MissingBlocks", "", this.getMissingBlocksCount()).addGauge("BlockCapacity", "", this.getBlockCapacity()).addGauge("StaleDataNodes", "Number of datanodes marked stale due to delayed heartbeat", this.getNumStaleNodes());
    }

    private void registerWith(MetricsSystem ms) {
        ms.register("FSNamesystemMetrics", "FSNamesystem metrics", this);
    }

    private boolean isExternalInvocation() {
        return Server.getRemoteIp() != null;
    }

    void logFsckEvent(String src, InetAddress remoteAddress) throws IOException {
        if (auditLog.isInfoEnabled()) {
            FSNamesystem.logAuditEvent(UserGroupInformation.getCurrentUser(), remoteAddress, "fsck", src, null, null);
        }
    }

    void removeDecomNodeFromDeadList(ArrayList<DatanodeDescriptor> dead) {
        if (this.hostsReader.getHosts().isEmpty()) {
            return;
        }
        Iterator<DatanodeDescriptor> it = dead.iterator();
        while (it.hasNext()) {
            DatanodeDescriptor node = it.next();
            if (this.inHostsList(node, null) || this.inExcludedHostsList(node, null) || !node.isDecommissioned()) continue;
            it.remove();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.host2DataNodeMap;
    }

    void setNumStaleNodes(int numStaleNodes) {
        this.numStaleNodes = numStaleNodes;
    }

    public int getNumStaleNodes() {
        return this.numStaleNodes;
    }

    @Override
    public boolean shouldAvoidStaleDataNodesForWrite() {
        return this.avoidStaleDataNodesForWrite && (float)this.numStaleNodes <= (float)this.heartbeats.size() * this.ratioUseStaleDataNodesForWrite;
    }

    private Collection<CorruptFileBlockInfo> getCorruptFileBlocks() {
        ArrayList<CorruptFileBlockInfo> corruptFiles = new ArrayList<CorruptFileBlockInfo>();
        for (Block blk : this.neededReplications.getCorruptQueue()) {
            INodeFile inode = this.blocksMap.getINode(blk);
            if (inode == null || this.countNodes(blk).liveReplicas() != 0) continue;
            String filePath = inode.getFullPathName();
            CorruptFileBlockInfo info = new CorruptFileBlockInfo(filePath, blk);
            corruptFiles.add(info);
            if (corruptFiles.size() < this.maxCorruptFilesReturned) continue;
            break;
        }
        return corruptFiles;
    }

    synchronized Collection<CorruptFileBlockInfo> listCorruptFileBlocks() throws AccessControlException, IOException {
        this.checkSuperuserPrivilege();
        return this.getCorruptFileBlocks();
    }

    static {
        randBlockId = new Random();
    }

    static class CorruptFileBlockInfo {
        String path;
        Block block;

        public CorruptFileBlockInfo(String p, Block b) {
            this.path = p;
            this.block = b;
        }

        public String toString() {
            return this.block.getBlockName() + "\t" + this.path;
        }
    }

    class SafeModeMonitor
    implements Runnable {
        private static final long recheckInterval = 1000L;

        SafeModeMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning && FSNamesystem.this.safeMode != null && !FSNamesystem.this.safeMode.canLeave()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
            try {
                FSNamesystem.this.leaveSafeMode(true);
            }
            catch (SafeModeException es) {
                String msg = "SafeModeMonitor may not run during distributed upgrade.";
                assert (false) : msg;
                throw new RuntimeException(msg, es);
            }
            FSNamesystem.this.smmthread = null;
        }
    }

    class SafeModeInfo {
        private double threshold;
        private int datanodeThreshold;
        private int extension;
        private int safeReplication;
        private long reached = -1L;
        int blockTotal;
        private int blockSafe;
        private long lastStatusReport = 0L;

        SafeModeInfo(Configuration conf) {
            this.threshold = conf.getFloat("dfs.safemode.threshold.pct", 0.95f);
            this.datanodeThreshold = conf.getInt("dfs.namenode.safemode.min.datanodes", 0);
            this.extension = conf.getInt("dfs.safemode.extension", 0);
            this.safeReplication = conf.getInt("dfs.replication.min", 1);
            this.blockTotal = 0;
            this.blockSafe = 0;
            LOG.info((Object)("dfs.safemode.threshold.pct          = " + this.threshold));
            LOG.info((Object)("dfs.namenode.safemode.min.datanodes = " + this.datanodeThreshold));
            LOG.info((Object)("dfs.safemode.extension              = " + this.extension));
        }

        private SafeModeInfo() {
            this.threshold = 1.5;
            this.datanodeThreshold = Integer.MAX_VALUE;
            this.extension = Integer.MAX_VALUE;
            this.safeReplication = 32768;
            this.blockTotal = -1;
            this.blockSafe = -1;
            this.reached = -1L;
            this.enter();
            this.reportStatus("STATE* Safe mode is ON", true);
        }

        synchronized boolean isOn() {
            try {
                assert (this.isConsistent()) : " SafeMode: Inconsistent filesystem state: Total num of blocks, active blocks, or total safe blocks don't match";
            }
            catch (IOException e) {
                System.err.print(StringUtils.stringifyException(e));
            }
            return this.reached >= 0L;
        }

        void enter() {
            this.reached = 0L;
        }

        synchronized void leave(boolean checkForUpgrades) {
            if (checkForUpgrades) {
                boolean needUpgrade = false;
                try {
                    needUpgrade = FSNamesystem.this.startDistributedUpgradeIfNeeded();
                }
                catch (IOException e) {
                    LOG.error((Object)StringUtils.stringifyException(e));
                }
                if (needUpgrade) {
                    FSNamesystem.this.safeMode = new SafeModeInfo();
                    return;
                }
            }
            long startTimeMisReplicatedScan = FSNamesystem.now();
            FSNamesystem.this.processMisReplicatedBlocks();
            NameNode.stateChangeLog.info((Object)("STATE* Safe mode termination scan for invalid, over- and under-replicated blocks completed in " + (FSNamesystem.now() - startTimeMisReplicatedScan) + " msec"));
            long timeInSafemode = FSNamesystem.now() - FSNamesystem.this.systemStart;
            NameNode.stateChangeLog.info((Object)("STATE* Leaving safe mode after " + timeInSafemode / 1000L + " secs"));
            NameNode.getNameNodeMetrics().setSafeModeTime(timeInSafemode);
            if (this.reached >= 0L) {
                NameNode.stateChangeLog.info((Object)"STATE* Safe mode is OFF");
            }
            this.reached = -1L;
            FSNamesystem.this.safeMode = null;
            NameNode.stateChangeLog.info((Object)("STATE* Network topology has " + FSNamesystem.this.clusterMap.getNumOfRacks() + " racks and " + FSNamesystem.this.clusterMap.getNumOfLeaves() + " datanodes"));
            NameNode.stateChangeLog.info((Object)("STATE* UnderReplicatedBlocks has " + FSNamesystem.this.neededReplications.size() + " blocks"));
        }

        synchronized boolean canLeave() {
            if (this.reached == 0L) {
                return false;
            }
            if (FSNamesystem.now() - this.reached < (long)this.extension) {
                this.reportStatus("STATE* Safe mode ON", false);
                return false;
            }
            return !this.needEnter();
        }

        boolean needEnter() {
            return (double)this.getSafeBlockRatio() < this.threshold || FSNamesystem.this.numLiveDataNodes() < this.datanodeThreshold;
        }

        private float getSafeBlockRatio() {
            return this.blockTotal == 0 ? 1.0f : (float)this.blockSafe / (float)this.blockTotal;
        }

        private void checkMode() {
            if (this.needEnter()) {
                this.enter();
                this.reportStatus("STATE* Safe mode ON", false);
                return;
            }
            if (!this.isOn() || this.extension <= 0 || this.threshold <= 0.0) {
                this.leave(true);
                return;
            }
            if (this.reached > 0L) {
                this.reportStatus("STATE* Safe mode ON", false);
                return;
            }
            this.reached = FSNamesystem.now();
            FSNamesystem.this.smmthread = new Daemon(new SafeModeMonitor());
            FSNamesystem.this.smmthread.start();
            this.reportStatus("STATE* Safe mode extension entered", true);
        }

        synchronized void setBlockTotal(int total) {
            this.blockTotal = total;
            this.checkMode();
        }

        synchronized void incrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication) {
                ++this.blockSafe;
            }
            this.checkMode();
        }

        synchronized void decrementSafeBlockCount(short replication) {
            if (replication == this.safeReplication - 1) {
                --this.blockSafe;
            }
            this.checkMode();
        }

        boolean isManual() {
            return this.extension == Integer.MAX_VALUE;
        }

        void setManual() {
            this.extension = Integer.MAX_VALUE;
        }

        String getTurnOffTip() {
            String leaveMsg = "Safe mode will be turned off automatically";
            if (this.reached < 0L) {
                return "Safe mode is OFF";
            }
            if (this.isManual()) {
                if (FSNamesystem.this.getDistributedUpgradeState()) {
                    return leaveMsg + " upon completion of " + "the distributed upgrade: upgrade progress = " + FSNamesystem.this.getDistributedUpgradeStatus() + "%";
                }
                leaveMsg = "Use \"hadoop dfsadmin -safemode leave\" to turn safe mode off";
            }
            if (this.blockTotal < 0) {
                return leaveMsg + ".";
            }
            int numLive = FSNamesystem.this.numLiveDataNodes();
            String msg = "";
            if (this.reached == 0L) {
                if ((double)this.getSafeBlockRatio() < this.threshold) {
                    msg = msg + String.format("The reported blocks is only %d but the threshold is %.4f and the total blocks %d.", this.blockSafe, this.threshold, this.blockTotal);
                }
                if (numLive < this.datanodeThreshold) {
                    if (!"".equals(msg)) {
                        msg = msg + "\n";
                    }
                    msg = msg + String.format("The number of live datanodes %d needs an additional %d live datanodes to reach the minimum number %d.", numLive, this.datanodeThreshold - numLive, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            } else {
                msg = String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d.", this.blockSafe, this.threshold, this.blockTotal);
                if (this.datanodeThreshold > 0) {
                    msg = msg + String.format(" The number of live datanodes %d has reached the minimum number %d.", numLive, this.datanodeThreshold);
                }
                msg = msg + " " + leaveMsg;
            }
            if (this.reached == 0L || this.isManual()) {
                return msg + ".";
            }
            return msg + " in " + Math.abs(this.reached + (long)this.extension - FSNamesystem.now()) / 1000L + " seconds.";
        }

        private void reportStatus(String msg, boolean rightNow) {
            long curTime = FSNamesystem.now();
            if (!rightNow && curTime - this.lastStatusReport < 20000L) {
                return;
            }
            NameNode.stateChangeLog.info((Object)(msg + " \n" + this.getTurnOffTip()));
            this.lastStatusReport = curTime;
        }

        public String toString() {
            String resText = "Current safe block ratio = " + this.getSafeBlockRatio() + ". Target threshold = " + this.threshold + ". Minimal replication = " + this.safeReplication + ".";
            if (this.reached > 0L) {
                resText = resText + " Threshold was reached " + new Date(this.reached) + ".";
            }
            return resText;
        }

        boolean isConsistent() throws IOException {
            if (this.blockTotal == -1 && this.blockSafe == -1) {
                return true;
            }
            int activeBlocks = FSNamesystem.this.blocksMap.size() - (int)FSNamesystem.this.pendingDeletionBlocksCount;
            return this.blockTotal == activeBlocks || this.blockSafe >= 0 && this.blockSafe <= this.blockTotal;
        }
    }

    static class NumberReplicas {
        private int liveReplicas;
        private int decommissionedReplicas;
        private int corruptReplicas;
        private int excessReplicas;

        NumberReplicas() {
            this.initialize(0, 0, 0, 0);
        }

        NumberReplicas(int live, int decommissioned, int corrupt, int excess) {
            this.initialize(live, decommissioned, corrupt, excess);
        }

        void initialize(int live, int decommissioned, int corrupt, int excess) {
            this.liveReplicas = live;
            this.decommissionedReplicas = decommissioned;
            this.corruptReplicas = corrupt;
            this.excessReplicas = excess;
        }

        int liveReplicas() {
            return this.liveReplicas;
        }

        int decommissionedReplicas() {
            return this.decommissionedReplicas;
        }

        int corruptReplicas() {
            return this.corruptReplicas;
        }

        int excessReplicas() {
            return this.excessReplicas;
        }
    }

    class ReplicationMonitor
    implements Runnable {
        ReplicateQueueProcessingStats replicateQueueStats = new ReplicateQueueProcessingStats();
        InvalidateQueueProcessingStats invalidateQueueStats = new InvalidateQueueProcessingStats();

        ReplicationMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    FSNamesystem.this.computeDatanodeWork();
                    FSNamesystem.this.processPendingReplications();
                    Thread.sleep(FSNamesystem.this.replicationRecheckInterval);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)("ReplicationMonitor thread received InterruptedException" + ie));
                    break;
                }
                catch (IOException ie) {
                    LOG.warn((Object)("ReplicationMonitor thread received exception. " + ie + " " + StringUtils.stringifyException(ie)));
                }
                catch (Throwable t) {
                    LOG.warn((Object)("ReplicationMonitor thread received Runtime exception. " + t + " " + StringUtils.stringifyException(t)));
                    Runtime.getRuntime().exit(-1);
                }
            }
        }

        private class InvalidateQueueProcessingStats
        extends QueueProcessingStatistics {
            InvalidateQueueProcessingStats() {
                super("InvalidateQueue", "blocks", LOG);
            }

            @Override
            public boolean preCheckIsLastCycle(int maxWorkToProcess) {
                return false;
            }

            @Override
            public boolean postCheckIsLastCycle(int workFound) {
                return FSNamesystem.this.recentInvalidateSets.isEmpty();
            }
        }

        private class ReplicateQueueProcessingStats
        extends QueueProcessingStatistics {
            ReplicateQueueProcessingStats() {
                super("ReplicateQueue", "blocks", LOG);
            }

            @Override
            public boolean preCheckIsLastCycle(int maxWorkToProcess) {
                return maxWorkToProcess >= FSNamesystem.this.neededReplications.size();
            }

            @Override
            public boolean postCheckIsLastCycle(int workFound) {
                return false;
            }
        }
    }

    class HeartbeatMonitor
    implements Runnable {
        private long lastHeartbeatCheck;
        private long lastAccessKeyUpdate;

        HeartbeatMonitor() {
        }

        @Override
        public void run() {
            while (FSNamesystem.this.fsRunning) {
                try {
                    long now = FSNamesystem.now();
                    if (this.lastHeartbeatCheck + FSNamesystem.this.heartbeatRecheckInterval < now) {
                        FSNamesystem.this.heartbeatCheck();
                        this.lastHeartbeatCheck = now;
                    }
                    if (FSNamesystem.this.isAccessTokenEnabled && this.lastAccessKeyUpdate + FSNamesystem.this.accessKeyUpdateInterval < now) {
                        FSNamesystem.this.updateAccessKey();
                        this.lastAccessKeyUpdate = now;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)StringUtils.stringifyException(e));
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static enum CompleteFileStatus {
        OPERATION_FAILED,
        STILL_WAITING,
        COMPLETE_SUCCESS;

    }
}

