/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.server.tasktracker.JVMInfo;
import org.apache.hadoop.mapreduce.server.tasktracker.userlogs.JvmFinishedEvent;
import org.apache.hadoop.util.ProcessTree;
import org.apache.hadoop.util.Shell;

class JvmManager {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.mapred.JvmManager");
    private JvmManagerForType mapJvmManager;
    private JvmManagerForType reduceJvmManager;

    public JvmEnv constructJvmEnv(List<String> setup, Vector<String> vargs, File stdout, File stderr, long logSize, File workDir, JobConf conf) {
        return new JvmEnv(setup, vargs, stdout, stderr, logSize, workDir, conf);
    }

    public JvmManager(TaskTracker tracker) {
        this.mapJvmManager = new JvmManagerForType(tracker.getMaxCurrentMapTasks(), true, tracker);
        this.reduceJvmManager = new JvmManagerForType(tracker.getMaxCurrentReduceTasks(), false, tracker);
    }

    JvmManagerForType getJvmManagerForType(TaskType type) {
        if (type.equals((Object)TaskType.MAP)) {
            return this.mapJvmManager;
        }
        if (type.equals((Object)TaskType.REDUCE)) {
            return this.reduceJvmManager;
        }
        return null;
    }

    void setPidToJvm(JVMId jvmId, String pid) {
        if (jvmId.isMapJVM()) {
            this.mapJvmManager.jvmIdToPid.put(jvmId, pid);
        } else {
            this.reduceJvmManager.jvmIdToPid.put(jvmId, pid);
        }
    }

    String getPid(TaskRunner t) {
        if (t != null && t.getTask() != null) {
            if (t.getTask().isMapTask()) {
                JVMId id = this.mapJvmManager.runningTaskToJvm.get(t);
                if (id != null) {
                    return this.mapJvmManager.jvmIdToPid.get(id);
                }
            } else {
                JVMId id = this.reduceJvmManager.runningTaskToJvm.get(t);
                if (id != null) {
                    return this.reduceJvmManager.jvmIdToPid.get(id);
                }
            }
        }
        return null;
    }

    public void stop() throws IOException, InterruptedException {
        this.mapJvmManager.stop();
        this.reduceJvmManager.stop();
    }

    public boolean isJvmKnown(JVMId jvmId) {
        if (jvmId.isMapJVM()) {
            return this.mapJvmManager.isJvmknown(jvmId);
        }
        return this.reduceJvmManager.isJvmknown(jvmId);
    }

    public void launchJvm(TaskRunner t, JvmEnv env) throws IOException, InterruptedException {
        if (t.getTask().isMapTask()) {
            this.mapJvmManager.reapJvm(t, env);
        } else {
            this.reduceJvmManager.reapJvm(t, env);
        }
    }

    public boolean validateTipToJvm(TaskTracker.TaskInProgress tip, JVMId jvmId) {
        if (jvmId.isMapJVM()) {
            return this.mapJvmManager.validateTipToJvm(tip, jvmId);
        }
        return this.reduceJvmManager.validateTipToJvm(tip, jvmId);
    }

    public TaskTracker.TaskInProgress getTaskForJvm(JVMId jvmId) throws IOException {
        if (jvmId.isMapJVM()) {
            return this.mapJvmManager.getTaskForJvm(jvmId);
        }
        return this.reduceJvmManager.getTaskForJvm(jvmId);
    }

    public void taskFinished(TaskRunner tr) {
        if (tr.getTask().isMapTask()) {
            this.mapJvmManager.taskFinished(tr);
        } else {
            this.reduceJvmManager.taskFinished(tr);
        }
    }

    public void taskKilled(TaskRunner tr) throws IOException, InterruptedException {
        if (tr.getTask().isMapTask()) {
            this.mapJvmManager.taskKilled(tr);
        } else {
            this.reduceJvmManager.taskKilled(tr);
        }
    }

    public void killJvm(JVMId jvmId) throws IOException, InterruptedException {
        if (jvmId.isMap) {
            this.mapJvmManager.killJvm(jvmId);
        } else {
            this.reduceJvmManager.killJvm(jvmId);
        }
    }

    static void deleteWorkDir(TaskTracker tracker, Task task) {
        String user = task.getUser();
        String jobid = task.getJobID().toString();
        String taskid = task.getTaskID().toString();
        String workDir = TaskTracker.getTaskWorkDir(user, jobid, taskid, task.isTaskCleanupTask());
        String userDir = TaskTracker.getUserDir(user);
        tracker.getCleanupThread().addToQueue(new TaskController.DeletionContext(tracker.getTaskController(), false, user, workDir.substring(userDir.length())));
    }

    static class JvmEnv {
        List<String> vargs;
        List<String> setup;
        File stdout;
        File stderr;
        File workDir;
        long logSize;
        JobConf conf;
        Map<String, String> env;

        public JvmEnv(List<String> setup, Vector<String> vargs, File stdout, File stderr, long logSize, File workDir, JobConf conf) {
            this.setup = setup;
            this.vargs = vargs;
            this.stdout = stdout;
            this.stderr = stderr;
            this.workDir = workDir;
            this.conf = conf;
        }
    }

    static class JvmManagerForType {
        Map<JVMId, TaskRunner> jvmToRunningTask = new HashMap<JVMId, TaskRunner>();
        Map<TaskRunner, JVMId> runningTaskToJvm = new HashMap<TaskRunner, JVMId>();
        Map<JVMId, JvmRunner> jvmIdToRunner = new HashMap<JVMId, JvmRunner>();
        Map<JVMId, String> jvmIdToPid = new HashMap<JVMId, String>();
        int maxJvms;
        boolean isMap;
        private final long sleeptimeBeforeSigkill;
        Random rand = new Random(System.currentTimeMillis());
        static final String DELAY_BEFORE_KILL_KEY = "mapred.tasktracker.tasks.sleeptime-before-sigkill";
        private static final long DEFAULT_SLEEPTIME_BEFORE_SIGKILL = 250L;
        private TaskTracker tracker;

        public JvmManagerForType(int maxJvms, boolean isMap, TaskTracker tracker) {
            this.maxJvms = maxJvms;
            this.isMap = isMap;
            this.tracker = tracker;
            this.sleeptimeBeforeSigkill = tracker.getJobConf().getLong(DELAY_BEFORE_KILL_KEY, 250L);
        }

        public synchronized void setRunningTaskForJvm(JVMId jvmId, TaskRunner t) {
            this.jvmToRunningTask.put(jvmId, t);
            this.runningTaskToJvm.put(t, jvmId);
            this.jvmIdToRunner.get(jvmId).setBusy(true);
        }

        public synchronized boolean validateTipToJvm(TaskTracker.TaskInProgress tip, JVMId jvmId) {
            if (jvmId == null) {
                LOG.warn((Object)"Null jvmId. Cannot verify Jvm. validateTipToJvm returning false");
                return false;
            }
            TaskRunner taskRunner = this.jvmToRunningTask.get(jvmId);
            if (taskRunner == null) {
                return false;
            }
            TaskTracker.TaskInProgress knownTip = taskRunner.getTaskInProgress();
            return knownTip == tip;
        }

        public synchronized TaskTracker.TaskInProgress getTaskForJvm(JVMId jvmId) throws IOException {
            if (this.jvmToRunningTask.containsKey(jvmId)) {
                TaskRunner taskRunner = this.jvmToRunningTask.get(jvmId);
                JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
                Task task = taskRunner.getTaskInProgress().getTask();
                jvmRunner.taskGiven(task);
                return taskRunner.getTaskInProgress();
            }
            return null;
        }

        public synchronized boolean isJvmknown(JVMId jvmId) {
            return this.jvmIdToRunner.containsKey(jvmId);
        }

        public synchronized void taskFinished(TaskRunner tr) {
            JVMId jvmId = this.runningTaskToJvm.remove(tr);
            if (jvmId != null) {
                this.jvmToRunningTask.remove(jvmId);
                JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
                if (jvmRunner != null) {
                    jvmRunner.taskRan();
                }
            }
        }

        public synchronized void taskKilled(TaskRunner tr) throws IOException, InterruptedException {
            JVMId jvmId = this.runningTaskToJvm.remove(tr);
            if (jvmId != null) {
                this.jvmToRunningTask.remove(jvmId);
                this.killJvm(jvmId);
            }
        }

        public synchronized void killJvm(JVMId jvmId) throws IOException, InterruptedException {
            JvmRunner jvmRunner = this.jvmIdToRunner.get(jvmId);
            if (jvmRunner != null) {
                this.killJvmRunner(jvmRunner);
            }
        }

        public synchronized void stop() throws IOException, InterruptedException {
            ArrayList<JvmRunner> list = new ArrayList<JvmRunner>();
            list.addAll(this.jvmIdToRunner.values());
            for (JvmRunner jvm : list) {
                this.killJvmRunner(jvm);
            }
        }

        private synchronized void killJvmRunner(JvmRunner jvmRunner) throws IOException, InterruptedException {
            jvmRunner.kill();
            this.removeJvm(jvmRunner.jvmId);
        }

        private synchronized void removeJvm(JVMId jvmId) {
            this.jvmIdToRunner.remove(jvmId);
            this.jvmIdToPid.remove(jvmId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void reapJvm(TaskRunner t, JvmEnv env) throws IOException, InterruptedException {
            if (t.getTaskInProgress().wasKilled()) {
                return;
            }
            boolean spawnNewJvm = false;
            JobID jobId = t.getTask().getJobID();
            int numJvmsSpawned = this.jvmIdToRunner.size();
            JvmRunner runnerToKill = null;
            if (numJvmsSpawned >= this.maxJvms) {
                Iterator<Map.Entry<JVMId, JvmRunner>> jvmIter = this.jvmIdToRunner.entrySet().iterator();
                while (jvmIter.hasNext()) {
                    JvmRunner jvmRunner = jvmIter.next().getValue();
                    JobID jId = jvmRunner.jvmId.getJobId();
                    if (jId.equals(jobId) && !jvmRunner.isBusy() && !jvmRunner.ranAll()) {
                        this.setRunningTaskForJvm(jvmRunner.jvmId, t);
                        LOG.info((Object)("No new JVM spawned for jobId/taskid: " + jobId + "/" + t.getTask().getTaskID() + ". Attempting to reuse: " + jvmRunner.jvmId));
                        return;
                    }
                    if ((!jId.equals(jobId) || !jvmRunner.ranAll()) && (jId.equals(jobId) || jvmRunner.isBusy())) continue;
                    runnerToKill = jvmRunner;
                    spawnNewJvm = true;
                }
            } else {
                spawnNewJvm = true;
            }
            if (spawnNewJvm) {
                if (runnerToKill != null) {
                    LOG.info((Object)("Killing JVM: " + runnerToKill.jvmId));
                    this.killJvmRunner(runnerToKill);
                }
                this.spawnNewJvm(jobId, env, t);
                return;
            }
            try {
                LOG.fatal((Object)("Inconsistent state!!! JVM Manager reached an unstable state while reaping a JVM for task: " + t.getTask().getTaskID() + " " + this.getDetails() + ". Aborting. "));
            }
            catch (Exception e) {
                LOG.fatal((Object)e);
            }
            finally {
                System.exit(-1);
            }
        }

        private String getDetails() {
            StringBuffer details = new StringBuffer();
            details.append("Number of active JVMs:").append(this.jvmIdToRunner.size());
            for (JVMId jvmId : this.jvmIdToRunner.keySet()) {
                details.append("\n  JVMId ").append(jvmId.toString()).append(" #Tasks ran: ").append(this.jvmIdToRunner.get((Object)jvmId).numTasksRan).append(" Currently busy? ").append(this.jvmIdToRunner.get((Object)jvmId).busy).append(" Currently running: ").append(this.jvmToRunningTask.get(jvmId).getTask().getTaskID().toString());
            }
            return details.toString();
        }

        private void spawnNewJvm(JobID jobId, JvmEnv env, TaskRunner t) {
            JvmRunner jvmRunner = new JvmRunner(env, jobId, t.getTask());
            this.jvmIdToRunner.put(jvmRunner.jvmId, jvmRunner);
            jvmRunner.setDaemon(true);
            jvmRunner.setName("JVM Runner " + jvmRunner.jvmId + " spawned.");
            this.setRunningTaskForJvm(jvmRunner.jvmId, t);
            LOG.info((Object)jvmRunner.getName());
            jvmRunner.start();
        }

        private synchronized void updateOnJvmExit(JVMId jvmId, int exitCode) {
            this.removeJvm(jvmId);
            TaskRunner t = this.jvmToRunningTask.remove(jvmId);
            if (t != null) {
                this.runningTaskToJvm.remove(t);
                if (exitCode != 0) {
                    t.setExitCode(exitCode);
                }
                t.signalDone();
            }
        }

        class JvmRunner
        extends Thread {
            JvmEnv env;
            volatile boolean killed = false;
            volatile int numTasksRan;
            final int numTasksToRun;
            JVMId jvmId;
            volatile boolean busy = true;
            private Shell.ShellCommandExecutor shexec;
            private Task firstTask;
            private List<Task> tasksGiven = new ArrayList<Task>();

            void taskGiven(Task task) {
                this.tasksGiven.add(task);
            }

            public JvmRunner(JvmEnv env, JobID jobId, Task firstTask) {
                this.env = env;
                this.jvmId = new JVMId(jobId, JvmManagerForType.this.isMap, JvmManagerForType.this.rand.nextInt());
                this.numTasksToRun = env.conf.getNumTasksToExecutePerJvm();
                this.firstTask = firstTask;
                LOG.info((Object)("In JvmRunner constructed JVM ID: " + this.jvmId));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.runChild(this.env);
                }
                catch (InterruptedException ie) {
                    return;
                }
                catch (IOException e) {
                    LOG.warn((Object)"Caught IOException in JVMRunner", (Throwable)e);
                }
                catch (Throwable e) {
                    LOG.error((Object)"Caught Throwable in JVMRunner. Aborting TaskTracker.", e);
                    System.exit(1);
                }
                finally {
                    this.jvmFinished();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runChild(JvmEnv env) throws IOException, InterruptedException {
                int exitCode = 0;
                try {
                    env.vargs.add(Integer.toString(this.jvmId.getId()));
                    TaskRunner runner = JvmManagerForType.this.jvmToRunningTask.get(this.jvmId);
                    if (runner != null) {
                        Task task = runner.getTask();
                        String user = task.getUser();
                        TaskAttemptID taskAttemptId = task.getTaskID();
                        String taskAttemptIdStr = task.isTaskCleanupTask() ? taskAttemptId.toString() + ".cleanup" : taskAttemptId.toString();
                        exitCode = JvmManagerForType.this.tracker.getTaskController().launchTask(user, this.jvmId.jobId.toString(), taskAttemptIdStr, env.setup, env.vargs, env.workDir, env.stdout.toString(), env.stderr.toString());
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    this.kill();
                    JvmManagerForType.this.updateOnJvmExit(this.jvmId, exitCode);
                    LOG.info((Object)("JVM : " + this.jvmId + " exited with exit code " + exitCode + ". Number of tasks it ran: " + this.numTasksRan));
                    JvmManager.deleteWorkDir(JvmManagerForType.this.tracker, this.firstTask);
                }
            }

            synchronized void kill() throws IOException, InterruptedException {
                if (!this.killed) {
                    block6: {
                        TaskController controller = JvmManagerForType.this.tracker.getTaskController();
                        String pidStr = JvmManagerForType.this.jvmIdToPid.get(this.jvmId);
                        if (pidStr != null) {
                            String user = this.env.conf.getUser();
                            int pid = Integer.parseInt(pidStr);
                            try {
                                if (JvmManagerForType.this.sleeptimeBeforeSigkill > 0L) {
                                    new DelayedProcessKiller(user, pid, JvmManagerForType.this.sleeptimeBeforeSigkill, ProcessTree.Signal.KILL).start();
                                    controller.signalTask(user, pid, ProcessTree.Signal.TERM);
                                    break block6;
                                }
                                controller.signalTask(user, pid, ProcessTree.Signal.KILL);
                            }
                            catch (IOException e) {
                                LOG.error((Object)"Catch Exception caused by lack of user information to prevent inconsistent state: ", (Throwable)e);
                            }
                        } else {
                            LOG.info((Object)String.format("JVM Not killed %s but just removed", this.jvmId.toString()));
                        }
                    }
                    this.killed = true;
                }
            }

            private void jvmFinished() {
                JvmFinishedEvent jfe = new JvmFinishedEvent(new JVMInfo(TaskLog.getAttemptDir(this.firstTask.getTaskID(), this.firstTask.isTaskCleanupTask()), this.tasksGiven));
                JvmManagerForType.this.tracker.getUserLogManager().addLogEvent(jfe);
            }

            public void taskRan() {
                this.busy = false;
                ++this.numTasksRan;
            }

            public boolean ranAll() {
                return this.numTasksRan == this.numTasksToRun;
            }

            public void setBusy(boolean busy) {
                this.busy = busy;
            }

            public boolean isBusy() {
                return this.busy;
            }

            private class DelayedProcessKiller
            extends Thread {
                private final String user;
                private final int pid;
                private final long delay;
                private final ProcessTree.Signal signal;

                DelayedProcessKiller(String user, int pid, long delay, ProcessTree.Signal signal) {
                    this.user = user;
                    this.pid = pid;
                    this.delay = delay;
                    this.signal = signal;
                    this.setName("Task killer for " + pid);
                    this.setDaemon(false);
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(this.delay);
                        JvmManagerForType.this.tracker.getTaskController().signalTask(this.user, this.pid, this.signal);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Exception when killing task " + this.pid), (Throwable)e);
                    }
                }
            }
        }
    }
}

