/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.JobHistoryServer;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;
import org.apache.jasper.runtime.ResourceInjector;
import org.codehaus.jackson.map.ObjectMapper;

public final class jobdetails_jsp
extends HttpJspBase
implements JspSourceDependent {
    static SimpleDateFormat dateFormat = new SimpleDateFormat("d-MMM-yyyy HH:mm:ss");
    private static final long serialVersionUID = 1L;
    private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();
    private static Vector _jspx_dependants;
    private ResourceInjector _jspx_resourceInjector;

    private void printTaskSummary(JspWriter out, String jobId, String kind, double completePercent, TaskInProgress[] tasks) throws IOException {
        int totalTasks = tasks.length;
        int runningTasks = 0;
        int finishedTasks = 0;
        int killedTasks = 0;
        int failedTaskAttempts = 0;
        int killedTaskAttempts = 0;
        for (int i = 0; i < totalTasks; ++i) {
            TaskInProgress task = tasks[i];
            if (task.isComplete()) {
                ++finishedTasks;
            } else if (task.isRunning()) {
                ++runningTasks;
            } else if (task.wasKilled()) {
                ++killedTasks;
            }
            failedTaskAttempts += task.numTaskFailures();
            killedTaskAttempts += task.numKilledTasks();
        }
        int pendingTasks = totalTasks - runningTasks - killedTasks - finishedTasks;
        out.print("<tr><th><a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1\">" + kind + "</a></th><td align=\"right\">" + StringUtils.formatPercent(completePercent, 2) + ServletUtil.percentageGraph((int)(completePercent * 100.0), 80) + "</td><td align=\"right\">" + totalTasks + "</td><td align=\"right\">" + (pendingTasks > 0 ? "<a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1" + "&state=pending\">" + pendingTasks + "</a>" : "0") + "</td><td align=\"right\">" + (runningTasks > 0 ? "<a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1" + "&state=running\">" + runningTasks + "</a>" : "0") + "</td><td align=\"right\">" + (finishedTasks > 0 ? "<a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1" + "&state=completed\">" + finishedTasks + "</a>" : "0") + "</td><td align=\"right\">" + (killedTasks > 0 ? "<a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1" + "&state=killed\">" + killedTasks + "</a>" : "0") + "</td><td align=\"right\">" + (failedTaskAttempts > 0 ? "<a href=\"jobfailures.jsp?jobid=" + jobId + "&kind=" + kind + "&cause=failed\">" + failedTaskAttempts + "</a>" : "0") + " / " + (killedTaskAttempts > 0 ? "<a href=\"jobfailures.jsp?jobid=" + jobId + "&kind=" + kind + "&cause=killed\">" + killedTaskAttempts + "</a>" : "0") + "</td></tr>\n");
    }

    private void printJobLevelTaskSummary(JspWriter out, String jobId, String kind, TaskInProgress[] tasks) throws IOException {
        int totalTasks = tasks.length;
        int runningTasks = 0;
        int finishedTasks = 0;
        int killedTasks = 0;
        for (int i = 0; i < totalTasks; ++i) {
            TaskInProgress task = tasks[i];
            if (task.isComplete()) {
                ++finishedTasks;
                continue;
            }
            if (task.isRunning()) {
                ++runningTasks;
                continue;
            }
            if (!task.isFailed()) continue;
            ++killedTasks;
        }
        int pendingTasks = totalTasks - runningTasks - killedTasks - finishedTasks;
        out.print(runningTasks > 0 ? "<a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1" + "&state=running\">" + " Running" + "</a>" : (pendingTasks > 0 ? " Pending" : (finishedTasks > 0 ? "<a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1" + "&state=completed\">" + " Successful" + "</a>" : (killedTasks > 0 ? "<a href=\"jobtasks.jsp?jobid=" + jobId + "&type=" + kind + "&pagenum=1" + "&state=killed\">" + " Failed" + "</a>" : "None"))));
    }

    private void printConfirm(JspWriter out, String jobId) throws IOException {
        String url = "jobdetails.jsp?jobid=" + jobId;
        out.print("<html><head><META http-equiv=\"refresh\" content=\"15;URL=" + url + "\"></head>" + "<body><h3> Are you sure you want to kill " + jobId + " ?<h3><br><table border=\"0\"><tr><td width=\"100\">" + "<form action=\"" + url + "\" method=\"post\">" + "<input type=\"hidden\" name=\"action\" value=\"kill\" />" + "<input type=\"submit\" name=\"kill\" value=\"Kill\" />" + "</form>" + "</td><td width=\"100\"><form method=\"post\" action=\"" + url + "\"><input type=\"submit\" value=\"Cancel\" name=\"Cancel\"" + "/></form></td></tr></table></body></html>");
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block64: {
            block62: {
                block63: {
                    block61: {
                        block60: {
                            block59: {
                                block58: {
                                    block57: {
                                        block65: {
                                            pageContext = null;
                                            session = null;
                                            application = null;
                                            config = null;
                                            out = null;
                                            page = this;
                                            _jspx_out = null;
                                            _jspx_page_context = null;
                                            response.setContentType("text/html");
                                            _jspx_page_context = pageContext = jobdetails_jsp._jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
                                            application = pageContext.getServletContext();
                                            config = pageContext.getServletConfig();
                                            session = pageContext.getSession();
                                            _jspx_out = out = pageContext.getOut();
                                            this._jspx_resourceInjector = (ResourceInjector)application.getAttribute("com.sun.appserv.jsp.resource.injector");
                                            out.write("\n\n\n");
                                            out.write(10);
                                            out.write(10);
                                            out.write("       \n\n");
                                            out.write(10);
                                            out.write(10);
                                            response_format = request.getParameter("format");
                                            if (response_format == null) break block65;
                                            theJobDetailsResponse = null;
                                            theErrorResponse = null;
                                            tracker = (JobTracker)application.getAttribute("job.tracker");
                                            jobId = request.getParameter("jobid");
                                            if (jobId != null) {
                                                jobIdObj = JobID.forName(jobId);
                                                myJob = JSPUtil.checkAccessAndGetJob(tracker, jobIdObj, request, response);
                                                if (myJob.isViewJobAllowed()) {
                                                    job = myJob.getJob();
                                                    if (job != null) {
                                                        theJobDetailsResponse = new JobDetailsResponse(jobId, job, tracker);
                                                    } else {
                                                        response.setStatus(404);
                                                        theErrorResponse = new ErrorResponse(4101L, "JobID " + jobId + " Not Found");
                                                    }
                                                }
                                            } else {
                                                response.setStatus(400);
                                                theErrorResponse = new ErrorResponse(4100L, "Missing JobID");
                                            }
                                            if ("json".equals(response_format)) {
                                                response.setContentType("application/json");
                                                responseObjectMapper = new ObjectMapper();
                                                out.println(responseObjectMapper.writeValueAsString(theErrorResponse == null ? theJobDetailsResponse : theErrorResponse));
                                            } else {
                                                response.setStatus(501);
                                            }
                                            ** GOTO lbl314
                                        }
                                        out.write(10);
                                        response.setContentType("text/html; charset=UTF-8");
                                        tracker = (JobTracker)application.getAttribute("job.tracker");
                                        trackerName = StringUtils.simpleHostname(tracker.getJobTrackerMachine());
                                        jobId = request.getParameter("jobid");
                                        refreshParam = request.getParameter("refresh");
                                        if (jobId != null) break block57;
                                        out.println("<h2>Missing 'jobid'!</h2>");
                                        jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                                        return;
                                    }
                                    refresh = 60;
                                    if (refreshParam != null) {
                                        try {
                                            refresh = Integer.parseInt(refreshParam);
                                        }
                                        catch (NumberFormatException ignored) {
                                            // empty catch block
                                        }
                                    }
                                    if ((myJob = JSPUtil.checkAccessAndGetJob(tracker, jobIdObj = JobID.forName(jobId), request, response)).isViewJobAllowed()) break block58;
                                    jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                                    return;
                                }
                                job = myJob.getJob();
                                newPriority = request.getParameter("prio");
                                user = request.getRemoteUser();
                                ugi = null;
                                if (user != null) {
                                    ugi = UserGroupInformation.createRemoteUser(user);
                                }
                                action = request.getParameter("action");
                                if (!JSPUtil.privateActionsAllowed(tracker.conf) || !"changeprio".equalsIgnoreCase(action) || !request.getMethod().equalsIgnoreCase("POST")) ** GOTO lbl95
                                if (ugi == null) break block59;
                                try {
                                    ugi.doAs(new PrivilegedExceptionAction<Void>(){

                                        @Override
                                        public Void run() throws IOException {
                                            tracker.setJobPriority(jobIdObj, JobPriority.valueOf(newPriority));
                                            return null;
                                        }
                                    });
                                    ** GOTO lbl95
                                }
                                catch (AccessControlException e) {
                                    errMsg = "User " + user + " failed to modify priority of " + jobIdObj + "!<br><br>" + e.getMessage() + "<hr><a href=\"jobdetails.jsp?jobid=" + jobId + "\">Go back to Job</a><br>";
                                    JSPUtil.setErrorAndForward(errMsg, request, response);
                                    jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                                    return;
                                }
                            }
                            tracker.setJobPriority(jobIdObj, JobPriority.valueOf(newPriority));
lbl95:
                            // 3 sources

                            if (!JSPUtil.privateActionsAllowed(tracker.conf)) ** GOTO lbl117
                            action = request.getParameter("action");
                            if (action == null || !action.equalsIgnoreCase("confirm")) break block60;
                            this.printConfirm(out, jobId);
                            jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                            return;
                        }
                        if (action == null || !action.equalsIgnoreCase("kill") || !request.getMethod().equalsIgnoreCase("POST")) ** GOTO lbl117
                        if (ugi == null) break block61;
                        try {
                            ugi.doAs(new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws IOException {
                                    tracker.killJob(jobIdObj);
                                    return null;
                                }
                            });
                            ** GOTO lbl117
                        }
                        catch (AccessControlException e) {
                            errMsg = "User " + user + " failed to kill " + jobIdObj + "!<br><br>" + e.getMessage() + "<hr><a href=\"jobdetails.jsp?jobid=" + jobId + "\">Go back to Job</a><br>";
                            JSPUtil.setErrorAndForward(errMsg, request, response);
                            jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                            return;
                        }
                    }
                    tracker.killJob(jobIdObj);
lbl117:
                    // 4 sources

                    out.write("\n\n\n<!DOCTYPE html>\n<html>\n<head>\n  ");
                    if (refresh != 0) {
                        out.write("\n      <meta http-equiv=\"refresh\" content=\"");
                        out.print(refresh);
                        out.write("\">\n      ");
                    }
                    out.write("\n<title>Hadoop ");
                    out.print(jobId);
                    out.write(" on ");
                    out.print(trackerName);
                    out.write("</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n</head>\n<body>\n<h1>Hadoop ");
                    out.print(jobId);
                    out.write(" on <a href=\"jobtracker.jsp\">");
                    out.print(trackerName);
                    out.write("</a></h1>\n\n");
                    if (job != null) break block62;
                    historyFile = JobHistory.getHistoryFilePath(jobIdObj);
                    if (historyFile != null) break block63;
                    out.println("<h2>Job " + jobId + " not known!</h2>");
                    jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                    return;
                }
                historyUrl = JobHistoryServer.getHistoryUrlPrefix(tracker.conf) + "/jobdetailshistory.jsp?logFile=" + JobHistory.JobInfo.encodeJobHistoryFilePath(historyFile);
                response.sendRedirect(response.encodeRedirectURL(historyUrl));
                jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                return;
            }
            try {
                profile = job.getProfile();
                status = job.getStatus();
                runState = status.getRunState();
                flakyTaskTrackers = job.getNoOfBlackListedTrackers();
                out.print("<b>User:</b> " + HtmlQuoting.quoteHtmlChars(profile.getUser()) + "<br>\n");
                out.print("<b>Job Name:</b> " + HtmlQuoting.quoteHtmlChars(profile.getJobName()) + "<br>\n");
                out.print("<b>Job File:</b> <a href=\"jobconf.jsp?jobid=" + jobId + "\">" + profile.getJobFile() + "</a><br>\n");
                out.print("<b>Submit Host:</b> " + HtmlQuoting.quoteHtmlChars(job.getJobSubmitHostName()) + "<br>\n");
                out.print("<b>Submit Host Address:</b> " + HtmlQuoting.quoteHtmlChars(job.getJobSubmitHostAddress()) + "<br>\n");
                jobAcls = status.getJobACLs();
                JSPUtil.printJobACLs(tracker, jobAcls, out);
                out.print("<b>Job Setup:</b>");
                this.printJobLevelTaskSummary(out, jobId, "setup", job.getTasks(TaskType.JOB_SETUP));
                out.print("<br>\n");
                if (runState == 1) {
                    out.print("<b>Status:</b> Running<br>\n");
                    out.print("<b>Started at:</b> " + new Date(job.getStartTime()) + "<br>\n");
                    out.print("<b>Running for:</b> " + StringUtils.formatTimeDiff(System.currentTimeMillis(), job.getStartTime()) + "<br>\n");
                } else if (runState == 2) {
                    out.print("<b>Status:</b> Succeeded<br>\n");
                    out.print("<b>Started at:</b> " + new Date(job.getStartTime()) + "<br>\n");
                    out.print("<b>Finished at:</b> " + new Date(job.getFinishTime()) + "<br>\n");
                    out.print("<b>Finished in:</b> " + StringUtils.formatTimeDiff(job.getFinishTime(), job.getStartTime()) + "<br>\n");
                } else if (runState == 3) {
                    out.print("<b>Status:</b> Failed<br>\n");
                    out.print("<b>Failure Info:</b>" + HtmlQuoting.quoteHtmlChars(status.getFailureInfo()) + "<br>\n");
                    out.print("<b>Started at:</b> " + new Date(job.getStartTime()) + "<br>\n");
                    out.print("<b>Failed at:</b> " + new Date(job.getFinishTime()) + "<br>\n");
                    out.print("<b>Failed in:</b> " + StringUtils.formatTimeDiff(job.getFinishTime(), job.getStartTime()) + "<br>\n");
                } else if (runState == 5) {
                    out.print("<b>Status:</b> Killed<br>\n");
                    out.print("<b>Failure Info:</b>" + HtmlQuoting.quoteHtmlChars(status.getFailureInfo()) + "<br>\n");
                    out.print("<b>Started at:</b> " + new Date(job.getStartTime()) + "<br>\n");
                    out.print("<b>Killed at:</b> " + new Date(job.getFinishTime()) + "<br>\n");
                    out.print("<b>Killed in:</b> " + StringUtils.formatTimeDiff(job.getFinishTime(), job.getStartTime()) + "<br>\n");
                }
                out.print("<b>Job Cleanup:</b>");
                this.printJobLevelTaskSummary(out, jobId, "cleanup", job.getTasks(TaskType.JOB_CLEANUP));
                out.print("<br>\n");
                if (flakyTaskTrackers > 0) {
                    out.print("<b>Black-listed TaskTrackers:</b> <a href=\"jobblacklistedtrackers.jsp?jobid=" + jobId + "\">" + flakyTaskTrackers + "</a><br>\n");
                }
                if (job.getSchedulingInfo() != null) {
                    out.print("<b>Job Scheduling information: </b>" + job.getSchedulingInfo().toString() + "\n");
                }
                out.print("<hr>\n");
                out.print("<table border=2 cellpadding=\"5\" cellspacing=\"2\">");
                out.print("<tr><th>Kind</th><th>% Complete</th><th>Num Tasks</th><th>Pending</th><th>Running</th><th>Complete</th><th>Killed</th><th><a href=\"jobfailures.jsp?jobid=" + jobId + "\">Failed/Killed<br>Task Attempts</a></th></tr>\n");
                this.printTaskSummary(out, jobId, "map", status.mapProgress(), job.getTasks(TaskType.MAP));
                this.printTaskSummary(out, jobId, "reduce", status.reduceProgress(), job.getTasks(TaskType.REDUCE));
                out.print("</table>\n");
                out.write("\n    <p/>\n    <table border=2 cellpadding=\"5\" cellspacing=\"2\">\n    <tr>\n      <th><br/></th>\n      <th>Counter</th>\n      <th>Map</th>\n      <th>Reduce</th>\n      <th>Total</th>\n    </tr>\n    ");
                isFine = true;
                mapCounters = new Counters();
                isFine = job.getMapCounters(mapCounters);
                mapCounters = isFine != false ? mapCounters : new Counters();
                reduceCounters = new Counters();
                isFine = job.getReduceCounters(reduceCounters);
                reduceCounters = isFine != false ? reduceCounters : new Counters();
                totalCounters = new Counters();
                isFine = job.getCounters(totalCounters);
                totalCounters = isFine != false ? totalCounters : new Counters();
                for (String groupName : totalCounters.getGroupNames()) {
                    totalGroup = totalCounters.getGroup(groupName);
                    mapGroup = mapCounters.getGroup(groupName);
                    reduceGroup = reduceCounters.getGroup(groupName);
                    decimal = new DecimalFormat();
                    isFirst = true;
                    for (Counters.Counter counter : totalGroup) {
                        displayName = counter.getDisplayName();
                        name = counter.getName();
                        mapValue = decimal.format((Object)mapGroup.getCounter(name));
                        reduceValue = decimal.format((Object)reduceGroup.getCounter(name));
                        totalValue = decimal.format((Object)counter.getCounter());
                        out.write("\n        <tr>\n          ");
                        if (isFirst) {
                            isFirst = false;
                            out.write("\n            <td rowspan=\"");
                            out.print(totalGroup.size());
                            out.write("\">\n            ");
                            out.print(HtmlQuoting.quoteHtmlChars(totalGroup.getDisplayName()));
                            out.write("</td>\n            ");
                        }
                        out.write("\n          <td>");
                        out.print(HtmlQuoting.quoteHtmlChars(displayName));
                        out.write("</td>\n          <td align=\"right\">");
                        out.print(mapValue);
                        out.write("</td>\n          <td align=\"right\">");
                        out.print(reduceValue);
                        out.write("</td>\n          <td align=\"right\">");
                        out.print(totalValue);
                        out.write("</td>\n        </tr>\n        ");
                    }
                }
                out.write("\n    </table>\n\n<hr>Map Completion Graph - \n");
                if ("off".equals(request.getParameter("map.graph"))) {
                    session.setAttribute("map.graph", (Object)"off");
                } else if ("on".equals(request.getParameter("map.graph"))) {
                    session.setAttribute("map.graph", (Object)"on");
                }
                if ("off".equals(request.getParameter("reduce.graph"))) {
                    session.setAttribute("reduce.graph", (Object)"off");
                } else if ("on".equals(request.getParameter("reduce.graph"))) {
                    session.setAttribute("reduce.graph", (Object)"on");
                }
                if ("off".equals(session.getAttribute("map.graph"))) {
                    out.write("\n<a href=\"/jobdetails.jsp?jobid=");
                    out.print(jobId);
                    out.write("&refresh=");
                    out.print(refresh);
                    out.write("&map.graph=on\" > open </a>\n");
                } else {
                    out.write(" \n<a href=\"/jobdetails.jsp?jobid=");
                    out.print(jobId);
                    out.write("&refresh=");
                    out.print(refresh);
                    out.write("&map.graph=off\" > close </a>\n<br><embed src=\"/taskgraph?type=map&jobid=");
                    out.print(jobId);
                    out.write("\" \n       width=\"");
                    out.print(760);
                    out.write("\" \n       height=\"");
                    out.print(260);
                    out.write("\"\n       style=\"width:100%\" type=\"image/svg+xml\" pluginspage=\"http://www.adobe.com/svg/viewer/install/\" />\n");
                }
                out.write(10);
                out.write(10);
                if (job.getTasks(TaskType.REDUCE).length > 0) {
                    out.write("\n<hr>Reduce Completion Graph -\n");
                    if ("off".equals(session.getAttribute("reduce.graph"))) {
                        out.write("\n<a href=\"/jobdetails.jsp?jobid=");
                        out.print(jobId);
                        out.write("&refresh=");
                        out.print(refresh);
                        out.write("&reduce.graph=on\" > open </a>\n");
                    } else {
                        out.write(" \n<a href=\"/jobdetails.jsp?jobid=");
                        out.print(jobId);
                        out.write("&refresh=");
                        out.print(refresh);
                        out.write("&reduce.graph=off\" > close </a>\n \n <br><embed src=\"/taskgraph?type=reduce&jobid=");
                        out.print(jobId);
                        out.write("\" \n       width=\"");
                        out.print(760);
                        out.write("\" \n       height=\"");
                        out.print(260);
                        out.write("\" \n       style=\"width:100%\" type=\"image/svg+xml\" pluginspage=\"http://www.adobe.com/svg/viewer/install/\" />\n");
                    }
                }
                out.write("\n\n<hr>\n");
                if (JSPUtil.privateActionsAllowed(tracker.conf)) {
                    out.write("\n  <table border=\"0\"> <tr> <td>\n  Change priority from ");
                    out.print((Object)job.getPriority());
                    out.write(" to:\n  <form action=\"jobdetails.jsp\" method=\"post\">\n  <input type=\"hidden\" name=\"action\" value=\"changeprio\"/>\n  <input type=\"hidden\" name=\"jobid\" value=\"");
                    out.print(jobId);
                    out.write("\"/>\n  </td><td> <select name=\"prio\"> \n  ");
                    jobPrio = job.getPriority();
                    for (JobPriority prio : JobPriority.values()) {
                        if (jobPrio == prio) continue;
                        out.write(" <option value=");
                        out.print((Object)prio);
                        out.write(62);
                        out.print((Object)prio);
                        out.write("</option> ");
                    }
                    out.write("\n  </select> </td><td><input type=\"submit\" value=\"Submit\"> </form></td></tr> </table>\n");
                }
                out.write("\n\n<table border=\"0\"> <tr>\n    \n");
                if (JSPUtil.privateActionsAllowed(tracker.conf) && runState == 1) {
                    out.write("\n\t<br/><a href=\"jobdetails.jsp?action=confirm&jobid=");
                    out.print(jobId);
                    out.write("\"> Kill this job </a>\n");
                }
                out.write("\n\n<hr>\n\n<hr>\n<a href=\"jobtracker.jsp\">Go back to JobTracker</a><br>\n");
                out.println(ServletUtil.htmlFooter());
                out.write(10);
lbl314:
                // 3 sources

                out.write(10);
            }
            catch (Throwable t) {
                try {
                    if (!(t instanceof SkipPageException)) {
                        out = _jspx_out;
                        if (out != null && out.getBufferSize() != 0) {
                            out.clearBuffer();
                        }
                        if (_jspx_page_context != null) {
                            _jspx_page_context.handlePageException(t);
                        }
                    }
                    break block64;
                }
                catch (Throwable var47_64) {
                    throw var47_64;
                }
                finally {
                    jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
            jobdetails_jsp._jspxFactory.releasePageContext(_jspx_page_context);
        }
    }

    public static class JobDetailsResponse {
        private final String jobId;
        private final JobMetaInfo metaInfo;
        private final JobTaskSummary mapTaskSummary;
        private final JobTaskSummary reduceTaskSummary;
        private final Collection<JobCounterGroupInfo> jobCounterGroupsInfo;

        private void populateJobCounterGroups(JobInProgress jip) {
            boolean isFine = true;
            Counters mapCounters = new Counters();
            isFine = jip.getMapCounters(mapCounters);
            mapCounters = isFine ? mapCounters : new Counters();
            Counters reduceCounters = new Counters();
            isFine = jip.getReduceCounters(reduceCounters);
            reduceCounters = isFine ? reduceCounters : new Counters();
            Counters totalCounters = new Counters();
            isFine = jip.getCounters(totalCounters);
            totalCounters = isFine ? totalCounters : new Counters();
            for (String groupName : totalCounters.getGroupNames()) {
                Counters.Group totalGroup = totalCounters.getGroup(groupName);
                Counters.Group mapGroup = mapCounters.getGroup(groupName);
                Counters.Group reduceGroup = reduceCounters.getGroup(groupName);
                JobCounterGroupInfo jobCounterGroupInfo = new JobCounterGroupInfo(totalGroup.getDisplayName());
                for (Counters.Counter counter : totalGroup) {
                    String name = counter.getDisplayName();
                    long mapValue = mapGroup.getCounter(name);
                    long reduceValue = reduceGroup.getCounter(name);
                    long totalValue = counter.getCounter();
                    jobCounterGroupInfo.addJobCounterInfo(new JobCounterGroupInfo.JobCounterInfo(name, mapValue, reduceValue, totalValue));
                }
                this.addJobCounterGroupInfo(jobCounterGroupInfo);
            }
        }

        JobDetailsResponse(String ji, JobInProgress jip, JobTracker jt) {
            this.jobId = ji;
            this.metaInfo = new JobMetaInfo(jip, jt);
            JobStatus status = jip.getStatus();
            this.mapTaskSummary = new JobTaskSummary(status.mapProgress() * 100.0f, jip, TaskType.MAP);
            this.reduceTaskSummary = new JobTaskSummary(status.reduceProgress() * 100.0f, jip, TaskType.REDUCE);
            this.jobCounterGroupsInfo = new ArrayList<JobCounterGroupInfo>();
            this.populateJobCounterGroups(jip);
        }

        void addJobCounterGroupInfo(JobCounterGroupInfo jcgi) {
            this.jobCounterGroupsInfo.add(jcgi);
        }

        public String getJobId() {
            return this.jobId;
        }

        public JobMetaInfo getMetaInfo() {
            return this.metaInfo;
        }

        public JobTaskSummary getMapTaskSummary() {
            return this.mapTaskSummary;
        }

        public JobTaskSummary getReduceTaskSummary() {
            return this.reduceTaskSummary;
        }

        public Collection<JobCounterGroupInfo> getJobCounterGroupsInfo() {
            return this.jobCounterGroupsInfo;
        }

        public static class JobCounterGroupInfo {
            private final String groupName;
            private final Collection<JobCounterInfo> jobCountersInfo;

            JobCounterGroupInfo(String gn) {
                this.groupName = gn;
                this.jobCountersInfo = new ArrayList<JobCounterInfo>();
            }

            void addJobCounterInfo(JobCounterInfo jci) {
                this.jobCountersInfo.add(jci);
            }

            public String getGroupName() {
                return this.groupName;
            }

            public Collection<JobCounterInfo> getJobCountersInfo() {
                return this.jobCountersInfo;
            }

            public static class JobCounterInfo {
                private final String name;
                private final long mapValue;
                private final long reduceValue;
                private final long totalValue;

                JobCounterInfo(String n, long mv, long rv, long tv) {
                    this.name = n;
                    this.mapValue = mv;
                    this.reduceValue = rv;
                    this.totalValue = tv;
                }

                public String getName() {
                    return this.name;
                }

                public long getMapValue() {
                    return this.mapValue;
                }

                public long getReduceValue() {
                    return this.reduceValue;
                }

                public long getTotalValue() {
                    return this.totalValue;
                }
            }
        }

        public static class JobTaskSummary {
            private final float progressPercentage;
            private final JobTaskStats taskStats;

            JobTaskSummary(float pp, JobInProgress jip, TaskType tt) {
                this.progressPercentage = pp;
                this.taskStats = new JobTaskStats(jip, tt);
            }

            public float getProgressPercentage() {
                return this.progressPercentage;
            }

            public JobTaskStats getTaskStats() {
                return this.taskStats;
            }
        }

        public static class JobMetaInfo {
            private final String jobTrackerName;
            private final String jobName;
            private final String userName;
            private final String jobFileLocation;
            private final String jobSubmissionHostName;
            private final String jobSubmissionHostAddress;
            private final String jobSetupStatus;
            private final String jobCleanupStatus;
            private final String jobStatus;
            private final String jobStatusInfo;
            private final EventTimingInfo jobStartTimingInfo;
            private final EventTimingInfo jobFinishTimingInfo;
            private final int numFlakyTaskTrackers;
            private final String jobSchedulingInfo;

            JobMetaInfo(JobInProgress jip, JobTracker jt) {
                this.jobTrackerName = StringUtils.simpleHostname(jt.getJobTrackerMachine());
                JobProfile jobProfile = jip.getProfile();
                this.jobName = jobProfile.getJobName();
                this.userName = jobProfile.getUser();
                this.jobFileLocation = jobProfile.getJobFile();
                this.jobSubmissionHostName = jip.getJobSubmitHostName();
                this.jobSubmissionHostAddress = jip.getJobSubmitHostAddress();
                JobStatus status = jip.getStatus();
                this.jobSetupStatus = this.deduceJobTaskStatus(jip, TaskType.JOB_SETUP);
                this.jobCleanupStatus = this.deduceJobTaskStatus(jip, TaskType.JOB_CLEANUP);
                switch (status.getRunState()) {
                    case 1: {
                        this.jobStatus = "Running";
                        this.jobStatusInfo = null;
                        this.jobStartTimingInfo = new EventTimingInfo(jip.getStartTime(), System.currentTimeMillis());
                        this.jobFinishTimingInfo = null;
                        break;
                    }
                    case 2: {
                        this.jobStatus = "Succeeded";
                        this.jobStatusInfo = null;
                        this.jobStartTimingInfo = new EventTimingInfo(jip.getStartTime(), 0L);
                        this.jobFinishTimingInfo = new EventTimingInfo(jip.getFinishTime(), jip.getStartTime());
                        break;
                    }
                    case 3: {
                        this.jobStatus = "Failed";
                        this.jobStatusInfo = status.getFailureInfo();
                        this.jobStartTimingInfo = new EventTimingInfo(jip.getStartTime(), 0L);
                        this.jobFinishTimingInfo = new EventTimingInfo(jip.getFinishTime(), jip.getStartTime());
                        break;
                    }
                    case 5: {
                        this.jobStatus = "Killed";
                        this.jobStatusInfo = status.getFailureInfo();
                        this.jobStartTimingInfo = new EventTimingInfo(jip.getStartTime(), 0L);
                        this.jobFinishTimingInfo = new EventTimingInfo(jip.getFinishTime(), jip.getStartTime());
                        break;
                    }
                    default: {
                        this.jobStatus = "Unknown";
                        this.jobStatusInfo = "Unknown";
                        this.jobStartTimingInfo = null;
                        this.jobFinishTimingInfo = null;
                    }
                }
                this.numFlakyTaskTrackers = jip.getNoOfBlackListedTrackers();
                this.jobSchedulingInfo = jip.getSchedulingInfo() != null ? jip.getSchedulingInfo().toString() : null;
            }

            private String deduceJobTaskStatus(JobInProgress jip, TaskType tt) {
                JobTaskStats taskStats = new JobTaskStats(jip, tt);
                return taskStats.getNumRunningTasks() > 0 ? "Running" : (taskStats.getNumPendingTasks() > 0 ? "Pending" : (taskStats.getNumFinishedTasks() > 0 ? "Successful" : (taskStats.getNumKilledTasks() > 0 ? "Failed" : "None")));
            }

            public String getJobTrackerName() {
                return this.jobTrackerName;
            }

            public String getJobName() {
                return this.jobName;
            }

            public String getUserName() {
                return this.userName;
            }

            public String getJobFileLocation() {
                return this.jobFileLocation;
            }

            public String getJobSubmissionHostName() {
                return this.jobSubmissionHostName;
            }

            public String getJobSubmissionHostAddress() {
                return this.jobSubmissionHostAddress;
            }

            public String getJobSetupStatus() {
                return this.jobSetupStatus;
            }

            public String getJobCleanupStatus() {
                return this.jobCleanupStatus;
            }

            public String getJobStatus() {
                return this.jobStatus;
            }

            public String getJobStatusInfo() {
                return this.jobStatusInfo;
            }

            public EventTimingInfo getJobStartTimingInfo() {
                return this.jobStartTimingInfo;
            }

            public EventTimingInfo getJobFinishTimingInfo() {
                return this.jobFinishTimingInfo;
            }

            public int getNumFlakyTaskTrackers() {
                return this.numFlakyTaskTrackers;
            }

            public String getJobSchedulingInfo() {
                return this.jobSchedulingInfo;
            }

            public static class EventTimingInfo {
                private final String timestamp;
                private final long durationSecs;

                EventTimingInfo(long eventOccurrenceTimeMSecs, long previousEventOccurrenceTimeMSecs) {
                    this.timestamp = dateFormat.format(new Date(eventOccurrenceTimeMSecs));
                    this.durationSecs = 0L != previousEventOccurrenceTimeMSecs ? Math.abs(eventOccurrenceTimeMSecs - previousEventOccurrenceTimeMSecs) / 1000L : 0L;
                }

                public String getTimestamp() {
                    return this.timestamp;
                }

                public long getDurationSecs() {
                    return this.durationSecs;
                }
            }
        }

        public static class JobTaskStats {
            private final int numTotalTasks;
            private final int numPendingTasks;
            private final int numRunningTasks;
            private final int numFinishedTasks;
            private final int numKilledTasks;
            private final int numFailedTaskAttempts;
            private final int numKilledTaskAttempts;

            JobTaskStats(JobInProgress jip, TaskType tt) {
                TaskInProgress[] tasks = jip.getTasks(tt);
                int totalTasks = tasks.length;
                int runningTasks = 0;
                int finishedTasks = 0;
                int killedTasks = 0;
                int failedTaskAttempts = 0;
                int killedTaskAttempts = 0;
                for (int i = 0; i < totalTasks; ++i) {
                    TaskInProgress task = tasks[i];
                    if (task.isComplete()) {
                        ++finishedTasks;
                    } else if (task.isRunning()) {
                        ++runningTasks;
                    } else if (task.wasKilled()) {
                        ++killedTasks;
                    }
                    failedTaskAttempts += task.numTaskFailures();
                    killedTaskAttempts += task.numKilledTasks();
                }
                int pendingTasks = totalTasks - runningTasks - killedTasks - finishedTasks;
                this.numTotalTasks = totalTasks;
                this.numPendingTasks = pendingTasks;
                this.numRunningTasks = runningTasks;
                this.numFinishedTasks = finishedTasks;
                this.numKilledTasks = killedTasks;
                this.numFailedTaskAttempts = failedTaskAttempts;
                this.numKilledTaskAttempts = killedTaskAttempts;
            }

            public int getNumTotalTasks() {
                return this.numTotalTasks;
            }

            public int getNumPendingTasks() {
                return this.numPendingTasks;
            }

            public int getNumRunningTasks() {
                return this.numRunningTasks;
            }

            public int getNumFinishedTasks() {
                return this.numFinishedTasks;
            }

            public int getNumKilledTasks() {
                return this.numKilledTasks;
            }

            public int getNumFailedTaskAttempts() {
                return this.numFailedTaskAttempts;
            }

            public int getNumKilledTaskAttempts() {
                return this.numKilledTaskAttempts;
            }
        }
    }

    public static class ErrorResponse {
        private final long errorCode;
        private final String errorDescription;

        ErrorResponse(long ec, String ed) {
            this.errorCode = ec;
            this.errorDescription = ed;
        }

        public long getErrorCode() {
            return this.errorCode;
        }

        public String getErrorDescription() {
            return this.errorDescription;
        }
    }
}

