/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2.mapred.lib;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.tools.distcp2.mapred.lib.DynamicInputChunk;
import org.apache.hadoop.tools.distcp2.mapred.lib.DynamicInputFormat;
import org.apache.hadoop.tools.distcp2.util.DistCpUtils;

public class DynamicRecordReader<K, V>
extends RecordReader<K, V> {
    private static final Log LOG = LogFactory.getLog(DynamicRecordReader.class);
    private TaskAttemptContext taskAttemptContext;
    private Configuration configuration;
    private DynamicInputChunk<K, V> chunk;
    private TaskID taskId;
    private int numRecordsPerChunk;
    private int totalNumRecords;
    private int numRecordsProcessedByThisMap = 0;
    private long timeOfLastChunkDirScan = 0L;
    private boolean isChunkDirAlreadyScanned = false;
    private static long TIME_THRESHOLD_FOR_DIR_SCANS = TimeUnit.MINUTES.toMillis(5L);

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.numRecordsPerChunk = DynamicInputFormat.getNumEntriesPerChunk(taskAttemptContext.getConfiguration());
        this.taskAttemptContext = taskAttemptContext;
        this.configuration = taskAttemptContext.getConfiguration();
        this.taskId = taskAttemptContext.getTaskAttemptID().getTaskID();
        this.chunk = DynamicInputChunk.acquire(this.taskAttemptContext);
        this.timeOfLastChunkDirScan = System.currentTimeMillis();
        this.isChunkDirAlreadyScanned = false;
        this.totalNumRecords = this.getTotalNumRecords();
    }

    private int getTotalNumRecords() {
        return DistCpUtils.getInt(this.configuration, "mapred.number.of.records");
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.chunk == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.taskId + ": RecordReader is null. No records to be read."));
            }
            return false;
        }
        if (this.chunk.getReader().nextKeyValue()) {
            ++this.numRecordsProcessedByThisMap;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.taskId + ": Current chunk exhausted. " + " Attempting to pick up new one."));
        }
        this.chunk.release();
        this.timeOfLastChunkDirScan = System.currentTimeMillis();
        this.isChunkDirAlreadyScanned = false;
        this.chunk = DynamicInputChunk.acquire(this.taskAttemptContext);
        if (this.chunk == null) {
            return false;
        }
        if (this.chunk.getReader().nextKeyValue()) {
            ++this.numRecordsProcessedByThisMap;
            return true;
        }
        return false;
    }

    @Override
    public K getCurrentKey() throws IOException, InterruptedException {
        return this.chunk.getReader().getCurrentKey();
    }

    @Override
    public V getCurrentValue() throws IOException, InterruptedException {
        return this.chunk.getReader().getCurrentValue();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        int numChunksLeft = this.getNumChunksLeft();
        if (numChunksLeft < 0) {
            assert (this.numRecordsProcessedByThisMap <= this.numRecordsPerChunk) : "numRecordsProcessedByThisMap:" + this.numRecordsProcessedByThisMap + " exceeds numRecordsPerChunk:" + this.numRecordsPerChunk;
            return (float)this.numRecordsProcessedByThisMap / (float)this.totalNumRecords;
        }
        return (float)this.numRecordsProcessedByThisMap / (float)(this.numRecordsProcessedByThisMap + this.numRecordsPerChunk * numChunksLeft);
    }

    private int getNumChunksLeft() throws IOException {
        boolean tooLongSinceLastDirScan;
        long now = System.currentTimeMillis();
        boolean bl = tooLongSinceLastDirScan = now - this.timeOfLastChunkDirScan > TIME_THRESHOLD_FOR_DIR_SCANS;
        if (tooLongSinceLastDirScan || !this.isChunkDirAlreadyScanned && this.numRecordsProcessedByThisMap % this.numRecordsPerChunk > this.numRecordsPerChunk / 2) {
            DynamicInputChunk.getListOfChunkFiles();
            this.isChunkDirAlreadyScanned = true;
            this.timeOfLastChunkDirScan = now;
        }
        return DynamicInputChunk.getNumChunksLeft();
    }

    @Override
    public void close() throws IOException {
        if (this.chunk != null) {
            this.chunk.close();
        }
    }
}

