/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.stat;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.revwalk.RevCommit;
import org.gitective.core.stat.FileCommitActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHistogram
implements Serializable {
    private static final long serialVersionUID = -3756081515294090375L;
    private final Map<String, FileCommitActivity> files = new HashMap<String, FileCommitActivity>();

    public FileCommitActivity getActivity(String path) {
        return path != null ? this.files.get(path) : null;
    }

    public FileCommitActivity[] getFileActivity(Comparator<FileCommitActivity> comparator) {
        FileCommitActivity[] activity = this.files.values().toArray(new FileCommitActivity[this.files.size()]);
        if (comparator != null) {
            Arrays.sort(activity, comparator);
        }
        return activity;
    }

    public FileCommitActivity[] getFileActivity() {
        return this.getFileActivity(null);
    }

    public FileHistogram include(RevCommit commit, DiffEntry entry) {
        String path = entry.getChangeType() != DiffEntry.ChangeType.DELETE ? entry.getNewPath() : entry.getOldPath();
        FileCommitActivity activity = this.files.get(path);
        if (activity == null) {
            activity = new FileCommitActivity(path);
            this.files.put(path, activity);
        }
        activity.include(commit, entry);
        return this;
    }
}

