/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSshConfig {
    static final int SSH_PORT = 22;
    private final File home;
    private final File configFile;
    private long lastModified;
    private Map<String, Host> hosts;

    public static OpenSshConfig get(FS fs) {
        File home = fs.userHome();
        if (home == null) {
            home = new File(".").getAbsoluteFile();
        }
        File config = new File(new File(home, ".ssh"), "config");
        OpenSshConfig osc = new OpenSshConfig(home, config);
        osc.refresh();
        return osc;
    }

    OpenSshConfig(File h, File cfg) {
        this.home = h;
        this.configFile = cfg;
        this.hosts = Collections.emptyMap();
    }

    public Host lookup(String hostName) {
        Map<String, Host> cache = this.refresh();
        Host h = cache.get(hostName);
        if (h == null) {
            h = new Host();
        }
        if (h.patternsApplied) {
            return h;
        }
        for (Map.Entry<String, Host> e : cache.entrySet()) {
            if (!OpenSshConfig.isHostPattern(e.getKey()) || !OpenSshConfig.isHostMatch(e.getKey(), hostName)) continue;
            h.copyFrom(e.getValue());
        }
        if (h.hostName == null) {
            h.hostName = hostName;
        }
        if (h.user == null) {
            h.user = OpenSshConfig.userName();
        }
        if (h.port == 0) {
            h.port = 22;
        }
        if (h.connectionAttempts == 0) {
            h.connectionAttempts = 1;
        }
        h.patternsApplied = true;
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Map<String, Host> refresh() {
        long mtime = this.configFile.lastModified();
        if (mtime != this.lastModified) {
            try {
                FileInputStream in = new FileInputStream(this.configFile);
                try {
                    this.hosts = this.parse(in);
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException none) {
                this.hosts = Collections.emptyMap();
            }
            catch (IOException err) {
                this.hosts = Collections.emptyMap();
            }
            this.lastModified = mtime;
        }
        return this.hosts;
    }

    private Map<String, Host> parse(InputStream in) throws IOException {
        String line;
        LinkedHashMap<String, Host> m = new LinkedHashMap<String, Host>();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ArrayList<Host> current = new ArrayList<Host>(4);
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            String[] parts = line.split("[ \t]*[= \t]", 2);
            String keyword = parts[0].trim();
            String argValue = parts[1].trim();
            if (StringUtils.equalsIgnoreCase("Host", keyword)) {
                current.clear();
                for (String pattern : argValue.split("[ \t]")) {
                    String name = OpenSshConfig.dequote(pattern);
                    Host c = (Host)m.get(name);
                    if (c == null) {
                        c = new Host();
                        m.put(name, c);
                    }
                    current.add(c);
                }
                continue;
            }
            if (current.isEmpty()) continue;
            if (StringUtils.equalsIgnoreCase("HostName", keyword)) {
                for (Host c : current) {
                    if (c.hostName != null) continue;
                    c.hostName = OpenSshConfig.dequote(argValue);
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("User", keyword)) {
                for (Host c : current) {
                    if (c.user != null) continue;
                    c.user = OpenSshConfig.dequote(argValue);
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("Port", keyword)) {
                try {
                    int port = Integer.parseInt(OpenSshConfig.dequote(argValue));
                    for (Host c : current) {
                        if (c.port != 0) continue;
                        c.port = port;
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
            }
            if (StringUtils.equalsIgnoreCase("IdentityFile", keyword)) {
                for (Host c : current) {
                    if (c.identityFile != null) continue;
                    c.identityFile = this.toFile(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("PreferredAuthentications", keyword)) {
                for (Host c : current) {
                    if (c.preferredAuthentications != null) continue;
                    c.preferredAuthentications = OpenSshConfig.nows(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("BatchMode", keyword)) {
                for (Host c : current) {
                    if (c.batchMode != null) continue;
                    c.batchMode = OpenSshConfig.yesno(OpenSshConfig.dequote(argValue));
                }
                continue;
            }
            if (StringUtils.equalsIgnoreCase("StrictHostKeyChecking", keyword)) {
                String value = OpenSshConfig.dequote(argValue);
                for (Host c : current) {
                    if (c.strictHostKeyChecking != null) continue;
                    c.strictHostKeyChecking = value;
                }
                continue;
            }
            if (!StringUtils.equalsIgnoreCase("ConnectionAttempts", keyword)) continue;
            try {
                int connectionAttempts = Integer.parseInt(OpenSshConfig.dequote(argValue));
                if (connectionAttempts <= 0) continue;
                for (Host c : current) {
                    if (c.connectionAttempts != 0) continue;
                    c.connectionAttempts = connectionAttempts;
                }
            }
            catch (NumberFormatException nfe) {
            }
        }
        return m;
    }

    private static boolean isHostPattern(String s) {
        return s.indexOf(42) >= 0 || s.indexOf(63) >= 0;
    }

    private static boolean isHostMatch(String pattern, String name) {
        FileNameMatcher fn;
        try {
            fn = new FileNameMatcher(pattern, null);
        }
        catch (InvalidPatternException e) {
            return false;
        }
        fn.append(name);
        return fn.isMatch();
    }

    private static String dequote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private static String nows(String value) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isSpaceChar(value.charAt(i))) continue;
            b.append(value.charAt(i));
        }
        return b.toString();
    }

    private static Boolean yesno(String value) {
        if (StringUtils.equalsIgnoreCase("yes", value)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private File toFile(String path) {
        if (path.startsWith("~/")) {
            return new File(this.home, path.substring(2));
        }
        File ret = new File(path);
        if (ret.isAbsolute()) {
            return ret;
        }
        return new File(this.home, path);
    }

    static String userName() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.name");
            }
        });
    }

    public static class Host {
        boolean patternsApplied;
        String hostName;
        int port;
        File identityFile;
        String user;
        String preferredAuthentications;
        Boolean batchMode;
        String strictHostKeyChecking;
        int connectionAttempts;

        void copyFrom(Host src) {
            if (this.hostName == null) {
                this.hostName = src.hostName;
            }
            if (this.port == 0) {
                this.port = src.port;
            }
            if (this.identityFile == null) {
                this.identityFile = src.identityFile;
            }
            if (this.user == null) {
                this.user = src.user;
            }
            if (this.preferredAuthentications == null) {
                this.preferredAuthentications = src.preferredAuthentications;
            }
            if (this.batchMode == null) {
                this.batchMode = src.batchMode;
            }
            if (this.strictHostKeyChecking == null) {
                this.strictHostKeyChecking = src.strictHostKeyChecking;
            }
            if (this.connectionAttempts == 0) {
                this.connectionAttempts = src.connectionAttempts;
            }
        }

        public String getStrictHostKeyChecking() {
            return this.strictHostKeyChecking;
        }

        public String getHostName() {
            return this.hostName;
        }

        public int getPort() {
            return this.port;
        }

        public File getIdentityFile() {
            return this.identityFile;
        }

        public String getUser() {
            return this.user;
        }

        public String getPreferredAuthentications() {
            return this.preferredAuthentications;
        }

        public boolean isBatchMode() {
            return this.batchMode != null && this.batchMode != false;
        }

        public int getConnectionAttempts() {
            return this.connectionAttempts;
        }
    }
}

