/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.io.IOException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.Assert;
import org.gitective.core.filter.commit.CommitFilter;

public class CommitCursorFilter
extends CommitFilter {
    private RevCommit last;
    private final RevFilter filter;

    public CommitCursorFilter(RevFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(Assert.formatNotNull("Filter"));
        }
        this.filter = filter;
    }

    public boolean include(RevWalk walker, RevCommit commit) throws IOException {
        try {
            boolean include = this.filter.include(walker, commit);
            this.last = include ? null : commit;
            return include;
        }
        catch (StopWalkException e) {
            this.last = commit;
            throw e;
        }
    }

    public RevCommit getLast() {
        return this.last;
    }

    public CommitFilter setRepository(Repository repository) {
        if (this.filter instanceof CommitFilter) {
            ((CommitFilter)this.filter).setRepository(repository);
        }
        return super.setRepository(repository);
    }

    public CommitFilter reset() {
        this.last = null;
        if (this.filter instanceof CommitFilter) {
            ((CommitFilter)this.filter).reset();
        }
        return super.reset();
    }

    public RevFilter clone() {
        return new CommitCursorFilter(this.filter.clone());
    }
}

