/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.internal;

import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.git.GitProxyService;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@ThreadSafe
@Component(name="io.fabric8.git.proxy", label="Fabric8 Git Proxy Registration Handler", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={GitProxyService.class})
public class GitProxyRegistrationHandler
extends AbstractComponent
implements GitProxyService {
    @Reference
    private Configurer configurer;
    @Property(name="proxyProtocol", label="Proxy Protocol", description="The protocol of the Proxy")
    private String proxyProtocol;
    @Property(name="proxyHost", label="Proxy Host", description="The host of the Proxy")
    private String proxyHost;
    @Property(name="proxyPort", label="Proxy Port", description="The port of the Proxy")
    private int proxyPort;
    @Property(name="nonProxyHosts", label="Non Proxy Hosts", description="Hosts that should be reached without using a Proxy")
    private String nonProxyHosts;

    @Activate
    void init(Map<String, ?> configuration) throws Exception {
        this.configurer.configure(configuration, (Object)this);
        this.activateComponent();
    }

    @Deactivate
    void destroy() {
        this.deactivateComponent();
    }

    @Override
    public String getProxyProtocol() {
        return this.proxyProtocol;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

