/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.gitective.core.filter.commit.CommitMessageFindFilter;

public class SignedOffByFilter
extends CommitMessageFindFilter {
    public static final String SIGNED_OFF_BY = "Signed-off-by: {0} <{1}>";
    private final PersonIdent person;

    public SignedOffByFilter(PersonIdent person) {
        super(Pattern.quote(MessageFormat.format(SIGNED_OFF_BY, person.getName(), person.getEmailAddress())), 8);
        this.person = person;
    }

    public RevFilter clone() {
        return new SignedOffByFilter(this.person);
    }
}

