/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.http;

import io.fabric8.zookeeper.ZkPath;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.eclipse.jgit.http.server.GitServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricGitServlet
extends GitServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricGitServlet.class);
    private final CuratorFramework curator;
    private final String path = ZkPath.GIT_TRIGGER.getPath(new String[0]);
    private SharedCount counter;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public FabricGitServlet(CuratorFramework curator) {
        this.curator = curator;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.counter = new SharedCount(this.curator, this.path, 0);
            this.counter.start();
        }
        catch (Exception e) {
            LOGGER.error("Error starting SharedCount for ZkNode " + this.path + " due " + e.getMessage(), (Throwable)e);
            throw new ServletException("Error starting SharedCount for ZkNode " + this.path, (Throwable)e);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            this.counter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error closing SharedCount due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String service = req.getParameter("service");
        boolean isPush = service != null && service.equals("git-receive-pack");
        LOGGER.trace("FabricGitServlet service git service={}, isPush={}", (Object)service, (Object)isPush);
        Lock lock = isPush ? this.rwLock.writeLock() : this.rwLock.readLock();
        try {
            lock.lock();
            super.service(req, res);
        }
        finally {
            lock.unlock();
            if (isPush) {
                int value = this.counter.getCount();
                int newValue = value + 1;
                LOGGER.debug("Updating counter to {}", (Object)newValue);
                try {
                    this.counter.trySetCount(newValue);
                }
                catch (Exception e) {
                    LOGGER.debug("Error updating counter on ZkPath: " + this.path + " due " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                    LOGGER.warn("Error updating counter on ZkPath: " + this.path + " due " + e.getMessage() + ". This exception is ignored.");
                }
            }
        }
    }
}

