/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.git.hawtio;

import io.fabric8.api.GitContext;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.Validatable;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.ValidationSupport;
import io.fabric8.git.GitDataStore;
import io.fabric8.git.internal.GitHelpers;
import io.fabric8.git.internal.GitOperation;
import io.hawt.git.CommitInfo;
import io.hawt.git.CommitTreeInfo;
import io.hawt.git.FileContents;
import io.hawt.git.FileInfo;
import io.hawt.git.GitFacadeMXBean;
import io.hawt.git.GitFacadeSupport;
import io.hawt.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.util.Base64;

@ThreadSafe
@Component(name="io.fabric8.git.hawtio", label="Fabric8 Git Hawtio Service", immediate=true, metatype=false)
@Service(value={GitFacadeMXBean.class})
public final class FabricGitFacade
extends GitFacadeSupport
implements Validatable {
    @Reference(referenceInterface=GitDataStore.class)
    private final ValidatingReference<GitDataStore> gitDataStore = new ValidatingReference();
    private final ValidationSupport active = new ValidationSupport();

    @Activate
    void activate() throws Exception {
        super.init();
        this.active.setValid();
    }

    @Deactivate
    void deactivate() throws Exception {
        this.active.setInvalid();
        super.destroy();
    }

    public boolean isValid() {
        return this.active.isValid();
    }

    public void assertValid() {
        this.active.assertValid();
    }

    @Override
    public String getDefaultObjectName() {
        return "hawtio:type=GitFacade,repo=fabric";
    }

    @Override
    public String getContent(final String objectId, final String blobPath) {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<String>(){

            public String call(Git git, GitContext context) throws Exception {
                return FabricGitFacade.this.doGetContent(git, objectId, blobPath);
            }
        });
    }

    @Override
    public List<CommitTreeInfo> getCommitTree(final String commitId) {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<List<CommitTreeInfo>>(){

            public List<CommitTreeInfo> call(Git git, GitContext context) throws Exception {
                return FabricGitFacade.this.doGetCommitTree(git, commitId);
            }
        });
    }

    @Override
    public CommitInfo getCommitInfo(final String commitId) {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<CommitInfo>(){

            public CommitInfo call(Git git, GitContext context) throws Exception {
                return FabricGitFacade.this.doGetCommitInfo(git, commitId);
            }
        });
    }

    @Override
    public FileContents read(final String branch, final String pathOrEmpty) throws IOException, GitAPIException {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<FileContents>(){

            public FileContents call(Git git, GitContext context) throws Exception {
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                return FabricGitFacade.this.doRead(git, rootDir, branch, pathOrEmpty);
            }
        });
    }

    @Override
    public FileInfo exists(final String branch, final String pathOrEmpty) throws IOException, GitAPIException {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<FileInfo>(){

            public FileInfo call(Git git, GitContext context) throws Exception {
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                return FabricGitFacade.this.doExists(git, rootDir, branch, pathOrEmpty);
            }
        });
    }

    @Override
    public List<String> completePath(final String branch, final String completionText, final boolean directoriesOnly) {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<List<String>>(){

            public List<String> call(Git git, GitContext context) throws Exception {
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                return FabricGitFacade.this.doCompletePath(git, rootDir, branch, completionText, directoriesOnly);
            }
        });
    }

    @Override
    public String readJsonChildContent(final String branch, final String path, String fileNameWildcardOrBlank, final String search) throws IOException {
        this.assertValid();
        final String fileNameWildcard = Strings.isBlank(fileNameWildcardOrBlank) ? "*.json" : fileNameWildcardOrBlank;
        return this.gitReadOperation(new GitOperation<String>(){

            public String call(Git git, GitContext context) throws Exception {
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                return FabricGitFacade.this.doReadJsonChildContent(git, rootDir, branch, path, fileNameWildcard, search);
            }
        });
    }

    @Override
    public CommitInfo write(final String branch, final String path, final String commitMessage, String authorName, String authorEmail, final String contents) {
        this.assertValid();
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        return this.gitWriteOperation(personIdent, new GitOperation<CommitInfo>(){

            public CommitInfo call(Git git, GitContext context) throws Exception {
                FabricGitFacade.this.checkoutBranch(git, branch);
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                byte[] data = contents.getBytes();
                CommitInfo answer = FabricGitFacade.this.doWrite(git, rootDir, branch, path, data, personIdent, commitMessage);
                context.commitMessage(commitMessage);
                return answer;
            }
        });
    }

    @Override
    public CommitInfo writeBase64(final String branch, final String path, final String commitMessage, String authorName, String authorEmail, final String contents) {
        this.assertValid();
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        return this.gitWriteOperation(personIdent, new GitOperation<CommitInfo>(){

            public CommitInfo call(Git git, GitContext context) throws Exception {
                FabricGitFacade.this.checkoutBranch(git, branch);
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                byte[] data = Base64.decode((String)contents);
                CommitInfo answer = FabricGitFacade.this.doWrite(git, rootDir, branch, path, data, personIdent, commitMessage);
                context.commitMessage(commitMessage);
                return answer;
            }
        });
    }

    @Override
    public void revertTo(final String branch, final String objectId, final String blobPath, final String commitMessage, String authorName, String authorEmail) {
        this.assertValid();
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        this.gitWriteOperation(personIdent, new GitOperation<Void>(){

            public Void call(Git git, GitContext context) throws Exception {
                FabricGitFacade.this.checkoutBranch(git, branch);
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                Void answer = FabricGitFacade.this.doRevert(git, rootDir, branch, objectId, blobPath, commitMessage, personIdent);
                context.commitMessage(commitMessage);
                return answer;
            }
        });
    }

    @Override
    public void rename(final String branch, final String oldPath, final String newPath, final String commitMessage, String authorName, String authorEmail) {
        this.assertValid();
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        this.gitWriteOperation(personIdent, new GitOperation<RevCommit>(){

            public RevCommit call(Git git, GitContext context) throws Exception {
                FabricGitFacade.this.checkoutBranch(git, branch);
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                RevCommit answer = FabricGitFacade.this.doRename(git, rootDir, branch, oldPath, newPath, commitMessage, personIdent);
                context.commitMessage(commitMessage);
                return answer;
            }
        });
    }

    @Override
    public void remove(final String branch, final String path, final String commitMessage, String authorName, String authorEmail) {
        this.assertValid();
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        this.gitWriteOperation(personIdent, new GitOperation<RevCommit>(){

            public RevCommit call(Git git, GitContext context) throws Exception {
                FabricGitFacade.this.checkoutBranch(git, branch);
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                RevCommit answer = FabricGitFacade.this.doRemove(git, rootDir, branch, path, commitMessage, personIdent);
                context.commitMessage(commitMessage);
                return answer;
            }
        });
    }

    @Override
    public void createBranch(final String fromBranch, final String newBranch) {
        this.gitWriteOperation(null, new GitOperation<Object>(){

            public Object call(Git git, GitContext context) throws Exception {
                FabricGitFacade.this.doCreateBranch(git, fromBranch, newBranch);
                context.commitMessage("Created branch from " + fromBranch + " to " + newBranch);
                return null;
            }
        });
    }

    @Override
    public CommitInfo createDirectory(final String branch, final String path, final String commitMessage, String authorName, String authorEmail) {
        this.assertValid();
        final PersonIdent personIdent = new PersonIdent(authorName, authorEmail);
        return this.gitWriteOperation(personIdent, new GitOperation<CommitInfo>(){

            public CommitInfo call(Git git, GitContext context) throws Exception {
                FabricGitFacade.this.checkoutBranch(git, branch);
                File rootDir = GitHelpers.getRootGitDirectory((Git)git);
                CommitInfo answer = FabricGitFacade.this.doCreateDirectory(git, rootDir, branch, path, personIdent, commitMessage);
                context.commitMessage(commitMessage);
                return answer;
            }
        });
    }

    @Override
    public List<String> branches() {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<List<String>>(){

            public List<String> call(Git git, GitContext context) throws Exception {
                return FabricGitFacade.this.doListBranches(git);
            }
        });
    }

    @Override
    public String getHEAD() {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<String>(){

            public String call(Git git, GitContext context) throws Exception {
                return FabricGitFacade.this.doGetHead(git);
            }
        });
    }

    @Override
    public List<CommitInfo> history(final String branch, final String objectId, final String path, final int limit) {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<List<CommitInfo>>(){

            public List<CommitInfo> call(Git git, GitContext context) throws Exception {
                return FabricGitFacade.this.doHistory(git, branch, objectId, path, limit);
            }
        });
    }

    @Override
    public String diff(final String objectId, final String baseObjectId, final String path) {
        this.assertValid();
        return this.gitReadOperation(new GitOperation<String>(){

            public String call(Git git, GitContext context) throws Exception {
                return FabricGitFacade.this.doDiff(git, objectId, baseObjectId, path);
            }
        });
    }

    @Override
    public boolean isPushOnCommit() {
        this.assertValid();
        return true;
    }

    @Override
    public Iterable<PushResult> doPush(Git git) throws Exception {
        this.assertValid();
        return ((GitDataStore)this.gitDataStore.get()).doPush(git, new GitContext());
    }

    @Override
    public void checkoutBranch(Git git, String branch) throws GitAPIException {
        this.assertValid();
        if (Strings.isBlank(branch)) {
            branch = "master";
        }
        GitHelpers.createOrCheckoutBranch((Git)git, (String)branch, (String)"origin");
    }

    private <T> T gitReadOperation(GitOperation<T> gitop) {
        GitContext context = new GitContext();
        return (T)((GitDataStore)this.gitDataStore.get()).gitOperation(context, gitop, null);
    }

    private <T> T gitWriteOperation(PersonIdent personIdent, GitOperation<T> gitop) {
        GitContext context = new GitContext().requireCommit().requirePush();
        return (T)((GitDataStore)this.gitDataStore.get()).gitOperation(context, gitop, personIdent);
    }

    public void bindGitDataStoreForTesting(GitDataStore gitDataStore) {
        this.bindGitDataStore(gitDataStore);
    }

    public void activateForTesting() throws Exception {
        this.activate();
    }

    void bindGitDataStore(GitDataStore gitDataStore) {
        this.gitDataStore.bind((Object)gitDataStore);
    }

    void unbindGitDataStore(GitDataStore gitDataStore) {
        this.gitDataStore.unbind((Object)gitDataStore);
    }
}

