/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.git;

import io.hawt.git.RuntimeIOException;
import io.hawt.util.XmlHelper;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileInfo {
    private static final transient Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    private final String path;
    private final String name;
    private final long lastModified;
    private final long length;
    private final boolean directory;
    private String[] xmlNamespaces;

    public static FileInfo createFileInfo(File rootDir, File file) {
        String path = FileInfo.getRelativePath(rootDir, file).replace("\\", "/");
        FileInfo answer = new FileInfo(path, file.getName(), file.lastModified(), file.length(), file.isDirectory());
        if (file.isFile()) {
            String name = file.getName();
            if (name.indexOf(35) > 0) {
                name = name.substring(0, name.indexOf(35));
            }
            if (name.endsWith(".xml")) {
                try {
                    Set<String> uris = XmlHelper.getNamespaces(file);
                    if (uris.size() > 0) {
                        String[] namespaces = uris.toArray(new String[uris.size()]);
                        answer.setXmlNamespaces(namespaces);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Failed to parse the XML namespaces in " + file + " due: " + e.getMessage() + ". This exception is ignored.", (Throwable)e);
                }
            }
        }
        return answer;
    }

    public static String getRelativePath(File rootDir, File file) {
        try {
            String rootPath = rootDir.getCanonicalPath();
            String fullPath = file.getCanonicalPath();
            if (fullPath.startsWith(rootPath)) {
                return fullPath.substring(rootPath.length());
            }
            return fullPath;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public FileInfo(String path, String name, long lastModified, long length, boolean directory) {
        this.path = path;
        this.name = name;
        this.lastModified = lastModified;
        this.length = length;
        this.directory = directory;
    }

    public String toString() {
        return "FileInfo(" + this.path + ")";
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setXmlNamespaces(String[] xmlNamespaces) {
        this.xmlNamespaces = xmlNamespaces;
    }

    public String[] getXmlNamespaces() {
        return this.xmlNamespaces;
    }
}

