/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.jaxb.dynamic.profile;

import com.google.common.base.Throwables;
import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRegistry;
import io.fabric8.api.Profiles;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.common.util.Maps;
import io.fabric8.common.util.Strings;
import io.fabric8.git.GitService;
import io.fabric8.git.internal.GitHelpers;
import io.fabric8.jaxb.dynamic.CompileResults;
import io.fabric8.jaxb.dynamic.CompileResultsHandler;
import io.fabric8.jaxb.dynamic.DynamicCompiler;
import io.fabric8.jaxb.dynamic.DynamicXJC;
import io.hawt.introspect.Introspector;
import io.hawt.util.introspect.ClassLoaderProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.util.AriesFrameworkUtil;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.eclipse.jgit.api.Git;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.profile.jaxb.compiler", label="Fabric8 Profile JAXB Compiler", policy=ConfigurationPolicy.OPTIONAL, immediate=true, metatype=true)
@Service(value={DynamicCompiler.class})
public class ProfileDynamicJaxbCompiler
extends AbstractComponent
implements DynamicCompiler {
    public static final String PROPERTY_SCHEMA_PATH = "schemaPath";
    private static final transient Logger LOG = LoggerFactory.getLogger(ProfileDynamicJaxbCompiler.class);
    private BundleContext bundleContext;
    @Reference(referenceInterface=FabricService.class)
    private FabricService fabricService;
    @Reference(referenceInterface=Introspector.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private Introspector introspector;
    @Reference(referenceInterface=GitService.class)
    private GitService gitService;
    private String schemaPath;
    private Timer timer = new Timer();
    private AtomicBoolean startedFlag = new AtomicBoolean(false);
    private ExecutorService executorService = Executors.newFixedThreadPool(2);
    private final ConcurrentMap<String, PathChildrenCache> pathCacheMap = new ConcurrentHashMap<String, PathChildrenCache>();
    private long timerDelay = 1000L;
    private CompileResults compileResults;
    private CompileResultsHandler handler;
    private Runnable changeRunnable = new Runnable(){

        @Override
        public void run() {
            ProfileDynamicJaxbCompiler.this.asyncRecompile();
        }
    };
    private Introspector localIntrospector;

    @Activate
    void activate(BundleContext bundleContext, Map<String, String> configuration) {
        try {
            this.bundleContext = bundleContext;
            this.schemaPath = Maps.stringValue(configuration, (String)PROPERTY_SCHEMA_PATH, (String)"schemas");
            this.getDataStore().trackConfiguration(this.changeRunnable);
            if (this.introspector == null) {
                this.localIntrospector = new Introspector();
                this.localIntrospector.init();
                this.introspector = this.localIntrospector;
            }
            this.asyncRecompile();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() throws Exception {
        this.getDataStore().untrackConfiguration(this.changeRunnable);
        this.executorService.shutdown();
        this.timer.cancel();
        if (this.localIntrospector != null) {
            this.localIntrospector.destroy();
        }
        this.deactivateComponent();
    }

    public void setHandler(CompileResultsHandler handler) throws Exception {
        this.handler = handler;
        if (handler != null && this.compileResults != null) {
            handler.onCompileResults(this.compileResults);
        }
    }

    public CompileResults getCompileResults() {
        return this.compileResults;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    public DataStore getDataStore() {
        return (DataStore)this.getFabricService().adapt(DataStore.class);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public long getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(long timerDelay) {
        this.timerDelay = timerDelay;
    }

    protected void asyncRecompile() {
        if (this.startedFlag.compareAndSet(false, true)) {
            this.timer.schedule((TimerTask)new RecompileTask(), this.timerDelay);
        }
    }

    protected void recompile() {
        LOG.debug("Looking for XSDs to recompile");
        TreeSet<String> urls = new TreeSet<String>();
        FabricService fabric = this.getFabricService();
        Container container = fabric.getCurrentContainer();
        String versionId = container.getVersion().getId();
        List profiles = Containers.overlayProfiles((Container)container);
        List profileIds = Profiles.profileIds((Iterable)profiles);
        Collection<String> names = this.listFiles(versionId, profileIds, this.schemaPath);
        for (String name : names) {
            if (!name.endsWith(".xsd")) continue;
            String prefix = this.schemaPath;
            if (Strings.isNotBlank((String)prefix)) {
                prefix = prefix + "/";
            }
            urls.add("profile:" + prefix + name);
        }
        LOG.info("Recompiling XSDs at URLs: " + urls);
        this.startedFlag.set(false);
        ClassLoader classLoader = AriesFrameworkUtil.getClassLoader((Bundle)this.bundleContext.getBundle());
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        DynamicXJC xjc = new DynamicXJC(classLoader);
        xjc.setSchemaUrls(new ArrayList(urls));
        this.compileResults = xjc.compileSchemas();
        if (this.handler != null) {
            this.handler.onCompileResults(this.compileResults);
        }
        if (this.introspector != null) {
            this.introspector.setClassLoaderProvider("dynamic.jaxb", new ClassLoaderProvider(){

                public ClassLoader getClassLoader() {
                    return ProfileDynamicJaxbCompiler.this.compileResults.getClassLoader();
                }
            });
        }
    }

    private Collection<String> listFiles(String versionId, Iterable<String> profileIds, String path) {
        this.assertValid();
        Git git = this.gitService.getGit();
        ProfileRegistry profileRegistry = (ProfileRegistry)this.getFabricService().adapt(ProfileRegistry.class);
        TreeSet<String> answer = new TreeSet<String>();
        for (String profileId : profileIds) {
            String[] values;
            profileRegistry.getRequiredProfile(versionId, profileId);
            File profileDirectory = GitHelpers.getProfileDirectory((Git)git, (String)profileId);
            File file = Strings.isNotBlank((String)path) ? new File(profileDirectory, path) : profileDirectory;
            if (!file.exists() || (values = file.list()) == null) continue;
            for (String value : values) {
                answer.add(value);
            }
        }
        return Collections.unmodifiableSet(answer);
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }

    protected void bindIntrospector(Introspector introspector) {
        this.introspector = introspector;
    }

    protected void unbindIntrospector(Introspector introspector) {
        if (this.introspector == introspector) {
            this.introspector = null;
        }
    }

    protected void bindGitService(GitService gitService) {
        this.gitService = gitService;
    }

    protected void unbindGitService(GitService gitService) {
        if (this.gitService == gitService) {
            this.gitService = null;
        }
    }

    private class RecompileTask
    extends TimerTask {
        private RecompileTask() {
        }

        @Override
        public void run() {
            ProfileDynamicJaxbCompiler.this.recompile();
        }
    }
}

