/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.introspect;

import io.hawt.introspect.Introspections;
import io.hawt.introspect.IntrospectorMXBean;
import io.hawt.introspect.PropertyDTO;
import io.hawt.util.MBeanSupport;
import io.hawt.util.Strings;
import io.hawt.util.introspect.ClassLoaderProvider;
import io.hawt.util.introspect.support.ClassScanner;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Introspector
extends MBeanSupport
implements IntrospectorMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(Introspector.class);
    private static Introspector singleton;
    private ClassScanner classScanner = new ClassScanner(new ClassLoader[0]);

    public static Introspector getSingleton() {
        if (singleton == null) {
            LOG.warn("No Introspector constructed yet so using default configuration for now");
            singleton = new Introspector();
        }
        return singleton;
    }

    public void init() throws Exception {
        singleton = this;
        this.findClassNames("", null);
        super.init();
    }

    protected String getDefaultObjectName() {
        return "hawtio:type=Introspector";
    }

    public void setClassLoaderProvider(String id, ClassLoaderProvider classLoaderProvider) {
        this.classScanner.setClassLoaderProvider(id, classLoaderProvider);
    }

    @Override
    public SortedSet<String> findClassNames(String search, Integer limit) {
        return this.getClassScanner().findClassNames(search, limit);
    }

    @Override
    public SortedSet<String> findClassNamesMethodsAnnotatedWith(String annotationClassName) {
        return this.getClassScanner().findClassNamesMethodsAnnotatedWith(annotationClassName);
    }

    @Override
    public SortedSet<String> findJUnitTestClassNames() {
        String annotationClassName = "org.junit.Test";
        File file = this.getBaseDir();
        File targetDir = new File(file, "target");
        File testClasses = new File(targetDir, "test-classes");
        return this.getClassScanner().findClassNamesInDirectoryWithMethodAnnotatedWith(testClasses, annotationClassName);
    }

    public File getBaseDir() {
        String basedir = System.getProperty("basedir", ".");
        return new File(basedir);
    }

    @Override
    public List<PropertyDTO> getProperties(String className) throws Exception {
        Class aClass = this.getClassScanner().findClass(className);
        return this.getProperties(aClass);
    }

    public List<PropertyDTO> getProperties(Class<?> aClass) throws Exception {
        ArrayList<PropertyDTO> answer = new ArrayList<PropertyDTO>();
        if (aClass != null) {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = java.beans.Introspector.getBeanInfo(aClass);
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                if (propertyDescriptor.getName().equals("class")) continue;
                PropertyDTO info = new PropertyDTO(propertyDescriptor);
                answer.add(info);
            }
        }
        return answer;
    }

    @Override
    public List<PropertyDTO> findProperties(String className, String filter) throws Exception {
        List<PropertyDTO> properties = this.getProperties(className);
        if (Strings.isNotBlank((String)filter)) {
            String propertyPath;
            PropertyDTO property;
            String[] propertyPaths = filter.split("\\.");
            String firstPrefix = "";
            PropertyDTO lastNavigation = null;
            StringBuilder prefixBuilder = new StringBuilder();
            String[] arr$ = propertyPaths;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (property = Introspections.findPropertyByName(properties, propertyPath = arr$[i$])) != null; ++i$) {
                lastNavigation = property;
                List<PropertyDTO> childProperties = this.getProperties(property.getTypeClass());
                if (childProperties.size() <= 0) break;
                properties = childProperties;
                firstPrefix = prefixBuilder.toString();
                prefixBuilder.append(propertyPath);
                prefixBuilder.append(".");
            }
            if (lastNavigation != null) {
                ArrayList<PropertyDTO> answer = new ArrayList<PropertyDTO>();
                answer.add(lastNavigation);
                answer.addAll(properties);
                String nestedPrefix = prefixBuilder.toString();
                String prefix = firstPrefix;
                for (PropertyDTO dto : answer) {
                    dto.setName(prefix + dto.getName());
                    prefix = nestedPrefix;
                }
                return answer;
            }
        }
        return properties;
    }

    @Override
    public void clearCache() {
        this.getClassScanner().clearCache();
    }

    public ClassScanner getClassScanner() {
        return this.classScanner;
    }

    public void setClassScanner(ClassScanner classScanner) {
        this.classScanner = classScanner;
    }
}

