/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.dosgi.util;

import io.fabric8.dosgi.util.StringSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class IntrospectionSupport {
    private IntrospectionSupport() {
    }

    public static boolean getProperties(Object target, Map props, String optionPrefix) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        Class<?> clazz = target.getClass();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            Class<?> type = method.getReturnType();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("is") && !name.startsWith("get") || params.length != 0 || type == null || !IntrospectionSupport.isSettableType(type)) continue;
            try {
                String strValue;
                Object value = method.invoke(target, new Object[0]);
                if (value == null || (strValue = IntrospectionSupport.convertToString(value, type)) == null) continue;
                name = name.startsWith("get") ? name.substring(3, 4).toLowerCase() + name.substring(4) : name.substring(2, 3).toLowerCase() + name.substring(3);
                props.put(optionPrefix + name, strValue);
                rc = true;
                continue;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map<String, ?> props, String optionPrefix) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator<String> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value)) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static Map<String, Object> extractProperties(Map props, String optionPrefix) {
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        HashMap<String, Object> rc = new HashMap<String, Object>(props.size());
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            if (!name.startsWith(optionPrefix)) continue;
            name = name.substring(optionPrefix.length());
            rc.put(name, entry.getValue());
            iter.remove();
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map props) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!IntrospectionSupport.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static Class<?> getPropertyType(Object target, String name) {
        Class<?> clazz = target.getClass();
        Method setter = IntrospectionSupport.findSetterMethod(clazz, name);
        if (setter == null) {
            return null;
        }
        return setter.getParameterTypes()[0];
    }

    public static boolean setProperty(Object target, String name, Object value) {
        try {
            Class<?> clazz = target.getClass();
            Method setter = IntrospectionSupport.findSetterMethod(clazz, name);
            if (setter == null) {
                return false;
            }
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, IntrospectionSupport.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static Object convert(Object value, Class<?> type) {
        if (type.isArray() && value.getClass().isArray()) {
            int length = Array.getLength(value);
            Class<?> componentType = type.getComponentType();
            Object rc = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(value, i);
                Array.set(rc, i, IntrospectionSupport.convert(o, componentType));
            }
            return rc;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        return null;
    }

    public static String convertToString(Object value, Class<?> type) {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setValue(value);
            return editor.getAsText();
        }
        return null;
    }

    private static Method findSetterMethod(Class<?> clazz, String name) {
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1) continue;
            return method;
        }
        return null;
    }

    private static boolean isSettableType(Class<?> clazz) {
        return PropertyEditorManager.findEditor(clazz) != null;
    }

    public static String toString(Object target) {
        return IntrospectionSupport.toString(target, Object.class, null, (String[])null);
    }

    public static String toString(Object target, String ... fields) {
        return IntrospectionSupport.toString(target, Object.class, null, fields);
    }

    public static String toString(Object target, Class<?> stopClass) {
        return IntrospectionSupport.toString(target, stopClass, null, (String[])null);
    }

    public static String toString(Object target, Map<String, Object> overrideFields, String ... fields) {
        return IntrospectionSupport.toString(target, Object.class, overrideFields, fields);
    }

    public static String toString(Object target, Class<?> stopClass, Map<String, Object> overrideFields, String ... fields) {
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            IntrospectionSupport.addFields(target, target.getClass(), stopClass, map);
            if (overrideFields != null) {
                for (String key : overrideFields.keySet()) {
                    Object value = overrideFields.get(key);
                    map.put(key, value);
                }
            }
            if (fields != null) {
                map.keySet().retainAll(Arrays.asList(fields));
            }
            boolean useMultiLine = false;
            LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = null;
                if (entry.getValue() != null && (value = entry.getValue().toString()) != null && (value.indexOf(10) >= 0 || key.length() + value.length() > 70)) {
                    useMultiLine = true;
                }
                props.put(key, value);
            }
            StringBuffer buffer = new StringBuffer();
            if (useMultiLine) {
                buffer.append("{\n");
                boolean first = true;
                for (Map.Entry entry : props.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",\n");
                    }
                    buffer.append("  ");
                    buffer.append((String)entry.getKey());
                    buffer.append(": ");
                    buffer.append(StringSupport.indent((String)entry.getValue(), 2));
                }
                buffer.append("\n}");
            } else {
                buffer.append("{");
                boolean first = true;
                for (Map.Entry entry : props.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append((String)entry.getKey());
                    buffer.append(": ");
                    String value = (String)entry.getValue();
                    buffer.append(value);
                }
                buffer.append("}");
            }
            return buffer.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "Could not toString: " + e.toString();
        }
    }

    public static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(".");
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private static void addFields(Object target, Class<?> startClass, Class<?> stopClass, LinkedHashMap<String, Object> map) {
        if (startClass != stopClass) {
            IntrospectionSupport.addFields(target, startClass.getSuperclass(), stopClass, map);
        }
        Field[] fields = startClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                List<Object> o = field.get(target);
                if (o != null && o.getClass().isArray()) {
                    try {
                        o = Arrays.asList((Object[])o);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                map.put(field.getName(), o);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

