/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api;

import io.fabric8.docker.api.Container;
import io.fabric8.docker.api.Docker;
import io.fabric8.docker.api.DockerApiConnectionException;
import io.fabric8.docker.api.container.Port;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dockers {
    private static final transient Logger LOG = LoggerFactory.getLogger(Dockers.class);

    public static Set<Integer> getUsedPorts(Docker docker) {
        try {
            List<Container> containers = docker.containers(null, null, null, null, null);
            HashSet<Integer> answer = new HashSet<Integer>();
            for (Container container : containers) {
                List<Port> ports = container.getPorts();
                if (ports == null) continue;
                for (Port port : ports) {
                    Integer privatePort = port.getPrivatePort();
                    Integer publicPort = port.getPublicPort();
                    if (privatePort == null || publicPort == null) continue;
                    answer.add(publicPort);
                }
            }
            return answer;
        }
        catch (ProcessingException e) {
            throw new DockerApiConnectionException("Can't connect to the Docker REST API.", e);
        }
    }

    public static String extractLastProgressId(String progressJson) {
        Pattern regex = Pattern.compile("\"id\"\\s*:\\s*\"([^\"]+)");
        Matcher matcher = regex.matcher(progressJson);
        String answer = null;
        while (matcher.find()) {
            answer = matcher.group(1);
        }
        return answer;
    }

    public static String dockerErrorMessage(Exception e) {
        if (e instanceof WebApplicationException) {
            try {
                WebApplicationException webException = (WebApplicationException)e;
                return " " + webException.getResponse().readEntity(String.class);
            }
            catch (Exception e1) {
                return " could not extract response message: " + e;
            }
        }
        return "";
    }
}

