/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.DateUtil;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.WeightedLanguage;

public class ResteasyHttpHeaders
implements HttpHeaders {
    private MultivaluedMap<String, String> requestHeaders = new CaseInsensitiveMap<String>();
    private Map<String, Cookie> cookies = Collections.emptyMap();

    public ResteasyHttpHeaders(MultivaluedMap<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    @Override
    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.requestHeaders;
    }

    public void testParsing() {
        this.getAcceptableMediaTypes();
        this.getMediaType();
        this.getLanguage();
        this.getAcceptableLanguages();
    }

    @Override
    public List<String> getRequestHeader(String name) {
        List vals = (List)this.requestHeaders.get(name);
        if (vals == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(vals);
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, Cookie> cookies) {
        this.cookies = Collections.unmodifiableMap(cookies);
    }

    @Override
    public Date getDate() {
        String date = this.requestHeaders.getFirst("Date");
        if (date == null) {
            return null;
        }
        return DateUtil.parseDate(date);
    }

    @Override
    public String getHeaderString(String name) {
        List vals = (List)this.requestHeaders.get(name);
        if (vals == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String val : vals) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(val);
        }
        return builder.toString();
    }

    @Override
    public Locale getLanguage() {
        String obj = this.requestHeaders.getFirst("Content-Language");
        if (obj == null) {
            return null;
        }
        return new Locale(obj);
    }

    @Override
    public int getLength() {
        String obj = this.requestHeaders.getFirst("Content-Length");
        if (obj == null) {
            return -1;
        }
        return Integer.parseInt(obj);
    }

    @Override
    public MediaType getMediaType() {
        String obj = this.requestHeaders.getFirst("Content-Type");
        if (obj == null) {
            return null;
        }
        return MediaType.valueOf(obj);
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        String accepts = this.getHeaderString("Accept");
        if (accepts == null) {
            return Collections.emptyList();
        }
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        StringTokenizer tokenizer = new StringTokenizer(accepts, ",");
        while (tokenizer.hasMoreElements()) {
            String item = tokenizer.nextToken().trim();
            list.add(MediaType.valueOf(item));
        }
        MediaTypeHelper.sortByWeight(list);
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        String accepts = this.getHeaderString("Accept-Language");
        if (accepts == null) {
            return Collections.emptyList();
        }
        ArrayList<Locale> list = new ArrayList<Locale>();
        ArrayList<WeightedLanguage> languages = new ArrayList<WeightedLanguage>();
        StringTokenizer tokenizer = new StringTokenizer(accepts, ",");
        while (tokenizer.hasMoreElements()) {
            String item = tokenizer.nextToken().trim();
            languages.add(WeightedLanguage.parse(item));
        }
        Collections.sort(languages);
        for (WeightedLanguage language : languages) {
            list.add(language.getLocale());
        }
        return Collections.unmodifiableList(list);
    }
}

