/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf.endpoint;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import io.fabric8.cxf.endpoint.BeanValidationAnnotationModule;
import io.fabric8.cxf.endpoint.FourSpacePrettyPrinter;
import io.fabric8.cxf.endpoint.IgnorePropertiesBackedByTransientFields;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

public class JsonSchemaLookup {
    private static final Logger LOG = LogUtils.getL7dLogger(JsonSchemaLookup.class);
    private static JsonSchemaLookup singleton;
    private ObjectMapper mapper;

    public static JsonSchemaLookup getSingleton() {
        if (singleton == null) {
            new JsonSchemaLookup().init();
        }
        return singleton;
    }

    public void init() {
        LOG.log(Level.INFO, "Creating JsonSchemaLookup instance");
        try {
            if (this.mapper == null) {
                this.mapper = new ObjectMapper();
                this.mapper.setVisibilityChecker((VisibilityChecker)new IgnorePropertiesBackedByTransientFields(this.mapper.getVisibilityChecker()));
                JaxbAnnotationModule module1 = new JaxbAnnotationModule();
                this.mapper.registerModule((Module)module1);
                BeanValidationAnnotationModule module2 = new BeanValidationAnnotationModule();
                this.mapper.registerModule((Module)module2);
            }
            singleton = this;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Exception during initialization: ", e);
            throw new RuntimeException(e);
        }
    }

    public String getSchemaForClass(Class<?> clazz) {
        LOG.info("Looking up schema for " + clazz.getCanonicalName());
        String name = clazz.getName();
        try {
            ObjectWriter writer = this.mapper.writer().with((PrettyPrinter)new FourSpacePrettyPrinter());
            return writer.writeValueAsString((Object)this.mapper.generateJsonSchema(clazz));
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "Failed to generate JSON schema for class " + name, e);
            return "";
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

