/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.cxf;

import io.fabric8.cxf.CxfNodeState;
import io.fabric8.cxf.ServerAddressResolver;
import io.fabric8.groups.Group;
import io.fabric8.groups.NodeState;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerLifeCycleListener;

public class FabricServerListener
implements ServerLifeCycleListener {
    private static final transient Log LOG = LogFactory.getLog(FabricServerListener.class);
    private final Group<CxfNodeState> group;
    private ServerAddressResolver addressResolver;
    private final List<String> services = new ArrayList<String>();

    public FabricServerListener(Group<CxfNodeState> group, ServerAddressResolver addressResolver) {
        this.group = group;
        this.addressResolver = addressResolver;
    }

    public FabricServerListener(Group<CxfNodeState> group) {
        this(group, null);
    }

    public void startServer(Server server) {
        String address = this.getFullAddress(server.getEndpoint().getEndpointInfo().getAddress());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is start with address " + address));
        }
        this.services.add(address);
        this.group.update((NodeState)this.createState());
    }

    public void stopServer(Server server) {
        String address = this.getFullAddress(server.getEndpoint().getEndpointInfo().getAddress());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The CXF server is stopped with address " + address));
        }
        this.services.remove(address);
        this.group.update((NodeState)this.createState());
    }

    private CxfNodeState createState() {
        CxfNodeState state = new CxfNodeState("cxf");
        state.services = this.services.toArray(new String[this.services.size()]);
        return state;
    }

    public String getFullAddress(String address) {
        if (this.addressResolver != null) {
            return this.addressResolver.getFullAddress(address);
        }
        return address;
    }
}

