/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.child;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.ContainerAutoScalerFactory;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateChildContainerMetadata;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.PortService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.ProfileService;
import io.fabric8.api.Profiles;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.Strings;
import io.fabric8.internal.ContainerImpl;
import io.fabric8.internal.Objects;
import io.fabric8.service.ContainerTemplate;
import io.fabric8.service.child.ChildAutoScaler;
import io.fabric8.service.child.ChildContainerController;
import io.fabric8.service.child.ChildContainers;
import io.fabric8.service.child.ProcessControllerFactory;
import io.fabric8.utils.AuthenticationUtils;
import io.fabric8.utils.Ports;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.provider.child", label="Fabric8 Child Container Provider", immediate=true, metatype=false)
@Service(value={ContainerProvider.class, ChildContainerProvider.class})
@Properties(value={@Property(name="fabric.container.protocol", value={"child"})})
public final class ChildContainerProvider
extends AbstractComponent
implements ContainerProvider<CreateChildContainerOptions, CreateChildContainerMetadata>,
ContainerAutoScalerFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(ChildContainerProvider.class);
    static final String SCHEME = "child";
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    @Reference(referenceInterface=ProcessControllerFactory.class, cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC, bind="bindProcessControllerFactory", unbind="unbindProcessControllerFactory")
    private final ValidatingReference<ProcessControllerFactory> processControllerFactory = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public CreateChildContainerOptions.Builder newBuilder() {
        this.assertValid();
        return CreateChildContainerOptions.builder();
    }

    public CreateChildContainerMetadata create(CreateChildContainerOptions options, CreationStateListener listener) throws Exception {
        this.assertValid();
        ChildContainerController controller = this.createController(options);
        return controller.create(options, listener);
    }

    public void start(Container container) {
        this.assertValid();
        this.getContainerController(container).start(container);
    }

    public void stop(Container container) {
        this.assertValid();
        this.getContainerController(container).stop(container);
    }

    public void destroy(Container container) {
        this.assertValid();
        this.getContainerController(container).destroy(container);
    }

    public String getScheme() {
        return SCHEME;
    }

    public Class<CreateChildContainerOptions> getOptionsType() {
        this.assertValid();
        return CreateChildContainerOptions.class;
    }

    public Class<CreateChildContainerMetadata> getMetadataType() {
        this.assertValid();
        return CreateChildContainerMetadata.class;
    }

    public boolean isValidProvider() {
        String environment;
        FabricService service = this.getFabricService();
        if (service != null && (Objects.equal(environment = service.getEnvironment(), "docker") || Objects.equal(environment, "openshift"))) {
            return false;
        }
        boolean openshiftFuseEnv = Strings.notEmpty((String)System.getenv("OPENSHIFT_FUSE_DIR"));
        boolean openshiftAmqEnv = Strings.notEmpty((String)System.getenv("OPENSHIFT_AMQ_DIR"));
        return !openshiftFuseEnv && !openshiftAmqEnv;
    }

    public ContainerAutoScaler createAutoScaler(FabricRequirements requirements, ProfileRequirements profileRequirements) {
        this.assertValid();
        return new ChildAutoScaler(this);
    }

    private ChildContainerController createController(CreateChildContainerOptions options) throws Exception {
        ChildContainerController answer = null;
        boolean isJavaContainer = ChildContainers.isJavaContainer(this.getFabricService(), (CreateContainerBasicOptions)options);
        boolean isProcessContainer = ChildContainers.isProcessContainer(this.getFabricService(), (CreateContainerBasicOptions)options);
        ProcessControllerFactory factory = (ProcessControllerFactory)this.processControllerFactory.getOptional();
        if (factory != null) {
            answer = factory.createController(options);
        } else if (isJavaContainer || isProcessContainer) {
            throw new Exception("No ProcessControllerFactory is available to create a ProcessManager based child container");
        }
        if (answer == null) {
            answer = this.createKarafContainerController();
        }
        LOG.info("Using container controller " + answer);
        return answer;
    }

    private ChildContainerController getContainerController(Container container) {
        this.assertValid();
        ChildContainerController answer = null;
        try {
            ProcessControllerFactory factory = (ProcessControllerFactory)this.processControllerFactory.getOptional();
            if (factory != null) {
                answer = factory.getControllerForContainer(container);
            }
        }
        catch (Exception e) {
            LOG.warn("Caught: " + e, (Throwable)e);
        }
        if (answer == null) {
            answer = this.createKarafContainerController();
        }
        LOG.info("Using container controller " + answer);
        return answer;
    }

    private ChildContainerController createKarafContainerController() {
        return new ChildContainerController(){

            @Override
            public CreateChildContainerMetadata create(final CreateChildContainerOptions options, final CreationStateListener listener) {
                final Container parent = ((FabricService)ChildContainerProvider.this.fabricService.get()).getContainer(options.getParent());
                ContainerTemplate containerTemplate = new ContainerTemplate(parent, options.getJmxUser(), options.getJmxPassword(), false);
                return containerTemplate.execute(new ContainerTemplate.AdminServiceCallback<CreateChildContainerMetadata>(){

                    @Override
                    public CreateChildContainerMetadata doWithAdminService(AdminServiceMBean adminService) throws Exception {
                        return ChildContainerProvider.this.doCreateKaraf(adminService, options, listener, parent);
                    }
                });
            }

            @Override
            public void start(final Container container) {
                ChildContainerProvider.this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

                    @Override
                    public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                        adminService.startInstance(container.getId(), null);
                        return null;
                    }
                });
            }

            @Override
            public void stop(final Container container) {
                ChildContainerProvider.this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

                    @Override
                    public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                        adminService.stopInstance(container.getId());
                        container.setProvisionResult("stopped");
                        return null;
                    }
                });
            }

            @Override
            public void destroy(final Container container) {
                ChildContainerProvider.this.getContainerTemplateForChild(container).execute(new ContainerTemplate.AdminServiceCallback<Object>(){

                    @Override
                    public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                        adminService.destroyInstance(container.getId());
                        return null;
                    }
                });
            }
        };
    }

    private CreateChildContainerMetadata doCreateKaraf(AdminServiceMBean adminService, CreateChildContainerOptions options, CreationStateListener listener, final Container parent) throws Exception {
        StringBuilder jvmOptsBuilder = new StringBuilder();
        String zkPasswordEncode = System.getProperty("zookeeper.password.encode", "true");
        jvmOptsBuilder.append("-server -Dcom.sun.management.jmxremote -Dorg.jboss.gravia.repository.storage.dir=data/repository").append(options.getZookeeperUrl() != null ? " -Dzookeeper.url=\"" + options.getZookeeperUrl() + "\"" : "").append(zkPasswordEncode != null ? " -Dzookeeper.password.encode=\"" + zkPasswordEncode + "\"" : "").append(options.getZookeeperPassword() != null ? " -Dzookeeper.password=\"" + options.getZookeeperPassword() + "\"" : "");
        if (options.getJvmOpts() == null || !options.getJvmOpts().contains("-Xmx")) {
            jvmOptsBuilder.append(" -Xmx512m");
        }
        if (options.getJvmOpts() == null || !options.getJvmOpts().contains("-XX:MaxPermSize=")) {
            jvmOptsBuilder.append(" -XX:MaxPermSize=256m");
        }
        if (options.isEnsembleServer()) {
            jvmOptsBuilder.append(" ").append("ensemble.auto.start=true");
        }
        if (options.getJvmOpts() != null && !options.getJvmOpts().isEmpty()) {
            jvmOptsBuilder.append(" ").append(options.getJvmOpts());
        }
        if (options.getJvmOpts() == null || !options.getJvmOpts().contains("-XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass")) {
            jvmOptsBuilder.append(" -XX:+UnlockDiagnosticVMOptions -XX:+UnsyncloadClass");
        }
        if (options.getBindAddress() != null && !options.getBindAddress().isEmpty()) {
            jvmOptsBuilder.append(" -Dbind.address=" + options.getBindAddress());
        }
        if (options.getResolver() != null && !options.getResolver().isEmpty()) {
            jvmOptsBuilder.append(" -Dlocal.resolver=" + options.getResolver());
        }
        if (options.getManualIp() != null && !options.getManualIp().isEmpty()) {
            jvmOptsBuilder.append(" -Dmanualip=" + options.getManualIp());
        }
        DataStore dataStore = (DataStore)((FabricService)this.fabricService.get()).adapt(DataStore.class);
        ProfileService profileService = (ProfileService)((FabricService)this.fabricService.get()).adapt(ProfileService.class);
        for (Map.Entry dataStoreEntries : options.getDataStoreProperties().entrySet()) {
            String key = (String)dataStoreEntries.getKey();
            String value = (String)dataStoreEntries.getValue();
            jvmOptsBuilder.append(" -Dio.fabric8.datastore." + key + "=" + value);
        }
        Profile profile = parent.getVersion().getRequiredProfile("default");
        Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)((FabricService)this.fabricService.get()), (Profile)profileService.getOverlayProfile(profile));
        String featuresUrls = ChildContainerProvider.collectionAsString(effectiveProfile.getRepositories());
        LinkedHashSet<String> features = new LinkedHashSet<String>();
        features.add("fabric-core");
        String containerName = options.getName();
        PortService portService = ((FabricService)this.fabricService.get()).getPortService();
        Set usedPorts = portService.findUsedPortByHost(parent);
        CreateChildContainerMetadata metadata = new CreateChildContainerMetadata();
        metadata.setCreateOptions((CreateContainerOptions)options);
        metadata.setContainerName(containerName);
        int minimumPort = parent.getMinimumPort();
        int maximumPort = parent.getMaximumPort();
        dataStore.setContainerAttribute(containerName, DataStore.ContainerAttribute.PortMin, String.valueOf(minimumPort));
        dataStore.setContainerAttribute(containerName, DataStore.ContainerAttribute.PortMax, String.valueOf(maximumPort));
        this.inheritAddresses((FabricService)this.fabricService.get(), parent.getId(), containerName, options);
        ContainerImpl child = new ContainerImpl(parent, containerName, (FabricService)this.fabricService.get()){

            @Override
            public String getIp() {
                return parent.getIp();
            }
        };
        int sshFrom = Ports.mapPortToRange(8101, minimumPort, maximumPort);
        int sshTo = Ports.mapPortToRange(8201, minimumPort, maximumPort);
        int sshPort = portService.registerPort((Container)child, "org.apache.karaf.shell", "sshPort", sshFrom, sshTo, usedPorts);
        int httpFrom = Ports.mapPortToRange(8181, minimumPort, maximumPort);
        int httpTo = Ports.mapPortToRange(8281, minimumPort, maximumPort);
        portService.registerPort((Container)child, "org.ops4j.pax.web", "org.osgi.service.http.port", httpFrom, httpTo, usedPorts);
        int rmiServerFrom = Ports.mapPortToRange(44444, minimumPort, maximumPort);
        int rmiServerTo = Ports.mapPortToRange(44544, minimumPort, maximumPort);
        int rmiServerPort = portService.registerPort((Container)child, "org.apache.karaf.management", "rmiServerPort", rmiServerFrom, rmiServerTo, usedPorts);
        int rmiRegistryFrom = Ports.mapPortToRange(1099, minimumPort, maximumPort);
        int rmiRegistryTo = Ports.mapPortToRange(1199, minimumPort, maximumPort);
        int rmiRegistryPort = portService.registerPort((Container)child, "org.apache.karaf.management", "rmiRegistryPort", rmiRegistryFrom, rmiRegistryTo, usedPorts);
        try {
            adminService.createInstance(containerName, sshPort, rmiRegistryPort, rmiServerPort, null, jvmOptsBuilder.toString(), ChildContainerProvider.collectionAsString(features), featuresUrls);
            adminService.startInstance(containerName, null);
        }
        catch (Throwable t) {
            metadata.setFailure(t);
        }
        return metadata;
    }

    private ContainerTemplate getContainerTemplateForChild(Container container) {
        CreateChildContainerOptions options = (CreateChildContainerOptions)container.getMetadata().getCreateOptions();
        String username = AuthenticationUtils.retrieveJaasUser();
        String password = AuthenticationUtils.retrieveJaasPassword();
        if (username != null && password != null) {
            options = (CreateChildContainerOptions)options.updateCredentials(username, password);
        }
        return new ContainerTemplate(container.getParent(), options.getJmxUser(), options.getJmxPassword(), false);
    }

    private void inheritAddresses(FabricService fabricService, String parent, String name, CreateChildContainerOptions options) throws Exception {
        DataStore dataStore = (DataStore)fabricService.adapt(DataStore.class);
        if (options.getManualIp() != null) {
            dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.ManualIp, options.getManualIp());
        } else {
            dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.ManualIp, "${zk:" + parent + "/manualip}");
        }
        dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.LocalHostName, "${zk:" + parent + "/localhostname}");
        dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.LocalIp, "${zk:" + parent + "/localip}");
        dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.PublicIp, "${zk:" + parent + "/publicip}");
        if (options.getResolver() != null) {
            dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.Resolver, options.getResolver());
        } else {
            dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.Resolver, "${zk:" + parent + "/resolver}");
        }
        if (options.getBindAddress() != null) {
            dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.BindAddress, options.getBindAddress());
        } else {
            dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.BindAddress, "${zk:" + parent + "/bindaddress}");
        }
        dataStore.setContainerAttribute(name, DataStore.ContainerAttribute.Ip, "${zk:" + name + "/${zk:" + name + "/resolver}}");
    }

    FabricService getFabricService() {
        return (FabricService)this.fabricService.get();
    }

    private static String collectionAsString(Collection<String> value) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (value != null) {
            for (String el : value) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(el);
            }
        }
        return sb.toString();
    }

    void bindFabricService(FabricService service) {
        this.fabricService.bind((Object)service);
    }

    void unbindFabricService(FabricService service) {
        this.fabricService.unbind((Object)service);
    }

    void bindProcessControllerFactory(ProcessControllerFactory service) {
        this.processControllerFactory.bind((Object)service);
    }

    void unbindProcessControllerFactory(ProcessControllerFactory service) {
        this.processControllerFactory.unbind((Object)service);
    }
}

