/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.Container;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.container", label="Fabric8 Container Placeholder Resolver", metatype=false)
@Service(value={PlaceholderResolver.class, ContainerPlaceholderResolver.class})
@Properties(value={@Property(name="scheme", value={"container"})})
public final class ContainerPlaceholderResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static final String RESOLVER_SCHEME = "container";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String NAME_PATTERN = "[a-zA-Z0-9]+[a-zA-Z0-9_-]*";
    private static final Pattern NAMED_CONTAINER_PATTERN = Pattern.compile("container:([a-zA-Z0-9]+[a-zA-Z0-9_-]*)/([a-zA-Z0-9]+[a-zA-Z0-9_-]*)");
    private static final Pattern CURRENT_CONTAINER_PATTERN = Pattern.compile("container:([a-zA-Z0-9]+[a-zA-Z0-9_-]*)");
    private static final Map<String, DataStore.ContainerAttribute> attributes;

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        Matcher namedMatcher = NAMED_CONTAINER_PATTERN.matcher(value);
        Matcher currentMatcher = CURRENT_CONTAINER_PATTERN.matcher(value);
        if (namedMatcher.matches()) {
            String name = namedMatcher.group(1);
            String attribute = namedMatcher.group(2);
            return this.getContainerAttribute(fabricService, name, attribute);
        }
        if (currentMatcher.matches()) {
            String attribute = currentMatcher.group(1);
            return this.getContainerAttribute(fabricService, fabricService.getCurrentContainerName(), attribute);
        }
        return "";
    }

    private String getContainerAttribute(FabricService fabricService, String name, String attribute) {
        Container container = fabricService.getContainer(name);
        if (NAME_ATTRIBUTE.equals(attribute)) {
            return container.getId();
        }
        DataStore dataStore = (DataStore)fabricService.adapt(DataStore.class);
        return dataStore.getContainerAttribute(container.getId(), attributes.get(attribute.toLowerCase()), "", false, true);
    }

    static {
        HashMap<String, DataStore.ContainerAttribute> auxatts = new HashMap<String, DataStore.ContainerAttribute>();
        for (DataStore.ContainerAttribute attr : EnumSet.allOf(DataStore.ContainerAttribute.class)) {
            auxatts.put(attr.name().toLowerCase(), attr);
        }
        attributes = Collections.unmodifiableMap(auxatts);
    }
}

