/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.support.ConfigInjection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.spi.MapPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.SubstitutionPropertiesProvider;

@Component(immediate=true)
@Service(value={Configurer.class})
public class ComponentConfigurer
extends AbstractComponent
implements Configurer {
    @Reference(referenceInterface=Runtime.class)
    private ValidatingReference<Runtime> runtime = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public <T> Map<String, ?> configure(Dictionary<String, ?> configuration, T target, String ... ignorePrefix) throws Exception {
        this.assertValid();
        HashMap mapConfiguration = new HashMap();
        Enumeration<String> keys = configuration.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            mapConfiguration.put(key, configuration.get(key));
        }
        return this.configure(mapConfiguration, target, ignorePrefix);
    }

    public <T> Map<String, ?> configure(Map<String, ?> configuration, T target, String ... ignorePrefix) throws Exception {
        this.assertValid();
        HashMap<String, Object> result = new HashMap<String, Object>();
        final Runtime runtime = (Runtime)this.runtime.get();
        PropertiesProvider runtimeProperties = new PropertiesProvider(){

            public Object getProperty(String key) {
                return runtime.getProperty(key);
            }

            public Object getRequiredProperty(String key) {
                return runtime.getRequiredProperty(key);
            }

            public Object getProperty(String key, Object defaultValue) {
                return runtime.getProperty(key, defaultValue);
            }
        };
        MapPropertiesProvider configurationProvider = new MapPropertiesProvider(configuration);
        PropertiesProvider[] propertiesProviders = new PropertiesProvider[]{configurationProvider, runtimeProperties};
        SubstitutionPropertiesProvider provider = new SubstitutionPropertiesProvider(propertiesProviders);
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String key = entry.getKey();
            Object value = provider.getProperty(key);
            result.put(key, value);
        }
        ConfigInjection.applyConfiguration(result, target, (String[])ignorePrefix);
        return result;
    }

    void bindRuntime(Runtime service) {
        this.runtime.bind((Object)service);
    }

    void unbindRuntime(Runtime service) {
        this.runtime.unbind((Object)service);
    }
}

