/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal.autoscale;

import io.fabric8.internal.autoscale.HostProfileCounter;

public class LoadSortedHostConfiguration<T>
implements Comparable<LoadSortedHostConfiguration> {
    private final String hostAlias;
    private final T configuration;
    private final String profile;
    private final HostProfileCounter hostProfileCounter;
    private final int index;
    private final int containerCount;
    private final int profileCount;

    public LoadSortedHostConfiguration(String hostAlias, T configuration, String profile, HostProfileCounter hostProfileCounter, int index) {
        this.hostAlias = hostAlias;
        this.configuration = configuration;
        this.profile = profile;
        this.hostProfileCounter = hostProfileCounter;
        this.index = index;
        this.containerCount = hostProfileCounter.containerCount(hostAlias);
        this.profileCount = hostProfileCounter.profileCount(hostAlias, profile);
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public HostProfileCounter getHostProfileCounter() {
        return this.hostProfileCounter;
    }

    public int getIndex() {
        return this.index;
    }

    public String getHostAlias() {
        return this.hostAlias;
    }

    public String getProfile() {
        return this.profile;
    }

    public int getContainerCount() {
        return this.containerCount;
    }

    public int getProfileCount() {
        return this.profileCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadSortedHostConfiguration that = (LoadSortedHostConfiguration)o;
        if (this.index != that.index) {
            return false;
        }
        return !(this.hostAlias != null ? !this.hostAlias.equals(that.hostAlias) : that.hostAlias != null);
    }

    public int hashCode() {
        int result = this.hostAlias != null ? this.hostAlias.hashCode() : 0;
        result = 31 * result + this.index;
        return result;
    }

    @Override
    public int compareTo(LoadSortedHostConfiguration that) {
        int answer = this.containerCount - that.containerCount;
        if (answer == 0 && (answer = this.profileCount - that.profileCount) == 0) {
            answer = this.index - that.index;
        }
        return answer;
    }
}

