/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal.autoscale;

import io.fabric8.utils.CountingMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HostProfileCounter {
    CountingMap hostContainerCounts = new CountingMap();
    Map<String, CountingMap> hostToProfileCounts = new HashMap<String, CountingMap>();

    public CountingMap getHostContainerCounts() {
        return this.hostContainerCounts;
    }

    public int containerCount(String hostAlias) {
        return this.hostContainerCounts.count(hostAlias);
    }

    public Map<String, CountingMap> getHostToProfileCounts() {
        return this.hostToProfileCounts;
    }

    public int incrementContainers(String host) {
        return this.hostContainerCounts.increment(host);
    }

    public int decrementContainers(String host) {
        return this.hostContainerCounts.decrement(host);
    }

    public void setContainerCount(String host, int count) {
        this.hostContainerCounts.setCount(host, count);
    }

    public int incrementProfileCount(String host, String profileId) {
        CountingMap countingMap = this.profileCounts(host);
        return countingMap.increment(profileId);
    }

    public CountingMap profileCounts(String host) {
        CountingMap countingMap = this.hostToProfileCounts.get(host);
        if (countingMap == null) {
            countingMap = new CountingMap();
            this.hostToProfileCounts.put(host, countingMap);
        }
        return countingMap;
    }

    public void incrementProfilesCount(String hostAlias, List<String> profileIds) {
        CountingMap counts = this.profileCounts(hostAlias);
        counts.incrementAll(profileIds);
    }

    public void decrementProfilesCount(String hostAlias, List<String> profileIds) {
        CountingMap counts = this.profileCounts(hostAlias);
        counts.decrementAll(profileIds);
    }

    public int profileCount(String hostAlias, String profileId) {
        CountingMap counts = this.profileCounts(hostAlias);
        return counts.count(profileId);
    }
}

