/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import io.fabric8.api.BootstrapComplete;
import io.fabric8.api.Container;
import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.FabricComplete;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZooKeeperClusterBootstrap;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.BundleUtils;
import io.fabric8.zookeeper.bootstrap.BootstrapConfiguration;
import io.fabric8.zookeeper.bootstrap.DataStoreBootstrapTemplate;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jboss.gravia.runtime.ServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.zookeeper.cluster.bootstrap", label="Fabric8 ZooKeeper Cluster Bootstrap", immediate=true, metatype=false)
@Service(value={ZooKeeperClusterBootstrap.class})
public final class ZooKeeperClusterBootstrapImpl
extends AbstractComponent
implements ZooKeeperClusterBootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperClusterBootstrapImpl.class);
    @Reference
    private Configurer configurer;
    @Reference(referenceInterface=BootstrapConfiguration.class)
    private final ValidatingReference<BootstrapConfiguration> bootstrapConfiguration = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class, bind="bindRuntimeProperties", unbind="unbindRuntimeProperties")
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Property(name="name", label="Container Name", description="The name of the container", value={"${runtime.id}"})
    private String name;
    @Property(name="homeDir", label="Container Home", description="The home directory of the container", value={"${runtime.home}"})
    private File homeDir;
    @Property(name="data", label="Container Data", description="The data directory of the container", value={"${runtime.data}"})
    private String data;
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext, Map<String, ?> configuration) throws Exception {
        this.bundleContext = bundleContext;
        this.configurer.configure(configuration, (Object)this, new String[0]);
        BootstrapConfiguration bootConfig = (BootstrapConfiguration)this.bootstrapConfiguration.get();
        CreateEnsembleOptions options = bootConfig.getBootstrapOptions();
        if (options.isEnsembleStart()) {
            this.startBundles(options);
        }
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public void create(CreateEnsembleOptions options) {
        this.assertValid();
        try {
            ServiceLocator.awaitService(BootstrapComplete.class);
            LOGGER.info("Create fabric with: {}", (Object)options);
            this.stopBundles();
            RuntimeProperties runtimeProps = (RuntimeProperties)this.runtimeProperties.get();
            BootstrapConfiguration bootConfig = (BootstrapConfiguration)this.bootstrapConfiguration.get();
            BundleContext syscontext = this.bundleContext.getBundle(0L).getBundleContext();
            if (options.isClean()) {
                bootConfig = this.cleanInternal(syscontext, bootConfig, runtimeProps);
            }
            BootstrapCreateHandler createHandler = new BootstrapCreateHandler(bootConfig, runtimeProps);
            createHandler.bootstrapFabric(this.name, this.homeDir, options);
            this.startBundles(options);
            long startTime = System.currentTimeMillis();
            long bootstrapTimeout = options.getBootstrapTimeout();
            ServiceLocator.awaitService(FabricComplete.class, (long)bootstrapTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
            long timeDiff = System.currentTimeMillis() - startTime;
            createHandler.waitForContainerAlive(this.name, syscontext, bootstrapTimeout - timeDiff);
            if (options.isWaitForProvision() && options.isAgentEnabled()) {
                long currentTime = System.currentTimeMillis();
                createHandler.waitForSuccessfulDeploymentOf(this.name, syscontext, bootstrapTimeout - (currentTime - startTime));
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new FabricException("Unable to create zookeeper server configuration", (Throwable)ex);
        }
    }

    private BootstrapConfiguration cleanInternal(final BundleContext syscontext, BootstrapConfiguration bootConfig, RuntimeProperties runtimeProps) throws TimeoutException {
        LOGGER.debug("Begin clean fabric");
        try {
            Configuration[] configs = ((ConfigurationAdmin)this.configAdmin.get()).listConfigurations("(|(service.factoryPid=io.fabric8.zookeeper.server)(service.pid=io.fabric8.zookeeper))");
            File karafData = new File(this.data);
            final CountDownLatch unregisterLatch = new CountDownLatch(1);
            Object listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (event.getType() == 4) {
                        LOGGER.debug("Unregistering BootstrapConfiguration");
                        syscontext.removeServiceListener((ServiceListener)this);
                        unregisterLatch.countDown();
                    }
                }
            };
            String filter = "(objectClass=" + BootstrapConfiguration.class.getName() + ")";
            bootConfig.getComponentContext().getBundleContext().addServiceListener(listener, filter);
            LOGGER.debug("Disable BootstrapConfiguration");
            ComponentContext componentContext = bootConfig.getComponentContext();
            componentContext.disableComponent("io.fabric8.bootstrap.configuration");
            if (!unregisterLatch.await(30L, TimeUnit.SECONDS)) {
                throw new TimeoutException("Timeout for unregistering BootstrapConfiguration service");
            }
            runtimeProps.clearRuntimeAttributes();
            this.cleanConfigurations(configs);
            this.cleanZookeeperDirectory(karafData);
            this.cleanGitDirectory(karafData);
            final CountDownLatch registerLatch = new CountDownLatch(1);
            final AtomicReference sref = new AtomicReference();
            listener = new ServiceListener(){

                public void serviceChanged(ServiceEvent event) {
                    if (event.getType() == 1) {
                        LOGGER.debug("Registered BootstrapConfiguration");
                        syscontext.removeServiceListener((ServiceListener)this);
                        sref.set(event.getServiceReference());
                        registerLatch.countDown();
                    }
                }
            };
            syscontext.addServiceListener(listener, "(objectClass=" + BootstrapConfiguration.class.getName() + ")");
            LOGGER.debug("Enable BootstrapConfiguration");
            componentContext.enableComponent("io.fabric8.bootstrap.configuration");
            if (!registerLatch.await(30L, TimeUnit.SECONDS)) {
                throw new TimeoutException("Timeout for registering BootstrapConfiguration service");
            }
            BootstrapConfiguration bootstrapConfiguration = (BootstrapConfiguration)syscontext.getService((ServiceReference)sref.get());
            return bootstrapConfiguration;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (TimeoutException toe) {
            throw toe;
        }
        catch (Exception ex) {
            throw new FabricException("Unable to delete zookeeper configuration", (Throwable)ex);
        }
        finally {
            LOGGER.debug("End clean fabric");
        }
    }

    private void cleanConfigurations(Configuration[] configs) throws IOException, InvalidSyntaxException {
        if (configs != null) {
            LOGGER.debug("cleanConfigurations: {}", Arrays.asList(configs));
            for (Configuration config : configs) {
                config.delete();
            }
        }
    }

    private void cleanZookeeperDirectory(File karafData) throws IOException {
        File zkdir = new File(karafData, "zookeeper");
        if (zkdir.isDirectory()) {
            LOGGER.debug("cleanZookeeperDirectory: {}", (Object)zkdir);
            File renamed = new File(karafData, "zookeeper." + System.currentTimeMillis());
            if (!zkdir.renameTo(renamed)) {
                throw new IOException("Cannot rename zookeeper data dir for removal: " + zkdir);
            }
            ZooKeeperClusterBootstrapImpl.delete(renamed);
        }
    }

    private void cleanGitDirectory(File karafData) throws IOException {
        File gitdir = new File(karafData, "git");
        if (gitdir.isDirectory()) {
            LOGGER.debug("cleanGitDirectory: {}", (Object)gitdir);
            File renamed = new File(karafData, "git." + System.currentTimeMillis());
            if (!gitdir.renameTo(renamed)) {
                throw new IOException("Cannot rename git data dir for removal: " + gitdir);
            }
            ZooKeeperClusterBootstrapImpl.delete(renamed);
        }
    }

    private void stopBundles() throws BundleException {
        BundleUtils bundleUtils = new BundleUtils(this.bundleContext);
        bundleUtils.findAndStopBundle("io.fabric8.fabric-agent");
    }

    private void startBundles(CreateEnsembleOptions options) throws BundleException {
        BundleUtils bundleUtils = new BundleUtils(this.bundleContext);
        Bundle agentBundle = bundleUtils.findBundle("io.fabric8.fabric-agent");
        if (agentBundle != null && options.isAgentEnabled()) {
            agentBundle.start();
        }
    }

    private static void delete(File dir) {
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                ZooKeeperClusterBootstrapImpl.delete(child);
            }
        }
        if (dir.exists()) {
            try {
                boolean deleted = dir.delete();
                if (!deleted) {
                    LOGGER.warn("Failed to delete dir {}", (Object)dir);
                }
            }
            catch (SecurityException e) {
                LOGGER.warn("Failed to delete dir {} due to {}", (Object)dir, (Object)e);
            }
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.bind((Object)service);
    }

    void unbindBootstrapConfiguration(BootstrapConfiguration service) {
        this.bootstrapConfiguration.unbind((Object)service);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }

    static class BootstrapCreateHandler {
        private final BootstrapConfiguration bootConfig;
        private final RuntimeProperties runtimeProperties;

        BootstrapCreateHandler(BootstrapConfiguration bootConfig, RuntimeProperties runtimeProperties) {
            this.bootConfig = bootConfig;
            this.runtimeProperties = runtimeProperties;
        }

        void bootstrapFabric(String containerId, File homeDir, CreateEnsembleOptions options) throws IOException {
            String connectionUrl = this.bootConfig.getConnectionUrl(options);
            BootstrapConfiguration.DataStoreOptions bootOptions = new BootstrapConfiguration.DataStoreOptions(containerId, homeDir, connectionUrl, options);
            this.runtimeProperties.putRuntimeAttribute(DataStoreTemplate.class, (Object)new DataStoreBootstrapTemplate(bootOptions));
            this.bootConfig.createOrUpdateDataStoreConfig(options);
            this.bootConfig.createZooKeeeperServerConfig(options);
            this.bootConfig.createZooKeeeperClientConfig(connectionUrl, options);
        }

        private void waitForContainerAlive(String containerName, BundleContext syscontext, long timeout) throws TimeoutException {
            System.out.println(String.format("Waiting for container: %s", containerName));
            Exception lastException = null;
            long now = System.currentTimeMillis();
            long end = now + timeout;
            while (!Thread.interrupted() && now < end) {
                FabricService fabricService = (FabricService)ServiceLocator.getRequiredService(FabricService.class);
                try {
                    Container container = fabricService.getContainer(containerName);
                    if (container != null && container.isAlive()) {
                        return;
                    }
                    Thread.sleep(500L);
                    now = System.currentTimeMillis();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    lastException = ex;
                }
                catch (Exception ex) {
                    lastException = ex;
                }
            }
            TimeoutException toex = new TimeoutException("Cannot create container in time");
            if (lastException != null) {
                toex.initCause(lastException);
            }
            throw toex;
        }

        private void waitForSuccessfulDeploymentOf(String containerName, BundleContext syscontext, long timeout) throws TimeoutException {
            System.out.println(String.format("Waiting for container %s to provision.", containerName));
            Exception lastException = null;
            long startedAt = System.currentTimeMillis();
            while (!Thread.interrupted() && System.currentTimeMillis() < startedAt + timeout) {
                ServiceReference sref = syscontext.getServiceReference(FabricService.class);
                FabricService fabricService = sref != null ? (FabricService)syscontext.getService(sref) : null;
                try {
                    Container container;
                    Container container2 = container = fabricService != null ? fabricService.getContainer(containerName) : null;
                    if (container != null && container.isAlive() && "success".equals(container.getProvisionStatus())) {
                        return;
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    lastException = ex;
                }
                catch (Exception ex) {
                    lastException = ex;
                }
            }
            TimeoutException toex = new TimeoutException("Cannot provision container in time");
            if (lastException != null) {
                toex.initCause(lastException);
            }
            throw toex;
        }
    }
}

