/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.RuntimeService;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.utils.IllegalStateAssertion;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true)
@Service(value={RuntimeService.class})
public class RuntimeServiceImpl
extends AbstractComponent
implements RuntimeService {
    @Reference(referenceInterface=Runtime.class)
    private ValidatingReference<Runtime> runtime = new ValidatingReference();
    private String identity;
    private Path homePath;
    private Path dataPath;
    private Path confPath;

    @Activate
    void activate(ComponentContext componentContext) throws Exception {
        this.identity = (String)IllegalStateAssertion.assertNotNull((Object)this.getProperty("runtime.id"), (String)"Runtime ID cannot be null.");
        this.homePath = Paths.get((String)IllegalStateAssertion.assertNotNull((Object)this.getProperty("runtime.home"), (String)"Runtime home directory cannot be null."), new String[0]);
        this.dataPath = Paths.get((String)IllegalStateAssertion.assertNotNull((Object)this.getProperty("runtime.data"), (String)"Runtime data directory cannot be null."), new String[0]);
        this.confPath = Paths.get((String)IllegalStateAssertion.assertNotNull((Object)this.getProperty("runtime.conf"), (String)"Runtime conf directory cannot be null."), new String[0]);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getRuntimeIdentity() {
        return this.identity;
    }

    public Path getHomePath() {
        return this.homePath;
    }

    public Path getConfPath() {
        return this.confPath;
    }

    public Path getDataPath() {
        return this.dataPath;
    }

    public String getProperty(String key) {
        return this.getPropertyInternal(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getPropertyInternal(key, defaultValue);
    }

    private String getPropertyInternal(String key, String defaultValue) {
        return (String)((Runtime)this.runtime.get()).getProperty(key, (Object)defaultValue);
    }

    void bindRuntime(Runtime service) {
        this.runtime.bind((Object)service);
    }

    void unbindRuntime(Runtime service) {
        this.runtime.unbind((Object)service);
    }
}

