/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricException;
import io.fabric8.insight.log.service.LogQueryCallback;
import io.fabric8.insight.log.service.LogQueryMBean;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.JMX;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmxTemplateSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxTemplateSupport.class);

    public abstract <T> T execute(JmxConnectorCallback<T> var1);

    public <T> T execute(final LogQueryCallback<T> callback) {
        return this.execute(new JmxConnectorCallback<T>(){

            @Override
            public T doWithJmxConnector(JMXConnector connector) throws Exception {
                String[] bean = new String[]{"type", "LogQuery"};
                return callback.doWithLogQuery(JmxTemplateSupport.this.getMBean(connector, LogQueryMBean.class, "io.fabric8.insight", bean));
            }
        });
    }

    public static ObjectName safeObjectName(String domain, String ... args) {
        if (args.length % 2 != 0) {
            LOGGER.warn("Not all values were defined for arguments %", (Object)Arrays.toString(args));
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < args.length; i += 2) {
            table.put(args[i], args[i + 1]);
        }
        try {
            return new ObjectName(domain, table);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Object name is invalid", e);
        }
    }

    public <T> T getMBean(JMXConnector connector, Class<T> type, String domain, String ... params) {
        try {
            return JMX.newMBeanProxy(connector.getMBeanServerConnection(), JmxTemplateSupport.safeObjectName(domain, params), type);
        }
        catch (IOException e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public static interface JmxConnectorCallback<T> {
        public T doWithJmxConnector(JMXConnector var1) throws Exception;
    }
}

