/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.scr.support.ConfigInjection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.spi.CompositePropertiesProvider;
import org.jboss.gravia.runtime.spi.EnvPropertiesProvider;
import org.jboss.gravia.runtime.spi.MapPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.SubstitutionPropertiesProvider;
import org.jboss.gravia.runtime.spi.SystemPropertiesProvider;
import org.jboss.gravia.utils.IllegalStateAssertion;

@Component(immediate=true)
@Service(value={Configurer.class})
public class ComponentConfigurer
extends AbstractComponent
implements Configurer {
    private static final String BOX_FORMAT = "${%s}";
    @Reference(referenceInterface=Runtime.class)
    private ValidatingReference<Runtime> runtime = new ValidatingReference();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public <T> Map<String, ?> configure(Dictionary<String, ?> configuration, T target, String ... ignorePrefix) throws Exception {
        this.assertValid();
        HashMap mapConfiguration = new HashMap();
        Enumeration<String> keys = configuration.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            mapConfiguration.put(key, configuration.get(key));
        }
        return this.configure(mapConfiguration, target, ignorePrefix);
    }

    public <T> Map<String, ?> configure(Map<String, ?> configuration, T target, String ... ignorePrefix) throws Exception {
        this.assertValid();
        HashMap<String, Object> result = new HashMap<String, Object>();
        EnvPropertiesProvider envPropertiesProvider = new EnvPropertiesProvider("FABRIC8_");
        SystemPropertiesProvider systemPropertiesProvider = new SystemPropertiesProvider();
        final Runtime runtime = (Runtime)this.runtime.get();
        MapPropertiesProvider configurationProvider = new MapPropertiesProvider(configuration);
        CompositePropertiesProvider fallbackPropertiesProvider = new CompositePropertiesProvider(new PropertiesProvider[]{systemPropertiesProvider, envPropertiesProvider});
        final PropertiesProvider[] propertiesProviders = new PropertiesProvider[]{configurationProvider, fallbackPropertiesProvider};
        SubstitutionPropertiesProvider provider = new SubstitutionPropertiesProvider(new PropertiesProvider(){

            public Object getProperty(String key) {
                return runtime.getProperty(key);
            }

            public Object getRequiredProperty(String key) {
                Object value = this.getProperty(key, null);
                IllegalStateAssertion.assertNotNull((Object)value, (String)("Cannot obtain property: " + key));
                return value;
            }

            public Object getProperty(String key, Object defaultValue) {
                Object value = null;
                for (PropertiesProvider p : propertiesProviders) {
                    value = p.getProperty(key);
                    if (value == null || ComponentConfigurer.isCyclicReference(key, value)) continue;
                    return value;
                }
                return defaultValue;
            }
        });
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String key = entry.getKey();
            Object value = provider.getProperty(key);
            result.put(key, value);
        }
        ConfigInjection.applyConfiguration(result, target, (String[])ignorePrefix);
        return result;
    }

    private static boolean isCyclicReference(String key, Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        return String.format(BOX_FORMAT, key).equals(value);
    }

    void bindRuntime(Runtime service) {
        this.runtime.bind((Object)service);
    }

    void unbindRuntime(Runtime service) {
        this.runtime.unbind((Object)service);
    }
}

