/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.FabricRequirements;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequirementsJson {
    private static final transient Logger LOG = LoggerFactory.getLogger(RequirementsJson.class);
    private static ObjectMapper mapper = new ObjectMapper();

    private RequirementsJson() {
    }

    public static void writeRequirements(OutputStream out, FabricRequirements value) throws IOException {
        mapper.writeValue(out, (Object)value);
    }

    public static String toJSON(FabricRequirements answer) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, (Object)answer);
            return writer.toString();
        }
        catch (IOException e) {
            LOG.warn("Failed to marshal to JSON: " + e, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    public static FabricRequirements readRequirements(InputStream in) throws IOException {
        return (FabricRequirements)mapper.readValue(in, FabricRequirements.class);
    }

    public static FabricRequirements fromJSON(String json) throws IOException {
        if (json == null) {
            return null;
        }
        String trimmedJson = json.trim();
        if (trimmedJson.length() == 0 || trimmedJson.equals("{}")) {
            return null;
        }
        return (FabricRequirements)mapper.reader(FabricRequirements.class).readValue(trimmedJson);
    }

    static {
        mapper.getSerializationConfig().withSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

