/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.MQService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.api.jmx.BrokerKind;
import io.fabric8.api.jmx.MQBrokerConfigDTO;
import io.fabric8.api.jmx.MQBrokerStatusDTO;
import io.fabric8.api.jmx.MQManagerMXBean;
import io.fabric8.common.util.JMXUtils;
import io.fabric8.common.util.Maps;
import io.fabric8.common.util.Strings;
import io.fabric8.internal.Objects;
import io.fabric8.service.MQServiceImpl;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Fabric8 MQ Manager JMX MBean", metatype=false)
public class MQManager
implements MQManagerMXBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(MQManager.class);
    private static ObjectName OBJECT_NAME;
    @Reference(referenceInterface=FabricService.class)
    private FabricService fabricService;
    @Reference(referenceInterface=MBeanServer.class)
    private MBeanServer mbeanServer;
    @Reference(referenceInterface=CuratorFramework.class)
    private CuratorFramework curator;
    @Reference(referenceInterface=RuntimeProperties.class)
    private RuntimeProperties runtimeProperties;
    private MQService mqService;

    @Activate
    void activate() throws Exception {
        Objects.notNull(this.fabricService, "fabricService");
        this.mqService = MQManager.createMQService(this.fabricService, this.runtimeProperties);
        if (this.mbeanServer != null) {
            JMXUtils.registerMBean((Object)this, (MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
    }

    @Deactivate
    void deactivate() throws Exception {
        if (this.mbeanServer != null) {
            JMXUtils.unregisterMBean((MBeanServer)this.mbeanServer, (ObjectName)OBJECT_NAME);
        }
    }

    @Override
    public List<MQBrokerConfigDTO> loadBrokerConfiguration() {
        ArrayList<MQBrokerConfigDTO> answer = new ArrayList<MQBrokerConfigDTO>();
        List<Profile> values = this.getActiveOrRequiredBrokerProfileMap();
        for (Profile profile : values) {
            List<MQBrokerConfigDTO> list = MQManager.createConfigDTOs(this.mqService, profile);
            answer.addAll(list);
        }
        return answer;
    }

    @Override
    public List<MQBrokerStatusDTO> loadBrokerStatus() throws Exception {
        FabricRequirements requirements = this.fabricService.getRequirements();
        ArrayList<MQBrokerStatusDTO> answer = new ArrayList<MQBrokerStatusDTO>();
        Version defaultVersion = this.fabricService.getDefaultVersion();
        Container[] containers = this.fabricService.getContainers();
        List<Profile> values = this.getActiveOrRequiredBrokerProfileMap(defaultVersion, requirements);
        for (Profile profile : values) {
            List<MQBrokerConfigDTO> list = MQManager.createConfigDTOs(this.mqService, profile);
            for (MQBrokerConfigDTO configDTO : list) {
                ProfileRequirements profileRequirements = requirements.findProfileRequirements(profile.getId());
                int count = 0;
                for (Container container : containers) {
                    if (!Containers.containerHasProfile((Container)container, (Profile)profile)) continue;
                    MQBrokerStatusDTO status = this.createStatusDTO(profile, configDTO, profileRequirements, container);
                    ++count;
                    answer.add(status);
                }
                if (count != 0) continue;
                MQBrokerStatusDTO status = this.createStatusDTO(profile, configDTO, profileRequirements, null);
                answer.add(status);
            }
        }
        this.addMasterSlaveStatus(answer);
        return answer;
    }

    protected void addMasterSlaveStatus(List<MQBrokerStatusDTO> answer) throws Exception {
        HashMap groupMap = new HashMap();
        for (MQBrokerStatusDTO status : answer) {
            String key = status.getGroup();
            HashMap<String, MQBrokerStatusDTO> list = (HashMap<String, MQBrokerStatusDTO>)groupMap.get(key);
            if (list == null) {
                list = new HashMap<String, MQBrokerStatusDTO>();
                groupMap.put(key, list);
            }
            String statusPath = String.format("%s/%s", status.getContainer(), status.getBrokerName());
            list.put(statusPath, status);
        }
        CuratorFramework curator = this.getCurator();
        Set entries = groupMap.entrySet();
        for (Map.Entry entry : entries) {
            String group = (String)entry.getKey();
            Map containerMap = (Map)entry.getValue();
            String groupPath = ZkPath.MQ_CLUSTER.getPath(new String[]{group});
            List children = ZooKeeperUtils.getChildrenSafe((CuratorFramework)curator, (String)groupPath);
            for (String child : children) {
                String container;
                String statusPath;
                MQBrokerStatusDTO containerStatus;
                ObjectMapper mapper;
                Map map;
                String id;
                String text;
                String childPath = groupPath + "/" + child;
                byte[] data = (byte[])curator.getData().forPath(childPath);
                if (data == null || data.length <= 0 || (text = new String(data).trim()).isEmpty() || (id = MQManager.stringValue(map = (Map)(mapper = new ObjectMapper()).readValue(data, HashMap.class), "id", "container")) == null || (containerStatus = (MQBrokerStatusDTO)containerMap.get(statusPath = String.format("%s/%s", container = MQManager.stringValue(map, "container", "agent"), id))) == null) continue;
                Boolean master = null;
                List services = MQManager.listValue(map, "services");
                if (services != null) {
                    if (!services.isEmpty()) {
                        ArrayList<String> serviceTexts = new ArrayList<String>();
                        for (Object service : services) {
                            String serviceText = ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)service.toString());
                            if (Strings.isNotBlank((String)serviceText)) {
                                serviceTexts.add(serviceText);
                            }
                            containerStatus.setServices(serviceTexts);
                        }
                        master = Boolean.TRUE;
                    } else {
                        master = Boolean.FALSE;
                    }
                } else {
                    master = Boolean.FALSE;
                }
                containerStatus.setMaster(master);
            }
        }
    }

    protected static String stringValue(Map<String, Object> map, String ... keys) {
        Object value = MQManager.value(map, keys);
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    protected static List listValue(Map<String, Object> map, String ... keys) {
        Object value = MQManager.value(map, keys);
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        return null;
    }

    protected static Object value(Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            Object value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    protected MQBrokerStatusDTO createStatusDTO(Profile profile, MQBrokerConfigDTO configDTO, ProfileRequirements profileRequirements, Container container) {
        Integer minimumInstances;
        MQBrokerStatusDTO answer = new MQBrokerStatusDTO(configDTO);
        if (container != null) {
            answer.setContainer(container.getId());
            answer.setAlive(container.isAlive());
            answer.setProvisionResult(container.getProvisionResult());
            answer.setProvisionStatus(container.getProvisionStatus());
            answer.setJolokiaUrl(container.getJolokiaUrl());
        }
        if (profileRequirements != null && (minimumInstances = profileRequirements.getMinimumInstances()) != null) {
            answer.setMinimumInstances(minimumInstances);
        }
        return answer;
    }

    public static List<MQBrokerConfigDTO> createConfigDTOs(MQService mqService, Profile profile) {
        ArrayList<MQBrokerConfigDTO> answer = new ArrayList<MQBrokerConfigDTO>();
        Map configurations = profile.getConfigurations();
        Set entries = configurations.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Map configuration = (Map)entry.getValue();
            if (!MQManager.isBrokerConfigPid(key)) continue;
            String brokerName = MQManager.getBrokerNameFromPID(key);
            String profileId = profile.getId();
            MQBrokerConfigDTO dto = new MQBrokerConfigDTO();
            dto.setProfile(profileId);
            dto.setBrokerName(brokerName);
            String version = profile.getVersion();
            dto.setVersion(version);
            Profile[] parents = profile.getParents();
            if (parents != null && parents.length > 0) {
                dto.setParentProfile(parents[0].getId());
            }
            if (configuration != null) {
                dto.setData((String)configuration.get("data"));
                dto.setConfigUrl((String)configuration.get("config"));
                dto.setGroup((String)configuration.get("group"));
                dto.setKind(BrokerKind.fromValue((String)configuration.get("kind")));
                dto.setMinimumInstances(Maps.integerValue((Map)configuration, (String)"minimumInstances"));
                dto.setNetworks(Maps.stringValues((Map)configuration, (String)"network"));
                dto.setNetworksUserName((String)configuration.get("network.userName"));
                dto.setNetworksPassword((String)configuration.get("network.password"));
                dto.setReplicas(Maps.integerValue((Map)configuration, (String)"replicas"));
                for (Map.Entry configurationEntry : configuration.entrySet()) {
                    if (!((String)configurationEntry.getKey()).endsWith("-port")) continue;
                    dto.getPorts().put(((String)configurationEntry.getKey()).substring(0, ((String)configurationEntry.getKey()).indexOf("-port")), (String)configurationEntry.getValue());
                }
            }
            answer.add(dto);
        }
        return answer;
    }

    public List<Profile> getActiveOrRequiredBrokerProfileMap() {
        return this.getActiveOrRequiredBrokerProfileMap(this.fabricService.getDefaultVersion());
    }

    public List<Profile> getActiveOrRequiredBrokerProfileMap(Version version) {
        return this.getActiveOrRequiredBrokerProfileMap(version, this.fabricService.getRequirements());
    }

    private List<Profile> getActiveOrRequiredBrokerProfileMap(Version version, FabricRequirements requirements) {
        Objects.notNull(this.fabricService, "fabricService");
        ArrayList<Profile> answer = new ArrayList<Profile>();
        if (version != null) {
            Profile[] profiles;
            for (Profile profile : profiles = version.getProfiles()) {
                String profileId = profile.getId();
                if (!requirements.hasMinimumInstances(profileId) && profile.getAssociatedContainers().length <= 0) continue;
                Profile overlay = profile.getOverlay();
                Map configurations = overlay.getConfigurations();
                Set entries = configurations.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    if (!MQManager.isBrokerConfigPid(key)) continue;
                    answer.add(overlay);
                }
            }
        }
        return answer;
    }

    protected static String getBrokerNameFromPID(String key) {
        return key.substring("io.fabric8.mq.fabric.server-".length());
    }

    protected static boolean isBrokerConfigPid(String key) {
        return key.startsWith("io.fabric8.mq.fabric.server-");
    }

    @Override
    public void saveBrokerConfigurationJSON(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        ArrayList<MQBrokerConfigDTO> dtos = new ArrayList<MQBrokerConfigDTO>();
        MappingIterator iter = mapper.reader(MQBrokerConfigDTO.class).readValues(json);
        while (iter.hasNext()) {
            Object next = iter.next();
            if (next instanceof MQBrokerConfigDTO) {
                dtos.add((MQBrokerConfigDTO)next);
                continue;
            }
            LOG.warn("Expected MQBrokerConfigDTO but parsed invalid DTO " + next);
        }
        this.saveBrokerConfiguration(dtos);
    }

    public void saveBrokerConfiguration(List<MQBrokerConfigDTO> dtos) throws IOException {
        for (MQBrokerConfigDTO dto : dtos) {
            MQManager.createOrUpdateProfile(dto, this.fabricService, this.runtimeProperties);
        }
    }

    public static Profile createOrUpdateProfile(MQBrokerConfigDTO dto, FabricService fabricService, RuntimeProperties runtimeProperties) throws IOException {
        String clientProfile;
        Integer minInstances;
        Integer replicas;
        Boolean ssl;
        String parentProfile;
        String networksPassword;
        String group;
        FabricRequirements requirements = fabricService.getRequirements();
        MQServiceImpl mqService = MQManager.createMQService(fabricService, runtimeProperties);
        HashMap<String, String> configuration = new HashMap<String, String>();
        List<String> properties = dto.getProperties();
        String version = dto.version();
        if (properties != null) {
            for (String entry : properties) {
                String[] parts = entry.split("=", 2);
                if (parts.length == 2) {
                    configuration.put(parts[0], parts[1]);
                    continue;
                }
                configuration.put(parts[0], "");
            }
        }
        String data = dto.getData();
        String profileName = dto.profile();
        String brokerName = dto.getBrokerName();
        if (data == null) {
            data = "${runtime.data}" + brokerName;
        }
        configuration.put("data", data);
        for (Map.Entry<String, String> port : dto.getPorts().entrySet()) {
            configuration.put(port.getKey() + "-port", port.getValue());
        }
        BrokerKind kind = dto.kind();
        configuration.put("kind", kind.toString());
        String config = dto.getConfigUrl();
        if (config != null) {
            configuration.put("config", mqService.getConfig(version, config));
        }
        if ((group = dto.getGroup()) != null) {
            configuration.put("group", group);
        }
        Maps.setStringValues(configuration, (String)"network", (String[])dto.getNetworks());
        String networksUserName = dto.getNetworksUserName();
        if (networksUserName != null) {
            configuration.put("network.userName", networksUserName);
        }
        if ((networksPassword = dto.getNetworksPassword()) != null) {
            configuration.put("network.password", networksPassword);
        }
        if ((parentProfile = dto.getParentProfile()) != null) {
            configuration.put("parent", parentProfile);
        }
        if ((ssl = dto.getSsl()) != null) {
            configuration.put("ssl", ssl.toString());
        }
        if ((replicas = dto.getReplicas()) != null) {
            configuration.put("replicas", replicas.toString());
        }
        if ((minInstances = dto.getMinimumInstances()) != null) {
            configuration.put("minimumInstances", minInstances.toString());
        }
        Profile profile = mqService.createOrUpdateMQProfile(version, profileName, brokerName, configuration, dto.kind().equals((Object)BrokerKind.Replicated));
        String profileId = profile.getId();
        ProfileRequirements profileRequirement = requirements.getOrCreateProfileRequirement(profileId);
        Integer minimumInstances = profileRequirement.getMinimumInstances();
        List<MQBrokerConfigDTO> list = MQManager.createConfigDTOs(mqService, profile);
        int requiredInstances = 2;
        if (list.size() == 1) {
            MQBrokerConfigDTO loadedDTO = list.get(0);
            requiredInstances = loadedDTO.requiredInstances();
        } else {
            requiredInstances = list.size() + 1;
        }
        if (minimumInstances == null || minimumInstances < requiredInstances) {
            profileRequirement.setMinimumInstances(Integer.valueOf(requiredInstances));
            fabricService.setRequirements(requirements);
        }
        if (Strings.isNotBlank((String)(clientProfile = dto.clientProfile()))) {
            String clientParentProfile = dto.getClientParentProfile();
            if (Strings.isNullOrBlank((String)clientParentProfile)) {
                clientParentProfile = "mq-client-base";
            }
            mqService.createOrUpdateMQClientProfile(version, clientProfile, group, clientParentProfile);
        }
        return profile;
    }

    protected static MQServiceImpl createMQService(FabricService fabricService, RuntimeProperties runtimeProperties) {
        return new MQServiceImpl(fabricService, runtimeProperties);
    }

    public static void assignProfileToContainers(FabricService fabricService, Profile profile, String[] assignContainers) {
        for (String containerName : assignContainers) {
            try {
                Container container = fabricService.getContainer(containerName);
                if (container == null) {
                    LOG.warn("Failed to assign profile to " + containerName + ": profile doesn't exists");
                    continue;
                }
                HashSet<Profile> profiles = new HashSet<Profile>(Arrays.asList(container.getProfiles()));
                profiles.add(profile);
                container.setProfiles(profiles.toArray(new Profile[profiles.size()]));
                LOG.info("Profile successfully assigned to " + containerName);
            }
            catch (Exception e) {
                LOG.warn("Failed to assign profile to " + containerName + ": " + e.getMessage());
            }
        }
    }

    public static List<CreateContainerBasicOptions.Builder> createContainerBuilders(MQBrokerConfigDTO dto, FabricService fabricService, String containerProviderScheme, String profileId, String version, String[] createContainers) throws IOException {
        ContainerProvider containerProvider = fabricService.getProvider(containerProviderScheme);
        Objects.notNull(containerProvider, "No ContainerProvider available for scheme: " + containerProviderScheme);
        ArrayList<CreateContainerBasicOptions.Builder> containerBuilders = new ArrayList<CreateContainerBasicOptions.Builder>();
        for (String container : createContainers) {
            Object type = null;
            String parent = fabricService.getCurrentContainerName();
            String jvmOpts = dto.getJvmOpts();
            CreateContainerBasicOptions.Builder builder = containerProvider.newBuilder();
            builder = (CreateContainerBasicOptions.Builder)builder.name(container).parent(parent).number(dto.requiredInstances()).ensembleServer(false).proxyUri(fabricService.getMavenRepoURI()).jvmOpts(jvmOpts).zookeeperUrl(fabricService.getZookeeperUrl()).zookeeperPassword(fabricService.getZookeeperPassword()).profiles(profileId).version(version);
            containerBuilders.add(builder);
        }
        return containerBuilders;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=MQManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }

    protected void bindFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    protected void unbindFabricService(FabricService fabricService) {
        if (this.fabricService == fabricService) {
            this.fabricService = null;
        }
    }

    protected void bindMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    protected void unbindMbeanServer(MBeanServer mBeanServer) {
        if (this.mbeanServer == mBeanServer) {
            this.mbeanServer = null;
        }
    }

    protected void bindCurator(CuratorFramework curatorFramework) {
        this.curator = curatorFramework;
    }

    protected void unbindCurator(CuratorFramework curatorFramework) {
        if (this.curator == curatorFramework) {
            this.curator = null;
        }
    }

    protected void bindRuntimeProperties(RuntimeProperties runtimeProperties) {
        this.runtimeProperties = runtimeProperties;
    }

    protected void unbindRuntimeProperties(RuntimeProperties runtimeProperties) {
        if (this.runtimeProperties == runtimeProperties) {
            this.runtimeProperties = null;
        }
    }
}

