/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.CreateEnsembleOptions;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZooKeeperClusterService;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.jmx.ClusterBootstrapManager;
import io.fabric8.api.jmx.ClusterServiceManagerMBean;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.common.util.JMXUtils;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;

@ThreadSafe
@Component(label="Fabric8 ZooKeeper Cluster Manager JMX MBean", metatype=false)
public final class ClusterServiceManager
extends AbstractComponent
implements ClusterServiceManagerMBean {
    private static ObjectName OBJECT_NAME;
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=ZooKeeperClusterService.class)
    private final ValidatingReference<ZooKeeperClusterService> clusterService = new ValidatingReference();
    @Reference(referenceInterface=MBeanServer.class, bind="bindMBeanServer", unbind="unbindMBeanServer")
    private final ValidatingReference<MBeanServer> mbeanServer = new ValidatingReference();

    @Activate
    void activate() throws Exception {
        JMXUtils.registerMBean((Object)this, (MBeanServer)((MBeanServer)this.mbeanServer.get()), (ObjectName)OBJECT_NAME);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() throws Exception {
        this.deactivateComponent();
        JMXUtils.unregisterMBean((MBeanServer)((MBeanServer)this.mbeanServer.get()), (ObjectName)OBJECT_NAME);
    }

    public List<String> getEnsembleContainers() {
        this.assertValid();
        return ((ZooKeeperClusterService)this.clusterService.get()).getEnsembleContainers();
    }

    public String getZooKeeperUrl() {
        this.assertValid();
        return ((ZooKeeperClusterService)this.clusterService.get()).getZooKeeperUrl();
    }

    public String getZookeeperPassword() {
        this.assertValid();
        return ((ZooKeeperClusterService)this.clusterService.get()).getZookeeperPassword();
    }

    public Map<String, String> getEnsembleConfiguration() throws Exception {
        return ((ZooKeeperClusterService)this.clusterService.get()).getEnsembleConfiguration();
    }

    public void createCluster(List<String> containers) {
        this.assertValid();
        ((ZooKeeperClusterService)this.clusterService.get()).createCluster(containers);
    }

    @Override
    public void addToCluster(List<String> containers, Map<String, Object> options) {
        this.assertValid();
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        CreateEnsembleOptions createEnsembleOptions = ClusterBootstrapManager.getCreateEnsembleOptions(sysprops, options);
        this.addToCluster(containers, createEnsembleOptions);
    }

    @Override
    public void removeFromCluster(List<String> containers, Map<String, Object> options) {
        this.assertValid();
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        CreateEnsembleOptions createEnsembleOptions = ClusterBootstrapManager.getCreateEnsembleOptions(sysprops, options);
        this.removeFromCluster(containers, createEnsembleOptions);
    }

    public void createCluster(List<String> containers, CreateEnsembleOptions options) {
        this.assertValid();
        ((ZooKeeperClusterService)this.clusterService.get()).createCluster(containers, options);
    }

    public void addToCluster(List<String> containers) {
        this.assertValid();
        ((ZooKeeperClusterService)this.clusterService.get()).addToCluster(containers);
    }

    public void addToCluster(List<String> containers, CreateEnsembleOptions options) {
        this.assertValid();
        ((ZooKeeperClusterService)this.clusterService.get()).addToCluster(containers, options);
    }

    public void removeFromCluster(List<String> containers) {
        this.assertValid();
        ((ZooKeeperClusterService)this.clusterService.get()).removeFromCluster(containers);
    }

    public void removeFromCluster(List<String> containers, CreateEnsembleOptions options) {
        this.assertValid();
        ((ZooKeeperClusterService)this.clusterService.get()).removeFromCluster(containers, options);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.bind((Object)mbeanServer);
    }

    void unbindMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer.unbind((Object)mbeanServer);
    }

    void bindClusterService(ZooKeeperClusterService service) {
        this.clusterService.bind((Object)service);
    }

    void unbindClusterService(ZooKeeperClusterService service) {
        this.clusterService.unbind((Object)service);
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=ClusterServiceManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

