/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.common.util.Strings;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.versionprop", label="Fabric8 Version Property Placeholder Resolver", immediate=true, metatype=false)
@Service(value={PlaceholderResolver.class, VersionPropertyPointerResolver.class})
@Properties(value={@Property(name="scheme", value={"version"})})
public final class VersionPropertyPointerResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static final String RESOLVER_SCHEME = "version";
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionPropertyPointerResolver.class);
    private static final String EMPTY = "";
    public static final String VERSIONS_PID = "io.fabric8.version";
    public static final String VERSION_PREFIX = "${version:";
    public static final String VERSION_POSTFIX = "}";

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public static String replaceVersions(FabricService fabricService, Map<String, Map<String, String>> configs, String value) {
        boolean replaced;
        do {
            int keyIdx;
            int endIdx;
            replaced = false;
            int startIdx = value.indexOf(VERSION_PREFIX);
            if (startIdx < 0 || (endIdx = value.indexOf(VERSION_POSTFIX, keyIdx = startIdx + VERSION_PREFIX.length())) <= 0) continue;
            String newKey = value.substring(keyIdx, endIdx);
            String newValue = VersionPropertyPointerResolver.substituteFromProfile(fabricService, configs, VERSIONS_PID, newKey);
            if (newValue != null) {
                value = value.substring(0, startIdx) + newValue + value.substring(endIdx + 1);
            }
            replaced = true;
        } while (replaced);
        return value;
    }

    private static String substituteFromProfile(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key) {
        Map configuration = configs.get(pid);
        if (configuration != null && configuration.containsKey(key)) {
            return (String)configuration.get(key);
        }
        configuration = fabricService.getCurrentContainer().getOverlayProfile().getConfiguration(pid);
        if (configuration != null && configuration.containsKey(key)) {
            return (String)configuration.get(key);
        }
        return EMPTY;
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        try {
            if (Strings.isNotBlank((String)value)) {
                String pidPey = value.substring(RESOLVER_SCHEME.length() + 1);
                String answer = VersionPropertyPointerResolver.substituteFromProfile(fabricService, configs, VERSIONS_PID, pidPey);
                if (answer != null) {
                    answer = VersionPropertyPointerResolver.replaceVersions(fabricService, configs, answer);
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Replaced value " + value + " with answer: " + answer);
                }
                return answer;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Could not load property value: {} in version pid. Returning empty String.", (Object)value, (Object)e);
        }
        return EMPTY;
    }
}

