/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.common.util.ChecksumUtils;
import io.fabric8.common.util.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.checksum", label="Fabric8 Checksum Placholder Resolver", metatype=false)
@Service(value={PlaceholderResolver.class, ChecksumPlaceholderResolver.class})
@Properties(value={@Property(name="scheme", value={"checksum"})})
public final class ChecksumPlaceholderResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static final String RESOLVER_SCHEME = "checksum";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChecksumPlaceholderResolver.class);

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        String string;
        if (value.contains(":mvel:") || value.contains(":mvel\\:")) {
            LOGGER.error("The checksum URL cannot contain mvel sub-URL");
            throw new InvalidParameterException("The checksum URL cannot contain mvel sub-URL");
        }
        InputStream is = null;
        try {
            URL url = new URL(value.substring("checksum:".length()));
            is = url.openStream();
            string = String.valueOf(ChecksumUtils.checksum((InputStream)is));
        }
        catch (Exception ex) {
            String string2;
            try {
                LOGGER.debug("Could not resolve placeholder", (Throwable)ex);
                string2 = "0";
            }
            catch (Throwable throwable) {
                Closeables.closeQuitely(is);
                throw throwable;
            }
            Closeables.closeQuitely((Closeable)is);
            return string2;
        }
        Closeables.closeQuitely((Closeable)is);
        return string;
    }
}

