/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.Container;
import io.fabric8.api.FabricException;
import io.fabric8.api.PortService;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMultiLock;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;

@ThreadSafe
@Component(name="io.fabric8.portservice.zookeeper", label="Fabric8 ZooKeeper Port Service", metatype=false)
@Service(value={PortService.class})
public final class ZookeeperPortService
extends AbstractComponent
implements PortService {
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private InterProcessLock interProcessLock;

    @Activate
    void activate() {
        this.interProcessLock = new InterProcessMultiLock((CuratorFramework)this.curator.get(), Arrays.asList(ZkPath.PORTS_LOCK.getPath(new String[0])));
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.releaseLock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int registerPort(Container container, String pid, String key, int fromPort, int toPort, Set<Integer> excludes) {
        this.assertValid();
        try {
            if (!this.interProcessLock.acquire(60L, TimeUnit.SECONDS)) throw new FabricException("Could not acquire port lock");
            int port = this.lookupPort(container, pid, key);
            if (port > 0) {
                int n = port;
                return n;
            }
            Set<Integer> boundPorts = this.findUsedPortByHost(container);
            boundPorts.addAll(excludes);
            port = fromPort;
            while (port <= toPort) {
                if (!boundPorts.contains(port)) {
                    this.registerPort(container, pid, key, port);
                    int n = port;
                    return n;
                }
                ++port;
            }
            throw new FabricException("Could not find port within range [" + fromPort + "," + toPort + "]");
        }
        catch (Exception ex) {
            throw FabricException.launderThrowable((Throwable)ex);
        }
        finally {
            this.releaseLock();
        }
    }

    public void registerPort(Container container, String pid, String key, int port) {
        block7: {
            this.assertValid();
            String portAsString = String.valueOf(port);
            String containerPortsPath = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key});
            String ipPortsPath = ZkPath.PORTS_IP.getPath(new String[]{container.getIp()});
            try {
                if (this.interProcessLock.acquire(60L, TimeUnit.SECONDS)) {
                    ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath, (String)portAsString);
                    ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath, (String)portAsString);
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath, (String)portAsString);
                    String existingPorts = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath);
                    if (!existingPorts.contains(portAsString)) {
                        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath, (String)(existingPorts + " " + portAsString));
                    }
                    break block7;
                }
                throw new FabricException("Could not acquire port lock");
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                this.releaseLock();
            }
        }
    }

    public void unregisterPort(Container container, String pid, String key) {
        block9: {
            this.assertValid();
            String containerPortsPidKeyPath = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key});
            String ipPortsPath = ZkPath.PORTS_IP.getPath(new String[]{container.getIp()});
            try {
                if (this.interProcessLock.acquire(60L, TimeUnit.SECONDS)) {
                    if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidKeyPath) != null) {
                        int port = this.lookupPort(container, pid, key);
                        ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidKeyPath);
                        Set<Integer> allPorts = this.findUsedPortByHost(container);
                        allPorts.remove(port);
                        StringBuilder sb = new StringBuilder();
                        boolean first = true;
                        for (Integer p : allPorts) {
                            if (first) {
                                sb.append(p);
                                first = false;
                                continue;
                            }
                            sb.append(" ").append(p);
                        }
                        ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ipPortsPath, (String)sb.toString());
                    }
                    break block9;
                }
                throw new FabricException("Could not acquire port lock");
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                this.releaseLock();
            }
        }
    }

    public void unregisterPort(Container container, String pid) {
        block8: {
            this.assertValid();
            String containerPortsPidPath = ZkPath.PORTS_CONTAINER_PID.getPath(new String[]{container.getId(), pid});
            try {
                if (this.interProcessLock.acquire(60L, TimeUnit.SECONDS)) {
                    if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidPath) != null) {
                        for (String key : ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidPath)) {
                            this.unregisterPort(container, pid, key);
                        }
                        ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPidPath);
                    }
                    break block8;
                }
                throw new FabricException("Could not acquire port lock");
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                this.releaseLock();
            }
        }
    }

    public void unregisterPort(Container container) {
        block8: {
            this.assertValid();
            String containerPortsPath = ZkPath.PORTS_CONTAINER.getPath(new String[]{container.getId()});
            try {
                if (this.interProcessLock.acquire(60L, TimeUnit.SECONDS)) {
                    if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath) != null) {
                        for (String pid : ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath)) {
                            this.unregisterPort(container, pid);
                        }
                        ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPortsPath);
                    }
                    break block8;
                }
                throw new FabricException("Could not acquire port lock");
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                this.releaseLock();
            }
        }
    }

    public int lookupPort(Container container, String pid, String key) {
        this.assertValid();
        int port = 0;
        String path = ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key});
        try {
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path) != null) {
                port = Integer.parseInt(ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path));
            }
        }
        catch (Exception ex) {
            throw FabricException.launderThrowable((Throwable)ex);
        }
        return port;
    }

    public Set<Integer> findUsedPortByContainer(Container container) {
        HashSet<Integer> ports;
        block11: {
            this.assertValid();
            ports = new HashSet<Integer>();
            String path = ZkPath.PORTS_CONTAINER.getPath(new String[]{container.getId()});
            try {
                if (this.interProcessLock.acquire(60L, TimeUnit.SECONDS)) {
                    if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path) != null) {
                        for (String pid : ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path)) {
                            for (String key : ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.PORTS_CONTAINER_PID.getPath(new String[]{container.getId(), pid}))) {
                                String port = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.PORTS_CONTAINER_PID_KEY.getPath(new String[]{container.getId(), pid, key}));
                                try {
                                    ports.add(Integer.parseInt(port));
                                }
                                catch (Exception ex) {}
                            }
                        }
                    }
                    break block11;
                }
                throw new FabricException("Could not acquire port lock");
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                this.releaseLock();
            }
        }
        return ports;
    }

    public Set<Integer> findUsedPortByHost(Container container) {
        HashSet<Integer> ports;
        block10: {
            this.assertValid();
            String ip = container.getIp();
            ports = new HashSet<Integer>();
            String path = ZkPath.PORTS_IP.getPath(new String[]{ip});
            try {
                if (this.interProcessLock.acquire(60L, TimeUnit.SECONDS)) {
                    ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)"");
                    String boundPorts = ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                    if (boundPorts != null && !boundPorts.isEmpty()) {
                        for (String port : boundPorts.split(" ")) {
                            try {
                                ports.add(Integer.parseInt(port.trim()));
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                    }
                    break block10;
                }
                throw new FabricException("Could not acquire port lock");
            }
            catch (Exception ex) {
                throw FabricException.launderThrowable((Throwable)ex);
            }
            finally {
                this.releaseLock();
            }
        }
        return ports;
    }

    private void releaseLock() {
        try {
            if (this.interProcessLock != null) {
                this.interProcessLock.release();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }
}

