/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.DataStore;
import io.fabric8.api.DataStoreRegistrationHandler;
import io.fabric8.api.DataStoreTemplate;
import io.fabric8.api.FabricException;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.visibility.VisibleForTesting;
import io.fabric8.utils.Base64Encoder;
import io.fabric8.utils.Closeables;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.ObjectUtils;
import io.fabric8.utils.Strings;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractDataStore<T extends DataStore>
extends AbstractComponent
implements DataStore,
PathChildrenCacheListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractDataStore.class);
    public static final String REQUIREMENTS_JSON_PATH = "/fabric/configs/io.fabric8.requirements.json";
    public static final String JVM_OPTIONS_PATH = "/fabric/configs/io.fabric8.containers.jvmOptions";
    private final ValidatingReference<DataStoreRegistrationHandler> registrationHandler = new ValidatingReference();
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    private final ExecutorService callbacksExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService cacheExecutor = Executors.newSingleThreadExecutor();
    private final CopyOnWriteArrayList<Runnable> callbacks = new CopyOnWriteArrayList();
    private Map<String, String> dataStoreProperties;
    private TreeCache treeCache;

    protected RuntimeProperties getRuntimeProperties() {
        return (RuntimeProperties)this.runtimeProperties.get();
    }

    public abstract void importFromFileSystem(String var1);

    protected void protectedActivate(Map<String, ?> configuration) throws Exception {
        HashMap<String, String> dataStoreProperties = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : configuration.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof String)) continue;
            dataStoreProperties.put(key, (String)value);
        }
        this.dataStoreProperties = Collections.unmodifiableMap(dataStoreProperties);
        try {
            this.activateComponent();
            this.activateInternal();
        }
        catch (Exception ex) {
            this.deactivateComponent();
            throw ex;
        }
    }

    protected void protectedDeactivate() {
        this.deactivateComponent();
        this.deactivateInternal();
    }

    protected void activateInternal() throws Exception {
        LOG.info("Starting up DataStore " + (Object)((Object)this));
        this.treeCache = new TreeCache(this.getCurator(), ZkPath.CONFIGS.getPath(new String[0]), true, false, true, this.cacheExecutor);
        this.treeCache.start(TreeCache.StartMode.NORMAL);
        this.treeCache.getListenable().addListener((Object)this);
        DataStoreRegistrationHandler templateRegistry = (DataStoreRegistrationHandler)this.registrationHandler.get();
        DataStoreTemplate template = templateRegistry.removeRegistrationCallback();
        if (template != null) {
            LOG.info("Using template: " + template);
            template.doWith((DataStore)this);
        }
    }

    protected void deactivateInternal() {
        this.treeCache.getListenable().removeListener((Object)this);
        Closeables.closeQuitely((Closeable)this.treeCache);
        this.callbacksExecutor.shutdownNow();
        this.cacheExecutor.shutdownNow();
    }

    protected TreeCache getTreeCache() {
        this.assertValid();
        return this.treeCache;
    }

    public Map<String, String> getDataStoreProperties() {
        this.assertValid();
        return this.dataStoreProperties;
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        if (this.isValid()) {
            switch (event.getType()) {
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_UPDATED: 
                case INITIALIZED: {
                    if (!this.shouldRunCallbacks(event.getData().getPath())) break;
                    this.fireChangeNotifications();
                }
            }
        }
    }

    protected void clearCaches() {
    }

    protected void fireChangeNotifications() {
        this.assertValid();
        LOG.debug("Firing change notifications!");
        this.clearCaches();
        this.runCallbacks();
    }

    private boolean shouldRunCallbacks(String path) {
        String karafName = ((RuntimeProperties)this.runtimeProperties.get()).getProperty("karaf.name");
        String currentVersion = this.getContainerVersion(karafName);
        return path.equals(ZkPath.CONFIG_ENSEMBLES.getPath(new String[0])) || path.equals(ZkPath.CONFIG_ENSEMBLE_URL.getPath(new String[0])) || path.equals(ZkPath.CONFIG_ENSEMBLE_PASSWORD.getPath(new String[0])) || path.equals(ZkPath.CONFIG_CONTAINER.getPath(new String[]{karafName})) || currentVersion != null && path.equals(ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{currentVersion, karafName}));
    }

    protected void runCallbacks() {
        this.callbacksExecutor.submit(new Runnable(){

            @Override
            public void run() {
                AbstractDataStore.this.doRunCallbacks();
            }
        });
    }

    protected void doRunCallbacks() {
        this.assertValid();
        for (Runnable callback : this.callbacks) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running callback " + callback);
                }
                callback.run();
            }
            catch (Throwable e) {
                LOG.warn("Caught: " + e, e);
            }
        }
    }

    public void trackConfiguration(Runnable callback) {
        if (this.isValid()) {
            this.callbacks.addIfAbsent(callback);
        }
    }

    public void untrackConfiguration(Runnable callback) {
        this.callbacks.remove(callback);
    }

    public List<String> getContainers() {
        this.assertValid();
        try {
            return ZooKeeperUtils.getChildren((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIGS_CONTAINERS.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public boolean hasContainer(String containerId) {
        this.assertValid();
        return this.getContainers().contains(containerId);
    }

    public String getContainerParent(String containerId) {
        this.assertValid();
        try {
            String parentName = ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_PARENT.getPath(new String[]{containerId}));
            return parentName != null ? parentName.trim() : "";
        }
        catch (KeeperException.NoNodeException e) {
            return "";
        }
        catch (Throwable e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void deleteContainer(String containerId) {
        this.assertValid();
        try {
            if (this.getCurator() == null) {
                throw new IllegalStateException("Zookeeper service not available");
            }
            for (String version : this.getVersions()) {
                ZooKeeperUtils.deleteSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, containerId}));
            }
            ZooKeeperUtils.deleteSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_DOMAINS.getPath(new String[]{containerId}));
            ZooKeeperUtils.deleteSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_PROVISION.getPath(new String[]{containerId}));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void createContainerConfig(CreateContainerOptions options) {
        this.assertValid();
        try {
            String parent = options.getParent();
            String containerId = options.getName();
            String versionId = options.getVersion();
            Set profileIds = options.getProfiles();
            StringBuilder sb = new StringBuilder();
            for (String profileId : profileIds) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(profileId);
            }
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}), (String)versionId);
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}), (String)sb.toString());
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_PARENT.getPath(new String[]{containerId}), (String)parent);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void createContainerConfig(CreateContainerMetadata metadata) {
        this.assertValid();
        try {
            String resolver;
            CreateContainerOptions options = metadata.getCreateOptions();
            String containerId = metadata.getContainerName();
            this.setContainerMetadata(metadata);
            Map configuration = metadata.getContainerConfiguration();
            for (Map.Entry entry : configuration.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_ENTRY.getPath(new String[]{metadata.getContainerName(), key}), (String)value);
            }
            String string = resolver = metadata.getOverridenResolver() != null ? metadata.getOverridenResolver() : options.getResolver();
            if (resolver == null && ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId})) != null) {
                resolver = ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId}));
            } else if (options.getResolver() == null) {
                resolver = ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)ZkPath.POLICIES.getPath(new String[]{"resolver"})) != null ? ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.POLICIES.getPath(new String[]{"resolver"})) : "localhostname";
            }
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId}), (String)resolver);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public CreateContainerMetadata getContainerMetadata(String containerId, final ClassLoader classLoader) {
        this.assertValid();
        try {
            byte[] encoded = ZooKeeperUtils.getByteData((TreeCache)this.getTreeCache(), (String)ZkPath.CONTAINER_METADATA.getPath(new String[]{containerId}));
            if (encoded == null) {
                return null;
            }
            byte[] decoded = Base64Encoder.decode(encoded);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decoded)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    return classLoader.loadClass(desc.getName());
                }
            };
            return (CreateContainerMetadata)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InvalidClassException e) {
            return null;
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerMetadata(CreateContainerMetadata metadata) {
        this.assertValid();
        try {
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_METADATA.getPath(new String[]{metadata.getContainerName()}), (byte[])Base64Encoder.encode(ObjectUtils.toBytes(metadata)));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getContainerVersion(String containerId) {
        this.assertValid();
        try {
            return ZooKeeperUtils.getStringData((TreeCache)this.getTreeCache(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerVersion(String containerId, String versionId) {
        this.assertValid();
        try {
            String oldVersionId = ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
            String oldProfileIds = ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{oldVersionId, containerId}));
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}), (String)oldProfileIds);
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}), (String)versionId);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public List<String> getContainerProfiles(String containerId) {
        this.assertValid();
        try {
            String versionId;
            String str = null;
            if (Strings.isNotBlank(containerId) && Strings.isNotBlank(versionId = ZooKeeperUtils.getStringData((TreeCache)this.getTreeCache(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId})))) {
                str = ZooKeeperUtils.getStringData((TreeCache)this.getTreeCache(), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}));
            }
            return str == null || str.isEmpty() ? Collections.emptyList() : Arrays.asList(str.trim().split(" +"));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerProfiles(String containerId, List<String> profileIds) {
        this.assertValid();
        try {
            String versionId = ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_CONTAINER.getPath(new String[]{containerId}));
            StringBuilder sb = new StringBuilder();
            for (String profileId : profileIds) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(profileId);
            }
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{versionId, containerId}), (String)sb.toString());
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public boolean isContainerAlive(String id) {
        this.assertValid();
        try {
            return ZooKeeperUtils.exists((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{id})) != null;
        }
        catch (KeeperException.NoNodeException e) {
            return false;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerAlive(String id, boolean flag) {
        this.assertValid();
        try {
            if (flag) {
                ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{id}), (String)"alive");
            } else {
                ZooKeeperUtils.deleteSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_ALIVE.getPath(new String[]{id}));
            }
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getContainerAttribute(String containerId, DataStore.ContainerAttribute attribute, String def, boolean mandatory, boolean substituted) {
        this.assertValid();
        if (attribute == DataStore.ContainerAttribute.Domains) {
            try {
                List list = (List)this.getCurator().getChildren().forPath(ZkPath.CONTAINER_DOMAINS.getPath(new String[]{containerId}));
                Collections.sort(list);
                StringBuilder sb = new StringBuilder();
                for (String l : list) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(l);
                }
                return sb.toString();
            }
            catch (Exception e) {
                return "";
            }
        }
        try {
            if (substituted) {
                return ZooKeeperUtils.getSubstitutedPath((CuratorFramework)this.getCurator(), (String)this.getAttributePath(containerId, attribute));
            }
            return ZooKeeperUtils.getStringData((CuratorFramework)this.getCurator(), (String)this.getAttributePath(containerId, attribute));
        }
        catch (KeeperException.NoNodeException e) {
            if (mandatory) {
                throw FabricException.launderThrowable((Throwable)e);
            }
            return def;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setContainerAttribute(String containerId, DataStore.ContainerAttribute attribute, String value) {
        this.assertValid();
        if (attribute == DataStore.ContainerAttribute.Resolver) {
            try {
                ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_IP.getPath(new String[]{containerId}), (String)("${zk:" + containerId + "/" + value + "}"));
                ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId}), (String)value);
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }
        if (attribute == DataStore.ContainerAttribute.Domains) {
            try {
                String path;
                List<String> list = value != null ? Arrays.asList(value.split("\n")) : Collections.emptyList();
                HashSet zkSet = new HashSet(ZooKeeperUtils.getChildrenSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CONTAINER_DOMAINS.getPath(new String[]{containerId})));
                for (String domain : list) {
                    path = ZkPath.CONTAINER_DOMAIN.getPath(new String[]{containerId, domain});
                    if (zkSet.remove(domain)) continue;
                    ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path, (String)"");
                }
                for (String domain : zkSet) {
                    path = ZkPath.CONTAINER_DOMAIN.getPath(new String[]{containerId, domain});
                    ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)path);
                }
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }
        try {
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)this.getAttributePath(containerId, attribute), (String)value);
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public String getDefaultVersion() {
        this.assertValid();
        try {
            String version = null;
            if (this.getTreeCache().getCurrentData(ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0])) != null) {
                version = ZooKeeperUtils.getStringData((TreeCache)this.getTreeCache(), (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]));
            }
            if (version == null || version.isEmpty()) {
                version = "1.0";
                ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)version);
                ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_VERSION.getPath(new String[]{version}), (String)null);
            }
            return version;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public void setDefaultVersion(String versionId) {
        this.assertValid();
        try {
            ZooKeeperUtils.setData((CuratorFramework)this.getCurator(), (String)ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), (String)versionId);
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public boolean hasProfile(String version, String profile) {
        this.assertValid();
        return this.getProfile(version, profile, false) != null;
    }

    private String getAttributePath(String containerId, DataStore.ContainerAttribute attribute) {
        switch (attribute) {
            case BlueprintStatus: {
                return ZkPath.CONTAINER_EXTENDER_STATUS.getPath(new String[]{containerId, "blueprint"});
            }
            case SpringStatus: {
                return ZkPath.CONTAINER_EXTENDER_STATUS.getPath(new String[]{containerId, "spring"});
            }
            case ProvisionStatus: {
                return ZkPath.CONTAINER_PROVISION_RESULT.getPath(new String[]{containerId});
            }
            case ProvisionException: {
                return ZkPath.CONTAINER_PROVISION_EXCEPTION.getPath(new String[]{containerId});
            }
            case ProvisionList: {
                return ZkPath.CONTAINER_PROVISION_LIST.getPath(new String[]{containerId});
            }
            case ProvisionChecksums: {
                return ZkPath.CONTAINER_PROVISION_CHECKSUMS.getPath(new String[]{containerId});
            }
            case Location: {
                return ZkPath.CONTAINER_LOCATION.getPath(new String[]{containerId});
            }
            case GeoLocation: {
                return ZkPath.CONTAINER_GEOLOCATION.getPath(new String[]{containerId});
            }
            case Resolver: {
                return ZkPath.CONTAINER_RESOLVER.getPath(new String[]{containerId});
            }
            case Ip: {
                return ZkPath.CONTAINER_IP.getPath(new String[]{containerId});
            }
            case LocalIp: {
                return ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{containerId});
            }
            case LocalHostName: {
                return ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{containerId});
            }
            case PublicIp: {
                return ZkPath.CONTAINER_PUBLIC_IP.getPath(new String[]{containerId});
            }
            case PublicHostName: {
                return ZkPath.CONTAINER_PUBLIC_HOSTNAME.getPath(new String[]{containerId});
            }
            case ManualIp: {
                return ZkPath.CONTAINER_MANUAL_IP.getPath(new String[]{containerId});
            }
            case BindAddress: {
                return ZkPath.CONTAINER_BINDADDRESS.getPath(new String[]{containerId});
            }
            case JmxUrl: {
                return ZkPath.CONTAINER_JMX.getPath(new String[]{containerId});
            }
            case JolokiaUrl: {
                return ZkPath.CONTAINER_JOLOKIA.getPath(new String[]{containerId});
            }
            case HttpUrl: {
                return ZkPath.CONTAINER_HTTP.getPath(new String[]{containerId});
            }
            case SshUrl: {
                return ZkPath.CONTAINER_SSH.getPath(new String[]{containerId});
            }
            case PortMin: {
                return ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{containerId});
            }
            case PortMax: {
                return ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{containerId});
            }
            case ProcessId: {
                return ZkPath.CONTAINER_PROCESS_ID.getPath(new String[]{containerId});
            }
            case OpenShift: {
                return ZkPath.CONTAINER_OPENSHIFT.getPath(new String[]{containerId});
            }
        }
        throw new IllegalArgumentException("Unsupported container attribute " + attribute);
    }

    public Map<String, String> getProfileAttributes(String version, String profile) {
        this.assertValid();
        HashMap<String, String> attributes = new HashMap<String, String>();
        Map config = this.getConfiguration(version, profile, "io.fabric8.agent");
        for (Map.Entry entry : config.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("attribute.")) continue;
            String attribute = key.substring("attribute.".length());
            String value = (String)entry.getValue();
            attributes.put(attribute, value);
        }
        return attributes;
    }

    public void setProfileAttribute(String version, String profile, String key, String value) {
        this.assertValid();
        Map config = this.getConfiguration(version, profile, "io.fabric8.agent");
        if (value != null) {
            config.put("attribute." + key, value);
        } else {
            config.remove(key);
        }
        this.setConfiguration(version, profile, "io.fabric8.agent", config);
    }

    public List<String> getConfigurationFileNames(String version, String profile) {
        this.assertValid();
        try {
            Map configs = this.getFileConfigurations(version, profile);
            return new ArrayList<String>(configs.keySet());
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public Map<String, Map<String, String>> getConfigurations(String version, String profile) {
        this.assertValid();
        try {
            HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
            Map configs = this.getFileConfigurations(version, profile);
            for (Map.Entry entry : configs.entrySet()) {
                if (!((String)entry.getKey()).endsWith(".properties")) continue;
                String pid = DataStoreUtils.stripSuffix((String)entry.getKey(), ".properties");
                configurations.put(pid, DataStoreUtils.toMap(DataStoreUtils.toProperties((byte[])entry.getValue())));
            }
            return configurations;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    protected CuratorFramework getCurator() {
        return (CuratorFramework)this.curator.get();
    }

    @VisibleForTesting
    public void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    protected void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    @VisibleForTesting
    public void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    protected void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    @VisibleForTesting
    public void bindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.bind((Object)service);
    }

    protected void unbindRegistrationHandler(DataStoreRegistrationHandler service) {
        this.registrationHandler.unbind((Object)service);
    }
}

