/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.zookeeper.ZkPath;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.zookeeper", label="Fabric8 ZooKeeper Placeholder Resolver", metatype=false)
@Service(value={PlaceholderResolver.class, ZookeeperPlaceholderResolver.class})
@Properties(value={@Property(name="scheme", value={"zk"})})
public final class ZookeeperPlaceholderResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static final String RESOLVER_SCHEME = "zk";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperPlaceholderResolver.class);

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        try {
            return new String(ZkPath.loadURL((CuratorFramework)((CuratorFramework)fabricService.adapt(CuratorFramework.class)), (String)value), "UTF-8");
        }
        catch (KeeperException.NoNodeException e) {
            LOGGER.warn("Could not load property value: {}. Ignoring.", (Object)value, (Object)e);
            return "";
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }
}

