/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;

@ThreadSafe
@Component(name="io.fabric8.placholder.resolver.crypt", label="Fabric8 Encrypted Property Placeholder Resolver", metatype=false)
@Service(value={PlaceholderResolver.class, EncryptedPropertyResolver.class})
@Properties(value={@Property(name="scheme", value={"crypt"})})
public final class EncryptedPropertyResolver
extends AbstractComponent
implements PlaceholderResolver {
    public static final String RESOLVER_SCHEME = "crypt";

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public String getScheme() {
        return RESOLVER_SCHEME;
    }

    public String resolve(FabricService fabricService, Map<String, Map<String, String>> configs, String pid, String key, String value) {
        return this.getEncryptor(fabricService).decrypt(value.substring(RESOLVER_SCHEME.length() + 1));
    }

    private PBEStringEncryptor getEncryptor(FabricService fabricService) {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setAlgorithm(this.getAlgorithm(fabricService));
        encryptor.setPassword(this.getPassword(fabricService));
        return encryptor;
    }

    private String getAlgorithm(FabricService fabricService) {
        try {
            return ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)fabricService.adapt(CuratorFramework.class)), (String)ZkPath.AUTHENTICATION_CRYPT_ALGORITHM.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    private String getPassword(FabricService fabricService) {
        try {
            return ZooKeeperUtils.getStringData((CuratorFramework)((CuratorFramework)fabricService.adapt(CuratorFramework.class)), (String)ZkPath.AUTHENTICATION_CRYPT_PASSWORD.getPath(new String[0]));
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }
}

