/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.api.jmx;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.HasId;
import io.fabric8.api.Ids;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import io.fabric8.api.Version;
import io.fabric8.api.jmx.BeanUtils;
import io.fabric8.api.jmx.FabricManagerMBean;
import io.fabric8.api.jmx.FabricStatusDTO;
import io.fabric8.api.jmx.ServiceStatusDTO;
import io.fabric8.insight.log.support.Strings;
import io.fabric8.service.FabricServiceImpl;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.codec.binary.Base64;
import org.apache.curator.framework.CuratorFramework;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricManager
implements FabricManagerMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabricManager.class);
    private final FabricServiceImpl fabricService;
    private ObjectName objectName;

    public FabricManager(FabricServiceImpl fabricService) {
        this.fabricService = fabricService;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            this.objectName = new ObjectName("io.fabric8:type=Fabric");
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getObjectName();
            if (!mbeanServer.isRegistered(name)) {
                mbeanServer.registerMBean(this, name);
            }
        }
        catch (Exception e) {
            LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                ObjectName name = this.getObjectName();
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (Exception e) {
                LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    protected FabricServiceImpl getFabricService() {
        return this.fabricService;
    }

    @Override
    public String getFabricEnvironment() {
        return this.getFabricService().getEnvironment();
    }

    @Override
    public List<String> getFields(String className) {
        try {
            return BeanUtils.getFields(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new FabricException("Failed to load class " + className, (Throwable)e);
        }
    }

    @Override
    public ServiceStatusDTO getFabricServiceStatus() {
        ServiceStatusDTO rc = new ServiceStatusDTO();
        CuratorFramework curator = this.getFabricService().adapt(CuratorFramework.class);
        try {
            rc.setClientValid(curator != null);
        }
        catch (Throwable t) {
            rc.setClientValid(false);
        }
        if (rc.isClientValid()) {
            try {
                rc.setClientConnected(curator.getZookeeperClient().isConnected());
                if (!rc.isClientConnected()) {
                    rc.setClientConnectionError(curator.getState().toString());
                }
            }
            catch (Throwable t) {
                rc.setClientConnected(false);
            }
            if (rc.isClientValid() && rc.isClientConnected()) {
                Container c = this.getFabricService().getCurrentContainer();
                try {
                    rc.setManaged(c.isManaged());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    rc.setProvisionComplete(c.isProvisioningComplete());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        return rc;
    }

    @Override
    public Map<String, String> createContainers(Map<String, Object> options) {
        String providerType;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating containers from JSON data: " + options);
        }
        if ((providerType = (String)options.get("providerType")) == null) {
            throw new RuntimeException("No providerType provided");
        }
        CreateContainerBasicOptions.Builder builder = null;
        Class clazz = this.fabricService.getProviders().get(providerType).getOptionsType();
        try {
            builder = (CreateContainerBasicOptions.Builder)clazz.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to find builder type", (Throwable)e);
        }
        if (builder == null) {
            throw new RuntimeException("Unknown provider type : " + providerType);
        }
        ObjectMapper mapper = this.getObjectMapper();
        builder = (CreateContainerBasicOptions.Builder)mapper.convertValue(options, builder.getClass());
        builder.zookeeperPassword(this.getFabricService().getZookeeperPassword());
        builder.zookeeperUrl(this.getFabricService().getZookeeperUrl());
        Object profileObject = options.get("profiles");
        if (profileObject != null) {
            List profiles = (List)mapper.convertValue(profileObject, List.class);
            builder.profiles(profiles);
        }
        CreateContainerBasicOptions build = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created container options: " + build + " with profiles " + build.getProfiles());
        }
        CreateContainerMetadata[] metadatas = this.getFabricService().createContainers((CreateContainerOptions)build);
        HashMap<String, String> rc = new HashMap<String, String>();
        for (CreateContainerMetadata metadata : metadatas) {
            if (metadata.isSuccess()) continue;
            LOG.warn("Failed to create container {}: ", (Object)metadata.getContainerName(), (Object)metadata.getFailure());
            rc.put(metadata.getContainerName(), metadata.getFailure().getMessage());
        }
        return rc;
    }

    private ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        return mapper;
    }

    @Override
    public Map<String, Object> createProfile(String versionId, String name) {
        Profile p = this.getFabricService().getVersion(versionId).createProfile(name);
        return this.getProfile(versionId, p.getId());
    }

    @Override
    public Map<String, Object> createProfile(String versionId, String name, List<String> parents) {
        Profile p = this.getFabricService().getVersion(versionId).createProfile(name);
        p.setParents(this.stringsToProfiles(versionId, parents));
        return this.getProfile(versionId, p.getId());
    }

    @Override
    public Map<String, Object> changeProfileParents(String versionId, String name, List<String> parents) {
        Profile p = this.getFabricService().getVersion(versionId).getProfile(name);
        p.setParents(this.stringsToProfiles(versionId, parents));
        return this.getProfile(versionId, p.getId());
    }

    @Override
    public String profileWebAppURL(String webAppId, String profileId, String versionId) {
        Version version;
        FabricServiceImpl service = this.getFabricService();
        if ((versionId == null || versionId.length() == 0) && (version = service.getDefaultVersion()) != null) {
            versionId = version.getId();
        }
        List<String> ids = this.containerIdsForProfile(versionId, profileId);
        for (String id : ids) {
            String url = this.containerWebAppURL(webAppId, id);
            if (url == null || url.length() <= 0) continue;
            return url;
        }
        return null;
    }

    @Override
    public String containerWebAppURL(String webAppId, String name) {
        return this.getFabricService().containerWebAppURL(webAppId, name);
    }

    @Override
    public Map<String, Object> createVersion(String parentVersionId, String toVersion) {
        Version version = this.getFabricService().createVersion(parentVersionId, toVersion);
        return BeanUtils.convertVersionToMap(this.getFabricService(), version, BeanUtils.getFields(Version.class));
    }

    @Override
    public Map<String, Object> createVersion(String version) {
        return this.createVersion(this.getLatestVersion().getId(), version);
    }

    @Override
    public Map<String, Object> createVersion() {
        return this.createVersion(this.getLatestVersion().getSequence().next().getName());
    }

    private Version getLatestVersion() {
        Version[] versions = this.getFabricService().getVersions();
        Version latest = null;
        int length = versions.length;
        if (length <= 0) {
            throw new FabricException("No versions available");
        }
        latest = versions[length - 1];
        return latest;
    }

    @Override
    public void deleteProfile(String versionId, String profileId) {
        this.deleteProfile(versionId, profileId, true);
    }

    @Override
    public void deleteProfile(String versionId, String profileId, boolean force) {
        Version v = this.getFabricService().getVersion(versionId);
        Profile p = v.getProfile(profileId);
        p.delete(force);
    }

    @Override
    public void deleteVersion(String version) {
        this.getFabricService().deleteVersion(version);
    }

    @Override
    public void destroyContainer(String containerId) {
        this.getFabricService().destroyContainer(containerId);
    }

    @Override
    public Map<String, Object> getContainer(String name) {
        return this.getContainer(name, BeanUtils.getFields(Container.class));
    }

    @Override
    public Map<String, Object> getContainer(String name, List<String> fields) {
        Container c = this.getFabricService().getContainer(name);
        return BeanUtils.convertContainerToMap(this.getFabricService(), c, fields);
    }

    @Override
    public List<String> getContainerProvisionList(String name) {
        Container container = this.getFabricService().getContainer(name);
        if (container != null) {
            return new ArrayList<String>();
        }
        throw new IllegalStateException(String.format("Container %s not found.", name));
    }

    @Override
    public void applyVersionToContainers(String version, List<String> containers) {
        Version v = this.getFabricService().getVersion(version);
        for (String container : containers) {
            this.getFabricService().getContainer(container).setVersion(v);
        }
    }

    @Override
    public void applyProfilesToContainers(String version, List<String> profiles, List<String> containers) {
        Profile[] p = this.stringsToProfiles(version, profiles);
        for (String container : containers) {
            this.getFabricService().getContainer(container).setProfiles(p);
        }
    }

    @Override
    public void addProfilesToContainer(String container, List<String> profiles) {
        Container cont = this.getFabricService().getContainer(container);
        cont.addProfiles(this.stringsToProfiles(cont.getVersion(), profiles));
    }

    @Override
    public void removeProfilesFromContainer(String container, List<String> profiles) {
        Container cont = this.getFabricService().getContainer(container);
        cont.removeProfiles(this.stringsToProfiles(cont.getVersion(), profiles));
    }

    @Override
    public List<Map<String, Object>> containers() {
        return this.containers(BeanUtils.getFields(Container.class));
    }

    @Override
    public List<Map<String, Object>> containers(List<String> fields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        for (Container c : this.getFabricService().getContainers()) {
            answer.add(BeanUtils.convertContainerToMap(this.getFabricService(), c, fields));
        }
        return answer;
    }

    @Override
    public List<Map<String, Object>> containers(List<String> fields, List<String> profileFields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        for (Container c : this.getFabricService().getContainers()) {
            Map<String, Object> map = BeanUtils.convertContainerToMap(this.getFabricService(), c, fields);
            ArrayList<Map<String, Object>> profiles = new ArrayList<Map<String, Object>>();
            for (Profile p : c.getProfiles()) {
                profiles.add(BeanUtils.convertProfileToMap(this.getFabricService(), p, profileFields));
            }
            map.put("profiles", profiles);
            answer.add(map);
        }
        return answer;
    }

    private CreateContainerMetadata<?> getContainerMetaData(String id) {
        Container container = this.getFabricService().getContainer(id);
        return container.getMetadata();
    }

    @Override
    public String containerMetadataType(String id) {
        CreateContainerMetadata<?> metadata = this.getContainerMetaData(id);
        if (metadata == null) {
            return null;
        }
        return metadata.getClass().getName();
    }

    @Override
    public Map<String, String> getProfileProperties(String versionId, String profileId, String pid) {
        Profile profile;
        Map answer = null;
        Version version = this.getFabricService().getVersion(versionId);
        if (version != null && (profile = version.getProfile(profileId)) != null) {
            answer = profile.getConfiguration(pid);
        }
        return answer;
    }

    @Override
    public boolean setProfileProperties(String versionId, String profileId, String pid, Map<String, String> properties) {
        Profile profile;
        boolean answer = false;
        Version version = this.getFabricService().getVersion(versionId);
        if (version != null && (profile = version.getProfile(profileId)) != null) {
            profile.setConfiguration(pid, properties);
            answer = true;
        }
        return answer;
    }

    @Override
    public String getProfileProperty(String versionId, String profileId, String pid, String propertyName) {
        String answer = null;
        Map<String, String> properties = this.getProfileProperties(versionId, profileId, pid);
        if (properties != null) {
            answer = properties.get(propertyName);
        }
        return answer;
    }

    @Override
    public String setProfileProperty(String versionId, String profileId, String pid, String propertyName, String value) {
        Map<String, String> properties = this.getProfileProperties(versionId, profileId, pid);
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        String answer = properties.put(propertyName, value);
        this.setProfileProperties(versionId, profileId, pid, properties);
        return answer;
    }

    @Override
    public void setProfileAttribute(String versionId, String profileId, String attributeId, String value) {
        Version version = this.getFabricService().getVersion(versionId);
        Profile profile = version.getProfile(profileId);
        profile.setAttribute(attributeId, value);
    }

    @Override
    public String containerCreateOptionsType(String id) {
        CreateContainerMetadata<?> metadata = this.getContainerMetaData(id);
        if (metadata == null) {
            return null;
        }
        CreateContainerOptions options = metadata.getCreateOptions();
        if (options == null) {
            return null;
        }
        return options.getClass().getName();
    }

    @Override
    public void changeCreateOptionsField(String containerId, String field, Object value) {
        CreateContainerMetadata<?> metadata = this.getContainerMetaData(containerId);
        if (metadata == null) {
            return;
        }
        CreateContainerOptions options = metadata.getCreateOptions();
        if (options == null) {
            return;
        }
        ObjectMapper mapper = this.getObjectMapper();
        JsonNode optionsJson = (JsonNode)mapper.convertValue((Object)options, JsonNode.class);
        JsonNode valueJson = (JsonNode)mapper.convertValue(value, JsonNode.class);
        ((ObjectNode)optionsJson).put(field, valueJson);
        Object builder = null;
        try {
            builder = options.getClass().getMethod("builder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to get builder when setting " + field + " on container " + containerId, (Throwable)e);
            throw new RuntimeException("Failed to get builder when setting " + field + " on container " + containerId, e);
        }
        builder = mapper.convertValue((Object)optionsJson, builder.getClass());
        CreateContainerOptions newOptions = null;
        try {
            newOptions = (CreateContainerOptions)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (Exception e) {
            LOG.warn("Failed to build CreatecontainerOptions when setting " + field + " on container " + containerId, (Throwable)e);
            throw new RuntimeException("Failed to build CreatecontainerOptions when setting " + field + " on container " + containerId, e);
        }
        metadata.setCreateOptions(newOptions);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Create container metadata: " + metadata);
        }
        this.getFabricService().getDataStore().setContainerMetadata(metadata);
    }

    @Override
    public String[] containerIds() {
        ArrayList<String> answer = new ArrayList<String>();
        for (Container container : this.getFabricService().getContainers()) {
            answer.add(container.getId());
        }
        return answer.toArray(new String[answer.size()]);
    }

    @Override
    public List<String> containerIdsForProfile(String versionId, String profileId) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        return BeanUtils.collapseToList(this.containersForProfile(versionId, profileId, fields), "id");
    }

    @Override
    public List<Map<String, Object>> containersForProfile(String versionId, String profileId) {
        return this.containersForProfile(versionId, profileId, BeanUtils.getFields(Container.class));
    }

    @Override
    public List<Map<String, Object>> containersForProfile(String versionId, String profileId, List<String> fields) {
        Version version = this.getFabricService().getVersion(versionId);
        Profile profile = version != null ? version.getProfile(profileId) : null;
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        if (profile != null) {
            for (Container c : this.getFabricService().getContainers()) {
                for (Profile p : c.getProfiles()) {
                    if (!p.equals(profile)) continue;
                    answer.add(BeanUtils.convertContainerToMap(this.getFabricService(), c, fields));
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> containerIdsForVersion(String versionId) {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("id");
        return BeanUtils.collapseToList(this.containersForVersion(versionId, fields), "id");
    }

    @Override
    public List<Map<String, Object>> containersForVersion(String versionId) {
        return this.containersForVersion(versionId, BeanUtils.getFields(Container.class));
    }

    @Override
    public List<Map<String, Object>> containersForVersion(String versionId, List<String> fields) {
        Version version = this.getFabricService().getVersion(versionId);
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        if (version != null) {
            for (Container c : this.getFabricService().getContainers()) {
                if (!c.getVersion().equals(version)) continue;
                answer.add(BeanUtils.convertContainerToMap(this.getFabricService(), c, fields));
            }
        }
        return answer;
    }

    @Override
    public void setContainerProperty(String containerId, String property, Object value) {
        Container container = this.getFabricService().getContainer(containerId);
        BeanUtils.setValue(container, property, value);
    }

    protected Profile[] stringsToProfiles(String version, List<String> names) {
        return this.stringsToProfiles(this.getFabricService().getVersion(version), names);
    }

    protected Profile[] stringsToProfiles(Version version, List<String> names) {
        Profile[] allProfiles = version.getProfiles();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        if (names == null) {
            return new Profile[0];
        }
        for (String name : names) {
            Profile profile = null;
            for (Profile p : allProfiles) {
                if (!name.equals(p.getId())) continue;
                profile = p;
                break;
            }
            if (profile == null) {
                throw new IllegalArgumentException("Profile " + name + " not found.");
            }
            profiles.add(profile);
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    @Override
    public Map<String, Object> currentContainer() {
        return BeanUtils.convertContainerToMap(this.getFabricService(), this.getFabricService().getCurrentContainer(), BeanUtils.getFields(Container.class));
    }

    @Override
    public String getCurrentContainerName() {
        return this.getFabricService().getCurrentContainerName();
    }

    @Override
    public String getDefaultJvmOptions() {
        return this.getFabricService().getDefaultJvmOptions();
    }

    @Override
    public String getDefaultRepo() {
        return this.getFabricService().getDefaultRepo();
    }

    @Override
    public Map<String, Object> defaultVersion() {
        return BeanUtils.convertVersionToMap(this.getFabricService(), this.getFabricService().getDefaultVersion(), BeanUtils.getFields(Version.class));
    }

    @Override
    public String getDefaultVersion() {
        return this.getFabricService().getDefaultVersion().getId();
    }

    @Override
    public FabricStatusDTO fabricStatus() {
        return new FabricStatusDTO(this.getFabricService().getFabricStatus());
    }

    @Override
    public String getMavenRepoUploadURI() {
        URI answer = this.getFabricService().getMavenRepoUploadURI();
        return answer != null ? answer.toString() : null;
    }

    @Override
    public String getMavenRepoURI() {
        URI answer = this.getFabricService().getMavenRepoURI();
        return answer != null ? answer.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getProfileFeatures(String versionId, String profileId) {
        Profile profile = this.getFabricService().getVersion(versionId).getProfile(profileId);
        Profile overlay = profile.getOverlay(true);
        HashMap<String, Boolean> isParentFeature = new HashMap<String, Boolean>();
        for (String feature : profile.getFeatures()) {
            isParentFeature.put(feature, Boolean.FALSE);
        }
        for (String feature : overlay.getFeatures()) {
            if (isParentFeature.get(feature) != null) continue;
            isParentFeature.put(feature, Boolean.TRUE);
        }
        HashMap<String, Object> rc = new HashMap<String, Object>();
        ArrayList featureDefs = new ArrayList();
        for (Map.Entry featureEntry : isParentFeature.entrySet()) {
            HashMap<String, Object> featureDef = new HashMap<String, Object>();
            featureDef.put("id", featureEntry.getKey());
            featureDef.put("isParentFeature", featureEntry.getValue());
            featureDefs.add(featureDef);
        }
        rc.put("featureDefinitions", featureDefs);
        ArrayList repositoryDefs = new ArrayList();
        for (String repo : overlay.getRepositories()) {
            HashMap<String, String> repoDef = new HashMap<String, String>();
            repoDef.put("id", repo);
            Closeable closeable = null;
            try {
                int stat;
                URL url = new URL(repo);
                InputStream os = url.openStream();
                closeable = os;
                BufferedInputStream is = new BufferedInputStream(url.openStream());
                closeable = is;
                char[] buffer = new char[8192];
                StringBuilder data = new StringBuilder();
                InputStreamReader in = new InputStreamReader((InputStream)is, "UTF-8");
                closeable = in;
                while ((stat = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                    data.append(buffer, 0, stat);
                }
                repoDef.put("data", data.toString());
            }
            catch (Throwable t) {
                repoDef.put("error", t.getMessage());
            }
            finally {
                try {
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t) {}
            }
            repositoryDefs.add(repoDef);
        }
        rc.put("repositoryDefinitions", repositoryDefs);
        return rc;
    }

    @Override
    public Map<String, Object> getProfile(String versionId, String profileId) {
        return this.getProfile(versionId, profileId, BeanUtils.getFields(Profile.class));
    }

    @Override
    public Map<String, Object> getProfile(String versionId, String profileId, List<String> fields) {
        Profile profile = this.getFabricService().getVersion(versionId).getProfile(profileId);
        return BeanUtils.convertProfileToMap(this.getFabricService(), profile, fields);
    }

    @Override
    public List<Map<String, Object>> getProfiles(String versionId) {
        return this.getProfiles(versionId, BeanUtils.getFields(Profile.class));
    }

    @Override
    public List<Map<String, Object>> getProfiles(String versionId, List<String> fields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        for (Profile p : this.getFabricService().getVersion(versionId).getProfiles()) {
            answer.add(this.getProfile(versionId, p.getId(), fields));
        }
        return answer;
    }

    @Override
    public List<String> getProfileIds(String version) {
        return Ids.getIds((HasId[])this.getFabricService().getVersion(version).getProfiles());
    }

    @Override
    public String getConfigurationFile(String versionId, String profileId, String fileName) {
        return Base64.encodeBase64String((byte[])((byte[])this.getFabricService().getVersion(versionId).getProfile(profileId).getFileConfigurations().get(fileName)));
    }

    @Override
    public List<String> getConfigurationFileNames(String versionId, String profileId) {
        Version version = this.getFabricService().getVersion(versionId);
        Profile profile = version.getProfile(profileId);
        if (profile != null) {
            return profile.getConfigurationFileNames();
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, String> currentContainerConfigurationFiles() {
        String containerName = this.getCurrentContainerName();
        FabricServiceImpl service = this.getFabricService();
        Container container = service.getContainer(containerName);
        if (container != null) {
            Profile[] profiles = container.getProfiles();
            return Profiles.getConfigurationFileNameMap((Profile[])profiles);
        }
        return new HashMap<String, String>();
    }

    @Override
    public Map<String, Object> getConfigurationFiles(String versionId, List<String> profileIds, String filename) {
        Pattern pattern = Pattern.compile(filename);
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Version version = this.getFabricService().getVersion(versionId);
        for (String profileId : profileIds) {
            Profile profile = version.getProfile(profileId);
            if (profile == null) continue;
            HashMap files = new HashMap();
            Map configs = profile.getFileConfigurations();
            for (Map.Entry configEntry : configs.entrySet()) {
                if (!pattern.matcher((CharSequence)configEntry.getKey()).matches()) continue;
                files.put(configEntry.getKey(), Base64.encodeBase64String((byte[])((byte[])configEntry.getValue())));
            }
            answer.put(profileId, files);
        }
        return answer;
    }

    @Override
    public void deleteConfigurationFile(String versionId, String profileId, String fileName) {
        Profile profile = this.getFabricService().getVersion(versionId).getProfile(profileId);
        Map configs = profile.getFileConfigurations();
        configs.remove(fileName);
        profile.setFileConfigurations(configs);
    }

    @Override
    public void setConfigurationFile(String versionId, String profileId, String fileName, String data) {
        Profile profile = this.getFabricService().getVersion(versionId).getProfile(profileId);
        Map configs = profile.getFileConfigurations();
        try {
            configs.put(fileName, Base64.decodeBase64((String)data));
            profile.setFileConfigurations(configs);
        }
        catch (Exception e) {
            throw new FabricException("Error setting config file: ", (Throwable)e);
        }
    }

    @Override
    public void setProfileBundles(String versionId, String profileId, List<String> bundles) {
        Version v = this.getFabricService().getVersion(versionId);
        Profile profile = v.getProfile(profileId);
        profile.setBundles(bundles);
    }

    @Override
    public void setProfileFeatures(String versionId, String profileId, List<String> features) {
        Version v = this.getFabricService().getVersion(versionId);
        Profile profile = v.getProfile(profileId);
        profile.setFeatures(features);
    }

    @Override
    public void setProfileRepositories(String versionId, String profileId, List<String> repositories) {
        Version v = this.getFabricService().getVersion(versionId);
        Profile profile = v.getProfile(profileId);
        profile.setRepositories(repositories);
    }

    @Override
    public void setProfileFabs(String versionId, String profileId, List<String> fabs) {
        Version v = this.getFabricService().getVersion(versionId);
        Profile profile = v.getProfile(profileId);
        profile.setFabs(fabs);
    }

    @Override
    public void setProfileOverrides(String versionId, String profileId, List<String> overrides) {
        Version v = this.getFabricService().getVersion(versionId);
        Profile profile = v.getProfile(profileId);
        profile.setOverrides(overrides);
    }

    @Override
    public boolean scaleProfile(String profile, int numberOfInstances) throws IOException {
        return this.getFabricService().scaleProfile(profile, numberOfInstances);
    }

    @Override
    public FabricRequirements requirements() {
        return this.getFabricService().getRequirements();
    }

    @Override
    public Map<String, Object> getVersion(String versionId) {
        return this.getVersion(versionId, BeanUtils.getFields(Version.class));
    }

    @Override
    public Map<String, Object> getVersion(String versionId, List<String> fields) {
        return BeanUtils.convertVersionToMap(this.getFabricService(), this.getFabricService().getVersion(versionId), fields);
    }

    @Override
    public List<Map<String, Object>> versions() {
        return this.versions(BeanUtils.getFields(Version.class));
    }

    @Override
    public List<Map<String, Object>> versions(List<String> fields) {
        ArrayList<Map<String, Object>> answer = new ArrayList<Map<String, Object>>();
        for (Version v : this.getFabricService().getVersions()) {
            answer.add(this.getVersion(v.getId(), fields));
        }
        return answer;
    }

    @Override
    public void copyProfile(String versionId, String sourceId, String targetId, boolean force) {
        Version v = this.getFabricService().getVersion(versionId);
        if (v != null) {
            v.copyProfile(sourceId, targetId, force);
        }
    }

    @Override
    public void renameProfile(String versionId, String profileId, String newId, boolean force) {
        Version v = this.getFabricService().getVersion(versionId);
        if (v != null) {
            v.renameProfile(profileId, newId, force);
        }
    }

    @Override
    public void refreshProfile(String versionId, String profileId) {
        Profile profile;
        Version version = this.getFabricService().getVersion(versionId);
        if (version != null && (profile = version.getProfile(profileId)) != null) {
            profile.refresh();
        }
    }

    @Override
    public String getZookeeperInfo(String name) {
        return this.getFabricService().getZookeeperInfo(name);
    }

    @Override
    public String getZookeeperUrl() {
        return this.getFabricService().getZookeeperUrl();
    }

    @Override
    public void registerProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.getFabricService().registerProvider(provider, properties);
    }

    @Override
    public void registerProvider(String scheme, ContainerProvider provider) {
        this.getFabricService().registerProvider(scheme, provider);
    }

    @Override
    public void setDefaultJvmOptions(String jvmOptions) {
        this.getFabricService().setDefaultJvmOptions(jvmOptions);
    }

    @Override
    public void setDefaultRepo(String defaultRepo) {
        this.getFabricService().setDefaultRepo(defaultRepo);
    }

    @Override
    public void setDefaultVersion(String versionId) {
        this.getFabricService().setDefaultVersion(versionId);
    }

    @Override
    public void requirements(FabricRequirements requirements) throws IOException {
        this.getFabricService().setRequirements(requirements);
    }

    @Override
    public void requirementsJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        Object value = mapper.reader(FabricRequirements.class).readValue(json);
        if (!(value instanceof FabricRequirements)) {
            throw new IOException("Failed to parse FabricRequirements from JSON. Got " + value + ". JSON: " + json);
        }
        this.requirements((FabricRequirements)value);
    }

    @Override
    public void startContainer(String containerId) {
        this.getFabricService().startContainer(containerId);
    }

    @Override
    public List<Map<String, Object>> startContainers(List<String> containerIds) {
        ArrayList<Map<String, Object>> rc = new ArrayList<Map<String, Object>>();
        for (String containerId : containerIds) {
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("id", containerId);
            try {
                this.startContainer(containerId);
                status.put("success", true);
            }
            catch (Throwable t) {
                status.put("error", t);
                status.put("errorMessage", t.getMessage());
            }
            rc.add(status);
        }
        return rc;
    }

    @Override
    public void stopContainer(String containerId) {
        this.getFabricService().stopContainer(containerId);
    }

    @Override
    public List<Map<String, Object>> stopContainers(List<String> containerIds) {
        ArrayList<Map<String, Object>> rc = new ArrayList<Map<String, Object>>();
        for (String containerId : containerIds) {
            HashMap<String, Object> status = new HashMap<String, Object>();
            status.put("id", containerId);
            try {
                this.stopContainer(containerId);
                status.put("success", true);
            }
            catch (Throwable t) {
                status.put("error", t);
                status.put("errorMessage", t.getMessage());
            }
            rc.add(status);
        }
        return rc;
    }

    @Override
    public Map<String, String> registeredProviders() {
        Map<String, ContainerProvider> providers = this.getFabricService().getProviders();
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Map.Entry<String, ContainerProvider> providerEntry : providers.entrySet()) {
            answer.put(providerEntry.getKey(), providerEntry.getValue().getOptionsType().getName());
        }
        return answer;
    }

    @Override
    public void unregisterProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.getFabricService().unregisterProvider(provider, properties);
    }

    @Override
    public void unregisterProvider(String scheme) {
        this.getFabricService().unregisterProvider(scheme);
    }

    @Override
    public void applyPatches(List<String> files, String targetVersionId, String newVersionId, String proxyUser, String proxyPassword) {
        ArrayList<File> patchFiles = new ArrayList<File>();
        for (String fileName : files) {
            File file = new File(fileName);
            if (file.exists()) {
                patchFiles.add(file);
                continue;
            }
            LOG.warn("Patch file does not exist, skipping: {}", (Object)fileName);
        }
        if (patchFiles.isEmpty()) {
            LOG.warn("No valid patches to apply");
            throw new FabricException("No valid patches to apply");
        }
        Version version = this.getFabricService().getVersion(targetVersionId);
        if (version == null) {
            throw new FabricException("Version " + targetVersionId + " not found");
        }
        if (newVersionId == null || newVersionId.equals("")) {
            newVersionId = this.getLatestVersion().getSequence().next().getName();
        }
        Version targetVersion = this.getFabricService().createVersion(version, newVersionId);
        File currentPatchFile = null;
        try {
            Iterator i$ = patchFiles.iterator();
            while (i$.hasNext()) {
                File file;
                currentPatchFile = file = (File)i$.next();
                if (!file.isFile()) {
                    LOG.info("File is a directory, skipping: {}", (Object)file);
                    continue;
                }
                LOG.info("Applying patch file {}", (Object)file);
                this.getFabricService().getPatchService().applyPatch(targetVersion, file.toURI().toURL(), proxyUser, proxyPassword);
                LOG.info("Successfully applied {}", (Object)file);
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed to apply patch file {}", currentPatchFile, (Object)t);
            targetVersion.delete();
            throw new FabricException("Failed to apply patch file " + currentPatchFile, t);
        }
        for (File file : patchFiles) {
            try {
                LOG.info("Deleting patch file {}", (Object)file);
                boolean deleted = file.delete();
                if (deleted) continue;
                LOG.warn("Failed to delete patch file {}", (Object)file);
            }
            catch (Throwable t) {
                LOG.warn("Failed to delete patch file {} due to {}", (Object)file, (Object)t);
            }
        }
    }

    @Override
    public String getConfigurationValue(String versionId, String profileId, String pid, String key) {
        return this.getFabricService().getConfigurationValue(versionId, profileId, pid, key);
    }

    @Override
    public void setConfigurationValue(String versionId, String profileId, String pid, String key, String value) {
        this.getFabricService().setConfigurationValue(versionId, profileId, pid, key, value);
    }

    @Override
    public String clusterJson(String clusterPathSegment) throws Exception {
        String prefix = "/fabric/registry/clusters";
        String path = Strings.isEmpty((String)clusterPathSegment) ? prefix : (clusterPathSegment.startsWith("/") ? clusterPathSegment : prefix + "/" + clusterPathSegment);
        HashMap<String, Object> answer = new HashMap<String, Object>();
        CuratorFramework curator = this.getFabricService().adapt(CuratorFramework.class);
        ObjectMapper mapper = new ObjectMapper();
        this.addChildrenToMap(answer, path, curator, mapper);
        return mapper.writeValueAsString(answer);
    }

    protected void addChildrenToMap(Map<String, Object> answer, String path, CuratorFramework curator, ObjectMapper mapper) throws Exception {
        HashSet<String> dontSubstituteKeys = new HashSet<String>(Arrays.asList("id", "container"));
        List children = ZooKeeperUtils.getChildrenSafe((CuratorFramework)curator, (String)path);
        for (String child : children) {
            String childPath = path + "/" + child;
            byte[] data = (byte[])curator.getData().forPath(childPath);
            if (data != null && data.length > 0) {
                Map map;
                String text = new String(data).trim();
                if (text.isEmpty() || (map = (Map)mapper.readValue(data, HashMap.class)) == null) continue;
                HashMap substitutedMap = new HashMap();
                Set set = map.entrySet();
                for (Map.Entry entry : set) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value == null) continue;
                    if (value instanceof String && !dontSubstituteKeys.contains(key)) {
                        value = ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)value.toString());
                    } else if (value instanceof List) {
                        List list = (List)value;
                        ArrayList<String> substitutedValues = new ArrayList<String>();
                        value = substitutedValues;
                        for (Object item : list) {
                            String serviceText = ZooKeeperUtils.getSubstitutedData((CuratorFramework)curator, (String)item.toString());
                            substitutedValues.add(serviceText);
                        }
                    }
                    substitutedMap.put(key, value);
                }
                answer.put(child, substitutedMap);
                continue;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.addChildrenToMap(map, childPath, curator, mapper);
            if (map.isEmpty()) continue;
            answer.put(child, map);
        }
    }

    public static List listValue(Map<String, Object> map, String key) {
        Object value = null;
        if (map != null) {
            value = map.get(key);
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Object[]) {
            return Arrays.asList((Object[])value);
        }
        if (value != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            return list;
        }
        return null;
    }
}

