/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service;

import com.google.common.base.Strings;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerAutoScaler;
import io.fabric8.api.ContainerAutoScalerFactory;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.Containers;
import io.fabric8.api.CreateContainerBasicMetadata;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.DataStore;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricRequirements;
import io.fabric8.api.FabricService;
import io.fabric8.api.FabricStatus;
import io.fabric8.api.NullCreationStateListener;
import io.fabric8.api.PatchService;
import io.fabric8.api.PlaceholderResolver;
import io.fabric8.api.PortService;
import io.fabric8.api.Profile;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.visibility.VisibleForTesting;
import io.fabric8.internal.ContainerImpl;
import io.fabric8.internal.PlaceholderResolverHelpers;
import io.fabric8.internal.VersionImpl;
import io.fabric8.service.ChecksumPlaceholderResolver;
import io.fabric8.service.ContainerPlaceholderResolver;
import io.fabric8.service.EncryptedPropertyResolver;
import io.fabric8.service.EnvPlaceholderResolver;
import io.fabric8.service.PatchServiceImpl;
import io.fabric8.service.PortPlaceholderResolver;
import io.fabric8.service.ProfilePropertyPointerResolver;
import io.fabric8.service.VersionPropertyPointerResolver;
import io.fabric8.service.ZookeeperPlaceholderResolver;
import io.fabric8.utils.DataStoreUtils;
import io.fabric8.utils.PasswordEncoder;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.InterpolationHelper;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.service", label="Fabric8 Service", metatype=false)
@Service(value={FabricService.class})
public final class FabricServiceImpl
extends AbstractComponent
implements FabricService {
    public static final String REQUIREMENTS_JSON_PATH = "/fabric/configs/io.fabric8.requirements.json";
    public static final String JVM_OPTIONS_PATH = "/fabric/configs/io.fabric8.containers.jvmOptions";
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricServiceImpl.class);
    @Reference
    private ChecksumPlaceholderResolver checksumPlaceholderResolver;
    @Reference
    private ContainerPlaceholderResolver containerPlaceholderResolver;
    @Reference
    private EncryptedPropertyResolver encryptedPropertyResolver;
    @Reference
    private EnvPlaceholderResolver envPlaceholderResolver;
    @Reference
    private PortPlaceholderResolver portPlaceholderResolver;
    @Reference
    private ProfilePropertyPointerResolver profilePropertyPointerResolver;
    @Reference
    private VersionPropertyPointerResolver versionPropertyPointerResolver;
    @Reference
    private ZookeeperPlaceholderResolver zookeeperPlaceholderResolver;
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=DataStore.class)
    private final ValidatingReference<DataStore> dataStore = new ValidatingReference();
    @Reference(referenceInterface=PortService.class)
    private final ValidatingReference<PortService> portService = new ValidatingReference();
    @Reference(referenceInterface=ContainerProvider.class, bind="bindProvider", unbind="unbindProvider", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<String, ContainerProvider> providers = new ConcurrentHashMap<String, ContainerProvider>();
    @Reference(referenceInterface=PlaceholderResolver.class, bind="bindPlaceholderResolver", unbind="unbindPlaceholderResolver", cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private final Map<String, PlaceholderResolver> placeholderResolvers = new ConcurrentHashMap<String, PlaceholderResolver>();
    private String defaultRepo = "https://repo.fusesource.com/nexus/content/groups/public/";
    private BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public <T> T adapt(Class<T> type) {
        this.assertValid();
        if (type.isAssignableFrom(CuratorFramework.class)) {
            return (T)this.curator.get();
        }
        return null;
    }

    public DataStore getDataStore() {
        return (DataStore)this.dataStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultRepo() {
        FabricServiceImpl fabricServiceImpl = this;
        synchronized (fabricServiceImpl) {
            return this.defaultRepo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRepo(String defaultRepo) {
        FabricServiceImpl fabricServiceImpl = this;
        synchronized (fabricServiceImpl) {
            this.defaultRepo = defaultRepo;
        }
    }

    public PortService getPortService() {
        this.assertValid();
        return (PortService)this.portService.get();
    }

    public Container getCurrentContainer() {
        this.assertValid();
        String name = this.getCurrentContainerName();
        return this.getContainer(name);
    }

    public String getEnvironment() {
        this.assertValid();
        return ((RuntimeProperties)this.runtimeProperties.get()).getProperty("fabric.environment");
    }

    public String getCurrentContainerName() {
        this.assertValid();
        return ((RuntimeProperties)this.runtimeProperties.get()).getProperty("karaf.name");
    }

    public void trackConfiguration(Runnable callback) {
        this.assertValid();
        this.getDataStore().trackConfiguration(callback);
    }

    public void untrackConfiguration(Runnable callback) {
        this.assertValid();
        this.getDataStore().untrackConfiguration(callback);
    }

    public Container[] getContainers() {
        this.assertValid();
        HashMap<String, Container> containers = new HashMap<String, Container>();
        List containerIds = this.getDataStore().getContainers();
        for (String containerId : containerIds) {
            String parentId = this.getDataStore().getContainerParent(containerId);
            if (parentId.isEmpty()) {
                if (containers.containsKey(containerId)) continue;
                ContainerImpl container = new ContainerImpl(null, containerId, this);
                containers.put(containerId, container);
                continue;
            }
            Container parent = (Container)containers.get(parentId);
            if (parent == null) {
                parent = new ContainerImpl(null, parentId, this);
                containers.put(parentId, parent);
            }
            ContainerImpl container = new ContainerImpl(parent, containerId, this);
            containers.put(containerId, container);
        }
        return containers.values().toArray(new Container[containers.size()]);
    }

    public Container getContainer(String name) {
        this.assertValid();
        if (this.getDataStore().hasContainer(name)) {
            Container parent = null;
            String parentId = this.getDataStore().getContainerParent(name);
            if (parentId != null && !parentId.isEmpty()) {
                parent = this.getContainer(parentId);
            }
            return new ContainerImpl(parent, name, this);
        }
        throw new FabricException("Container '" + name + "' does not exist");
    }

    public void startContainer(String containerId) {
        this.startContainer(containerId, false);
    }

    public void startContainer(String containerId, boolean force) {
        this.assertValid();
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.startContainer(container, force);
        }
    }

    public void startContainer(Container container) {
        this.startContainer(container, true);
    }

    public void startContainer(Container container, boolean force) {
        this.assertValid();
        LOGGER.info("Starting container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        provider.start(container);
    }

    public void stopContainer(String containerId) {
        this.stopContainer(containerId, false);
    }

    public void stopContainer(String containerId, boolean force) {
        this.assertValid();
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.stopContainer(container, force);
        }
    }

    public void stopContainer(Container container) {
        this.stopContainer(container, false);
    }

    public void stopContainer(Container container, boolean force) {
        this.assertValid();
        LOGGER.info("Stopping container {}", (Object)container.getId());
        ContainerProvider provider = this.getProvider(container);
        provider.stop(container);
    }

    public void destroyContainer(String containerId) {
        this.destroyContainer(containerId, false);
    }

    public void destroyContainer(String containerId, boolean force) {
        this.assertValid();
        Container container = this.getContainer(containerId);
        if (container != null) {
            this.destroyContainer(container, force);
        }
    }

    public void destroyContainer(Container container) {
        this.destroyContainer(container, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyContainer(Container container, boolean force) {
        this.assertValid();
        String containerId = container.getId();
        LOGGER.info("Destroying container {}", (Object)containerId);
        boolean destroyed = false;
        try {
            ContainerProvider provider = this.getProvider(container, true);
            try {
                provider.stop(container);
            }
            catch (Exception ex) {
                // empty catch block
            }
            provider.destroy(container);
            destroyed = true;
        }
        finally {
            try {
                if (destroyed || force) {
                    ((PortService)this.portService.get()).unregisterPort(container);
                    this.getDataStore().deleteContainer(container.getId());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to cleanup container {} entries due to: {}. This will be ignored.", (Object)containerId, (Object)e.getMessage());
            }
        }
    }

    private ContainerProvider getProvider(Container container) {
        return this.getProvider(container, false);
    }

    private ContainerProvider getProvider(Container container, boolean returnNull) {
        String type;
        CreateContainerMetadata metadata = container.getMetadata();
        String string = type = metadata != null ? metadata.getCreateOptions().getProviderType() : null;
        if (type == null) {
            if (returnNull) {
                return null;
            }
            throw new UnsupportedOperationException("Container " + container.getId() + " has not been created using Fabric");
        }
        ContainerProvider provider = this.getProvider(type);
        if (provider == null) {
            if (returnNull) {
                return null;
            }
            throw new UnsupportedOperationException("Container provider " + type + " not supported");
        }
        return provider;
    }

    public CreateContainerMetadata[] createContainers(CreateContainerOptions options) {
        return this.createContainers(options, null);
    }

    public CreateContainerMetadata[] createContainers(CreateContainerOptions options, CreationStateListener listener) {
        this.assertValid();
        try {
            ContainerProvider provider = this.getProvider(options.getProviderType());
            if (provider == null) {
                throw new FabricException("Unable to find a container provider supporting '" + options.getProviderType() + "'");
            }
            String originalName = options.getName();
            if (originalName == null || originalName.length() == 0) {
                throw new FabricException("A name must be specified when creating containers");
            }
            if (listener == null) {
                listener = new NullCreationStateListener();
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Map optionsMap = (Map)mapper.readValue(mapper.writeValueAsString((Object)options), Map.class);
            String versionId = options.getVersion() != null ? options.getVersion() : this.getDataStore().getDefaultVersion();
            LinkedHashSet<String> profileIds = options.getProfiles();
            if (profileIds == null || profileIds.isEmpty()) {
                profileIds = new LinkedHashSet<String>();
                profileIds.add("default");
            }
            optionsMap.put("version", versionId);
            optionsMap.put("profiles", profileIds);
            optionsMap.put("number", 0);
            CopyOnWriteArrayList metadatas = new CopyOnWriteArrayList();
            int orgNumber = options.getNumber();
            int number = Math.max(orgNumber, 1);
            CountDownLatch latch = new CountDownLatch(number);
            for (int i = 1; i <= number; ++i) {
                String containerName = orgNumber >= 1 ? originalName + i : originalName;
                optionsMap.put("name", containerName);
                if (!FabricServiceImpl.hasValidDataStoreProperties(optionsMap)) {
                    optionsMap.put("dataStoreProperties", this.getDataStore().getDataStoreProperties());
                }
                Class<?> cl = options.getClass().getClassLoader().loadClass(options.getClass().getName() + "$Builder");
                CreateContainerBasicOptions.Builder builder = (CreateContainerBasicOptions.Builder)mapper.readValue(mapper.writeValueAsString((Object)optionsMap), cl);
                builder = (CreateContainerBasicOptions.Builder)builder.zookeeperPassword(PasswordEncoder.encode(this.getZookeeperPassword()));
                CreateContainerBasicOptions containerOptions = builder.build();
                CreationStateListener containerListener = listener;
                new Thread("Creating container " + containerName, (CreateContainerOptions)containerOptions, provider, containerListener, metadatas, latch){
                    final /* synthetic */ CreateContainerOptions val$containerOptions;
                    final /* synthetic */ ContainerProvider val$provider;
                    final /* synthetic */ CreationStateListener val$containerListener;
                    final /* synthetic */ List val$metadatas;
                    final /* synthetic */ CountDownLatch val$latch;
                    {
                        this.val$containerOptions = createContainerOptions;
                        this.val$provider = containerProvider;
                        this.val$containerListener = creationStateListener;
                        this.val$metadatas = list;
                        this.val$latch = countDownLatch;
                        super(x0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            FabricServiceImpl.this.getDataStore().createContainerConfig(this.val$containerOptions);
                            CreateContainerMetadata metadata = this.val$provider.create(this.val$containerOptions, this.val$containerListener);
                            if (metadata.isSuccess()) {
                                Container parent;
                                Container container = parent = this.val$containerOptions.getParent() != null ? FabricServiceImpl.this.getContainer(this.val$containerOptions.getParent()) : null;
                                if (!this.val$containerOptions.isEnsembleServer()) {
                                    FabricServiceImpl.this.getDataStore().createContainerConfig(metadata);
                                }
                                ContainerImpl container2 = new ContainerImpl(parent, metadata.getContainerName(), FabricServiceImpl.this);
                                metadata.setContainer((Container)container2);
                                LOGGER.info("The container " + metadata.getContainerName() + " has been successfully created");
                            } else {
                                LOGGER.info("The creation of the container " + metadata.getContainerName() + " has failed", metadata.getFailure());
                            }
                            this.val$metadatas.add(metadata);
                        }
                        catch (Throwable t) {
                            CreateContainerBasicMetadata metadata = new CreateContainerBasicMetadata();
                            metadata.setCreateOptions(this.val$containerOptions);
                            metadata.setFailure(t);
                            this.val$metadatas.add(metadata);
                            FabricServiceImpl.this.getDataStore().deleteContainer(this.val$containerOptions.getName());
                        }
                        finally {
                            this.val$latch.countDown();
                        }
                    }
                }.start();
            }
            if (!latch.await(15L, TimeUnit.MINUTES)) {
                throw new FabricException("Timeout waiting for container creation");
            }
            return metadatas.toArray(new CreateContainerMetadata[metadatas.size()]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create containers " + e, (Throwable)e);
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public Set<Class<? extends CreateContainerBasicOptions>> getSupportedCreateContainerOptionTypes() {
        this.assertValid();
        HashSet<Class<? extends CreateContainerBasicOptions>> optionTypes = new HashSet<Class<? extends CreateContainerBasicOptions>>();
        for (Map.Entry<String, ContainerProvider> entry : this.providers.entrySet()) {
            optionTypes.add(entry.getValue().getOptionsType());
        }
        return optionTypes;
    }

    public Set<Class<? extends CreateContainerBasicMetadata>> getSupportedCreateContainerMetadataTypes() {
        this.assertValid();
        HashSet<Class<? extends CreateContainerBasicMetadata>> metadataTypes = new HashSet<Class<? extends CreateContainerBasicMetadata>>();
        for (Map.Entry<String, ContainerProvider> entry : this.providers.entrySet()) {
            metadataTypes.add(entry.getValue().getMetadataType());
        }
        return metadataTypes;
    }

    public ContainerProvider getProvider(String scheme) {
        return this.providers.get(scheme);
    }

    public Map<String, ContainerProvider> getProviders() {
        this.assertValid();
        return Collections.unmodifiableMap(this.providers);
    }

    public URI getMavenRepoURI() {
        this.assertValid();
        URI uri = URI.create(this.getDefaultRepo());
        try {
            List children;
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"})) != null && (children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}))) != null && !children.isEmpty()) {
                Collections.sort(children);
                String mavenRepo = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}) + "/" + (String)children.get(0)));
                if (mavenRepo != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public List<URI> getMavenRepoURIs() {
        this.assertValid();
        try {
            ArrayList<URI> uris = new ArrayList<URI>();
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"})) != null) {
                List children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}));
                if (children != null && !children.isEmpty()) {
                    Collections.sort(children);
                }
                if (children != null) {
                    for (String child : children) {
                        String mavenRepo = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"download"}) + "/" + child));
                        if (mavenRepo != null && !mavenRepo.endsWith("/")) {
                            mavenRepo = mavenRepo + "/";
                        }
                        uris.add(new URI(mavenRepo));
                    }
                }
            }
            return uris;
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
    }

    public URI getMavenRepoUploadURI() {
        this.assertValid();
        URI uri = URI.create(this.getDefaultRepo());
        try {
            List children;
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"})) != null && (children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}))) != null && !children.isEmpty()) {
                Collections.sort(children);
                String mavenRepo = ZooKeeperUtils.getSubstitutedPath((CuratorFramework)((CuratorFramework)this.curator.get()), (String)(ZkPath.MAVEN_PROXY.getPath(new String[]{"upload"}) + "/" + (String)children.get(0)));
                if (mavenRepo != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public String containerWebAppURL(String webAppId, String name) {
        this.assertValid();
        String answer = this.containerWebAppUrl(ZkPath.WEBAPPS_CLUSTER.getPath(new String[]{webAppId}), name);
        if (answer == null) {
            answer = this.containerWebAppUrl(ZkPath.SERVLETS_CLUSTER.getPath(new String[]{webAppId}), name);
        }
        return answer;
    }

    private String containerWebAppUrl(String versionsPath, String name) {
        try {
            List children;
            if (ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)versionsPath) != null && (children = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)versionsPath)) != null && !children.isEmpty()) {
                for (String child : children) {
                    if (Strings.isNullOrEmpty((String)name)) {
                        String containerPath;
                        String answer;
                        String parentPath = versionsPath + "/" + child;
                        List grandChildren = ZooKeeperUtils.getChildren((CuratorFramework)((CuratorFramework)this.curator.get()), (String)parentPath);
                        if (grandChildren.isEmpty() || Strings.isNullOrEmpty((String)(answer = this.getWebUrl(containerPath = parentPath + "/" + (String)grandChildren.get(0))))) continue;
                        return answer;
                    }
                    String childPath = versionsPath + "/" + child;
                    String containerPath = childPath + "/" + name;
                    String answer = this.getWebUrl(containerPath);
                    if (Strings.isNullOrEmpty((String)answer)) {
                        answer = this.containerWebAppUrl(childPath, name);
                    }
                    if (Strings.isNullOrEmpty((String)answer)) continue;
                    return answer;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to find container Jolokia URL " + e, (Throwable)e);
        }
        return null;
    }

    private String getWebUrl(String containerPath) throws Exception {
        if (((CuratorFramework)this.curator.get()).checkExists().forPath(containerPath) != null) {
            int startIndex;
            int endIdx;
            byte[] bytes = ZkPath.loadURL((CuratorFramework)((CuratorFramework)this.curator.get()), (String)containerPath);
            String text = new String(bytes);
            String prefix = "\"services\":[\"";
            int idx = text.indexOf(prefix);
            String answer = text;
            if (idx > 0 && (endIdx = text.indexOf("\"]", startIndex = idx + prefix.length())) > 0 && (answer = text.substring(startIndex, endIdx)).length() > 0) {
                answer = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)answer);
                return answer;
            }
        }
        return null;
    }

    private static boolean hasValidDataStoreProperties(Map options) {
        if (!options.containsKey("dataStoreProperties")) {
            return false;
        }
        Object props = options.get("dataStoreProperties");
        if (props instanceof Map) {
            return !((Map)props).isEmpty();
        }
        return false;
    }

    public void registerProvider(String scheme, ContainerProvider provider) {
        this.assertValid();
        this.providers.put(scheme, provider);
    }

    public void registerProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.assertValid();
        String scheme = (String)properties.get("fabric.container.protocol");
        this.registerProvider(scheme, provider);
    }

    public void unregisterProvider(String scheme) {
        this.assertValid();
        this.providers.remove(scheme);
    }

    public void unregisterProvider(ContainerProvider provider, Map<String, Object> properties) {
        this.assertValid();
        String scheme = (String)properties.get("fabric.container.protocol");
        this.unregisterProvider(scheme);
    }

    public String getZookeeperUrl() {
        this.assertValid();
        return this.getZookeeperInfo("zookeeper.url");
    }

    public String getZooKeeperUser() {
        this.assertValid();
        return "admin";
    }

    public String getZookeeperPassword() {
        this.assertValid();
        String rawZookeeperPassword = this.getZookeeperInfo("zookeeper.password");
        if (rawZookeeperPassword != null) {
            return PasswordEncoder.decode(rawZookeeperPassword);
        }
        return null;
    }

    public String getZookeeperInfo(String name) {
        this.assertValid();
        String zooKeeperUrl = null;
        try {
            Map zookeeperConfig;
            Profile profile;
            Version defaultVersion;
            if (((CuratorFramework)this.curator.get()).getZookeeperClient().isConnected() && (defaultVersion = this.getDefaultVersion()) != null && (profile = defaultVersion.getProfile("default")) != null && (zookeeperConfig = profile.getConfiguration("io.fabric8.zookeeper")) != null) {
                zooKeeperUrl = ZooKeeperUtils.getSubstitutedData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)((String)zookeeperConfig.get(name)));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (zooKeeperUrl == null) {
            try {
                Configuration config = ((ConfigurationAdmin)this.configAdmin.get()).getConfiguration("io.fabric8.zookeeper", null);
                zooKeeperUrl = (String)config.getProperties().get(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return zooKeeperUrl;
    }

    public Version getDefaultVersion() {
        this.assertValid();
        return new VersionImpl(this.getDataStore().getDefaultVersion(), this);
    }

    public void setDefaultVersion(Version version) {
        this.assertValid();
        this.setDefaultVersion(version.getId());
    }

    public void setDefaultVersion(String versionId) {
        this.assertValid();
        this.getDataStore().setDefaultVersion(versionId);
    }

    public Version createVersion(String version) {
        this.assertValid();
        this.getDataStore().createVersion(version);
        return new VersionImpl(version, this);
    }

    public Version createVersion(Version parent, String toVersion) {
        this.assertValid();
        return this.createVersion(parent.getId(), toVersion);
    }

    public Version createVersion(String parentVersionId, String toVersion) {
        this.assertValid();
        this.getDataStore().createVersion(parentVersionId, toVersion);
        return new VersionImpl(toVersion, this);
    }

    public void deleteVersion(String version) {
        this.assertValid();
        this.getVersion(version).delete();
    }

    public Version[] getVersions() {
        this.assertValid();
        ArrayList<VersionImpl> versions = new ArrayList<VersionImpl>();
        List children = this.getDataStore().getVersions();
        for (String child : children) {
            versions.add(new VersionImpl(child, this));
        }
        Collections.sort(versions);
        return versions.toArray(new Version[versions.size()]);
    }

    public Version getVersion(String name) {
        this.assertValid();
        if (this.getDataStore().hasVersion(name)) {
            return new VersionImpl(name, this);
        }
        throw new FabricException("Version '" + name + "' does not exist");
    }

    public Profile[] getProfiles(String version) {
        this.assertValid();
        return this.getVersion(version).getProfiles();
    }

    public Profile getProfile(String version, String name) {
        this.assertValid();
        return this.getVersion(version).getProfile(name);
    }

    public Profile createProfile(String version, String name) {
        this.assertValid();
        return this.getVersion(version).createProfile(name);
    }

    public void deleteProfile(Profile profile) {
        this.assertValid();
        this.deleteProfile(profile.getVersion(), profile.getId());
    }

    private void deleteProfile(String versionId, String profileId) {
        this.getDataStore().deleteProfile(versionId, profileId);
    }

    public void setRequirements(FabricRequirements requirements) throws IOException {
        this.assertValid();
        this.getDataStore().setRequirements(requirements);
    }

    public FabricRequirements getRequirements() {
        this.assertValid();
        FabricRequirements requirements = this.getDataStore().getRequirements();
        Version defaultVersion = this.getDefaultVersion();
        if (defaultVersion != null) {
            requirements.setVersion(defaultVersion.getId());
        }
        return requirements;
    }

    public FabricStatus getFabricStatus() {
        this.assertValid();
        return new FabricStatus((FabricService)this);
    }

    public PatchService getPatchService() {
        this.assertValid();
        return new PatchServiceImpl(this);
    }

    public String getDefaultJvmOptions() {
        this.assertValid();
        return this.getDataStore().getDefaultJvmOptions();
    }

    public void setDefaultJvmOptions(String jvmOptions) {
        this.assertValid();
        this.getDataStore().setDefaultJvmOptions(jvmOptions);
    }

    public String getConfigurationValue(String versionId, String profileId, String pid, String key) {
        this.assertValid();
        Version v = this.getVersion(versionId);
        if (v == null) {
            throw new FabricException("No version found: " + versionId);
        }
        Profile pr = v.getProfile(profileId);
        if (pr == null) {
            throw new FabricException("No profile found: " + profileId);
        }
        Map configs = pr.getFileConfigurations();
        byte[] b = (byte[])configs.get(pid);
        Properties p = null;
        try {
            p = b != null ? DataStoreUtils.toProperties(b) : new Properties();
        }
        catch (Throwable t) {
            throw new FabricException(t);
        }
        return p.getProperty(key);
    }

    public void setConfigurationValue(String versionId, String profileId, String pid, String key, String value) {
        this.assertValid();
        Version v = this.getVersion(versionId);
        if (v == null) {
            throw new FabricException("No version found: " + versionId);
        }
        Profile pr = v.getProfile(profileId);
        if (pr == null) {
            throw new FabricException("No profile found: " + profileId);
        }
        Map configs = pr.getFileConfigurations();
        byte[] b = (byte[])configs.get(pid);
        Properties p = null;
        try {
            p = b != null ? DataStoreUtils.toProperties(b) : new Properties();
            p.setProperty(key, value);
            b = DataStoreUtils.toBytes(p);
            configs.put(pid, b);
            pr.setFileConfigurations(configs);
        }
        catch (Throwable t) {
            throw new FabricException(t);
        }
    }

    public boolean scaleProfile(String profile, int numberOfInstances) throws IOException {
        boolean update;
        if (numberOfInstances == 0) {
            throw new IllegalArgumentException("numberOfInstances should be greater or less than zero");
        }
        FabricRequirements requirements = this.getRequirements();
        ProfileRequirements profileRequirements = requirements.getOrCreateProfileRequirement(profile);
        Integer minimumInstances = profileRequirements.getMinimumInstances();
        List containers = Containers.containersForProfile((Container[])this.getContainers(), (String)profile);
        int containerCount = containers.size();
        int newCount = containerCount + numberOfInstances;
        if (newCount < 0) {
            newCount = 0;
        }
        boolean bl = update = minimumInstances == null || newCount != minimumInstances;
        if (update) {
            profileRequirements.setMinimumInstances(Integer.valueOf(newCount));
            this.setRequirements(requirements);
        }
        return update;
    }

    public ContainerAutoScaler createContainerAutoScaler() {
        Collection<ContainerProvider> providerCollection = this.getProviders().values();
        for (ContainerProvider containerProvider : providerCollection) {
            Integer key;
            ContainerAutoScalerFactory provider;
            ContainerAutoScaler autoScaler;
            TreeMap<Integer, ContainerAutoScaler> sortedAutoScalers = new TreeMap<Integer, ContainerAutoScaler>();
            if (containerProvider instanceof ContainerAutoScalerFactory && (autoScaler = (provider = (ContainerAutoScalerFactory)containerProvider).createAutoScaler()) != null) {
                int weight = autoScaler.getWeight();
                sortedAutoScalers.put(weight, autoScaler);
            }
            if (sortedAutoScalers.isEmpty() || (key = (Integer)sortedAutoScalers.lastKey()) == null) continue;
            return (ContainerAutoScaler)sortedAutoScalers.get(key);
        }
        return null;
    }

    public void substituteConfigurations(final Map<String, Map<String, String>> configs) {
        final HashMap<String, PlaceholderResolver> resolversSnapshot = new HashMap<String, PlaceholderResolver>(this.placeholderResolvers);
        Set<String> requiredSchemes = PlaceholderResolverHelpers.getSchemesForProfileConfigurations(configs);
        Set availableSchemes = resolversSnapshot.keySet();
        if (!availableSchemes.containsAll(requiredSchemes)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Missing Placeholder Resolvers:");
            for (String scheme : requiredSchemes) {
                if (availableSchemes.contains(scheme)) continue;
                sb.append(" ").append(scheme);
            }
            throw new FabricException(sb.toString());
        }
        final FabricServiceImpl fabricService = this;
        for (Map.Entry<String, Map<String, String>> entry : configs.entrySet()) {
            final String pid = entry.getKey();
            Map<String, String> props = entry.getValue();
            for (Map.Entry<String, String> e : props.entrySet()) {
                final String key = e.getKey();
                String value = e.getValue();
                props.put(key, InterpolationHelper.substVars((String)value, (String)key, null, props, (InterpolationHelper.SubstitutionCallback)new InterpolationHelper.SubstitutionCallback(){

                    public String getValue(String toSubstitute) {
                        if (toSubstitute != null && toSubstitute.contains(":")) {
                            String scheme = toSubstitute.substring(0, toSubstitute.indexOf(":"));
                            return ((PlaceholderResolver)resolversSnapshot.get(scheme)).resolve(fabricService, configs, pid, key, toSubstitute);
                        }
                        return DataStoreUtils.substituteBundleProperty(toSubstitute, FabricServiceImpl.this.bundleContext);
                    }
                }));
            }
        }
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    @VisibleForTesting
    public void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    @VisibleForTesting
    public void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    @VisibleForTesting
    public void bindDataStore(DataStore dataStore) {
        this.dataStore.bind((Object)dataStore);
    }

    void unbindDataStore(DataStore dataStore) {
        this.dataStore.unbind((Object)dataStore);
    }

    void bindPortService(PortService portService) {
        this.portService.bind((Object)portService);
    }

    void unbindPortService(PortService portService) {
        this.portService.unbind((Object)portService);
    }

    void bindProvider(ContainerProvider provider) {
        this.providers.put(provider.getScheme(), provider);
    }

    void unbindProvider(ContainerProvider provider) {
        this.providers.remove(provider.getScheme());
    }

    void bindPlaceholderResolver(PlaceholderResolver resolver) {
        String resolverScheme = resolver.getScheme();
        this.placeholderResolvers.put(resolverScheme, resolver);
    }

    void unbindPlaceholderResolver(PlaceholderResolver resolver) {
        String resolverScheme = resolver.getScheme();
        this.placeholderResolvers.remove(resolverScheme);
    }

    protected void bindChecksumPlaceholderResolver(ChecksumPlaceholderResolver checksumPlaceholderResolver) {
        this.checksumPlaceholderResolver = checksumPlaceholderResolver;
    }

    protected void unbindChecksumPlaceholderResolver(ChecksumPlaceholderResolver checksumPlaceholderResolver) {
        if (this.checksumPlaceholderResolver == checksumPlaceholderResolver) {
            this.checksumPlaceholderResolver = null;
        }
    }

    protected void bindContainerPlaceholderResolver(ContainerPlaceholderResolver containerPlaceholderResolver) {
        this.containerPlaceholderResolver = containerPlaceholderResolver;
    }

    protected void unbindContainerPlaceholderResolver(ContainerPlaceholderResolver containerPlaceholderResolver) {
        if (this.containerPlaceholderResolver == containerPlaceholderResolver) {
            this.containerPlaceholderResolver = null;
        }
    }

    protected void bindEncryptedPropertyResolver(EncryptedPropertyResolver encryptedPropertyResolver) {
        this.encryptedPropertyResolver = encryptedPropertyResolver;
    }

    protected void unbindEncryptedPropertyResolver(EncryptedPropertyResolver encryptedPropertyResolver) {
        if (this.encryptedPropertyResolver == encryptedPropertyResolver) {
            this.encryptedPropertyResolver = null;
        }
    }

    protected void bindEnvPlaceholderResolver(EnvPlaceholderResolver envPlaceholderResolver) {
        this.envPlaceholderResolver = envPlaceholderResolver;
    }

    protected void unbindEnvPlaceholderResolver(EnvPlaceholderResolver envPlaceholderResolver) {
        if (this.envPlaceholderResolver == envPlaceholderResolver) {
            this.envPlaceholderResolver = null;
        }
    }

    protected void bindPortPlaceholderResolver(PortPlaceholderResolver portPlaceholderResolver) {
        this.portPlaceholderResolver = portPlaceholderResolver;
    }

    protected void unbindPortPlaceholderResolver(PortPlaceholderResolver portPlaceholderResolver) {
        if (this.portPlaceholderResolver == portPlaceholderResolver) {
            this.portPlaceholderResolver = null;
        }
    }

    protected void bindProfilePropertyPointerResolver(ProfilePropertyPointerResolver profilePropertyPointerResolver) {
        this.profilePropertyPointerResolver = profilePropertyPointerResolver;
    }

    protected void unbindProfilePropertyPointerResolver(ProfilePropertyPointerResolver profilePropertyPointerResolver) {
        if (this.profilePropertyPointerResolver == profilePropertyPointerResolver) {
            this.profilePropertyPointerResolver = null;
        }
    }

    protected void bindVersionPropertyPointerResolver(VersionPropertyPointerResolver versionPropertyPointerResolver) {
        this.versionPropertyPointerResolver = versionPropertyPointerResolver;
    }

    protected void unbindVersionPropertyPointerResolver(VersionPropertyPointerResolver versionPropertyPointerResolver) {
        if (this.versionPropertyPointerResolver == versionPropertyPointerResolver) {
            this.versionPropertyPointerResolver = null;
        }
    }

    protected void bindZookeeperPlaceholderResolver(ZookeeperPlaceholderResolver zookeeperPlaceholderResolver) {
        this.zookeeperPlaceholderResolver = zookeeperPlaceholderResolver;
    }

    protected void unbindZookeeperPlaceholderResolver(ZookeeperPlaceholderResolver zookeeperPlaceholderResolver) {
        if (this.zookeeperPlaceholderResolver == zookeeperPlaceholderResolver) {
            this.zookeeperPlaceholderResolver = null;
        }
    }
}

