/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.internal;

import io.fabric8.api.DynamicReference;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.common.util.Strings;
import io.fabric8.service.jclouds.ComputeRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.jclouds.compute.ComputeService;

@ThreadSafe
@Component(name="io.fabric8.jclouds.compute.registry", label="Fabric8 Jclouds Compute Registry", immediate=true, metatype=false)
@Service(value={ComputeRegistry.class})
public class ComputeRegistryImpl
extends AbstractComponent
implements ComputeRegistry {
    private static final Long COMPUTE_SERVICE_WAIT = 60000L;
    @GuardedBy(value="ConcurrentHashMap")
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindComputeService", unbind="unbindComputeService", referenceInterface=ComputeService.class, policy=ReferencePolicy.DYNAMIC)
    private final ConcurrentMap<String, DynamicReference<ComputeService>> computeServices = new ConcurrentHashMap<String, DynamicReference<ComputeService>>();

    @Activate
    void activate() {
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    @Override
    public List<ComputeService> list() {
        this.assertValid();
        ArrayList<ComputeService> list = new ArrayList<ComputeService>();
        for (Map.Entry entry : this.computeServices.entrySet()) {
            ComputeService computeService = (ComputeService)((DynamicReference)entry.getValue()).getIfPresent();
            if (computeService == null) continue;
            list.add(computeService);
        }
        return list;
    }

    @Override
    public ComputeService getIfPresent(String name) {
        this.assertValid();
        this.computeServices.putIfAbsent(name, (DynamicReference<ComputeService>)new DynamicReference(name, COMPUTE_SERVICE_WAIT.longValue(), TimeUnit.MILLISECONDS));
        return (ComputeService)((DynamicReference)this.computeServices.get(name)).getIfPresent();
    }

    @Override
    public ComputeService getOrWait(String name) {
        this.assertValid();
        this.computeServices.putIfAbsent(name, (DynamicReference<ComputeService>)new DynamicReference(name, COMPUTE_SERVICE_WAIT.longValue(), TimeUnit.MILLISECONDS));
        return (ComputeService)((DynamicReference)this.computeServices.get(name)).get();
    }

    @Override
    public void remove(String name) {
        this.assertValid();
        DynamicReference ref = (DynamicReference)this.computeServices.get(name);
        if (ref != null) {
            ref.unbind(null);
        }
    }

    void bindComputeService(ComputeService computeService) {
        String name = computeService.getContext().unwrap().getName();
        if (!Strings.isEmpty((String)name)) {
            this.computeServices.putIfAbsent(name, (DynamicReference<ComputeService>)new DynamicReference(name, COMPUTE_SERVICE_WAIT.longValue(), TimeUnit.MILLISECONDS));
            ((DynamicReference)this.computeServices.get(name)).bind((Object)computeService);
        }
    }

    void unbindComputeService(ComputeService computeService) {
        DynamicReference ref;
        String name = computeService.getContext().unwrap().getName();
        if (!Strings.isEmpty((String)name) && (ref = (DynamicReference)this.computeServices.get(name)) != null) {
            ref.unbind((Object)computeService);
        }
    }
}

