/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.Container;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import java.util.ArrayList;

public final class ContainerUpgradeSupport {
    public static Profile[] getProfilesForUpgradeOrRollback(Profile[] existingProfiles, Version targetVersion) {
        ArrayList<Profile> list = new ArrayList<Profile>(existingProfiles.length);
        for (Profile old : existingProfiles) {
            Profile newProfile = targetVersion.getRequiredProfile(old.getId());
            if (newProfile == null) {
                throw new IllegalArgumentException("Profile " + old.getId() + " with version " + targetVersion.getId() + " does not exists");
            }
            list.add(newProfile);
        }
        return list.toArray(new Profile[0]);
    }

    public static int canUpgrade(Version version, Container container) {
        Version current = container.getVersion();
        return version.compareTo((Object)current);
    }

    public static int canRollback(Version version, Container container) {
        return ContainerUpgradeSupport.canUpgrade(version, container) * -1;
    }
}

