/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.functions;

import com.google.common.base.Optional;
import io.fabric8.service.jclouds.CreateJCloudsContainerMetadata;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.domain.LoginCredentials;

public class ToRunScriptOptions {
    private final ComputeService computeService;

    public ToRunScriptOptions(ComputeService computeService) {
        this.computeService = computeService;
    }

    public static ToRunScriptOptions withComputeService(ComputeService computeService) {
        return new ToRunScriptOptions(computeService);
    }

    public Optional<RunScriptOptions> apply(CreateJCloudsContainerMetadata containerMetadata) {
        CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)containerMetadata.getCreateOptions();
        NodeMetadata nodeMetadata = this.computeService.getNodeMetadata(containerMetadata.getNodeId());
        LoginCredentials credentials = nodeMetadata.getCredentials();
        if (options.getUser() != null) {
            LoginCredentials.Builder loginBuilder = credentials == null ? LoginCredentials.builder() : credentials.toBuilder();
            credentials = options.getPassword() != null ? loginBuilder.user(options.getUser()).password(options.getPassword()).build() : loginBuilder.user(options.getUser()).build();
        }
        if (credentials != null) {
            return Optional.of((Object)RunScriptOptions.Builder.overrideLoginCredentials((LoginCredentials)credentials).runAsRoot(false));
        }
        return Optional.absent();
    }
}

