/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import io.fabric8.api.Container;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.CreateContainerMetadata;
import io.fabric8.api.CreateContainerOptions;
import io.fabric8.api.CreateRemoteContainerOptions;
import io.fabric8.api.CreationStateListener;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.api.visibility.VisibleForExternal;
import io.fabric8.internal.ContainerProviderUtils;
import io.fabric8.service.jclouds.CloudContainerInstallationTask;
import io.fabric8.service.jclouds.ComputeRegistry;
import io.fabric8.service.jclouds.CreateJCloudsContainerMetadata;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import io.fabric8.service.jclouds.firewall.FirewallManagerFactory;
import io.fabric8.service.jclouds.functions.ToRunScriptOptions;
import io.fabric8.service.jclouds.functions.ToTemplate;
import io.fabric8.service.jclouds.internal.CloudUtils;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.karaf.core.CredentialStore;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.provider.jclouds", label="Fabric8 Jclouds Container Provider", immediate=true, metatype=false)
@Service(value={ContainerProvider.class})
@Properties(value={@Property(name="fabric.container.protocol", value={"jclouds"})})
public class JcloudsContainerProvider
extends AbstractComponent
implements ContainerProvider<CreateJCloudsContainerOptions, CreateJCloudsContainerMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcloudsContainerProvider.class);
    private static final String NODE_CREATED_FORMAT = "Node %s has been succesfully created.";
    private static final String NODE_ERROR_FORMAT = "Error creating node %s. Status: .";
    private static final String OVERVIEW_FORMAT = "Creating %s nodes on %s. It may take a while ...";
    static final String SCHEME = "jclouds";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, bind="bindComputeService", unbind="unbindComputeService", referenceInterface=ComputeService.class, policy=ReferencePolicy.DYNAMIC)
    private final ConcurrentMap<String, ComputeService> computeServiceMap = new ConcurrentHashMap<String, ComputeService>();
    @Reference(referenceInterface=ComputeRegistry.class)
    private final ValidatingReference<ComputeRegistry> computeRegistry = new ValidatingReference();
    @Reference(referenceInterface=FirewallManagerFactory.class)
    private final ValidatingReference<FirewallManagerFactory> firewallManagerFactory = new ValidatingReference();
    @Reference(referenceInterface=CredentialStore.class)
    private final ValidatingReference<CredentialStore> credentialStore = new ValidatingReference();
    @Reference(referenceInterface=ConfigurationAdmin.class)
    private final ValidatingReference<ConfigurationAdmin> configAdmin = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @GuardedBy(value="volatile & assertValid()")
    private volatile BundleContext bundleContext;

    @Activate
    void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public CreateJCloudsContainerOptions.Builder newBuilder() {
        return CreateJCloudsContainerOptions.builder();
    }

    public CreateJCloudsContainerMetadata create(CreateJCloudsContainerOptions input, CreationStateListener listener) throws MalformedURLException, RunNodesException, URISyntaxException, InterruptedException {
        this.assertValid();
        CreateJCloudsContainerOptions options = input.updateComputeService(this.getOrCreateComputeService(input));
        listener.onStateChange("Looking up for compute service.");
        ComputeService computeService = this.getOrCreateComputeService(options);
        if (computeService == null) {
            throw new IllegalStateException("Compute service could not be found or created.");
        }
        Template template = ToTemplate.apply(options);
        listener.onStateChange(String.format(OVERVIEW_FORMAT, 1, options.getContextName()));
        try {
            Set metadata = computeService.createNodesInGroup(options.getGroup(), 1, template);
            if (metadata == null || metadata.size() != 1) {
                throw new IllegalStateException("JClouds created " + metadata.size() + " containers instead of 1");
            }
            NodeMetadata nodeMetadata = (NodeMetadata)metadata.iterator().next();
            switch ((NodeMetadata.Status)nodeMetadata.getStatus()) {
                case RUNNING: {
                    listener.onStateChange(String.format(NODE_CREATED_FORMAT, nodeMetadata.getName()));
                    break;
                }
                default: {
                    listener.onStateChange(String.format(NODE_ERROR_FORMAT, nodeMetadata.getStatus()));
                }
            }
            CloudContainerInstallationTask installationTask = new CloudContainerInstallationTask(options.getName(), nodeMetadata, options, computeService, (FirewallManagerFactory)this.firewallManagerFactory.get(), template.getOptions(), listener);
            return installationTask.install();
        }
        catch (Throwable ex) {
            CreateJCloudsContainerMetadata failureMetadata = new CreateJCloudsContainerMetadata();
            failureMetadata.setCreateOptions((CreateContainerOptions)options);
            failureMetadata.setFailure(ex);
            return failureMetadata;
        }
    }

    public void start(Container container) {
        this.assertValid();
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateJCloudsContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateJCloudsContainerMetadata jCloudsContainerMetadata = (CreateJCloudsContainerMetadata)metadata;
        CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)jCloudsContainerMetadata.getCreateOptions();
        ComputeService computeService = this.getOrCreateComputeService(options);
        try {
            String nodeId = jCloudsContainerMetadata.getNodeId();
            Optional<RunScriptOptions> runScriptOptions = ToRunScriptOptions.withComputeService(computeService).apply(jCloudsContainerMetadata);
            String script = ContainerProviderUtils.buildStartScript((String)container.getId(), (CreateRemoteContainerOptions)options);
            ExecResponse response = runScriptOptions.isPresent() ? computeService.runScriptOnNode(nodeId, script, (RunScriptOptions)runScriptOptions.get()) : computeService.runScriptOnNode(nodeId, script);
            if (response == null) {
                jCloudsContainerMetadata.setFailure(new Exception("No response received for fabric install script."));
            } else if (response.getOutput() != null && response.getOutput().contains("Command Failed:")) {
                jCloudsContainerMetadata.setFailure(new Exception(ContainerProviderUtils.parseScriptFailure((String)response.getOutput())));
            }
        }
        catch (Throwable t) {
            jCloudsContainerMetadata.setFailure(t);
        }
    }

    public void stop(Container container) {
        this.assertValid();
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateJCloudsContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateJCloudsContainerMetadata jCloudsContainerMetadata = (CreateJCloudsContainerMetadata)metadata;
        CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)jCloudsContainerMetadata.getCreateOptions();
        try {
            ComputeService computeService = this.getOrCreateComputeService(options);
            String nodeId = jCloudsContainerMetadata.getNodeId();
            Optional<RunScriptOptions> runScriptOptions = ToRunScriptOptions.withComputeService(computeService).apply(jCloudsContainerMetadata);
            String script = ContainerProviderUtils.buildStopScript((String)container.getId(), (CreateRemoteContainerOptions)options);
            ExecResponse response = runScriptOptions.isPresent() ? computeService.runScriptOnNode(nodeId, script, (RunScriptOptions)runScriptOptions.get()) : computeService.runScriptOnNode(nodeId, script);
            if (response == null) {
                jCloudsContainerMetadata.setFailure(new Exception("No response received for fabric install script."));
            } else if (response.getOutput() != null && response.getOutput().contains("Command Failed:")) {
                jCloudsContainerMetadata.setFailure(new Exception(ContainerProviderUtils.parseScriptFailure((String)response.getOutput())));
            }
        }
        catch (Throwable t) {
            container.setProvisionResult("stopped");
            jCloudsContainerMetadata.setFailure(t);
        }
    }

    public void destroy(Container container) {
        this.assertValid();
        CreateContainerMetadata metadata = container.getMetadata();
        if (!(metadata instanceof CreateJCloudsContainerMetadata)) {
            throw new IllegalStateException("Container doesn't have valid create container metadata type");
        }
        CreateJCloudsContainerMetadata jCloudsContainerMetadata = (CreateJCloudsContainerMetadata)metadata;
        CreateJCloudsContainerOptions options = (CreateJCloudsContainerOptions)jCloudsContainerMetadata.getCreateOptions();
        String nodeId = jCloudsContainerMetadata.getNodeId();
        ComputeService computeService = this.getOrCreateComputeService(options);
        computeService.destroyNode(nodeId);
    }

    private synchronized ComputeService getOrCreateComputeService(CreateJCloudsContainerOptions options) {
        ComputeService computeService = null;
        if (options != null) {
            computeService = options.getComputeService();
            if (computeService == null && options.getContextName() != null) {
                computeService = ((ComputeRegistry)this.computeRegistry.get()).getIfPresent(options.getContextName());
            }
            if (computeService == null) {
                if (Strings.isNullOrEmpty((String)options.getProviderName()) || Strings.isNullOrEmpty((String)options.getIdentity()) || Strings.isNullOrEmpty((String)options.getCredential())) {
                    throw new IllegalArgumentException("Cannot create compute service. A registered cloud provider or the provider name, identity and credential options are required");
                }
                Map<String, String> serviceOptions = options.getServiceOptions();
                try {
                    if (options.getProviderName() != null) {
                        CloudUtils.registerProvider((CuratorFramework)this.curator.get(), (ConfigurationAdmin)this.configAdmin.get(), options.getContextName(), options.getProviderName(), options.getIdentity(), options.getCredential(), serviceOptions);
                    } else if (options.getApiName() != null) {
                        CloudUtils.registerApi((CuratorFramework)this.curator.get(), (ConfigurationAdmin)this.configAdmin.get(), options.getContextName(), options.getApiName(), options.getEndpoint(), options.getIdentity(), options.getCredential(), serviceOptions);
                    }
                    computeService = CloudUtils.waitForComputeService(this.bundleContext, options.getContextName());
                }
                catch (Exception e) {
                    LOGGER.warn("Did not manage to register compute cloud provider.");
                }
            }
        }
        return computeService;
    }

    public String getScheme() {
        return SCHEME;
    }

    public Class<CreateJCloudsContainerOptions> getOptionsType() {
        return CreateJCloudsContainerOptions.class;
    }

    public Class<CreateJCloudsContainerMetadata> getMetadataType() {
        return CreateJCloudsContainerMetadata.class;
    }

    @VisibleForExternal
    public void bindFirewallManagerFactory(FirewallManagerFactory factory) {
        this.firewallManagerFactory.bind((Object)factory);
    }

    @VisibleForExternal
    public void unbindFirewallManagerFactory(FirewallManagerFactory factory) {
        this.firewallManagerFactory.unbind((Object)factory);
    }

    void bindCredentialStore(CredentialStore credentialStore) {
        this.credentialStore.bind((Object)credentialStore);
    }

    void unbindCredentialStore(CredentialStore credentialStore) {
        this.credentialStore.unbind((Object)credentialStore);
    }

    void bindComputeRegistry(ComputeRegistry service) {
        this.computeRegistry.bind((Object)service);
    }

    void unbindComputeRegistry(ComputeRegistry service) {
        this.computeRegistry.unbind((Object)service);
    }

    void bindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.bind((Object)service);
    }

    void unbindConfigAdmin(ConfigurationAdmin service) {
        this.configAdmin.unbind((Object)service);
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindComputeService(ComputeService computeService) {
        String name = computeService.getContext().unwrap().getName();
        if (name != null) {
            this.computeServiceMap.put(name, computeService);
        }
    }

    void unbindComputeService(ComputeService computeService) {
        String serviceId = computeService.getContext().unwrap().getName();
        if (serviceId != null) {
            this.computeServiceMap.remove(serviceId);
        }
    }
}

