/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.service.jclouds.commands;

import io.fabric8.api.Container;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Dictionary;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.osgi.service.cm.Configuration;

@Command(name="cloud-service-remove", scope="fabric", description="Removes a cloud provider from the fabric's registry.")
public class CloudServiceRemove
extends FabricCommand {
    private static final String PID_FILTER = "(service.pid=%s*)";
    @Argument(index=0, name="name", required=true, description="JClouds context name.")
    private String name;

    protected Object doExecute() throws Exception {
        Configuration[] computeConfigs;
        boolean connected = this.getCurator().getZookeeperClient().isConnected();
        Container current = null;
        if (connected) {
            ZooKeeperUtils.deleteSafe((CuratorFramework)this.getCurator(), (String)ZkPath.CLOUD_SERVICE.getPath(new String[]{this.name}));
            current = this.fabricService.getCurrentContainer();
        }
        if ((computeConfigs = this.findConfigurationByFactoryPid("org.jclouds.compute")) != null) {
            for (Configuration configuration : computeConfigs) {
                String contextName;
                Dictionary props = configuration.getProperties();
                if (props == null || !this.name.equals(contextName = (String)props.get("name"))) continue;
                configuration.delete();
            }
        }
        return null;
    }

    private Configuration[] findConfigurationByFactoryPid(String factoryPid) {
        Configuration[] configurations = new Configuration[]{};
        try {
            configurations = this.configurationAdmin.listConfigurations(String.format(PID_FILTER, factoryPid));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configurations;
    }
}

