/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands.support;

import io.fabric8.api.scr.AbstractComponent;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service(value={PidCompleter.class, Completer.class})
public class PidCompleter
extends AbstractComponent
implements Completer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PidCompleter.class);
    private final StringsCompleter delegate = new StringsCompleter();
    @Reference
    private ConfigurationAdmin configurationAdmin;

    @Activate
    void activate() {
        this.updateAllPids();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public int complete(String buffer, int cursor, List candidates) {
        int firstPass = this.delegate.complete(buffer, cursor, candidates);
        if (firstPass < 0) {
            this.updateAllPids();
            return this.delegate.complete(buffer, cursor, candidates);
        }
        return firstPass;
    }

    private void updateAllPids() {
        try {
            Configuration[] configs = this.configurationAdmin.listConfigurations(null);
            if (configs != null) {
                for (Configuration config : configs) {
                    String pid = config.getPid();
                    Dictionary dictionary = config.getProperties();
                    if (dictionary == null) continue;
                    Enumeration keyEnumeration = dictionary.keys();
                    while (keyEnumeration.hasMoreElements()) {
                        String key = (String)keyEnumeration.nextElement();
                        this.delegate.getStrings().add(pid + "/" + key);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not lookup pids from configuration admin.");
        }
    }

    protected void bindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    protected void unbindConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configurationAdmin == configurationAdmin) {
            this.configurationAdmin = null;
        }
    }
}

