/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.Containers;
import io.fabric8.api.FabricService;
import io.fabric8.api.ProfileRequirements;
import io.fabric8.utils.FabricValidations;
import java.io.PrintStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-scale", scope="fabric", description="Scales up or down the required number of instances of a profile")
public class ProfileScaleAction
extends AbstractAction {
    @Argument(index=0, required=true, name="profile", description="The name of the profile to scale up or down.")
    @CompleterValues(index=0)
    private String name;
    @Argument(index=1, required=false, name="count", description="The number of instances to increase or decrease (defaults to +1).")
    private int count = 1;
    private final FabricService fabricService;

    ProfileScaleAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        try {
            FabricValidations.validateProfileName(this.name);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            return null;
        }
        this.fabricService.scaleProfile(this.name, this.count);
        ProfileRequirements profileRequirements = this.fabricService.getRequirements().getOrCreateProfileRequirement(this.name);
        Integer minimumInstances = profileRequirements.getMinimumInstances();
        int size = Containers.containersForProfile((Container[])this.fabricService.getContainers(), (String)this.name).size();
        PrintStream output = System.out;
        output.println("Profile " + this.name + " " + (minimumInstances != null ? "now requires " + minimumInstances + " container(s)" : "does not require any containers") + " currently has " + size + " container(s) running");
        return null;
    }
}

