/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.AutoScaleProfileStatus;
import io.fabric8.api.AutoScaleStatus;
import io.fabric8.api.FabricService;
import io.fabric8.commands.RequireProfileListAction;
import io.fabric8.utils.TablePrinter;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="autoscale-status", scope="fabric", description="Display the status of the auto scaler service in the fabric")
public class AutoScaleStatusListAction
extends AbstractAction {
    private final FabricService fabricService;

    public AutoScaleStatusListAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        PrintStream out = System.out;
        AutoScaleStatus status = this.getFabricService().getAutoScaleStatus();
        this.printStatus(out, status);
        return null;
    }

    protected void printStatus(PrintStream out, AutoScaleStatus status) {
        TablePrinter table = new TablePrinter();
        table.columns("auto scale profile", "status", "message");
        List profileStatuses = status.getProfileStatuses();
        for (AutoScaleProfileStatus profile : profileStatuses) {
            table.row(RequireProfileListAction.getStringOrBlank(profile.getProfile()), RequireProfileListAction.getStringOrBlank(profile.getStatus()), RequireProfileListAction.getStringOrBlank(profile.getMessage()));
        }
        table.print();
    }
}

