/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.Version;
import io.fabric8.commands.support.CommandUtils;
import java.util.ArrayList;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="version-info", scope="fabric", description="Displays information about a version")
public class VersionInfoAction
extends AbstractAction {
    static final String FORMAT = "%-30s %s";
    @Argument(index=0, name="version", description="The version name.", required=true, multiValued=false)
    private String versionName;
    private final FabricService fabricService;
    private final RuntimeProperties runtimeProperties;

    VersionInfoAction(FabricService fabricService, RuntimeProperties runtimeProperties) {
        this.fabricService = fabricService;
        this.runtimeProperties = runtimeProperties;
    }

    protected Object doExecute() throws Exception {
        if (!this.versionExists(this.versionName)) {
            System.out.println("Version " + this.versionName + " does not exist");
            return null;
        }
        Version version = this.fabricService.getVersion(this.versionName);
        String description = (String)version.getAttributes().get("description");
        String derivedFrom = version.getDerivedFrom() != null ? version.getDerivedFrom().getId() : null;
        boolean defaultVersion = version.getId().equals(this.fabricService.getDefaultVersion().getId());
        Profile[] profiles = CommandUtils.sortProfiles(version.getProfiles());
        ArrayList<Container> containerList = new ArrayList<Container>();
        for (String c : this.fabricService.getDataStore().getContainers()) {
            Container container = this.fabricService.getContainer(c);
            if (!version.getId().equals(container.getVersion().getId())) continue;
            containerList.add(container);
        }
        Container[] containers = CommandUtils.sortContainers(containerList.toArray(new Container[containerList.size()]));
        System.out.println(String.format(FORMAT, "Name:", version.getId()));
        System.out.println(String.format(FORMAT, "Description:", description != null ? description : ""));
        System.out.println(String.format(FORMAT, "Derived From:", derivedFrom != null ? derivedFrom : ""));
        System.out.println(String.format(FORMAT, "Default Version:", defaultVersion));
        if (containers.length == 0) {
            System.out.println(String.format(FORMAT, "Containers:", ""));
        } else {
            for (int i = 0; i < containers.length; ++i) {
                if (i == 0) {
                    System.out.println(String.format(FORMAT, "Containers (" + containers.length + "):", containers[i].getId()));
                    continue;
                }
                System.out.println(String.format(FORMAT, "", containers[i].getId()));
            }
        }
        if (profiles.length == 0) {
            System.out.println(String.format(FORMAT, "Profiles:", ""));
        } else {
            for (int i = 0; i < profiles.length; ++i) {
                if (i == 0) {
                    System.out.println(String.format(FORMAT, "Profiles (" + profiles.length + "):", profiles[i].getId()));
                    continue;
                }
                System.out.println(String.format(FORMAT, "", profiles[i].getId()));
            }
        }
        return null;
    }

    private boolean versionExists(String versionName) {
        Version[] versions;
        for (Version v : versions = this.fabricService.getVersions()) {
            if (versionName == null || !versionName.equals(v.getId())) continue;
            return true;
        }
        return false;
    }
}

