/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.commands;

import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Version;
import io.fabric8.boot.commands.support.FabricCommand;
import io.fabric8.utils.FabricValidations;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;

@Command(name="profile-create", scope="fabric", description="Create a new profile with the specified name and version", detailedDescription="classpath:profileCreate.txt")
public class ProfileCreateAction
extends AbstractAction {
    @Option(name="--version", description="The profile version. Defaults to the current default version.")
    private String version;
    @Option(name="--parents", multiValued=true, required=false, description="Optionally specifies one or multiple parent profiles. To specify multiple parent profiles, specify this flag multiple times on the command line. For example, --parents foo --parents bar.")
    private List<String> parents;
    @Argument(index=0)
    private String name;
    private final FabricService fabricService;

    ProfileCreateAction(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public FabricService getFabricService() {
        return this.fabricService;
    }

    protected Object doExecute() throws Exception {
        FabricValidations.validateProfileName(this.name);
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        Profile[] parents = FabricCommand.getExistingProfiles((FabricService)this.fabricService, (Version)ver, this.parents);
        Profile profile = this.fabricService.getVersion(ver.getId()).createProfile(this.name);
        profile.setParents(parents);
        return null;
    }
}

